<?php
namespace My\Dao; require_once "ConnectionDao.php";
/**
 * Description of AgeCondition
 *
 * @author eabuilder
 */
class Logins {
   
    private $db = null;
    
    public function __construct() {
        $this->db=ConnectionDao::getDb();
    }
     
                 public function select_record($id){
                    $statement = $this->db->prepare("SELECT * FROM logins WHERE id = :id"); 
                    $statement->bindParam(':id',$id);
                    $statement->execute();
                   
                    if($statement->rowCount() > 0) {
                          return $statement->fetchAll(\PDO::FETCH_ASSOC);
                    } 
                    return false;
                 
                 } 
                      
                 public function select_all_record(){
                    $statement = $this->db->prepare("SELECT * FROM logins");
                    $statement->execute();
                   
                    if($statement->rowCount() > 0) {
                          return $statement->fetchAll(\PDO::FETCH_ASSOC);
                    } 
                    return false;
                 
                 } 
                      
                 public function delete_record($id){
                    $statement = $this->db->prepare("DELETE FROM logins WHERE id = :id"); 
                    $statement->bindParam(':id',$id);
                    return $statement->execute();
                        
                 } 
                      
                    public function insert_record(array $values) {
                        $sql = "INSERT INTO logins ";
                        $fields = array_keys($values);
                        $vals = array_values($values);

                        $sql .= "(" . implode(",", $fields) . ") ";

                        $arr = array();
                        foreach ($fields as $f) {
                            $arr[] = "?";
                        }
                        $sql .= " VALUES (" . implode(",", $arr) . ") ";

                        $statement = $this->db->prepare($sql);

                        foreach ($vals as $i => $v) {
                            $statement->bindValue($i + 1, $v);
                        }

                        return $statement->execute();
                    }
                  
                     
                    public function update_record(array $key_col_vals, array $values) {
        
                     $sql = "UPDATE logins SET ";
                     $fields = array_keys($values);
                     $vals = array_values($values);
                     $key_cols = array_keys($key_col_vals);
                     $key_vals = array_values($key_col_vals);
                     foreach ($fields as $i=>$f) {
                         $fields[$i] .= " = ? ";
                     }

                     $sql .= implode(",", $fields);
                     $sql .= " WHERE " ;
                     
                     foreach ($key_cols as $i=>$f) {
                         $key_cols[$i] .= " = ? ";
                     }
                     
                     $sql .= implode(" AND ", $key_cols);

                     $statement = $this->db->prepare($sql);
                     foreach ($vals as $i=>$v) {
                         $statement->bindValue($i+1, $v);
                     }
                     
                     foreach ($key_vals as $i=>$v) {
                        if($i==0){
                            $statement->bindValue((count($fields)+$i+1), $v);
                         }else{
                               $statement->bindValue((count($fields)+$i), $v);
                         }
                     }
                     
                    return  $statement->execute();

                 } 
                      
                }$logins= new \My\Dao\Logins; ?>