-- mysqldump-php https://github.com/ifsnop/mysqldump-php
--
-- Host: localhost	Database: sewassed_bibiani
-- ------------------------------------------------------
-- Server version 	5.7.36-cll-lve
-- Date: Thu, 17 Feb 2022 17:46:16 +0700

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `backup_log`
--

DROP TABLE IF EXISTS `backup_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `backup_log` (
  `backup_log_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `backup_time` datetime DEFAULT NULL,
  `backup_file` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`backup_log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `backup_log`
--

/*!40000 ALTER TABLE `backup_log` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `backup_log` ENABLE KEYS */;
COMMIT;

-- Dumped table `backup_log` with 0 row(s)
--

--
-- Table structure for table `biblio`
--

DROP TABLE IF EXISTS `biblio`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `biblio` (
  `biblio_id` int(11) NOT NULL AUTO_INCREMENT,
  `gmd_id` int(3) DEFAULT NULL,
  `title` text COLLATE utf8_unicode_ci NOT NULL,
  `sor` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `edition` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `isbn_issn` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `publisher_id` int(11) DEFAULT NULL,
  `publish_year` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `collation` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `series_title` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `call_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `language_id` char(5) COLLATE utf8_unicode_ci DEFAULT 'en',
  `source` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `publish_place_id` int(11) DEFAULT NULL,
  `classification` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8_unicode_ci,
  `image` varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `file_att` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `opac_hide` smallint(1) DEFAULT '0',
  `promoted` smallint(1) DEFAULT '0',
  `labels` text COLLATE utf8_unicode_ci,
  `frequency_id` int(11) NOT NULL DEFAULT '0',
  `spec_detail_info` text COLLATE utf8_unicode_ci,
  `content_type_id` int(11) DEFAULT NULL,
  `media_type_id` int(11) DEFAULT NULL,
  `carrier_type_id` int(11) DEFAULT NULL,
  `input_date` datetime DEFAULT NULL,
  `last_update` datetime DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  PRIMARY KEY (`biblio_id`),
  KEY `references_idx` (`gmd_id`,`publisher_id`,`language_id`,`publish_place_id`),
  KEY `classification` (`classification`),
  KEY `biblio_flag_idx` (`opac_hide`,`promoted`),
  KEY `rda_idx` (`content_type_id`,`media_type_id`,`carrier_type_id`),
  KEY `uid` (`uid`),
  FULLTEXT KEY `title_ft_idx` (`title`,`series_title`),
  FULLTEXT KEY `notes_ft_idx` (`notes`),
  FULLTEXT KEY `labels` (`labels`)
) ENGINE=MyISAM AUTO_INCREMENT=884 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `biblio`
--

/*!40000 ALTER TABLE `biblio` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `biblio` VALUES (149,32,'Fundamentals of midwifery : a textbook for students','','','',89,'2015','','','RG525','en',NULL,53,'','Contents:\r\nTo be a midwife / Nicky Clark and Carol Paeglis -- Team working / Mary Beadle and Sue Townend -- Sociology applied to maternity care/ Mary Beadle and Sara Wise -- Psychology applied to maternity care / Julie Jomeen and Lynda Bateman -- Parenthood / Ola Ogbuehi and Jacqui Powell -- Antenatal midwifery care / Julie Flint and Carol Lambert -- Intrapartum midwifery care / Julie Flint and Sue Townend -- Postnatal midwifery care / Louise Lewis and Lisa Lachanudis -- Care of the newborn / Liz Smith and Brenda Waite -- Infant feeding / Louise Lewis and Liz Mason -- Public health and health promotion / Ola Ogbuehi, Fiona Robinson and Catriona Jones -- Contraception and family planning / Liz Smith and Sarah Wise -- Perinatal mental health / Julie Jomeen and Nicky Clark -- Complementary and alternative medicines applied to maternity care / Catriona Jones and Jane Marsh -- Pharmacology and medicines management / Mary Beadle and Andrea Hilton -- Emergencies in midwifery / Liz Smith and Brenda Waite -- Bereavement and loss / Liz Smith and Brenda Waite.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-09-17 09:07:52','2017-03-16 01:26:04',NULL,NULL);
INSERT INTO `biblio` VALUES (150,32,'Legal aspects of midwifery','','3rd','0  7506  8817  3',91,'2006','xxix, 702p.','','KD2968.M5 D56','en',NULL,54,'','Contents: \r\n\r\n1. The legal system -- 2. Midwifery : professional regulation -- 3. Midwifery supervision -- 4. Professional accountability and the NMC -- 5. The midwives rules and code of practice, the code of professional conduct and the scope of professional practice -- 6. Woman-centred care -- 7. Consent -- 8. The duty to inform -- 9. Letting die and euthanasia -- 10. Confidentiality and access to records -- 11. Complaints -- 12. Teenage pregnancies -- 13. Negligence -- 14. Specific situations in negligence and civil court procedure -- 15. Record keeping, statements and report writing -- 16. Family planning and sterilisation -- 17. The status and rights of the unborn -- 18. Criminal liability -- 19. Health and safety -- 20. Medication -- 21. The structure of the NHS and the provision of hospital, community and primary care services -- 22. Employment law -- 23. The independent midwife and private maternity hospitals -- 24. Midwifery management -- 25. Criminal law and confinements -- 26. Termination of pregnancy -- 27. Legal issues relating to fertilisation, embryology and genetics -- 28. Vaccine damage payments -- 29. Infectious diseases and the midwife -- 30. Midwife teachers, clinical instructors, preceptors and mentors -- 31. Midwifery research -- 32. Child protection -- 33. Mental disorder and mental incapacity -- 34. Complementary therapies -- App. 1. Human Rights Act 1998 : schedule 1 : the articles -- App. 2. Congenital Disabilities (Civil Liability) Act 1976.\r\n\r\nAbstract: \r\n\r\nWritten in clear, accessible language, without legal jargon, the third edition of this text includes a new chapter on the laws relating to teenage pregnancy. It also covers many of the recommendations from NICE relevant to midwifery practice and considers their legal significance.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-09-17 09:29:39','2019-10-11 11:17:33',NULL,NULL);
INSERT INTO `biblio` VALUES (148,32,'Evidence based midwifery : applications in context','','','',89,'2010','','','','en',NULL,52,'','Contents:\r\nThe nature and use of evidence in midwifery care -- Development of EB midwifery in the Netherlands -- Vaginal birth after caesarean -- Midwives and maternity services in Greece -- Reflections on running an evidence course -- EBP and problem based learning -- Supervision of midwifery and EBP -- \'Is there enough evidence to meet the expectations of a changing midwifery agenda?\' -- Guidelines and the consultant midwife : the challenges of the interdisciplinary guideline group -- Unpicking the rhetoric of midwifery practice -- The potential of service user groups to support EBM -- Evidence based midwifery : current ststus and future priorities. \r\n\r\nAbstract:\r\nThis title offers international perspectives on evidence-based midwifery practice. It focuses on the use of evidence to enhance midwifery practice.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-09-17 08:52:54','2017-03-16 01:45:23',NULL,NULL);
INSERT INTO `biblio` VALUES (147,32,'Essential midwifery practice : public health','','','',90,'2007','','','RG950 .E66','en',NULL,51,'','Includes bibliographical references and index.\r\nThe midwifery public health agenda : setting the scene / Debbie Garrod, Sheena Byrom. Health and inequality : what can midwives do? / Eileen Stringer. Smoking in pregnancy : a growing public health problem / Grace Edwards, David King. Teenage pregnancy : everyone\'s business / Vanessa Hollings, Claire Jackson, Clare McCann. Sexual health : a potential time bomb / Julie Kelly, Grace Edwards. Substance abuse : what is the problem? / Lyn McIver. Domestic abuse in pregnancy : a public health issue / Sally Price. Maternal mental health : working in partnership / Samuel Dearman, Kathryn Gutteridge, Whaquas Waheed. Supporting breastfeeding : midwives facilitating a community model / Sue Henry, Fiona Dykes, Sheena Byrom, Michelle Atkin, Elaine Jackson. Normal birth and birth centre care : a public health catalyst for maternal and societal well-being / Soo Downe, Denis Walsh',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-09-17 08:39:57','2017-03-16 01:44:36',NULL,NULL);
INSERT INTO `biblio` VALUES (145,32,'African American midwifery in the South : dialogues of birth, race, and memory','','','',0,'1998','x, 287p.','','RG950 .F7','en',NULL,49,'','','African_American_midwifery_in_the_South_dialogues_of_birth,_race,_and_memory.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-09-17 07:43:08','2017-03-16 01:27:52',NULL,NULL);
INSERT INTO `biblio` VALUES (146,32,'Essential midwifery practice : intrapartum care','','','',89,'2010','','','RG950 .E87','en',NULL,50,'','Contents:\r\nEvolution of current systems of intrapartum care / Denis Walsh -- Debates about knowledge and intrapartum care / Soo Downe -- Childbirth education : politics, equality and revelance / Mary Nolan -- Birth environment / Denis Walsh -- Labour rhythms / Denis Walsh -- Evidence for neonatal transition and the first hour of life / Judith Mercer & Debra Erikson-Owens -- Midwifery presence : philosophy, science and art / Holly Powell-Kennedy, Tricia Anderson & Nicky Leap -- Skills for working with (the woman in) pain / Rosemary Mander -- Complementary therapies in labour : a woman-centered approach / Denise Tiran -- Midwifery skills for normalising unusual labours / Verena Schmidt and Soo Downe -- Psychology and labour experience : birth as peak experience / Gill Thompson -- Sexuality in labour and birth : an intimate perspective / Sarah Buckley -- Spirituality and labour care / Jenny Hall -- How midwives should organise to provide intrapartum care / Chris McCourt -- Feminism and intrapartum care / Mary Stewart -- Toward salutogenic birth in the 21st century / Soo Downe.\r\n\r\n',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-09-17 08:20:49','2017-03-16 01:42:32',NULL,NULL);
INSERT INTO `biblio` VALUES (16,1,'Anatomy and physiology for nurses','','4th','0713140895',12,'1965','viii, 373 pages : illustrations','Sears\'s anatomy and physiology for nurses','RT69','en',NULL,7,'','Includes bibliographical references and index.','Anatomy_and_physiology_for_nurses.jpg.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2017-04-10 12:08:53',NULL,NULL);
INSERT INTO `biblio` VALUES (17,1,'Anatomy and physiology applied to obstetrics / Sylvia Verralls.','','3rd','9780443042119',13,'1993','243 p. : ill. ; 23 cm','','QP259 .V61','en',NULL,8,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2018-03-12 12:24:35',NULL,NULL);
INSERT INTO `biblio` VALUES (18,1,'Ross and Wilson anatomy & physiology in health and illness / Anne Waugh','','12th','9780702053269',14,'2014','xii, 509 pages : color ill. ; 28 cm','Introduction to the human body -- Introduction to the chemistry of life -- The cells, tissues and organisation of the body -- The blood -- The cardiovascular system -- The lymphatic system -- The nerv','RT69 .W35','en',NULL,8,'','Introduces the structure and functions of the human body and the effects of disease or illness on normal body function. Uses easy-to-understand language and clear color illustrations to make learning more visual and engaging.rnIncludes bibliographical references (page 481) and index.','index.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2018-06-06 09:52:55',NULL,NULL);
INSERT INTO `biblio` VALUES (19,1,'Myles textbook for midwives.','','16th','9780702051463',15,'2014','xvii, 780 p : ill. (some color) ; 26 cm','','RG524 .M99','en',NULL,8,'','Revision of: Textbook for midwives.rnIncludes bibliographical references and index.','Myles_textbook_for_midwives..jpg.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2019-07-15 15:56:12',NULL,NULL);
INSERT INTO `biblio` VALUES (20,1,'Baillière\'s nurses\' dictionary : for nurses and health care workers.','','24th','9780702027055',16,'2005','xiv, 567 pages : illustrations ; 19 cm','','RT21 .B15','en',NULL,8,'','Includes bibliographical references.','cover_baillie_re_s_nurses_dictionary_for_nurses_and_health_care_workers_.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2022-02-17 07:51:50',NULL,NULL);
INSERT INTO `biblio` VALUES (21,1,'Baillière\'s nurses\' dictionary : for nurses and health care workers.','','26th','9780702053290',17,'2014','xv, 601 pages : ill.; 15 cm','','RT21 .B15','en',NULL,8,'','Nutrition -- Resuscitation -- First aid -- Medicines and their control -- The legal and professional framework of nursing -- Standards of conduct, performance and ethics -- Common abbreviations -- Common prefixes, suffixes and roots -- Units of measurement and tables of normal values -- Immunization and vaccinations -- Occupational health and safety -- Prevention and control of infection -- Practice development -- Clinical supervision. rnIncludes bibliographical references.','414jamw1CKL._SY344_BO1,204,203,200_.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-23 10:55:02',NULL,NULL);
INSERT INTO `biblio` VALUES (22,1,'Fundamentals of obstetrics and gynaecology / Derek Llewellyn-Jones ; illustrated by Audrey Besterman.','','6th','0723422826',16,'1994','340 p. : ill.','Obstetrics and gynaecology','RG101 .L77','en',NULL,9,'','Includes bibliographical references (p. 340) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-23 10:52:06',NULL,NULL);
INSERT INTO `biblio` VALUES (23,1,'Obstetrics illustrated.','','6th','0443072671',13,'2003','437 p. : ill.','','RG533 .H19','en',NULL,8,'','The Web and obstetrics -- 1. Physiology of reproduction -- 2. Fetal and maternal physiology -- 3. Obstetrical Anatomy -- 4. Diagnosis of pregnancy -- 5. Antenatal care -- 6. Assessment of the fetus -- 7. Diseases of pregnancy -- 8. Systemic diseases in pregnancy -- 9. Vaginal bleeding in pregnancy -- 10. Multiple pregnancy and other antenatal complications -- 11. Normal labour -- 12. Abnormal labour -- 13. Abnormalities of the third stage of labour and of the placenta and cord -- 14. Obstetrical operations and maternal injuries -- 15. Puerperium -- normal and abnormal -- 16. The newborn baby -- 17. Maternal and perinatal mortality -- 18. Contraception. rnIncludes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-23 10:53:24',NULL,NULL);
INSERT INTO `biblio` VALUES (24,1,'Llewellyn-Jones fundamentals of obstetrics and gynaecology / ed. by Jeremy Oats, Suzanne Abraham','','9th','9780723435082',18,'2010','viii, 354 s. : ill. ; 25 cm.','','RG101 .L77','en',NULL,10,'','This title includes comprehensive coverage of the clinical essentials of both obstetrics and gynaecology in one affordable volume. A new team of authors presents the latest advances in the management of pregnancy and the treatment of gynaecological disorders in a well-written, easy-to-read style. Shorter chapters, updated terminology, clearer scans, and more line drawings are just some of the fresh, new changes that bring this popular reference up-to-date and make it relevant to today\'s practice.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-23 10:56:26',NULL,NULL);
INSERT INTO `biblio` VALUES (25,1,'Obstetrics by ten teachers / ed. by Geoffrey Chamberlain.','','16th','9780340573167',19,'1995','XIII, 306 p. : ill. ; 25 cm','','RG123.G99','en',NULL,7,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2016-04-22 11:54:20',NULL,NULL);
INSERT INTO `biblio` VALUES (26,1,'Manual of neonatal care / editors, John P. Cloherty [and others].','','7th','9781451118117',20,'2012','xxii, 1007 p : ill. ; 21 cm.','Lippincott manual','RJ251 .C62','en',NULL,11,'','This edition of the Manual of Neonatal Care has been completely updated and extensively revised to reflect the changes in fetal','perinatal',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2016-10-10 13:54:09',NULL,NULL);
INSERT INTO `biblio` VALUES (154,1,'Trounce\'s Clinical pharmacology for nurses','','18th','9780443068058',13,'2009','xxvi, 483 s. : ill','','RM300.T74','en',NULL,10,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-10-18 16:19:20','2017-10-09 11:43:02',NULL,NULL);
INSERT INTO `biblio` VALUES (27,1,'Managing newborn problems : a guide for doctors, nurses and midwives.','','','9241546220',21,'2003','1 volume (various pagings) : illustrations.','Integrated management of pregnancy and childbirth','RJ251 .M31','en',NULL,12,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2016-10-28 11:58:12',NULL,NULL);
INSERT INTO `biblio` VALUES (28,1,'Managing complications in pregnancy and childbirth : a guide for midwives and doctors.',NULL,NULL,'9241545879',22,'2007','1 volume (various pagings) : illustrations ; 21 cm',NULL,'RG551 .M31','en',NULL,12,NULL,'Reprinted with minor revisions and corrections--P. iii.rnIncludes index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (29,1,'Maternal-newborn nursing : a family-centered approach : formerly Obstetric nursing / Sally B. Olds, Marcia L. London, Patricia A. Ladewig.',NULL,'2nd','0201127970',23,'1984','xxxvii, 1125 p. : ill. , (some color) ; 29 cm','Obstetric nursing.','RG951 .Ol1','en',NULL,13,NULL,'Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (30,1,'Essentials of maternity nursing : family-centered care / Leonide L. Martin, Sharon J. Reeder.',NULL,NULL,'9780397547913',24,'1991','xxi, 819 p : ill. ; 29 cm',NULL,'RG951 .M41','en',NULL,11,NULL,'Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (31,1,'Child health : a manual for medical and health workers in health centres and rural hospitals / edited by Paget Stanfield together with Bo Balldin and Zier Versluys ; with additonal chapters by Nimrod Bwibo [and others].','','2nd','9966874070',25,'1997','xii, 528 p : ill. ; 25 cm','','RJ45 .C43','en',NULL,14,'','Includes Index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2017-10-25 10:03:40',NULL,NULL);
INSERT INTO `biblio` VALUES (32,1,'Workbook for maternity nursing / Constance Lerch.',NULL,NULL,'801629667',16,'1969','viii, 303 p. : ill. ; 27 cm',NULL,'RG951 .L56','en',NULL,15,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (33,1,'Primary child care : a manual for health workers. book one / Maurice King, Felicity King, and Soebagyo Martodipoero.',NULL,NULL,NULL,26,'1978','vi, 315 p : ill. ; 25 cm',NULL,'RJ48 .K58','en',NULL,16,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (34,1,'Happy, healthy children : a child care book / written and illustrated by Janie Hampton.',NULL,NULL,'9780333390306',27,'1985','xiv, 143 p : ill ; 25 cm',NULL,'HQ769 .H18','en',NULL,14,NULL,'Includes bibliographical references (page 137) and index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (35,1,'Vulliamy\'s the newborn child / Peter G.B. Johnston.','','7th','0443057885',13,'1994','201 p. ill, (some color) ; 25 cm','','RJ254 .J65','en',NULL,8,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2018-06-07 20:45:01',NULL,NULL);
INSERT INTO `biblio` VALUES (36,1,'Practical mother and child health in developing countries',NULL,'4th','0333552288',28,'1991','v, 153 p : ill ; 22 cm',NULL,'RJ101 .Eb1','en',NULL,17,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (37,1,'National Safe Motherhood Service Protocol','','','978998844455',29,'2008','v, 128 p. : ill., 24.5cm','','RG940 .Sa1','en',NULL,18,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2017-04-24 11:55:49',NULL,NULL);
INSERT INTO `biblio` VALUES (38,1,'Gynaecology by ten teachers / edited by Stuart Campbell and Ash Monga.',NULL,'18TH','9780340816646',30,'2006','ix, 280 p. : col. ill. ; 25 cm.',NULL,'RG123 .G99','en',NULL,7,NULL,'Previous ed. published as: Gynaecology / by ten teachers. edited by Geoffrey Chamberlain. 16th ed. 1995.rnIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (39,1,'The high risk newborn / edited by M.K.C. Nair and Naveen Jain.','','','9788184482584',31,'2008','vi, 362 p 24 cm','','RG951 .H53','en',NULL,19,'','Includes bibliographic index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2016-08-22 13:19:53',NULL,NULL);
INSERT INTO `biblio` VALUES (40,1,'Helping mothers to breast feed / F. Savage King ; illustrated by Sara Kiunga-Kamau [and others].','','','9966874046',32,'1992','xv, 180 p : ill ; 21 cm','','RJ216 .Sa9','en',NULL,20,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2017-04-11 19:53:31',NULL,NULL);
INSERT INTO `biblio` VALUES (41,1,'Craig\'s care of the newly born infant [by] A.J. Keay and D.M. Morgan in collaboration with Norah J. Stephen.','','5th','0443010811',33,'1974','viii, 484 p ill; 23 cm','Nursing care of the newly born infant','RJ251 .C84','en',NULL,10,'','Includes bibliographical references.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2018-06-13 10:58:44',NULL,NULL);
INSERT INTO `biblio` VALUES (42,1,'The newborn child, by David G. Vulliamy.',NULL,'3rd','0443009031',13,'1972','vii, 189 p ill; 22 cm',NULL,'RJ254 .V97','en',NULL,21,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (43,1,'Basic maternal and newborn care : a guide for skilled providers / authors Barbara Kinzie, Patricia Gomez ; editor Rebecca Chase.','and nurses) who care for women and newborns in low-resource settings. Basic care can be given in a variety of sites',NULL,'0929817826',34,'2004','xxiv, 58, 136, 130, 64 p : ill; 28 cm',NULL,'RG951 .K62','en',NULL,22,NULL,'The MBNC manual is intended for use by skilled providers (including midwives','doctors',NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (44,1,'Universal childbirth picture book / by Fran P. Hosken.',NULL,NULL,'0942096010',35,'1995','78 p',NULL,'RG551.H79','en',NULL,23,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (45,1,'Better child care / edited by M.A. Tregoning and G.S. Bova.',NULL,NULL,'0333393058',36,'1985','64 p : ill. ; 22 cm',NULL,'RJ101 .B46','en',NULL,7,NULL,'Cover title.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (46,1,'Obstetrics by ten teachers / edited by Philip N. Baker',NULL,'18th','978034816677',37,'2006','xi, 340 p : ill. ; 24 cm',NULL,'RG526 .Ob7','en',NULL,7,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (47,1,'Gynaecology illustrated.',NULL,'6th','9780702030772',38,'2011','x, 414 p. : ill. ; 25 cm.',NULL,'RG101 .G99','en',NULL,8,NULL,'Embryology of the reproductive tract -- Anatomy of the reproductive tract -- Physiology of the reproductive tract -- Disorders of sex development -- History and examination -- Abnormalities of menstruation -- Gynaecological infections -- Diseases of the vulva -- Diseases of the vagina -- Diseases of the cervix -- Diseases of the uterus -- Prolapse and urogynaecology -- Diseases of the ovary and fallopian tube -- Complications of gynaecological surgery -- Early pregnancy -- Sexuality and contraception -- Infertility -- The menopause. Rev. ed. of: Gynaecology illustrated / David McKay Hart, Jane Norman. 5th ed. 2000.rnIncludes index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (48,1,'Textbook of neonatal resuscitation / editor, John Kattwinkel ; associate editors, Susan E. Denson [and others].',NULL,'4th','9781581100563',39,'2000','1 volume (various pagings) : chiefly color ill.',NULL,'WQ450 .T31','en',NULL,24,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (49,1,'Maternal and neonatal nursing care plans / Annamma Jacob.',NULL,NULL,'9788184486872',31,'2009','456 p : il. ; 28 cm',NULL,'RG951 .J15','en',NULL,19,NULL,'Includes bibliographical references',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (50,1,'Maternity nursing [by] Elise Fitzpatrick, Sharon R. [i.e. J.] Reeder [and] Luigi Mastroianni, Jr.',NULL,'12th','0397541155',24,'1971','xii, 638 p ill. (some color) 27 cm',NULL,'RG951 .F55','en',NULL,11,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (51,1,'Clinical gynaecology / [edited by] T.R. Varma.',NULL,NULL,'0713145749',40,'1991','x, 1053 p : ill. ; 26 cm',NULL,'RG101 .C61','en',NULL,7,NULL,'Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (52,1,'Gynecology and gynecologic nursing / by Norman F. Miller and Hazel Averyd',NULL,'5th',NULL,41,'1965','ix, 440 p : ill. ; 21 cm',NULL,'RG105 M61','en',NULL,25,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (53,1,'Gynaecology; a handbook for nurses.',NULL,NULL,'571093582',42,'1967','186 p.: ill. ; 21cm.',NULL,'RG105 .D66','en',NULL,7,NULL,'Includes Index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (54,1,'Essentials of maternal and neonatal nursing / [edited by] Carole Ann Kenner, Aileen MacLaren.',NULL,NULL,'9780874344714',43,'1993','xxxiv, 622 p. : ill. (some col.) ; 28 cm.',NULL,'RG951 .Es7','en',NULL,26,NULL,'Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (221,1,'Microorganisms in our world.','','','9780801678042',123,'1995','xviii, 765 p : ill. , 28cm','','QR41.2 .At1','en',NULL,7,'','Includes glossary and index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-11 20:10:52','2017-04-11 20:11:54',NULL,NULL);
INSERT INTO `biblio` VALUES (56,1,'Fundamentals of nursing : the art and science of nursing care / Carol R. Taylor [et al].','','7th','9781609133658',44,'2011','xxxi, 1673, [64] p. : col. ill. ; 29 cm. + 1 DVD-R','','RT41 .T21','en',NULL,11,'','Fundamentals of Nursing: The Art and Science of Nursing Care','Seventh Edition',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2017-04-10 16:09:51',NULL,NULL);
INSERT INTO `biblio` VALUES (220,1,'Standard treatment guidelines','','','9988828314',122,'2004','xiii, 493 p : ill. , 18cm','','RM145 St2','en',NULL,66,'','Handbooks and manuals.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-11 19:39:30','2017-04-11 19:46:53',NULL,NULL);
INSERT INTO `biblio` VALUES (57,1,'Gynaecology, by ten teachers.',NULL,'6th',NULL,40,'1989','viii, 296 p : ill.',NULL,'RG101','en',NULL,7,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (58,1,'Family-centered maternity nursing / Ernestine Wiedenbach. Illus. by Caroline E. Falls.',NULL,NULL,'6728089',45,'1967','xviii, 429 p : ill. ; 22 cm','The realities of nursing and the nurse -- Maternity nursing- family centered -- Preconceptual preparation -- Fertilization and heredity -- Anticipatory counseling and the nurse -- Pregnancy -- Nursing','RG951 .W63','en',NULL,8,NULL,'What should the concept of complete maternity care embrace? What contribution can it make to the individual and society? What is the role of the various professions providing service? And what part should expectant parents be encouraged and helped to play? This book explores the full range of the art and science of obstetric nursing. Interwoven with detailed scientific facts and practical guides to techniques are a broad and tender philosophy and an understanding, based on actual experience, of how good maternity nursing can enrich the childbearing experience and foster the necessary adjustments within the family. -- from Foreword.rnIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (59,1,'Essential nursing skills','','3rd','9780723434740',46,'2008','1 online resource (viii, 361 p) : ill.','Essential skills for nurses series','RT41 .Es2','en',NULL,8,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2016-12-12 10:40:13',NULL,NULL);
INSERT INTO `biblio` VALUES (202,1,'Mental health and mental illness','','5th','9780397550135',117,'1994','xxi, 438 p. : ill. ; 23 cm','Mental Status Exam. 15. Stress, Effective Coping, and Adaptation. 16. Ineffective Coping and Defense Mechanisms -- Unit IV Developing Critical Thinking Skills through Class Discussion -- Unit V. Nursi','RC454.4 .B27','en',NULL,11,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-12-12 11:39:28','2017-09-19 17:15:27',NULL,NULL);
INSERT INTO `biblio` VALUES (60,1,'Quick reference to common laboratory and diagnostic tests / [edited by] Frances Talaska Fischbach.','','','9780397551477',24,'1995','xi, 371 p. ; 19 cm','','RT48.5 .Q4','en',NULL,11,'','Includes bibliographical references (pages 349-351) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2017-10-16 09:39:30',NULL,NULL);
INSERT INTO `biblio` VALUES (61,1,'Exploring psychology',NULL,'5th','0716752549',47,'2002','xxiii; 576 p: illustrations (some color) ; 28 cm','Preface -- Thinking critically with psychological science -- Neuroscience and behavior -- The nature and nurture of behavior -- The developing person -- Sensation and perception -- States of conscious','BF121 .M99','en',NULL,8,NULL,'Includes bibliographical references (pages R0-R65) and indexes.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (62,1,'Handbook of therapeutic interventions.',NULL,NULL,'9780874344806',48,'1994','xi, 660 p : ill. ; 21 cm',NULL,'RM104 .H19','en',NULL,27,NULL,'Includes index.rnIncludes bibliographical references (pages 633-636) and index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (63,1,'The cancer experience : nursing diagnosis and management / Doris L. Carnevali, Ann C. Reiner.',NULL,NULL,'9780397547265',24,'1990','xi, 483 p ; 24 cm',NULL,'RC266 .C21','en',NULL,11,NULL,'Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (64,1,'Statistical methods in medical investigations / Brian S Everitt.',NULL,'2nd','9780340614310',49,'1994','ix, 241 p : ill. ; 24 cm','1. Statistics in Medicine -- 2. The Design of Medical Investigations: Clinical Trials, Observational Studies and Surveys -- 3. Measurement in Medicine -- 4. Statistical Inference -- 5. Regression Anal','R853.S7 Ev2','en',NULL,8,NULL,'This expanded and updated second edition builds upon the success of its predecessor in providing a concise, practical and yet relatively non-technical account of those more sophisticated statistical techniques now used routinely in many medical investigations. The new edition gives additional space to such important topics as the design of medical investigations, regression and logistic regression, the analysis of longitudinal studies, the problems of missing data, and the analysis of observational studies. All chapters include new examples. Statistical Methods for Medical Investigations is aimed at medical statisticians and other researchers working in the medical field.rnIncludes bibliographical references 9p. [219]-232) and index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (65,1,'Foundations of nursing research / Rose Marie Nieswiadomy.',NULL,'2nd','9780838526941',50,NULL,'xv, 404 pages ; 24 cm',NULL,'RT81.5 .N55','en',NULL,28,NULL,'Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (66,1,'Introduction to research in the health sciences / Stephen Polgar, Shane A. Thomas.',NULL,'3rd','9780443050398',13,'1995','x, 393 p. : ill. ; 24 cm.',NULL,'R850 .P75','en',NULL,8,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (67,1,'Handbook of health research methods : investigation, measurement and analysis / edited by Ann Bowling and Shah Ebrahim',NULL,NULL,'9780335214600',51,'2005','xii, 625 p. : ill.',NULL,'RA440.85 .H19','en',NULL,29,NULL,'pt. 1. Introduction. pt. 2. Multidisciplinary methods of investigation. pt. 3. Multidisciplinary research measurement. pt. 4. Data analysis. pt. 5. Essential issues to consider when conducting research',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (68,1,'Nursing research / Basavanthappa BT.',NULL,'2nd','9788184480740',52,'2007','574 p. : ill. ; 24 cm',NULL,'RT81.5 .B29','en',NULL,19,NULL,'Include índex.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (69,1,'Research methodology In nursing [electronic resource] / Nirmala V, J. Silvia Edison.',NULL,'1st','9789350251119',53,'2011','xiii, 192 p. : ill.',NULL,'RT81.5 .N62','en',NULL,30,NULL,'The contents of the textbook are organized systematically in an understandable and applicable manner for the health care professionals . Nursing research is a means to improve the health of the people. It is a way to identify new knowledge, improve professional education and practice, and use resources effectively. Systematic use of research process provides a wide basis for nursing practice. Use of research process in nursing and the application of research findings in the clinical setting foster newer means of improving the client care.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (70,1,'Essentials of nursing research/ BT Basavanthappa',NULL,NULL,'9789350250976',54,'2011','379 p. ; 21.5cm',NULL,'RT81.5 .B29','en',NULL,19,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (71,1,'Research methodology.',NULL,NULL,'9788131301364',55,'2012','xvi, 319 pages ; 22 cm',NULL,'Q180.55 K52','en',NULL,19,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (72,1,'Study guide to accompany Vander-Sherman-Luciano : Human physiology / Sharon Russell.','','5th','9780070669710',56,'1991','548 pages : illustrations ; 28 cm','Human physiology, study guide to accompany Vander-Sherman-Luciano','QP34.5 .V28','en',NULL,8,'','A study guide to accompany the 5th edition of Vander','Sherman',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2016-10-05 13:37:54',NULL,NULL);
INSERT INTO `biblio` VALUES (73,1,'National Family Planning Protocols: Reducing maternal mortality and morbidity r3m Ghana',NULL,NULL,'9789988838042',29,'2007','vi, 171 p. : ill. ; 24 cm.',NULL,'HQ766 .F21','en',NULL,18,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (74,1,'The essentials of contraceptive technology / Robert A. Hatcher [and others].','','','1885960018',57,'1997','1 volume (various pagings) : illustrations ; 23 cm','Subtitle on cover:Handbook for clinic staff','RG136 .Es7','en',NULL,31,'','Supplement to Population reports','Family planning methods: New guidance',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2017-10-18 09:45:36',NULL,NULL);
INSERT INTO `biblio` VALUES (75,1,'Emergency care and transportation of the sick and injured',NULL,'8th','9780763716660',58,'2002','xxxvii, 986p. : ill. (chiefly color) ; 29 cm + 1 c',NULL,'RC86.7 .Am3','en',NULL,32,NULL,'Helping the EMT student become EMT basics.rnSystem requirements for accompanying disk: Supports Palm/Handspring, Windows CE/Pocket PC, eBook Reader, Smart Phone, Windows 95/98/2000, and Macintosh.rnSystem requirements: Windows 95, 98, NT, 2000, or ME desktop or laptop; Macintosh with Os 8.x and above.rnIncludes index.rnCD-ROM includes lesson files for use with book.','Emergency_care_and_transportation_of_the_sick_and_injured.jpg.jpg',NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (76,1,'Where women have no doctor : a health guide for women','','2nd','9780333649336',36,'1997','583p. : ill.; 25 cm','','RA564.85 .W56','en',NULL,33,'','Previous edition: Berkeley, Calif. : Hesperian Foundation, 1997.rnIll. and text on inside covers.rnPublished in association with The Hesperian Foundation.rnIncludes bibliographical references and index.','Where_women_have_no_doctor,_a_health_guide_for_women.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2017-10-02 09:30:52',NULL,NULL);
INSERT INTO `biblio` VALUES (77,1,'Fundamentals of nursing : concepts, process and practice',NULL,'1st','9780131976535',59,'2008','xix, 787 p.',NULL,'RT41 .F96','en',NULL,33,NULL,'Nurses today must be able to grow and evolve in order to meet the demands of a changing health care system. This textbook helps readers on this journey with comprehensive coverage of contemporary professional nursing.','415UN972o8L._SY344_BO1,204,203,200_.jpg.jpg',NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (78,1,'Myles textbook for midwives','','14th','9780443072345',13,'2003','xiv, 1089p.','','RG524 .M86','en',NULL,10,'','Includes bibliographical references and index.','Myles_Textbook_for_Midwives.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2016-10-24 14:20:08',NULL,NULL);
INSERT INTO `biblio` VALUES (79,1,'Hutchison\'s clinical methods','','21st','0702025313',60,'2002','xii, 501p','','RC46 .H93','en',NULL,10,'','Includes index.rnIncludes bibliographical references and index','9780702025303_p0_v1_s260x420.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2016-10-24 14:23:32',NULL,NULL);
INSERT INTO `biblio` VALUES (80,1,'Springhouse nurse\'s drug guide97 / [foreword by Charold L. Baer].',NULL,NULL,'9780874348378',43,'1997','xvi, 1423 p. : ill. + 1 computer disc (3 1/2 in.)','Nurse\'s drug guide97','RM125 .N93','en',NULL,34,NULL,'Includes index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (81,1,'Nursing97 drug handbook.','','','9780874348675',43,'1997','x, 1334 pages, [16] pages of plates : color illust','Drug handbook','RM301.12 N93','en',NULL,35,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2018-03-14 08:46:21',NULL,NULL);
INSERT INTO `biblio` VALUES (82,1,'Elementary textbook of anatomy and physiology applied to nursing','','3rd ed.','0443006687',61,'1969','vii, 155 pages illustrations 23 cm','','RT69 .R43','en',NULL,10,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2018-06-20 08:50:40',NULL,NULL);
INSERT INTO `biblio` VALUES (83,1,'Foundations of nursing and first aid','','5th','0443007357',13,'1970','xi, 304 p. illus. 22 cm.','Livingstone nursing texts','RT41 .R73','en',NULL,10,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2016-08-22 13:17:59',NULL,NULL);
INSERT INTO `biblio` VALUES (84,1,'The New complete medical and health encyclopedia',NULL,NULL,'0894340077',62,'1977','4 volumes (xiv, 1411 pages) : illustrations ; 25 c',NULL,'RC81 .N42','en',NULL,36,NULL,'Portions of this book have been previously published under the titles: The Complete illustrated book of better health and the Illustrated encyclopedia of better health.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (85,1,'Last\'s anatomy, regional and applied',NULL,'9th','9780443046629',13,'1994','vi, 705p. : ill. ; 25 cm.',NULL,'QM531 .L33','en',NULL,10,NULL,'Includes index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (86,1,'Grant\'s atlas of anatomy',NULL,'11th','9780781742559',63,'2005','xv, 848p., : ill. (chiefly color) ; 29 cm + 1 CD-R',NULL,'QM25 .At1','en',NULL,11,NULL,'Interactive CD-ROM includes 800 images from Grant\'s Atlas of Anatomy, Eleventh Edition, 8 video clips from Acland\'s DVD Atlas of Human Anatomy, and 100 USMLE-style review questions in anatomy.rnIncludes index.rnIncludes bibliographical references and index.rnContents	Thorax -- Abdomen -- Pelvis and perineum -- Back -- Lower limb -- Upper limb -- Head -- Neck -- Cranial nerves.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (87,1,'Sociology as applied to nursing and health care','','','9780702019326',64,'1998','xiii, 274p.','','RA418 .So1','en',NULL,7,'','Published in association with the RCN.\"rnIncludes bibliographical references and index.rnContents:rnStudying sociology in nursing-- Sociology in everyday life-- Society and the individual: gender','\'race\' and age-- Introducing theory in sociology-- Poverty in health care-- Disadvantaged groups in ',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2016-10-10 13:13:32',NULL,NULL);
INSERT INTO `biblio` VALUES (155,1,'Mental health and psychiatric nursing','','','9788123916699',95,'2009','387 p: ill ; 22 cm','','RC440 .L15','en',NULL,19,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-10-18 17:16:54','2016-10-24 14:15:55',NULL,NULL);
INSERT INTO `biblio` VALUES (88,1,'Psychology',NULL,'6th','1572597917',47,'2001','xiii, 689p; ill. (some col.) ; 29 cm.',NULL,'BF121 .M99','en',NULL,8,NULL,'Includes bibliographical references and indexes','Psychology.jpg.jpg',NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (89,1,'Psychology','','1st','0879013117',47,'','xviii, 693 pages : illustrations (some color) ; 29','','BF121 .M99','en',NULL,8,'','','Psychology.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2016-10-24 14:21:22',NULL,NULL);
INSERT INTO `biblio` VALUES (90,1,'Introduction to psychology',NULL,'7th',NULL,65,NULL,'xli, 722p.  : illustrations (some color) ; 29 cm',NULL,'BF121 .P73','en',NULL,37,NULL,'Includes bibliographical references (pages 662-691) and indexes.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (91,1,'Essentials of understanding psychology',NULL,NULL,'0070204578',56,'1989','617p. ; color illustrations ; 26 cm',NULL,'BF121 .F33','en',NULL,8,NULL,'Abridged ed. of: Understanding psychology, c1987.rnIncludes bibliographical references (pages R 1-R 21).rnIncludes indexes.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (92,1,'International migration of SHPs-project of KWESI : international migration of skilled health professionals from Ghana : impact and policy responses',NULL,NULL,'9783639189469',66,'2009','254 p. ; 22 cm.',NULL,NULL,'en',NULL,38,NULL,'Thesis (Ph.D.)--University of Manchester, 2008.rnIncludes bibliographical references (p.230-254)',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (93,1,'NCLEX-RN review',NULL,'2nd','0071470247',56,'2006','x, 481 p. : ill. ; 28 cm. + 1 CD-ROM (4 3/4 in.)',NULL,'RT55 .D13','en',NULL,8,NULL,'CD-ROM in pocket attached at the back of the book.rnIncludes index.rnFormerly CIP. UkrnAccompanying disc is available for use on a standalone workstation within the library for single users. Disc will require installation. StEdNL',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (94,1,'Introduction to clinical medicine','','','1556642334',67,'1991','xvii, 794p. : ill. (some color) ; 28 cm','','RC49 .In8','en',NULL,11,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2017-10-13 13:58:55',NULL,NULL);
INSERT INTO `biblio` VALUES (95,1,'Foundations of anatomy and physiology',NULL,'4th','0443011168',61,'1973','vi, 452 p. illus. (some col.). 23 cm.',NULL,'RT69 .R73','en',NULL,7,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (96,1,'Myles textbook for midwives','','16th','9780702051456',15,'2014','xvii, 780 p. : ill. (some col.)','','RG524 .M99','en',NULL,10,'','Section 1 The midwife in context -- 1. The midwife in contemporary midwifery practice -- 2. Professional issues concerning the midwife and midwifery practice -- Section 2 Human anatomy and reproduction -- 3. The female pelvis and the reproductive organs -- 4. The female urinary tract -- 5. Hormonal cycles: fertilization and early development -- 6. The placenta -- 7. The fetus -- Section 3 Pregnancy -- 8. Antenatal education for birth and parenting -- 9. Change and adaptation in pregnancy -- 10. Antenatal care -- 11. Antenatal screening of the mother and fetus -- 12. Common problems associated with early and advanced pregnancy -- 13. Medical conditions of significance to midwifery practice -- 14. Multiple pregnancy -- Section 4 Labour -- 15. Care of the perineum, repair and female genital mutilation -- 16. Physiology and care during the first stage of labour -- 17 Physiology and care during the transition and second stage phases of labour -- 18. Physiology and care during the third stage of labour -- 19 Prolonged pregnancy and disorders of uterine action --rn20. Malpositions of the occiput and malpresentations -- 21. Operative births -- 22. Midwifery and obstetric emergencies -- Section 5 Puerperium -- 23. Physiology and care during the puerperium -- 24. Physical health problems and complications in the puerperium -- 25. Perinatal mental health -- 26. Bereavement and loss in maternity care -- 27. Contraception and sexual health in a global society -- Section 6 The neonate -- 28. Recognizing the healthy baby at term through examination of the newborn screening -- 29. Resuscitation of the healthy baby at birth: the importance of drying, airway management and establishment of breathing -- 30. The healthy low birth weight baby -- 31. Trauma during birth, haemorrhages and convulsions -- 32. Congenital malformations -- 33 Significant problems in the newborn baby -- 34. Infant feeding. rnIncludes bibliographical references and index.','index.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2016-10-11 20:54:02',NULL,NULL);
INSERT INTO `biblio` VALUES (97,1,'Baillière\'s midwives\' dictionary',NULL,'9th','9780702022814',64,'1997','viii, 353 p. : ill.',NULL,'RG45 .B15','en',NULL,7,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (98,1,'Baillière\'s midwives\' dictionary.',NULL,'8th','9780702014246',64,'1992','viii, 544 p. : ill.',NULL,'RG45 .B15','en',NULL,7,NULL,'Previous ed.: 1983',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (99,1,'Livingstone\'s dictionary for nurses.',NULL,'13TH','0443006164',61,'1970','xvi, 590 pages illustrations 14 cm','New dictionary for nurses','RT21 .Oa1','en',NULL,10,NULL,'Dictionary of words intended for the use of the student in the ward, rather than in the classroom. Includes new terms reflecting new advances in medicine. Appendixes include prefixes and suffixes, poison information, urine testing, physiological normals, eponyms, and abbreviations. Illustrated. 1st ed., 1932; 12th ed.,',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (100,1,'The human body : an introduction to structure and function.',NULL,NULL,'9783131292711',68,'2004','xi, 708 p.,  col. ill. ; 19 cm.',NULL,'QP38 .F19','en',NULL,39,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (101,1,'Dorland\'s illustrated medical dictionary.',NULL,'27th','9780721628592',60,'1956','v, 1887 pages : illustrations','Illustrated medical dictionary.','R125','en',NULL,11,NULL,'Illustrates and defines terms used in different branches of medicine and health science.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (102,1,'Dorland\'s illustrated medical dictionary.',NULL,'24th','0721628591',69,'1965','xxxiv, 1940 p : ill.','Illustrated medical dictionary.','R125','en',NULL,40,NULL,'Illustrates and defines terms used in different branches of medicine and health science.  	Illustrated medical dictionary.rn  	Contents 	Selected abbreviations used in medicine -- Anatomical appendix -- Arteries -- Bones, listed by regions of the body -- Bones -- Muscles -- Nerves -- Veins -- Celsius and Fahrenheit temperature equivalents -- Multiples and submultiples of the metric system -- Weights and measures -- Metric doses with approximate apothecary equivalents -- Reference values for the interpretation of laboratory tests -- Amino acids -- Cavity angles -- Chief malaria-carrying anopheles species of the world -- Table of arteriae -- Human blood group systems and erythrocytic antigenic determinants -- Black\'s classification of dental caries -- Cholecalciferol and related metabolites of vitamin D -- Symbols used in chromosome nomenclature -- Genetic code -- Proteins of the complement system -- Table of culture media -- Table of elements -- Some naturally occurring fatty acids -- Hyperlipoproteinemias -- Congenital adrenal hyperplasia -- Mediators of immediate hypersensitivity -- Primary immunodeficiency disorders, diseases and syndromes -- Human immunoglobulins.rn(cont) Table of ligamenta -- Common plasma lipoprotein classes -- Human T lymphocyte cell-surface markers -- Surface markers of lymphocytes -- Working formulation of non-Hodgkin\'s lymphomas for clinical usage -- Angle\'s classification of malocclusion -- Human adenoviruses -- Table of musculi -- Selected etiologic agents of mycetoma -- Table of nervi -- Oncogenes -- Organophosphorus insecticides -- NASPE/BPEG generic (NBG) pacemaker code -- Positions of the fetus in various presentations -- Rule of nines -- Senses -- Important venomous snakes -- Stains and staining methods -- Selected technetium Tc 99m radiopharmaceuticals -- Table of tests -- Table of venae -- Table of vitamins.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (103,1,'APA dictionary of psychology','','','9781591473800',70,'2007','xvi, 1024 p.','','BF31 .Am3','id',NULL,41,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2017-09-19 17:01:15',NULL,NULL);
INSERT INTO `biblio` VALUES (104,1,'A dictionary of health care: understanding care','','','9789988149925',71,'2011','vii, 569 p.','','RA8.A2 Es2','en',NULL,18,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2016-04-29 12:22:28',NULL,NULL);
INSERT INTO `biblio` VALUES (105,1,'Oxford advanced learner\'s dictionary of current English',NULL,'7th','9780194316613',26,'2006','xii, 1715, [8], 119 pages : illustrations (some co',NULL,'PE1628 .Ox2','en',NULL,16,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (106,1,'Concise Oxford English dictionary','phrases','11th','9780198608646',26,'2004','1 vol. (XX-1708 p.) ; 24 cm.',NULL,'PE1628 .C74','en',NULL,16,NULL,'Over 240','000 words',NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (107,1,'A dictionary of nursing',NULL,'4th','0195671562',26,'2003','ix, 563 pages',NULL,'RT21 .D56','en',NULL,16,NULL,'This dictionary incorporates new material on the major developments of the last few years, including public health medicine, genetics and organ transplantation. rnThe dictionary includes more than 10,200 clear and concise entries.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (108,1,'Microbiology for nurses : applications to patient care',NULL,'7th','0702014176',72,'1993','xi, 513 pages : illustrations','Nurses\' aids series','QR46 .St9','en',NULL,7,NULL,'Revised edition of: Microbiology for nurses.rnIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (109,1,'Textbook of anatomy and physiology for nurses',NULL,'2nd','9788184487589',31,'2010','498 pages : il., color ; 25 cm',NULL,'QM26 .As3','en',NULL,19,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (110,1,'Anatomy, descriptive and surgical',NULL,NULL,'9781856480062',73,'1992','xxxii, 750 pages : illustrations ; 24 cm',NULL,'QM23 .G78','en',NULL,42,NULL,'Originally published: London : J.W. Parker and Son, 1858.rnIncludes index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (111,1,'Your baby\'s secret world : four phases for effective parenting',NULL,NULL,'0828318506',74,'1983','xii, 167 pages : illustrations ; 18 cm',NULL,'HQ774 .C41','en',NULL,43,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (112,1,'Ross and Wilson anatomy and physiology in health and illness',NULL,'8th','0443051569',13,'1998','465 pages : illustrations',NULL,'RT69 .W36','en',NULL,8,NULL,'Includes bibliographical references (page 445) and index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (113,1,'Ross and Wilson anatomy and physiology in health and illness','','10th','0443101019',13,'2006','x, 490 p. : ill. ; 28 cm.','Anatomy and physiology in health and illness','RT69 .W36','en',NULL,10,'','-',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2017-10-30 12:47:56',NULL,NULL);
INSERT INTO `biblio` VALUES (114,1,'Ross & Wilson anatomy and physiology in health and illness.',NULL,'7th','044304421X',13,'1990','412 pages : illustrations','ManrnPhysiology','RT69 .W69','en',NULL,8,NULL,'Includes index.rnIncludes bibliographical references (page 401).',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (115,1,'Nursing pharmacology : an integrated approach to drug therapy and nursing practice',NULL,'2nd','9780397548545',75,'1991','xvi, 1366 pages : illustrations',NULL,'RM262','en',NULL,11,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (116,1,'Handbook on injectable drugs',NULL,'7th','1879907208',76,'1992','xvi, 1023 p.','Drugs','RM143 .T73','en',NULL,44,NULL,'Infusions, Parenteral -- Handbooks.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (117,1,'Clinical pharmacology in nursing',NULL,'2nd','0397543557',77,'1984','xi, 1008 pages : illustrations ; 27 cm','MedicinernDrug therapy - For nursing','RM300 .R61','en',NULL,11,NULL,'Includes bibliographical references and indexes.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (118,1,'Basic & clinical pharmacology',NULL,'10th','9780071260930',78,'2007','xiv, 1179 pages : illustrations ; 24 cm','Basic principles -- Autonomic drugs -- Cardiovascular-renal drugs -- Drugs with important actions on smooth muscle -- Drugs that act in the central nervous system -- Drugs used to treat diseases of th','RM300 .B29','en',NULL,8,NULL,'Katzung provides a current, authoritative, and comprehensive pharmacology book for medical, pharmacy, and other health science students.  	Includes bibliographical references and index.rnLange medical book.\"\"',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (119,1,'Pharmacology',NULL,'3rd','0443050864',13,'1998','855 p : ill ; 25 cm',NULL,'RM300 .P49','en',NULL,8,NULL,'Includes bibliographical references and index',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (120,1,'Tuberculosis : a comprensive clinical reference',NULL,NULL,'9788131221518',79,'2009','xxvi, 1014 p. : ill.',NULL,'RC311 .T79','en',NULL,40,NULL,'Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (121,1,'The premature baby: and other babies with low birth weight',NULL,'7th','0700015264',13,'1957','X, 290p. : ill. ; 22 cm.','MedicinernNewborn babies with low birth weight','RJ250 .C88','en',NULL,7,NULL,'Includes index and bibliography.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (122,1,'Abnormal psychology',NULL,'2nd','0673996352',80,'1994','xix, 678p. ; 29 cm',NULL,'RC454 .H73','en',NULL,8,NULL,'Comprend des références bibliographiques et un index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (123,1,'Handbook of practical pharmacology',NULL,'2nd','080164240x',79,'1980','xvii, 350 pages ; 22 cm','Handbooks and manuals','QV4 .R95','en',NULL,9,NULL,'Includes bibliographical references (page 341) and index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (124,1,'Drug calculations for nurses',NULL,NULL,'0340604794',75,'1995','vi, 250 p: illustrations ; 20 cm','rug calculations for nurses:  a step by step approachrn','RS57 .L31','en',NULL,7,NULL,'Pharmaceutical preparations  Administration & dosage. Pharmaceutical arithmetic Problems, exercises, etc. Pharmaceutical preparations, Administration & dosage Problems and exercises. Nursing  Mathematics. Includes index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (125,1,'Clinical drug therapy : rationales for nursing practice',NULL,'4th','0397551061',77,'1995','xviii, 794 p :  illustrations (some color) ;  28 c','sect. I. Introduction to drug therapy -- sect. II. Drugs affecting the central nervous system -- sect. III. Drugs affecting the autonomic nervous system -- sect. IV. Drugs affecting the endocrine syst','RM262 .Ab8','en',NULL,11,NULL,'Includes bibliographical references and index; pharmaceutical Preparations & Nurses\' Instruction, Drug Therapy Nurses\' Instruction',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (126,1,'Watson\'s clinical nursing and related sciences.',NULL,'7th','9780702028267',64,'2007','xi, 995 p : ill.','Clinical nursing and related sciences.','RT65 .W33','en',NULL,10,NULL,'Watson\'s clinical nursing and related sciences,Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (127,1,'Manson\'s tropical diseases','','22nd','9781416044703',60,'2009','xx, 1830p. : ill. (some color), maps ; 29 cm','','RC961 .M64','en',NULL,10,'','From the difficult to diagnose to the difficult to treat, be prepared for whatever your patients bring back. The revised and updated 22nd edition of this book provides you with the latest coverage on emerging and re-emerging diseases from around the world, such as multi-drug-resistant tuberculosis and malaria, the avian flu, and more. Boxes and tables highlight key information on current therapies. And now, as an Expert Consult title, you can access the information you need online as well as in print! Features up-to-date information on HIV/AIDS, with an emphasis on Africa; malaria; tropical gastroenterological problems; dengue and dengue hemorrhagic fever; tuberculosis; Sexually Transmitted Diseases; SARS; avian flu; bartonellosis, cat-scratch disease, trench fever, human erlichiosis; and more. Allows you to access the complete contents online, plus appendices on Laboratory Diagnosis, Parasitic Protozoa, Medical Helminthology, Nematodes, Trematodes, Cestodes, Medical Acarology and Entomology, and Sources of Information in Tropical Medicine. Your purchase entitles you to access the website until the next edition is published, or until the current edition is no longer offered for sale by Elsevier, whichever occurs first. If the next edition is published less than one year after your purchase, you will be entitled to online access for one year from your date of purchase. Elsevier reserves the right to offer a suitable replacement product (such as a downloadable or CD-ROM-based electronic version) should online access be discontinued.','manson\'s_tropical_diseases.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2018-03-22 16:06:45',NULL,NULL);
INSERT INTO `biblio` VALUES (128,1,'Natural family planning : a guide to provision of services.',NULL,NULL,NULL,21,'1998','vi, 82 pages : illustrations ; 24 cm',NULL,'RG136.5 .N38','en',NULL,12,NULL,'Includes bibliographical references (pages 61-62).',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (129,1,'A nurse\'s handbook of spiritual care : standing on holy ground',NULL,NULL,'9780763732912',58,'2004','xv, 224p. : ill. ; 18 cm',NULL,'RT85.2 .Ob6','en',NULL,32,NULL,'This handy pocket guide provides quick access to a variety of information that helps nurses address the spiritual needs of patients. Designed for use in myriad health care settings','and particularly ideal for visiting and parish nurses.\"--Jacket.rnrnContents	TABLE OF CONTENTS -- Sp',NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (130,1,'Frontline cardiology : an off-the-fence guide for those who need a definitive answer to what do I do next?\"\"',NULL,NULL,'0723434255',16,'2006','v, 178 pages ; 19 cm',NULL,'WG 39 F53','en',NULL,45,NULL,'Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (131,1,'Quick reference to community health nursing',NULL,'2nd','9780815183358',16,'1996','iii, 60p., ; 14 cm',NULL,'RT98 .C73','en',NULL,46,NULL,'Includes bibliographical references.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (132,1,'Pocket picture guides : lipids and lipid disorders',NULL,NULL,'0397446853',81,'1991','vii, 87 pages : illustrations.',NULL,'RC623.L5 F32','en',NULL,7,NULL,'Includes index.rnIncludes bibliographical references (pages 80-82) and index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (133,1,'Hypertension : a concise guide',NULL,NULL,'187002673X',82,'1991','74p. : ill. ; 21 cm',NULL,NULL,'en',NULL,7,NULL,'Includes index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (134,1,'Asthma : management in primary care',NULL,NULL,'9781870905404',83,'1990','X, 179p.',NULL,'RC591 .P32','en',NULL,16,NULL,'Reimpressions: 1991.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (135,1,'Managing chronic obstructive pulmonary disease',NULL,'2nd','9781858739328',82,'2001','v, 90p. : ill.',NULL,'RC776.63 .B26','en',NULL,7,NULL,'Includes bibliographical references (pages 88-90).',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (136,1,'Acute coronary syndromes',NULL,'Solvay Edition','9780199574636',26,'2009','xii, 100p.',NULL,'RC685.C6 Ac9','en',NULL,8,NULL,'Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (137,1,'Psychology',NULL,'2nd','0618527192',84,'2006','1 v. (various pagings) : ill. (chiefly col.) ; 29',NULL,'BF121 .P95','en',NULL,47,NULL,'Contents 	Introducing psychology -- Research in psychology -- Biological aspects of psychology -- Sensation -- Perception -- Learning -- Memory -- Cognition and language -- Consciousness -- Cognitive abilities -- Motivation and emotion -- Human development -- Health, stress, and coping -- Personality -- Psychological disorders -- Treatment of psychological disorders -- Social cognition -- Social influence. Includes bibliographical references and indexes.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (138,1,'Stroke care : a practical manual',NULL,'5th','0198529732, 97801985',26,'2005','ix, 273p.: ill. ; 18 cm.',NULL,'RC388.5 .H26','en',NULL,16,NULL,'Includes bibliographical references and index',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (139,1,'Handbook of diseases','','','9780874348385',85,'1996','','','RC55 .H19','en',NULL,35,'','Includes bibliographical references (p. 912) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2017-10-25 11:20:58',NULL,NULL);
INSERT INTO `biblio` VALUES (140,1,'A nurse\'s guide to anaesthetics, resuscitation, and intensive care',NULL,'5th','0443008728, 97804430',86,'1972','ix, 181p. ill. 22 cm',NULL,'RT65 .N79','en',NULL,22,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (141,1,'Nursing diagnoses in psychiatric nursing : care plans and psychotropic medications','','6th','9780803611665',87,'2004','xxix, 577p. ; 19 cm','','RC440 .T66','en',NULL,11,'','Includes bibliographical references (pages 486-491) and index.rnContents:rnThe Foundation for Planning Psychiatric Nursing Care -- Nursing Process: One Step to Professionalism -- Alterations in Psychosocial Adaptation -- Disorders Usually First Diagnosed In Infancy, Childhood, or Adolescence -- Delirium, Dementia, and Amnestic Disorders -- Substance-Related Disorders -- Schizophrenia and Other Psychotic Disorders -- Mood Disorders -- Anxiety Disorders -- Somatoform and Sleep Disorders -- Dissociative Disorders -- Sexual and Gender Identity Disorders -- Eating Disorders -- Adjustment Disorders -- Impulse Control Disorders -- Psychological Factors Affecting Medical Condition -- Personality Disorders -- Special Topics in Psychiatric/Mental Health Nursing -- Problems Related to Abuse or Neglect -- Premenstrual Dysphoric Disorder -- HIV Disease -- Homelessness -- Psychiatric Home Nursing Care -- Forensic Nursing -- Complementary Therapies -- Loss and Bereavement -- Psychotropic Medications -- Antianxiety Agents -- Antidepressants -- Mood-Stabilizing Drugs -- Antipsychotic Agents -- Antiparkinsonian Agents -- Sedative-Hypnotics -- Central Nervous System Stimulants -- Ego Defense Mechanisms -- Levels of Anxiety -- Medication Assessment Tool -- Cultural Assessment Tool -- The DSM-IV-TR Multiaxial Evaluation System -- Global Assessment of Functioning (GAF) Scale -- DSM-IV-TR Classification: Axes I and II Categories and Codes -- Mental Status Assessment -- Assigning Nursing Diagnoses to Client Behaviors.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2019-07-15 14:51:09',NULL,NULL);
INSERT INTO `biblio` VALUES (142,1,'The preterm baby: and other babies with low birth weight',NULL,'7th','0700015264',13,'1971','x, 290P., ill., form 23 cm.',NULL,'RJ250 .C87','en',NULL,10,NULL,'First-6th editions published under title: The premature baby.rnIncludes bibliographical references.',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (143,1,'Psychology as applied to nursing',NULL,'6th','0443010552',13,'1973','x, 292p. 22 cm.',NULL,'RT86 .M11','en',NULL,10,NULL,'Includes bibliographical references (pages 281-287).',NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'2016-03-21 11:19:06','2016-03-21 11:19:06',NULL,NULL);
INSERT INTO `biblio` VALUES (144,1,'Psychiatric Mental Health Nursing','','','0827372337',88,'1998','xxxi, 832 p. : ill.','','RC440 .F91','en',NULL,48,'','','Psychiatric_Mental_Health_Nursing.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-03-21 11:19:06','2016-10-24 14:16:48',NULL,NULL);
INSERT INTO `biblio` VALUES (161,1,'Essentials of obstetrics and gynecology.','','5th','9781416059400',98,'2010','xvi, 475 p; : ill','Hacker and Moore\'s Essentials of obstetrics and gynecology','RG101.Es2','en',NULL,11,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-10-27 17:15:54','2016-10-27 17:45:10',NULL,NULL);
INSERT INTO `biblio` VALUES (151,32,'Midwifery and women\'s health nurse practitioner certification review guide','','2nd','',92,'2011','xi, 373p.','','RT82.8 .M53','en',NULL,32,'','Contents:\r\n\r\nTest-taking strategies -- General health assessment and health promotion -- Women\'s health -- Pregnancy -- Midwifery care of newborn -- Intrapartum and postpartum -- Gynecological disorders -- Non-gynecological disorders/problems -- Advanced practice nursing and midwifery : role development, trends, and issues.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-09-17 09:52:57','2017-03-16 01:25:15',NULL,NULL);
INSERT INTO `biblio` VALUES (152,32,'Supportive Care and Midwifery','','','',93,'2001','','','RG950.M346','en',NULL,50,'','Contents:\r\nSupportive Care and Midwifery; Contents; Foreword; Acknowledgements; Introduction; 1 Making sense of support; 2 Systems of health care and maternity care provision; 3 The provision of support during childbearing; 4 Supportive midwifery care; 5 Support in labour; 6 The doula; 7 Support for the carer; 8 Conclusion; References; Index.\r\n\r\nAbstract:\r\nThis book considers the broad range of support given to mothers including social, psychological and clinical. It also looks at the provision of this service and how different models have been set up internationally to fulfill this important function. It brings together the latest research findings, which examine the nature of care that is provided and consider what constitutes effective and efficient support. This aspect of care is considered a crucial part of the increasing and expanding role of the midwife. The ability of midwives to provide ongoing support throughout childbearing is one of.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-09-17 10:06:03','2017-03-16 01:19:18',NULL,NULL);
INSERT INTO `biblio` VALUES (153,32,'The Art of midwifery : early modern midwives in Europe','','','',94,'1993','xvi, 234p','','','en',NULL,7,'','Contents:\r\nMothers and their midwives in seventeenth-century London / Doreen Evenden -- Provincial midwives in England : Lancashire and Chesire, 1660-1760 / David Harley -- Midwifery practice among the Quakers in southern rural England in the late seventeenth century / Ann Giardina Hess -- The midwives of south Germany and the public/private dichotomy / Merry E. Wiesner -- From hegemony to subordination : midwives in early modern Spain / Teresa Ortiz -- The politick midwife : models of midwifery in the work of Elizabeth Cellier / Helen King -- Midwife to a nation : Mme du Coudray serves France / Nina Gelbart -- The Church, the state and childbirth : the midwife in Italy during the eighteenth century / Nadia Maria Filippini.\r\nProfessionals? Sisters? Rivals? : midwives in Braunschweig, 1750-1800 / Mary Lindemann -- The \'burgerlijke\' midwife : the stadsvroedvrouw of eighteenth-century Holland / Hilary Marland.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-09-17 10:16:10','2016-10-11 16:56:07',NULL,NULL);
INSERT INTO `biblio` VALUES (156,1,'A text book of environmental studies','','','9788174733023',96,'2005','xxiii, 327 p','','GE105 Si6','en',NULL,55,'','Includes glossary and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-10-18 17:27:34','2016-10-18 17:56:33',NULL,NULL);
INSERT INTO `biblio` VALUES (157,1,'Manual of midwifery and gynaecological nursing','','2nd','9789350259207',31,'2012','xiv, 539 p. : ill. ; 18 cm.','','RG950.J15','en',NULL,19,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-10-18 17:36:40','2016-10-18 17:54:17',NULL,NULL);
INSERT INTO `biblio` VALUES (158,1,'MCQs in obstetrical nursing including neonatology','','1st','9789350254943',31,'2012','328 p ; 22 cm','','RG951.B54','en',NULL,19,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-10-18 17:49:51','2016-10-18 17:52:35',NULL,NULL);
INSERT INTO `biblio` VALUES (159,1,'Basics in burns for nurses.','','','9789350250686',31,'2011','xxii, ill; 327 p','','RT76.D53','en',NULL,19,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-10-18 19:01:18','2016-10-18 19:02:43',NULL,NULL);
INSERT INTO `biblio` VALUES (160,1,'Human communication','','5th','9780071318501',97,'2013','xxv, 388 p: ill (colour) ; 26 cm','','P90 .H88','en',NULL,8,'','\"This international student edition is for use outside of the U.S.\"--Cover.\r\nIncludes bibliographical references and index.','cover_human_communication.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2016-10-24 13:42:22','2022-02-17 07:55:13',NULL,NULL);
INSERT INTO `biblio` VALUES (162,1,'Biostatistics with latest MCQ\' s','','2nd','9788174731777',99,'2008','252 p. : ill.','','QH323.N31','en',NULL,19,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-10-27 17:59:46','2016-10-27 18:01:18',NULL,NULL);
INSERT INTO `biblio` VALUES (163,1,'Food and nutrition','','','9788174733634',96,'2016','x, 382 p. : ill','','RA784.B22','en',NULL,56,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-10-27 18:17:46','2016-10-27 18:18:41',NULL,NULL);
INSERT INTO `biblio` VALUES (164,1,'Fundamental aspects of anatomy','','','9788123916033',95,'2008','ix, 326 p. : ill ; 24 cm','','QM23.2.Sr2','en',NULL,19,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-10-27 18:41:57','2016-10-27 18:43:23',NULL,NULL);
INSERT INTO `biblio` VALUES (166,1,'Hospital management.','','Vol. 1','9788123923017',95,'2015','xii, 240 p. ill','','RA960.Sa9','en',NULL,19,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-10-27 19:09:27','2016-10-27 19:10:41',NULL,NULL);
INSERT INTO `biblio` VALUES (167,1,'Basics of medical genetics','','','9788174732200',99,'2009','169 p. : ill. ; 24 cm.','','QZ50 P18','en',NULL,19,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-10-27 19:41:42','2016-10-27 19:43:24',NULL,NULL);
INSERT INTO `biblio` VALUES (168,1,'Essentials of medical surgical nursing.','','','9789350251362',52,'2011','xxii, 807 p.','','RD99.B29','en',NULL,19,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-10-27 19:53:16','2016-10-27 19:54:39',NULL,NULL);
INSERT INTO `biblio` VALUES (169,1,'Textbook on first aid and emergency nursing','','1st','9789350259870',31,'2012','xiv, 514 p. : ill. ; 24cm.','','RC86.8.C59','en',NULL,19,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-10-28 11:20:05','2016-10-28 11:26:09',NULL,NULL);
INSERT INTO `biblio` VALUES (170,1,'Dictionary for nurses','','','9788123917801',95,'2010','x, 470 p. : ill; 21cm','','RT21.D46','en',NULL,19,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-10-28 11:46:44','2016-10-28 11:47:43',NULL,NULL);
INSERT INTO `biblio` VALUES (171,1,'Vitamins, minerals, and nutrition','','','9788123929292',100,'1986','iv, 73 p. : ill ; 18 cm.','Health Media of America nutrition series','TX553.V83','en',NULL,57,'','Includes bibliographical references (pages 53-66) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-10-28 13:10:37','2016-10-28 13:26:52',NULL,NULL);
INSERT INTO `biblio` VALUES (172,1,'The human body electronic resource : an introduction to structure and function','','','9781588901224',68,'2004','xi, 708 p. : col. ill. ; 19 cm.','','QP34.5.F19','en',NULL,8,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-10-28 14:14:51','2016-10-28 14:16:36',NULL,NULL);
INSERT INTO `biblio` VALUES (173,1,'The short textbook of medical microbiology for nurses','','','9789350251508',31,'2011','xvi, 296 p. :  ill ; (col), 26 cm','','QR46.98','en',NULL,19,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-10-31 09:42:27','2016-10-31 09:43:43',NULL,NULL);
INSERT INTO `biblio` VALUES (174,1,'On being in charge : a guide to management in primary health care','','2nd','9788174733900',21,'1998','vii, 472 p. ill; 24 cm','','RA427.M22','en',NULL,12,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-10-31 09:59:21','2017-10-02 09:05:02',NULL,NULL);
INSERT INTO `biblio` VALUES (175,1,'Brunner & Suddarth\'s textbook of medical-surgical nursing.','','13th','9789351292449',63,'2014','xxix, 2630, 109 pages : illustrations (chiefly col','Textbook of medical-surgical nursing.','RT41.T31','en',NULL,11,'','\"Preparing students for successful NCLEX results and strong futures as nurses in today\'s world. Now in its 12th edition, Brunner and Suddarth\'s Textbook of Medical-Surgical Nursing is designed to assist nurses in preparing for their roles and responsibilities in the medical-surgical setting and for success on the NCLEX. In the latest edition, the resource suite is complete with a robust set of premium and included ancillaries such as simulation support, adaptive testing, and a variety of digital resources helping prepare today\'s students for success. This leading textbook focuses on physiological, pathophysiological, and psychosocial concepts as they relate to nursing care. Brunner is known for its strong Nursing Process focus and its readability. This edition retains these strengths and incorporates enhanced visual appeal and better. \"Preparing students for successful NCLEX results and strong futures as nurses in today\'s world. Now in its 12th edition, Brunner and Suddarth\'s Textbook of Medical-Surgical Nursing is designed to assist nurses in preparing for their roles and responsibilities in the medical-surgical setting and for success on the NCLEX. In the latest edition, the resource suite is complete with a robust set of premium and included ancillaries such as simulation support, adaptive testing, and a variety of digital resources helping prepare today\'s students for success. This leading textbook focuses on physiological, pathophysiological, and psychosocial concepts as they relate to nursing care. Brunner is known for its strong Nursing Process focus and its readability. This edition retains these strengths and incorporates enhanced visual appeal and better portability for students.\"--Publisher\'s website. Focusing on health promotion, this book provides coverage of patients with chronic illness and disabilities. It includes an accompanying CD-ROM which features over 3,500 NCLEX [registered]-style questions and three-dimensional animations that demonstrate disease processes. portability for students.\"--Publisher\'s website. Focusing on health promotion, this book provides coverage of patients with chronic illness and disabilities. It includes an accompanying CD-ROM which features over 3,500 NCLEX [registered]-style questions and three-dimensional animations that demonstrate disease processes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-10-31 11:52:11','2018-03-12 10:37:52',NULL,NULL);
INSERT INTO `biblio` VALUES (176,1,'History taking and physical examination : essentials and clinical correlates / Norton J. Greenberger, Daniel R. Hinthorn.','','','0801666465',101,'1993','ix, 548 pages : illustrations (some color) ; 28 cm','The medical interview and physical examination -- The head and neck -- The respiratory system -- The heart -- The abdomen -- Male genitalia -- Female genitalia -- The breast -- The musculoskeletal sys','RC65 .G82','en',NULL,46,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-10-31 12:58:52','2016-10-31 13:03:12',NULL,NULL);
INSERT INTO `biblio` VALUES (177,1,'Child health nursing : a comprehensive approach to the care of children and their families','','','0397547250',102,'1993','xliv, 1949, 75 p. : ill. (some color) ; 29 cm','','RJ245.C43','en',NULL,11,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-10-31 13:55:40','2016-10-31 13:58:23',NULL,NULL);
INSERT INTO `biblio` VALUES (178,1,'Nursing fundamentals : caring & clinical decision making','','','0766838366',103,'2004','xli, 1589 p. : ill. (certaines en coul.) ; 28 cm.','','RT41.N93','en',NULL,37,'','Due to the continuing expansion of information needed by nursing students, it is time for a new text that offers a fresh perspective. Nursing Fundamentals offers a balanced look at nursing within a functional health patterns framework, making a complex discipline with an ever-changing and dynamic nature understandable. Emerging topics such as the impact of technology, the emphasis on wellness, evidence-based based practice and the expansion of care into the home and community settings are addressed as well as timeless topics such as clinical decision-making, delegation, prioritization, clinical skills and more. (Midwest).',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-11-04 10:38:22','2017-09-27 12:06:49',NULL,NULL);
INSERT INTO `biblio` VALUES (179,1,'Basic nursing : theory and practice','','3rd','9780801678769',104,'1995','xxix, 1256 p. : ill. (some color) ; 29 cm','Concepts basic to nursing practice -- unit 2. Implementing the nursing process -- unit 3. Skills basic to nusing practice -- unit 4. Psychosocial and developmental needs -- unit 5. Protection, safety,','RT41.P85','en',NULL,46,'','Previous edition under Patricia Ann Potter.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-11-04 10:56:29','2016-11-04 11:04:57',NULL,NULL);
INSERT INTO `biblio` VALUES (180,1,'Kozier & Erb\'s fundamentals of nursing : concepts, process, and practice /','','8th','9780132066747',105,'2008','xxv, 1631 p. : col. ill ; 29 cm','Fundamentals of nursing','RT41.F96','en',NULL,58,'','About the authors -- Preface -- Contributors -- Thank you -- Special features -- unit 1. The Nature of nursing -- ch. 1. Historical and contemporary nursing practice -- ch. 2. Nursing education, research, and evidence-based practice -- ch. 3. Nursing theories and conceptual frameworks -- ch. 4. Legal aspects of nursing -- ch. 5. Values, ethics, and advocacy -- unit 2. Contemporary health care -- ch. 6. Health care delivery systems -- ch. 7. Community nursing and care continuity -- ch. 8. Home care -- ch. 9. Nursing informatics -- unit 3. The nursing process -- ch. 10. Critical thinking and the nursing process -- ch. 11. Assessing -- ch. 12. Diagnosing -- ch. 13. Planning -- ch. 14. Implementing and evaluating -- ch. 15. Documenting and reporting -- unit 4. Health beliefs and practices -- ch. 16. Health promotion -- ch. 17. Health, wellness, and illness -- ch. 18. Culture and heritage -- ch. 19. Complementary and alternative healing modalities -- unit 5. Life span development -- ch. 20. Concepts of growth and development -- ch. 21. Promoting health from conception through adolescence -- ch. 22. Promoting health in young and middle-aged adults -- ch. 23. Promoting health in elders -- ch. 24. Promoting family health.\r\nunit 6. Integral aspects of nursing -- ch. 25. Caring -- ch. 26. Communicating -- ch. 27. Teaching -- ch. 28. Leading, managing, and delegating -- unit 7. Assessing health -- ch. 29. Vital signs -- ch. 30. Health assessment -- unit 8. Asepsis -- ch. 32. Safety -- ch. 33. Hygiene -- ch. 34. Diagnostic testing -- ch. 35. Medications -- ch. 36. Skin integrity and wound care -- ch. 37. Perioperative nursing -- unit 9. Promoting psychosocial health -- ch. 38. Sensory perception -- ch. 39. Self-concept -- ch. 40. Sexuality -- ch. 41. Spirituality -- ch. 42. Stress and coping -- ch. 43. Loss, grieving, and death -- unit 10. Promoting physiologic health -- ch. 44. Activity and exercise -- ch. 45. Sleep -- ch. 46. Pain management -- ch. 47. Nutrition -- ch. 48. Urinary elimination -- ch. 49. Fecal elimination -- ch. 50. Oxygenation -- ch. 51. Circulation -- ch. 52. Fluid, electrolyte, and acid-base balance -- Appendix A : Answers to anatomy & physiology review, critical thinking possibilities, and answers to test your knowledge -- Appendix B : Measurement scales used in NOC -- Appendix C : 2007-2007 NANDA-approved nursing diagnoses -- Glossary -- Index.\r\n  	Abstract 	We are pleased to bring you the 8th edition of a book that has been the foundational nursing textbook for generations of nurses. What is now considered fundamental to the practice of nursing was unimaginable to those nurses who practiced during the years of the first edition. Although the language and devices you will see in this edition differ immensely from those used by nurses before us and before you, the systematic nature of gathering data to determine health challenges and designing, implementing, and evaluating care, has not changed.\r\nBarbara Kozier\'s name appears first on earlier ed. under the title: Fundamentals of nursing.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-11-04 11:22:06','2016-11-04 11:29:18',NULL,NULL);
INSERT INTO `biblio` VALUES (181,1,'Pain and central nervous system disease','','','987654321',106,'1991','1 vol. (XIII-290 p.) : ill., couv. ill. ; 21 cm.','The Bristol-Myers Squibb symposium on pain research series','RC368.B77','en',NULL,8,'','Index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-11-21 12:40:55','2016-11-21 12:56:18',NULL,NULL);
INSERT INTO `biblio` VALUES (182,1,'Alternative delivery systems','','','087189615X',107,'1987','vii, 192 p. : illust ; 26 cm','','RA411.Al7','en',NULL,59,'','A collection of articles from Journal of ambulatory care management.\"\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-11-21 13:06:04','2017-04-10 12:04:56',NULL,NULL);
INSERT INTO `biblio` VALUES (183,1,'Trauma in children','','','087189369X',107,'1986','xiii, 288 p. : ill ; 28 cm','','RD93.5.C4 T69','en',NULL,59,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-11-21 13:24:20','2016-11-21 13:26:21',NULL,NULL);
INSERT INTO `biblio` VALUES (184,1,'Pharmaceutical practice.','','3rd','9780443072055',13,'2004','xiii, 573 p. : ill ; 25 cm','','RS91 .P49','en',NULL,8,'','Includes bibliographical references (pages 542-550) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-11-22 15:51:41','2016-11-22 15:52:59',NULL,NULL);
INSERT INTO `biblio` VALUES (185,1,'British Medical Association new guide to medicines and drugs','','3rd','9780751301021',108,'1994','vii, 472 p. ill; 23 cm','','QV39.M14','en',NULL,7,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-11-22 16:21:04','2016-12-12 10:18:19',NULL,NULL);
INSERT INTO `biblio` VALUES (186,1,'A comprehensive textbook of midwifery','','2nd','9788184482409',31,'2008','xiv, 769 pages, 6 pages of plates : illustrations','','RG105.J15','en',NULL,19,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-11-28 12:06:05','2017-04-10 12:33:02',NULL,NULL);
INSERT INTO `biblio` VALUES (187,1,'Midwifery casebook : a practical record of maternal and newborn nursing for GNM students','','2nd','9789350902073',31,'2013','578 p. ; 22 cm','','RG950.J15','en',NULL,19,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-11-28 12:24:19','2017-09-19 17:07:44',NULL,NULL);
INSERT INTO `biblio` VALUES (188,1,'Continuing care : the process and practice of discharge planning','','','0871893827',107,'1987','xi, 226 p. : ill. , forms ; 29 cm','','RA971.8 .Z1','en',NULL,59,'','Includes bibliographical references (pages 219-220) and index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-11-28 13:11:42','2016-11-28 13:13:27',NULL,NULL);
INSERT INTO `biblio` VALUES (189,1,'Watson\'s clinical nursing & related sciences.','','6th','9780702026904',64,'2002','xix, 1038 p. : ill. ; 28 cm','Clinical nursing & related sciences.\r\nWatson\'s medical-surgical nursing and related physiology.','RT65.W33','en',NULL,11,'','Revised edition of: Watson\'s medical-surgical nursing and related physiology. 5th ed. / edited by Joan A. Royle and Mike Walsh. 1992.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-11-28 14:04:47','2016-11-28 14:10:53',NULL,NULL);
INSERT INTO `biblio` VALUES (190,1,'Kozier & Erb\'s fundamentals of nursing : concepts, process and practice.','','9th','9781292022802',109,'2014','IV, 1660 p. : ill. ; 28 cm','Fundamentals of nursing','RT41.F96','en',NULL,60,'','Pearson new international edition--Cover.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-11-29 17:04:56','2016-12-12 10:26:13',NULL,NULL);
INSERT INTO `biblio` VALUES (191,1,'Obstetrics and the newborn : an illustrated textbook','','3rd','9780702021237',110,'1997','x, 794 p. ; [48] p. of plates : ill. (some color)','','RG524.B39','en',NULL,11,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-11-29 17:26:39','2017-10-13 13:55:12',NULL,NULL);
INSERT INTO `biblio` VALUES (192,1,'Fundamentals of nursing','','2nd','9788184486100',31,'2009','1041 p. ; ill., col. ; 28 cm','','RT41.B29','en',NULL,19,'','Index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-11-29 17:39:32','2016-11-29 17:41:11',NULL,NULL);
INSERT INTO `biblio` VALUES (193,1,'Breastfeeding handbook : a practical reference for physicians, nurses, and other health professionals','','','',111,'1980','256 p. : ill. ; 24 cm','','RJ216 .G57','en',NULL,61,'','Includes bibliographical references (pages 244-245) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-11-30 09:36:31','2016-11-30 09:40:32',NULL,NULL);
INSERT INTO `biblio` VALUES (194,1,'Reproductive potential and fertility control','','','9780750622493',112,'1996','xix, 188 p. ; 24 cm.','Psychology of reproduction','RG103.5 .R29','en',NULL,47,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-11-30 10:07:35','2016-11-30 10:08:40',NULL,NULL);
INSERT INTO `biblio` VALUES (195,1,'Introducing genetics','','','0719542359',113,'1986','x, 325 p. : ill. ; 24 cm','','QH430.J71','en',NULL,7,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-11-30 10:19:57','2016-11-30 10:20:58',NULL,NULL);
INSERT INTO `biblio` VALUES (196,1,'Caring for the vulnerable : perspectives in nursing theory, practice, and research','','','9780763751098',114,'2008','xxiv, 582 p','','RT86.5 .C19','en',NULL,62,'','Includes references',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-11-30 10:33:10','2016-11-30 10:34:14',NULL,NULL);
INSERT INTO `biblio` VALUES (197,1,'Safe motherhood strategies : a review of the evidence','','','9076070199',115,'2001','vi, 451 p. : ill. ; 24 cm.','Studies in health services organisation & policy','RG530.Sa1','en',NULL,63,'','Includes bibliographical references.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-11-30 10:53:11','2016-12-12 10:17:13',NULL,NULL);
INSERT INTO `biblio` VALUES (198,1,'Short textbook of public health medicine for the tropics','','4th','9780340816455',116,'2003','x, 389 pages, [32] pages of plates : illustrations','','RC961.5 .L96','en',NULL,8,'','Revised edition of: A new short textbook of preventive medicine for the tropics / Adetokunbo O. Lucas, Herbert M. Gilles. 3rd ed. 1990.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-11-30 12:16:06','2016-11-30 12:20:45',NULL,NULL);
INSERT INTO `biblio` VALUES (199,1,'Midwifery by ten teachers','','','9780340941591',116,'2006','xvi, 341 p. : ill. ; 25 cm','The midwife and modern maternity care -- 2 Conception, implantation and embryology -- 3 Normal fetal development and growth -- 4 Physiological changes in pregnancy -- 5 Antenatal care -- 6 Antenatal i','RG950 .M58','en',NULL,8,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-11-30 12:34:48','2016-11-30 12:38:18',NULL,NULL);
INSERT INTO `biblio` VALUES (200,1,'Basic facts for basic science','','','0881676659',106,'1990','xii, 258 p. : ill. ; 23 cm','','Q161.2 .Z1','en',NULL,8,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-12-01 18:31:56','2016-12-01 18:52:05',NULL,NULL);
INSERT INTO `biblio` VALUES (201,1,'Essentials of critical care nursing : body-mind-spirit','','','9780397548453',24,'1990','xvii, 666 p. : ill. ; 23 cm','','RT120.I5 D46','en',NULL,11,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-12-01 19:10:45','2016-12-01 19:36:23',NULL,NULL);
INSERT INTO `biblio` VALUES (203,1,'Basic concepts of psychiatric-mental health nursing','','3rd','9780397550012',24,'1994','xxv, 672 p. : ill. ; 23 cm','Unit 1. Psychiatric-Mental Health Nursing. 1. Mental Health and Mental Illness. 2. Psychiatric Nursing History and Trends. 3. Legal Issues -- Unit 2. Components of Psychiatric-Mental Health Nursing. 4','RC440.Sh6','en',NULL,11,'','A concise coverage of essential theory and assessment and related interventions in psychiatric- mental health nursing.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2016-12-12 12:53:50','2017-09-20 11:04:05',NULL,NULL);
INSERT INTO `biblio` VALUES (204,1,'Essentials of psychiatric mental health nursing','','3rd','9780803612679',87,'2005','xx, 697 p. : ill. en coul. ; 25 cm','','RC440 .T66','en',NULL,11,'','Using the stress-adaptation model as its conceptual framework, this text provides comprehensive yet need-to-know coverage of psychiatric/mental health nursing.\" \"Each disorder includes historic and epidemiologic factors, background assessment data, predisposing factors/symptomatology, common nursing diagnoses with standardized guidelines for intervention in care, outcome criteria, reassessment evaluation, and medications/treatment modalities.\"--Résumé de l\'éditeur.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-03-16 15:50:46','2017-03-16 16:22:00',NULL,NULL);
INSERT INTO `biblio` VALUES (205,1,'Brunner & Suddarth\'s textbook of medical-surgical nursing.','','11th','9780781759786',63,'2008','xxix, 2630, 109 pages : illustrations','Brunner and Suddarth\'s textbook of medical-surgical nursing\r\nTextbook of medical-surgical nursing','RT41 .T31','en',NULL,11,'','Focusing on health promotion, this book provides coverage of patients with chronic illness and disabilities. It includes an accompanying CD-ROM which features over 3,500 NCLEX [registered]-style questions and three-dimensional animations that demonstrate disease processes.\r\n',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-03-16 17:41:31','2017-03-16 19:01:30',NULL,NULL);
INSERT INTO `biblio` VALUES (206,1,'Microbiology : an introduction','','6th','9780805385359',118,'1998','832p. ; ill. ; 29cm. + 1 compact disc (4 3/4in.).','','QR41.2 T63','en',NULL,64,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-03-16 19:13:16','2017-03-16 19:19:28',NULL,NULL);
INSERT INTO `biblio` VALUES (207,1,'Mechanisms of microbial disease','','3rd','978068307605990000',119,'1998','xvi, 733 p : ill. , 27cm','','QR46 .M58','en',NULL,65,'','Includes bibliographical references and index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-03-16 19:42:43','2017-03-16 19:43:53',NULL,NULL);
INSERT INTO `biblio` VALUES (208,1,'Microbiology:concepts and applications','','','9780071129145',56,'1993','xxiv, 896 p : ill., 28cm','','QR41.2 .P41','en',NULL,8,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-03-16 19:58:24','2017-03-16 20:02:38',NULL,NULL);
INSERT INTO `biblio` VALUES (209,1,'Jawetz, Melnick, & Adelberg\'s medical microbiology','','23rd','9780071239837',56,'2004','818 p : ill. ; 23 cm.','A Lange medical book','QR46 .B79','en',NULL,8,'','International edition.\r\nIncludes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-03-16 20:19:57','2017-03-16 20:21:00',NULL,NULL);
INSERT INTO `biblio` VALUES (210,1,'Human biology','','','9780072496697',56,'2002','xix, 514, (54) p. : ill. (chiefly col.) ; 28 cm','','QP36 .M26','en',NULL,47,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-03-16 20:39:08','2017-03-16 20:41:57',NULL,NULL);
INSERT INTO `biblio` VALUES (211,1,'Myles textbook for midwives.','','African Edition','9780443102516',120,'2006','xvi, 1031 p : ill. , 24cm','','RG524 .F86','en',NULL,8,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-03-17 10:03:59','2017-04-10 12:15:03',NULL,NULL);
INSERT INTO `biblio` VALUES (212,1,'Brunner & Suddarth\'s textbook of medical-surgical nursing.','','12th','9781608310807',20,'2010','xxvii, 2240 p. , 96 pages : ill. (some col) ; 29 c','Brunner and Suddarth\'s textbook of medical-surgical nursing\r\nTextbook of medical-surgical nursing','RT41 .T31','en',NULL,11,'','Preparing students for successful NCLEX results and strong futures as nurses in today\'s world. Now in its 12th edition, Brunner and Suddarth\'s Textbook of Medical-Surgical Nursing is designed to assist nurses in preparing for their roles and responsibilities in the medical-surgical setting and for success on the NCLEX. In the latest edition, the resource suite is complete with a robust set of premium and included ancillaries such as simulation support, adaptive testing, and a variety of digital resources helping prepare today\'s students for success. This leading textbook focuses on physiological, pathophysiological, and psychosocial concepts as they relate to nursing care. Brunner is known for its strong Nursing Process focus and its readability. This edition retains these strengths and incorporates enhanced visual appeal and better portability for students. Online Tutoring powered by Smarthinking-Free online tutoring, powered by Smarthinking, gives students access to expert nursing and allied health science educators whose mission, like yours, is to achieve success. Students can access live tutoring support, critiques of written work, and other valuable tools. -- Provided by publisher.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-03-17 13:11:34','2017-03-17 15:31:44',NULL,NULL);
INSERT INTO `biblio` VALUES (213,1,'Myles textbook for midwives','','14th','9780443072352',13,'2003','xiv, 1089 p. : ill.,  (some col.) ; 26 cm','','RG960 .M99','en',NULL,10,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-03-22 15:11:37','2017-03-24 13:05:01',NULL,NULL);
INSERT INTO `biblio` VALUES (214,1,'Myles textbook for midwives','','13th','0443063923',13,'1999','xiv, 1031. : ill., 24cm','Textbook for midwives','RG524 .B43','en',NULL,10,'','Includes bibliographical references and index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-03-23 21:03:13','2017-03-24 12:53:40',NULL,NULL);
INSERT INTO `biblio` VALUES (215,1,'Myles textbook for midwives','','15th','9780443068447',13,'2009','xiv, 1122 p. : ill., (some color) ; 26 cm','Midwifery -- Human anatomy and reproduction -- Pregnancy -- Labour -- The puerperium -- The newborn baby -- the context of midwifery practice.','RG524 .C77','en',NULL,10,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-03-24 13:27:12','2017-03-24 13:30:36',NULL,NULL);
INSERT INTO `biblio` VALUES (216,1,'Myles textbook for midwives','','12th','0443056366',13,'1996','XV, 838 p. : ill. ; 25 cm.','','RG524 .M94','en',NULL,10,'','Includes references',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-03-27 12:03:29','2017-03-27 12:10:37',NULL,NULL);
INSERT INTO `biblio` VALUES (217,1,'Myles\' textbook for midwives','','11th','9780443030772',13,'1989','xiii, 786 p. : ill. ; 25 cm','Textbook for midwives','RG524 .M58','en',NULL,10,'','Eleventh ed. of: Textbook for midwives / Margaret F. Myles. 10th ed. 1985.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-03-27 12:23:26','2017-03-27 12:35:20',NULL,NULL);
INSERT INTO `biblio` VALUES (218,1,'A textbook for midwives in the tropics','','2nd','9988592736',40,'1982','xii, 468 p. : ill','','RG526 .Oj5','en',NULL,7,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-03-31 13:15:36','2017-11-13 09:54:48',NULL,NULL);
INSERT INTO `biblio` VALUES (219,1,'International journal of nursing and midwifery','','Vol. 1 No.1','9772026588008',121,'2017','x, 95 p ; 29cm','','RT1 .In8','en',NULL,18,'','Includes references\r\nAlso available online: http//www.numidhorizone.com','International_journal_of_nursing_and_midwifery.png.png',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2017-04-10 11:24:40','2019-07-17 10:37:38',NULL,NULL);
INSERT INTO `biblio` VALUES (222,1,'Families today.','','2nd','9780026429269',124,'1997','640 pag : col. ill ; 27 cm','Families make a difference -- What families are like -- Families in a changing world -- Roles and relationships -- Improving communication -- Resolving conflicts -- Building family relationships -- Ha','HQ536 .Sa7','en',NULL,8,'','Includes index.\r\nHow much do you know about families? Simply living in a family doesn\'t make anyone an expert on them. When asked to name what means the most to them in their lives, people often respond, \"My family.\" Obviously, the care of families is too important to be left to chance. Turning to the expertise, knowledge, and experience of others makes good sense. You may be surprised to discover all that you can learn and put to good use in your life after studying about families. Take a look. - p. 17-18.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-12 11:06:33','2017-04-12 11:09:01',NULL,NULL);
INSERT INTO `biblio` VALUES (223,1,'Life-span development','','7th','9780697364395',125,'1999','xxviii, 652 p : col., ill. ; 28 cm','','BF713 .Sa5','en',NULL,47,'','An up-to-date presentation of research in three primary divisions of development: biological, cognitive and socio emotional. Includes a discussion on how to apply what we know about life-span development to everyday life.\r\nIncludes bibliographical references (pages 591-620) and indexes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-12 11:22:45','2017-04-12 11:25:05',NULL,NULL);
INSERT INTO `biblio` VALUES (224,1,'Concepts in biology','','8th','9780697272058',126,'1997','xvii, 458 pages : illustrations (some color), maps','Concepts in biology','QH308.2 .En3','en',NULL,67,'','Revised edition of: Concepts in biology / Eldon D. Enger [and others]. c1994.\r\nIncludes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-12 11:39:39','2017-04-12 11:42:23',NULL,NULL);
INSERT INTO `biblio` VALUES (225,1,'Chemistry : the molecular nature of matter and change','','2nd','9780697395979',125,'2000','1 volume (various pagings) : illustrations (some c','','QD33 .Si3','en',NULL,47,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-12 11:56:16','2017-04-12 12:05:21',NULL,NULL);
INSERT INTO `biblio` VALUES (226,32,'Accountability in nursing and midwifery','','2nd','',0,'','','','','',NULL,0,'','Abstract\r\n\"The second edition of Accountability in Nursing and Midwifery addresses current issues and key concerns in accountability, focusing on accountability in the four main branches of nursing (adult, child, learning disabilities and mental health), as well as in midwifery, community nursing, and nursing management. In an increasingly litigous society, the ethical and legal implications of accountability are growing and it is important that nurses understand the implications for everyday practice.\"--BOOK JACKET.\r\n\r\nContents	\r\nIntroduction / Roger Watson, Stephen Tilley -- The development of nursing as an accountable profession / Susan Mcgann -- Accountability and clinical governance in nursing : a critical overview of the topic / Kerry Jacobs -- Accountability and clinical governance / Roger Watson -- The legal accountability of the nurse / John Tingle -- Accountability and clinical governance : a policy perspective / Tracey Heath -- Accountability in NHS trusts / Stephen Knight, Tony Hostick -- Accountability and clinical governance in nursing : a manager\'s perspective / Linda Pollock -- Working with children : accountability and paediatric nursing / Gosia Brykczyñska -- Accountability and clinical governance in learning disability nursing / Bob Gates, Mick Wolverson, Jane Wray -- Where does the buck stop? : accountability in midwifery / Rosemary Mander -- Accountability in community nursing / Sarah Baggaley, Alison Bryans -- Clinical governance, accountability and mental health nursing: an emergent story / Stephen Tilley -- Accountability in nursing research / Alison Tierney, Roger Watson.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 00:16:36','2017-04-21 04:15:36',NULL,NULL);
INSERT INTO `biblio` VALUES (227,32,'Becoming a midwife in the 21st century','','','0470985828',93,'2008','xiii, 458 pages : illustrations','','RG950.B38','en',NULL,68,'','Contents	Effective communication / Tandy Deane-Gray -- The aims of antenatal care / Laura Abbott -- Programmes of care during childbirth / Laura Abbott -- Interdisciplinary working: seamless working within maternity care / Eileen Huish & Lisa Nash -- Intrapartum care / Annabel Jay & Cathy Hamilton -- Effective emergency care / Caroline Duncombe, Meryl Dimmock & Sarah Green -- Initial assessment and examination of the newborn baby / Lyn Dolby -- Effective postnatal care / Annabel Jay -- Medication and the midwife / Cathy Hamilton -- Effective documentation / Carole Yearley, Celia Wildeman & Chandra Mehta -- Regulating the midwifery profession: protecting women or the profession? / Christine Lawrence & Carole Yearley -- The impact of cultural issues on the practice of midwifery / Celia Wildeman -- Legislation and the midwife / Cathy Hamilton & Lisa Nash -- Confidentiality / Celia Wildeman -- Clinical decision-making / Marianne Mead -- Health, safety and environmental issues / Lisa Nash -- Evidence-based practice / Marianne Mead -- Statutory supervision of midwives / Kath Mannion -- Clinical governance framework and quality assurance in relation to midwifery care / Cathy Rogers, Sally Luck & Nada Schiavone.','Becoming_a_Midwife_in_the_21st_Century.jpg.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2017-04-20 00:27:47','2019-07-15 15:42:52',NULL,NULL);
INSERT INTO `biblio` VALUES (228,32,'Becoming a midwife','','','',94,'2009','xiv, 228 pages','','','en',NULL,69,'','Contents\r\nMidwifery care in the community during the woman\'s pregnancy / Yvonne Fontein -- Midwifery care while the woman is in labour in an institution / Miranda Page -- Midwifery care of the mother and baby at home / Alison Ewing -- Midwives and perinatal mental health / Eleanor Forrest -- The midwife manager / Georgina Sosa -- The midwife who is in education / Elma Paxton -- The supervisor of midwives / Jean Duerden -- The academic midwife / Rosemary Mander -- The midwife as a researcher / Ans Luyben -- The midwife historian / Lindsay Reid -- The global midwife / Valerie Fleming -- The independent midwife / Nessa McHugh -- A male midwife\'s perspective / Denis Walsh -- The midwife who is not a mother / Rosemary Mander -- The midwife who is an author / Penny Curtis -- The ex-midwife / Elaine Haycock-Stuart.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 00:34:10','2017-04-21 04:17:49',NULL,NULL);
INSERT INTO `biblio` VALUES (229,32,'Complementary therapies in nursing and midwifery : from vision to practice','','','',127,'2001','xvi, 320 pages : illustrations, portraits','','','en',NULL,70,'','Contents\r\nComplementary therapies: historical, political and professional issues -- Introduction -- Nursing and complementary therapies: a natural partnership -- Complementary care: redefining nursing for the new millennium -- Developing clinical practice guidelines -- Education and professional development -- Legal and ethical aspects of complementary therapies and complementary care -- Research issues in complementary therapies and holistic care -- Careers and opportunities: complementary therapies and future nursing -- Complementary therapies: some therapeutic approaches -- Introduction -- Nutrition as a complementary therapy -- Aromatherapy -- Massage -- Relaxation: the learned response -- Therapeutic touch and healing touch: nursing modalities for the new millennium -- Introduction to music therapy -- Nursing and the role of animals -- Complementary therapies in action: stories from the workplace -- Introduction -- Complementary therapies in a high-tech health care environment: a pleasing and powerful partnership -- Complementary therapies in aged care -- Complementary therapies in a palliative care setting: the clinical experience -- Complementary therapies in midwifery practice -- Choosing a complementary therapy course: what should you consider? -- Animal-assisted therapy within hospitals: suggested infection control: a summary.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 00:40:52','2017-04-21 04:17:01',NULL,NULL);
INSERT INTO `biblio` VALUES (230,32,'Enabling learning in nursing and midwifery practice : a guide for mentors','','','',93,'2007','xv, 251 pages','','','en',NULL,68,'','Abstract	\r\n\"This text addresses the inter-professional and policy context for mentorship, examines the nature of effective learning environments and provides mentors with the necessary tools to assist students in their development within a practice setting. It explores the use of reflective practice, virtual learning and other core resources to enhance and support learning in practice and examines assessment of practice, making correct judgements about student competence and the development of competence in newly qualified practitioners.\" \"Enabling Learning in Nursing and Midwifery Practice: A Guide for Mentors is an important resource text for practitioners seeking to update their skills and understanding.\"--BOOK JACKET.\r\n\r\nContents	\r\nContemporary issues in mentoring practice / Margaret Andrews -- A good placement experience : the student\'s perspective of their needs in the practice setting / Sue West -- The reflective mentor : facilitating learning in the practice setting / Melanie Jasper -- Helping people learn / Stevie Penfold -- Developing effective learning relationships in practice / Sheila Daykin -- Learning styles in practice / Tim Clark -- Using interpersonal skills in mentoring / Sue Riddell -- The learning environment / Gill Beer, Andrew Southgate -- The development of competence in newly qualified practitioners / Tim Clark -- Assessment of practice : principles, process and responsibilities / Sue West -- Use of the Internet to support learning in practice / Susan Westerman, Emily Hurt -- Challenges in the interprofessional agenda / Judith Parsons -- Working as a professional : standards for professional practice / Melanie Jasper.','Nurse_as_Educator_Principles_of_Teaching_and_Learning_for_Nursing_Practice.jpg.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2017-04-20 00:58:27','2019-12-16 09:33:34',NULL,NULL);
INSERT INTO `biblio` VALUES (231,1,'Essential midwifery practice : intrapartum care','','','',89,'2010','xiii, 306 pages','','','en',NULL,50,'','Contents\r\nEvolution of current systems of intrapartum care / Denis Walsh -- Debates about knowledge and intrapartum care / Soo Downe -- Childbirth education : politics, equality and revelance / Mary Nolan -- Birth environment / Denis Walsh -- Labour rhythms / Denis Walsh -- Evidence for neonatal transition and the first hour of life / Judith Mercer & Debra Erikson-Owens -- Midwifery presence : philosophy, science and art / Holly Powell-Kennedy, Tricia Anderson & Nicky Leap -- Skills for working with (the woman in) pain / Rosemary Mander -- Complementary therapies in labour : a woman-centered approach / Denise Tiran -- Midwifery skills for normalising unusual labours / Verena Schmidt and Soo Downe -- Psychology and labour experience : birth as peak experience / Gill Thompson -- Sexuality in labour and birth : an intimate perspective / Sarah Buckley -- Spirituality and labour care / Jenny Hall -- How midwives should organise to provide intrapartum care / Chris McCourt -- Feminism and intrapartum care / Mary Stewart -- Toward salutogenic birth in the 21st century / Soo Downe.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 01:04:55','2017-04-21 04:14:48',NULL,NULL);
INSERT INTO `biblio` VALUES (232,32,'Fundamentals of midwifery : a textbook for students / edited by Louise Lewis.','','1st ed.','9781118528020',128,'2015','1 online resource (xiv, 423 pages) : color illustr','QFundamentals midwifery','RG950 .F96','en',NULL,53,'','Contents	To be a midwife / Nicky Clark, Carol Paeglis -- Team working / Mary Beadle, Sue Townend -- Sociology applied to maternity care/ Mary Beadle, Sara Wise -- Psychology applied to maternity care / Julie Jomeen, Lynda Bateman -- Parenthood / Olanma Ogbuehi, Jacqui Powell -- Antenatal midwifery care / Julie Flint, Carol Lambert -- Intrapartum midwifery care / Julie Flint, Sue Townend -- Postnatal midwifery care / Louise Lewis, Lisa Lachanudis -- Care of the newborn / Liz Smith, Brenda Waite -- Infant feeding / Louise Lewis, Liz Mason -- Public health and health promotion / Olanma Ogbuehi, Fiona Robinson, Catriona Jones -- Contraception and family planning / Liz Smith, Sarah Wise -- Perinatal mental health / Julie Jomeen, Nicky Clark -- Complementary and alternative medicines applied to maternity care / Catriona Jones, Jane Marsh -- Pharmacology and medicines management / Mary Beadle, Andrea Hilton -- Emergencies in midwifery / Liz Smith, Brenda Waite -- Bereavement and loss / Liz Smith, Brenda Waite.\r\nIncludes access to Wiley E-Text for self-test.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 08:48:36','2019-10-10 17:05:09',NULL,NULL);
INSERT INTO `biblio` VALUES (233,32,'Florence Nightingale on Women,Medicine, Midwifery and Prostitution','','','0-88920-466-7',239,'2005','1 online resource (Vol.8, 1110 pages).','','RT37.N56','en',NULL,140,'','Volume 8: Florence Nightingale on Women, Medicine, Midwifery and Prostitution makes available a great range of Florence Nightingale\'s work on women: her pioneering study of maternal mortality in childbirth (Introductory Notes on Lying-in Institutions), her opposition to the regulation of prostitution through the Contagious Diseases Acts (attempts to stop the legislation and otherwise to facilitate the voluntary treatment of syphilitic prostitutes), her views on gender roles, marriage and measures for income security for women and excerpts from her draft (abandoned) novel. There is corresponde.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 18:25:21','2019-08-28 13:37:33',NULL,NULL);
INSERT INTO `biblio` VALUES (234,32,'Florence Nightingale’s NOTES ON NURSING & NOTES ON NURSING FOR THE LABOURING CLASSES','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 18:26:41','2017-04-21 04:12:05',NULL,NULL);
INSERT INTO `biblio` VALUES (235,32,'HEALTH PROMOTION IN MIDWIFERY PRINCIPLES AND PRACTICE','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 18:31:58','2017-04-21 04:10:15',NULL,NULL);
INSERT INTO `biblio` VALUES (236,32,'Legal Aspects of Midwifery','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 18:34:03','2017-04-21 04:09:27',NULL,NULL);
INSERT INTO `biblio` VALUES (237,32,'Managing newborn problems a guide for doctors, nurses, and midwives_Integrated management of pregnancy and childbirth','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 18:36:34','2017-04-21 04:08:42',NULL,NULL);
INSERT INTO `biblio` VALUES (238,32,'Midwife’s Guide to Antenatal Investigations','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 18:38:26','2017-04-21 04:07:57',NULL,NULL);
INSERT INTO `biblio` VALUES (239,32,'Safeguarding Children and Young People_A guide for nurses and midwives','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 18:40:21','2017-04-21 04:06:54',NULL,NULL);
INSERT INTO `biblio` VALUES (240,32,'Sustainability, Midwifery and Birth','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 18:41:56','2017-04-21 04:06:24',NULL,NULL);
INSERT INTO `biblio` VALUES (241,32,'The Social Meaning of Midwifery','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 18:45:53','2017-04-21 04:05:22',NULL,NULL);
INSERT INTO `biblio` VALUES (242,32,'Varney’s midwifery','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 18:50:23','2017-04-21 04:04:44',NULL,NULL);
INSERT INTO `biblio` VALUES (243,32,'Human nutrition : a health perspective / Mary E. Barasi ; illustrations by Megan Morris','','2nd ed.','0 340 81025 4',214,'2003','1 online resource (xi, 403 pages) : illustrations','','QP141 .B23','en',NULL,141,'','pt. 1. The study of nutrition and food habits -- pt. 2. The nutrients in food and their role in health -- pt. 3. The application of nutritional knowledge.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 18:56:44','2019-10-10 19:13:36',NULL,NULL);
INSERT INTO `biblio` VALUES (244,32,'Advanced Assessment_Interpreting Findings and Formulating Differential Diagnosis','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 19:04:43','2017-04-21 04:03:35',NULL,NULL);
INSERT INTO `biblio` VALUES (245,32,'Advanced Cardiac Life Support, A Guide for Nurses','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 19:08:25','2017-04-21 04:02:54',NULL,NULL);
INSERT INTO `biblio` VALUES (246,32,'B Is for Balance, A nurse’s guide for enjoying life at work and at home','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 19:13:00','2017-04-21 04:02:13',NULL,NULL);
INSERT INTO `biblio` VALUES (247,32,'Breastfeeding challenges made easy for late preterm infants [ressource électronique] : the go-to guide for nurses and lactation consultants / Sandra Cole','','','9780826196040',210,'2014','1 ressource en ligne (276 pages)','','RJ216 .C66','en',NULL,8,'','','Breastfeeding_challenges_made_easy_for_late_preterm_infants_Sandra_Cole.jpg.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2017-04-20 19:19:33','2019-07-17 10:07:50',NULL,NULL);
INSERT INTO `biblio` VALUES (248,32,'Cancer of the gastrointestinal tract : a handbook for nurse practitioners / edited by Davinia Porock and Diane Palmer.','','','9780470031650',216,'2004','1 online resource (xii, 272 pages) : illustrations','A handbook for nurse practitioners','RC280.D5 C16','en',NULL,11,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 19:24:17','2019-06-10 09:58:24',NULL,NULL);
INSERT INTO `biblio` VALUES (249,32,'Care of the Dying and Deceased Patient, A practical guide for Nurses','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 19:26:17','2017-04-20 23:17:57',NULL,NULL);
INSERT INTO `biblio` VALUES (250,32,'Caring for People with Problem Behaviours_A basic, practical text for nurses, health workers and others who are learning to manage difficult behaviours','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 19:28:25','2017-04-20 23:16:57',NULL,NULL);
INSERT INTO `biblio` VALUES (251,32,'Cliffs Test Prep Nursing School Entrance Exams','','','0-7645-5986-9',128,'2004','1 online resource (274 pages)','','RT79.G78','en',NULL,132,'','A complete test-prep guide for the rapidly growing number of nursing program applicantsThis thorough guide reviews the five areas covered in RN entrance tests: verbal ability, numerical ability, life sciences, physical sciences, and reading skills. It includes two full-length practice exams with answers and solutions. Fred N. Grayson (Ridgefield, CT), an independent book developer and publisher, has written or coauthored dozens of books in the test preparation field.\r\nIncludes bibliographical references',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 19:31:39','2019-06-11 10:44:10',NULL,NULL);
INSERT INTO `biblio` VALUES (252,32,'Clinical coach for nursing excellence / Linda Campbell, Marcia A. Gilbert, Gary R. Laustsen.','','','0803621868',87,'2010','1 online resource (xiv, 297 p.) illustrations','Davis\'s clinical coach series','RT86.7 .C61','en',NULL,11,'','','CLINICAL_COACH_for_Nursing_Excellence.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 19:42:10','2019-07-17 10:30:09',NULL,NULL);
INSERT INTO `biblio` VALUES (253,32,'Clinical nurse specialist toolkit : a guide for the new clinical nurse specialist / Melanie Duffy, Susan Dresser, Janet S. Fulton, editors.','','','9781282025264',210,'2009','1 online resource (xi, 178 pages) : illustrations','','RT82.8 .C61','en',NULL,8,'','This toolkit is a concise and handy reference guide designed for those new graduates and novice Clinical Nurse Specialists (CNS) just getting started in this exciting new career. Containing all the essential information a new CNS needs to know, this tool-kit serves as a one-stop, all-inclusive guide for the CNS. Organized in an easy-to-use, bullet-point format, this book contains 6 sections, each filled with key topics and relevant information, including how to:. Key features.:.; Negotiate and secure a job.; Mentor staff, lead groups, and precept students.; Apply for reimbursement.; Pursue cer.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 19:44:05','2019-06-11 12:02:32',NULL,NULL);
INSERT INTO `biblio` VALUES (254,32,'Compact clinical guide to infant and children\'s pain management : an evidence-based approach / Linda L. Oakes.','','','978-0-8261-0618-6',210,'2011','1 online resource (ix, 399 p.)','Compact clinical guide series','RJ365 .Oa4','en',NULL,95,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 19:48:17','2019-06-11 15:00:40',NULL,NULL);
INSERT INTO `biblio` VALUES (255,32,'Davis\'s basic math review for nurses : with step-by-step solutions / Vicki Raines.','','','978-0-8036-2056-8',87,'2010','1 online resource (xix, 340 pages) : illustrations','Basic math review for nurses','RT68 .R13','en',NULL,11,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 19:51:14','2019-07-02 10:28:08',NULL,NULL);
INSERT INTO `biblio` VALUES (256,32,'Davis’s DRUG GUIDE FOR NURSES_11th Edition','','11th','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 19:56:55','2017-04-20 23:12:26',NULL,NULL);
INSERT INTO `biblio` VALUES (257,32,'Delmar’s National Council Licensure Examination (NCLEX)-PN REVIEW','','','',0,'','','','','en',NULL,0,'','','cover_delmar_s_national_council_licensure_examination_nclex_pn_review.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2017-04-20 20:02:27','2022-02-17 08:00:35',NULL,NULL);
INSERT INTO `biblio` VALUES (258,32,'Delmar\'s practice questions for NCLEX-PN / Judith C. Miller, Janet Tompkins McMahon.','','2nd ed.','978-1-428-31219-7',235,'2011','1 online resource (ix, 390 pages).','Practice questions for NCLEX-PN','RT62 .M61','en',NULL,135,'','Unit 1 Overview of practical/vocational nursing -- How to prepare for NCLEX-PN -- Essential concepts.\r\nUnit II Medical-surgical nursing -- The Cardiovascular system -- The Hematologic system -- The Respiratory system -- The Neurosensory system -- The Gastorintestinal system -- The Genitourinary system -- The Musculoskeletal system -- The endocrine system -- The Integumentary system.\r\nUnit III Maternity Pediatrics -- The Female reproductive system, maternity, and newborns -- Pediatrics.\r\nUnit IV Special populations -- The Older adult client -- The Mental health client -- The Perioperative client -- The Client with cancer.\r\nUnit V Health promotion and drug therapy -- Nutrition and special diets -- Pharmacology.\r\nUnit VI Comprehensive Practice Test -- Practice test one -- Practice test one -- Practice test two -- Practice test three -- Practice test four -- Practice test five -- Practice test six -- Practice test seven -- Practive test eight.','cover_delmar_s_practice_questions_for_nclex_pn_judith_c_miller_janet_tompkins_mcmahon_.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2017-04-20 20:05:33','2022-02-17 07:53:55',NULL,NULL);
INSERT INTO `biblio` VALUES (259,32,'ECGs for Nurses','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 20:09:59','2017-04-20 23:11:43',NULL,NULL);
INSERT INTO `biblio` VALUES (260,32,'Enabling Learning in Nursing and Midwifery Practice_A Guide for Mentors','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 20:14:25','2017-04-20 23:11:10',NULL,NULL);
INSERT INTO `biblio` VALUES (261,32,'Evaluation and testing in nursing education / Marilyn H. Oermann, Kathleen B. Gaberson.','','2nd','0-8261-9951-8',219,'2006','1 online resource (xiv, 403 pages) : illustrations','','RT73.7 .Oe7','en',NULL,95,'','Designated a Doody\'s Core Title!. The second edition of Evaluation and Testing in Nursing Education helps nursing educators measure and evaluate the level of learning that their students receive and aids them in altering their class plans. This award-winning book is the only book in nursing education that focuses entirely on evaluation and testing; explains how to prepare all types of test items; and explores how to assemble, administer, and analyze tests, measurement concepts, grading, and clinical evaluation. Educators will learn the basics of how to plan for classroom testing, analyze test.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 20:17:09','2019-07-04 14:32:43',NULL,NULL);
INSERT INTO `biblio` VALUES (262,32,'Evaluation and testing in nursing education Marilyn H. Oermann, Kathleen B. Gaberson','','3rd','978-0-8261-1062-6',210,'2009','1 online resource (xv, 446 p.)  : illustrations.','','RT73.7 .Oe7','en',NULL,95,'','This book presents a comprehensive list of all the tools required to measure students\' classroom and clinical performance. The newly revised edition sets forth expanded coverage on essential concepts of evaluation, measurement, and testing in nursing education; quality standards of effective measurement instruments; how to write all types of test items and establish clinical performance parameters and benchmarks; and how to evaluate critical thinking in written assignments and clinical performance. --from publisher description.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 20:18:50','2019-07-15 11:33:01',NULL,NULL);
INSERT INTO `biblio` VALUES (263,32,'Evaluation and testing in nursing education / Marilyn H. Oermann, PhD, RN, ANEF, FAAN, Kathleen B. Gaberson, PhD, RN, CNOR, CNE, ANEF','','4th ed.','978-0-8261-9556-2',210,'2014','1 online resource (xv, 434 p.)','','RT73.7 .Oe7','en',NULL,95,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 20:21:32','2019-07-15 11:49:35',NULL,NULL);
INSERT INTO `biblio` VALUES (264,32,'Everyday English for international nurses : a guide to working in the UK / Joy Parkinson, Chris Brooker.','','','1417593431',13,'2004','1 online resource (xi, 237 pages) : illustrations','','R123 .P22','en',NULL,10,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 20:23:36','2019-07-15 12:09:32',NULL,NULL);
INSERT INTO `biblio` VALUES (265,32,'Evidence-based advance directives : a guide for nurses / Dinah Brothers.','','','1-57839-685-9',0,'2005','1 online resource (x, 93 pages)','','RT42.B79','en',NULL,139,'','Includes bibliographical references.','Evidence-Based_Advance_Directives,_A_study_guide_for_Nurses.jpg.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2017-04-20 20:25:04','2019-07-15 14:35:33',NULL,NULL);
INSERT INTO `biblio` VALUES (266,32,'FAST FACTS FOR THE ANTEPARTUM AND POSTPARTUM NURSE_A Nursing Orientation and Care Guide in a Nutshell','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 20:30:45','2017-04-20 23:06:25',NULL,NULL);
INSERT INTO `biblio` VALUES (267,32,'FAST FACTS FOR THE TRAVEL NURSE_Travel Nursing in a Nutshell','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 20:34:11','2017-04-20 23:05:38',NULL,NULL);
INSERT INTO `biblio` VALUES (268,32,'Fertility demystified : [a self-teaching guide] / Susan Warhus.','','','9780071479226',238,'2007','1 online resource (272 pages)','','RC889 .W23','en',NULL,95,'','Includes bibliographical references',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 20:37:48','2019-08-28 12:55:22',NULL,NULL);
INSERT INTO `biblio` VALUES (269,32,'Fundamentals of Health Promotion for Nurses','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 20:41:53','2017-04-20 23:03:59',NULL,NULL);
INSERT INTO `biblio` VALUES (270,32,'Fundamentals of Palliative Care for Student Nurses','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 20:44:45','2017-04-20 23:03:20',NULL,NULL);
INSERT INTO `biblio` VALUES (271,32,'Handbook of service user involvement in nursing and healthcare research / Elizabeth Morrow [and others].','','','',0,'','1 online resource (xvii, 203 pages) : illustration','','RT81.5 .H19','en',NULL,0,'','This book fills an important niche in the market providing practical expert advice on service user (patients, carers and the public) involvement in nursing and healthcare research. An invaluable guide for anyone working or involved in nursing and healthcare research, this book provides a step-by-step guide to the principles and process of involvement, including understanding the rationale for involvement, designing involvement, working with service users, and evaluating what has been achieved.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 20:47:19','2019-10-10 18:02:51',NULL,NULL);
INSERT INTO `biblio` VALUES (272,32,'Healthy Places, Healthy People_A Handbook for Culturally Competent Community Nursing Practice','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 20:49:40','2017-04-20 23:00:18',NULL,NULL);
INSERT INTO `biblio` VALUES (273,32,'Heart failure : a clinical nursing handbook / Christopher Nicholson','','','978-0-470-05760-5',128,'2007','1 online resource (xii, 258 p.) illustrations','Wiley series in nursing','RC685.C46','en',NULL,1,'','Definitions. Epidemiology. Causes. Outcomes. Physiology. Clinical assessment. Investigations. Treatment exxentials. Exercise training. Medicines. Invasive treatments. End-stage heart failure. Policy framework. Service issues',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 20:50:59','2019-10-10 18:39:07',NULL,NULL);
INSERT INTO `biblio` VALUES (274,32,'Illustrated Guide for Theatre Nurses','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 20:54:48','2017-04-20 22:59:17',NULL,NULL);
INSERT INTO `biblio` VALUES (275,32,'Infectious Causes of Cancer_A guide for nurses and healthcare professionals','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-20 20:56:42','2017-04-20 21:18:19',NULL,NULL);
INSERT INTO `biblio` VALUES (276,32,'Infectious Diseases in Children a clinical guide for nurses','','','',0,'','','','','en',NULL,0,'','','Infectious_Diseases_in_Children_a_clinical_guide_for_nurses.jpg.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2017-04-20 20:58:48','2017-04-21 07:11:50',NULL,NULL);
INSERT INTO `biblio` VALUES (277,32,'Integrated Management of Pregnancy And Childbirth_Pregnancy, Childbirth, Postpartum and Newborn Care_A guide for essential practice','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 04:29:49','2017-04-21 04:29:55',NULL,NULL);
INSERT INTO `biblio` VALUES (278,32,'Initial management of acute medical patients : a guide for nurses and healthcare practitioners / edited by Ian Wood, Michelle Garner.','','2nd ed.','978-1-4443-3716-7',89,'2012','1 online resource (x, 310 pages) : illustrations','','RT120.E4 Ian6','en',NULL,137,'','Revised edition of: Medical assessment units / edited by Ian Wood and Michelle Rhodes. London : Whurr, 2003.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 04:32:34','2019-12-16 08:31:52',NULL,NULL);
INSERT INTO `biblio` VALUES (279,32,'International Council of Nurses Advanced Nursing Practice','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 04:36:03','2017-04-21 04:36:12',NULL,NULL);
INSERT INTO `biblio` VALUES (280,32,'Intravenous therapy / Teresa M.D. Finlay.','','','0-632-06451-X',242,'2004','1 online resource (xii, 228 pages) : illustrations','','RM170 .F49','en',NULL,136,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 04:38:04','2019-10-11 09:44:10',NULL,NULL);
INSERT INTO `biblio` VALUES (281,32,'Introduction to the Anatomy and Physiology of Children','','','',0,'','','','','en',NULL,0,'','','Introduction_to_the_Anatomy_and_Physiology_of_Children.jpg.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2017-04-21 04:40:13','2017-04-21 07:13:28',NULL,NULL);
INSERT INTO `biblio` VALUES (282,32,'Liver Diseases_An essential guide for nurses and health care professionals','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 04:43:01','2017-04-21 04:43:08',NULL,NULL);
INSERT INTO `biblio` VALUES (283,32,'Man up! : a practical guide for men in nursing / [edited by] Christopher Lance Coleman.','','','9781937554873',244,'2013','1 online resource (xxiii, 234 pages) : illustratio','','RT41 .M31','en',NULL,144,'','Includes bibliographical references and index.','Man_Up!_A_Practical_Guide_for_Men_in_Nursing.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 04:44:50','2019-10-11 11:40:46',NULL,NULL);
INSERT INTO `biblio` VALUES (284,32,'Managing Pain in Children_A Clinical Guide for Nurses and Healthcare Professionals','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 04:47:34','2017-04-21 04:47:43',NULL,NULL);
INSERT INTO `biblio` VALUES (285,32,'Mastering Pharmacogenomics, A Nurse’s Handbook for Success','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 04:50:14','2017-04-21 04:50:22',NULL,NULL);
INSERT INTO `biblio` VALUES (286,32,'Medicines management : a guide for nurses / edited by Philip Jevon [and others].','','','9781405181631',89,'2010','1 online resource (x, 309 pages) : illustrations','Essential clinical skills for nurses','RM125 .M46','en',NULL,137,'','The safe and effective management of medicines is an essential clinical skill, accounting for up to 40% of a nurse\'s time within practice. Medicines Management provides nurses with a clear, concise and practical exploration of their role in pharmacology and medicines management. It explains what is meant by medicines management, discusses the current professional and legal context, and gives insight into the reasons why mistakes are made. Focusing predominantly on the principles of safe drug administration, this pocket-sized text also explores legal and professional issues, medication errors, administration of oral medication, injections, and intraverous fluids and medicines, medication management in children, and basic pharmacology of common medications. --Book Jacket.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 04:53:30','2019-10-15 19:35:01',NULL,NULL);
INSERT INTO `biblio` VALUES (287,32,'Microbiology Demystified, A self-Teaching Guide','','','1280244933',238,'2005','1 online resource (309 pages)','','QR41.2 B46','en',NULL,95,'','The Microbial World 2. Observing Microorganisms Through a Microscope 3. Functional Anatomy of Prokaryotic and Eukaryotic Cells 4. Microbial Metabolism 5. Microbial Growth and Controlling Microbial Growth 6. Microbial Genetics 7. Biotechnology and Recombinant DNA 8. Classification of Microorganisms 9.','Microbiology_Demystified,_A_self-Teaching_Guide.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 04:59:02','2019-10-21 09:33:48',NULL,NULL);
INSERT INTO `biblio` VALUES (288,32,'Nurse as Educator Principles of Teaching and Learning for Nursing Practice','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 05:02:18','2017-04-21 05:02:26',NULL,NULL);
INSERT INTO `biblio` VALUES (289,32,'NURSING DIAGNOSES_Definitions & Classification_2015–2017','','','',0,'','','','','en',NULL,0,'','','cover_nursing_diagnoses_definitions_classification_2015_2017.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2017-04-21 05:04:33','2022-02-17 07:50:39',NULL,NULL);
INSERT INTO `biblio` VALUES (290,32,'NURSING in TODAY’S WORLD_Trends, Issues, and Management','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 05:09:59','2017-04-21 05:10:18',NULL,NULL);
INSERT INTO `biblio` VALUES (291,32,'Nursing Theories and Nursing Practice','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 05:13:40','2017-04-21 05:13:48',NULL,NULL);
INSERT INTO `biblio` VALUES (292,32,'Nutrition, A Handbook for Nurses','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 05:15:49','2017-04-21 05:16:08',NULL,NULL);
INSERT INTO `biblio` VALUES (293,32,'Ophthalmic Study Guide for Nurses and Health Professionals','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 05:20:04','2017-04-21 05:20:13',NULL,NULL);
INSERT INTO `biblio` VALUES (294,32,'Patients’ Rights,Law and Ethics for Nurses,A practical guide','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 05:21:59','2017-04-21 05:22:08',NULL,NULL);
INSERT INTO `biblio` VALUES (295,32,'Practice Nurse Handbook_5th Edition','','5th','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 05:23:56','2017-04-21 05:24:05',NULL,NULL);
INSERT INTO `biblio` VALUES (296,32,'Public Health Nursing_A Textbook for Health Visitors,School Nurses and Occupational Health Nurses','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 05:26:23','2017-04-21 05:26:31',NULL,NULL);
INSERT INTO `biblio` VALUES (297,32,'Public Health Skills_A Practical Guide for Nurses and Public Health Practitioners','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 05:35:40','2017-04-21 05:35:48',NULL,NULL);
INSERT INTO `biblio` VALUES (298,32,'Routledge Essentials for Nurses, Nursing Theories and Models','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 05:37:41','2017-04-21 05:37:47',NULL,NULL);
INSERT INTO `biblio` VALUES (299,32,'Saunders Nursing Drug Handbook 2016','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 05:41:06','2017-04-21 05:41:15',NULL,NULL);
INSERT INTO `biblio` VALUES (300,32,'Smart Nursing_Nurse Retention & Patient Safety Improvement Strategies','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 05:43:24','2017-04-21 05:43:33',NULL,NULL);
INSERT INTO `biblio` VALUES (301,32,'Statistics Demystified, A self Teaching guide','','','',0,'','','','','en',NULL,0,'','','Statistics_Demystified,_A_self_Teaching_guide.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 05:46:52','2019-07-15 14:53:35',NULL,NULL);
INSERT INTO `biblio` VALUES (302,32,'Study Guide for Maternal Child Nursing Care','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 05:49:24','2017-04-21 05:49:32',NULL,NULL);
INSERT INTO `biblio` VALUES (303,32,'Study Guide Pharmacology_A Patient-Centered Nursing Process Approach','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 05:56:33','2017-04-21 05:56:40',NULL,NULL);
INSERT INTO `biblio` VALUES (304,32,'TEACHING EVIDENCE-BASED PRACTICE IN NURSING_A Guide for Academic and Clinical Settings','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 06:01:03','2017-04-21 06:01:19',NULL,NULL);
INSERT INTO `biblio` VALUES (305,32,'THE CARE OF WOUNDS, A GUIDE FOR NURSES_THIRD EDITION','','3rd','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 06:03:30','2017-04-21 06:03:51',NULL,NULL);
INSERT INTO `biblio` VALUES (306,32,'The Informed Practice Nurse','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 06:05:41','2017-04-21 06:05:50',NULL,NULL);
INSERT INTO `biblio` VALUES (307,32,'The Prescription Drug Guide for Nurses','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 06:09:35','2017-04-21 06:09:50',NULL,NULL);
INSERT INTO `biblio` VALUES (308,32,'The Role of the Preceptor_A Guide for Nurse Educators, Clinicians, and Managers','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 06:11:59','2017-04-21 06:12:05',NULL,NULL);
INSERT INTO `biblio` VALUES (309,32,'Using Insulin Pumps in Diabetes A Guide for Nurses and Other Health Professionals','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 06:13:54','2017-04-21 06:14:02',NULL,NULL);
INSERT INTO `biblio` VALUES (310,32,'VASCULAR DISEASE_A HANDBOOK FOR NURSES','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 06:17:14','2017-04-21 06:17:25',NULL,NULL);
INSERT INTO `biblio` VALUES (311,32,'Vitamins and Minerals Demystified','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 06:26:16','2017-04-21 06:26:34',NULL,NULL);
INSERT INTO `biblio` VALUES (312,32,'Abnormal Psychology','','','',0,'','','','','en',NULL,0,'','','Abnormal_Psychology.jpg.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2017-04-21 06:29:19','2017-04-21 07:23:36',NULL,NULL);
INSERT INTO `biblio` VALUES (313,32,'ABNORMAL PSYCHOLOGY_The International Library of Psychology','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 06:31:58','2017-04-21 06:32:18',NULL,NULL);
INSERT INTO `biblio` VALUES (314,32,'STUDY GUIDE to Abnormal Psychology By Davison,Neale et al','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 06:35:50','2017-04-21 06:35:57',NULL,NULL);
INSERT INTO `biblio` VALUES (315,32,'Biochemistry Demystified','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 06:39:03','2017-04-21 06:39:26',NULL,NULL);
INSERT INTO `biblio` VALUES (316,32,'Biochemistry For Dummies','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 06:45:11','2017-04-21 06:45:18',NULL,NULL);
INSERT INTO `biblio` VALUES (317,32,'Clinical Biochemistry','','1st ed.','81-8448-191-8',172,'2008','1 online resource (212 pages)','','QU4 .M17','en',NULL,19,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 06:47:31','2019-06-11 11:12:24',NULL,NULL);
INSERT INTO `biblio` VALUES (318,32,'Textbook of MEDICAL BIOCHEMISTRY','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 06:54:17','2017-04-21 06:54:36',NULL,NULL);
INSERT INTO `biblio` VALUES (319,32,'Contemporary Sociological Thought_Themes and Theories','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 06:59:06','2017-04-21 06:59:13',NULL,NULL);
INSERT INTO `biblio` VALUES (320,32,'Perspectives in Sociology','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 07:01:18','2017-04-21 07:01:24',NULL,NULL);
INSERT INTO `biblio` VALUES (321,32,'Ten Questions,A Sociological Perspective','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-21 07:03:54','2017-04-21 07:04:04',NULL,NULL);
INSERT INTO `biblio` VALUES (322,32,'Trials of Labour : The Re-emergence of Midwifery','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-23 17:27:14','2017-04-25 00:21:04',NULL,NULL);
INSERT INTO `biblio` VALUES (323,32,'Abnormal Child Psychology','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-23 18:35:46','2017-04-25 00:18:06',NULL,NULL);
INSERT INTO `biblio` VALUES (324,1,'Food & nutrition','','3rd','9780198327660',26,'1996','282 pages : color illustrations ; 26 cm','utrition ; Providing foods for different needs ; Foods and food science ; Practical food preparation ; The kitchen.','TX353 .T82','en',NULL,16,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-24 11:25:03','2017-10-10 19:23:38',NULL,NULL);
INSERT INTO `biblio` VALUES (325,1,'Ten teachers\' self-assessment in gynaecology and obstetrics : multiple-choice and short-answer questions.','','4th','9780340760680',19,'2001','vii, 200 pages ; 22 cm','Setchell, Marcus E. (Marcus Edward). Multiple choice questions in gynaecology and obstetrics.','RG111 .Se7','en',NULL,7,'','Previous ed. published as: Multiple choice questions in gynaecology and obstetrics / Marcus E. Setchell and Richard J. Lilford, 1996.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-24 11:47:19','2017-04-24 11:53:19',NULL,NULL);
INSERT INTO `biblio` VALUES (326,1,'Midwifery practice : core topics 1','','','9780333663202',27,'1996','xii, 164 pages : illustrations ; 24 cm.','Midwifery practice.','RG950 .M58','en',NULL,71,'','Series numbering inferred from publisher\'s listing.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-24 12:11:22','2017-04-24 12:17:38',NULL,NULL);
INSERT INTO `biblio` VALUES (327,1,'Midwifery practice : core topics 2','','','9780333696279',27,'1997','xi, 148 pages ; 24 cm.','Midwifery practice','RG524 .L57','en',NULL,17,'','Series numbering inferred from publisher\'s listing.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-24 12:27:19','2017-04-24 12:39:28',NULL,NULL);
INSERT INTO `biblio` VALUES (328,1,'Theory for midwifery practice','','','9780333588673',27,'1995','xvi, 240 pages : illustrations.','Midwifery practice','RG524 .B84','en',NULL,72,'','Includes bibliographical references (pages 219-236) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-24 13:15:05','2017-04-24 13:25:53',NULL,NULL);
INSERT INTO `biblio` VALUES (329,1,'Essential Neonatal Medicine','','5th','9780470670408',89,'2012','388 p : Ill. ; 23cm','Essentials Fetal wellbeing and adaptation at birth -- Perinatal epidemiology and audit -- Multiple births -- Neonatal consequences of maternal disease -- Resuscitation at birth -- Examination of the n','RJ251 .Si6','en',NULL,52,'','Revised edition of: Essential neonatal medicine / Malcolm I. Levene, David I. Tudehope, Sunil K. Sinha. 4th ed. c2008.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-24 14:13:36','2017-04-24 14:16:00',NULL,NULL);
INSERT INTO `biblio` VALUES (330,1,'Postnatal care : the midwife\'s role','','','0443027722',13,'1984','vi, 105 pages ; 22 cm.','Studies in nursing series','RG950 .L32','en',NULL,10,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-24 14:25:25','2017-04-24 14:27:04',NULL,NULL);
INSERT INTO `biblio` VALUES (331,1,'Ward management and teaching','','','9788174733733',96,'2016','423 pages : illustrations ; 22 cm','','RT89 .G29','en',NULL,73,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-24 14:38:58','2017-04-24 14:40:52',NULL,NULL);
INSERT INTO `biblio` VALUES (332,1,'Physiology for nurses','','','9789374739919',99,'2012','250 P. Ill.; 24cm','','QP34.5 .M36','en',NULL,73,'','Includes Index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-24 14:56:39','2017-04-24 14:58:45',NULL,NULL);
INSERT INTO `biblio` VALUES (333,1,'Fundamentals of human physiology','','1st','9789374735145',99,'2013','v, 293 pages ; 24 cm.','','QP34 .M36','en',NULL,55,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-24 15:37:49','2017-04-24 15:38:54',NULL,NULL);
INSERT INTO `biblio` VALUES (334,1,'Manipal manual of nursing education','','','9788123913759',129,'2012','x, 419 pages : illustrations ; 24 cm','','RT51 .D49','en',NULL,19,'','Date of publication varies.\r\nIncludes References',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-24 15:50:51','2017-04-24 15:52:27',NULL,NULL);
INSERT INTO `biblio` VALUES (335,1,'Pocket medical dictionary','','4th','9788174731425',99,'2015','1143 p. : ill. ; 18 cm','','R121 .G95','en',NULL,55,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-24 16:07:07','2017-04-24 16:08:54',NULL,NULL);
INSERT INTO `biblio` VALUES (336,1,'Anatomy, physiology and health education','','','978813231005',130,'2012','xxi, 645 pages : illustrations 23cm','','QP34.5 Ag8','en',NULL,74,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-24 16:33:10','2017-04-24 16:34:31',NULL,NULL);
INSERT INTO `biblio` VALUES (337,32,'Abnormal Psychology By Kring,Johnson,Davison and Neale','','','',227,'2010','1 electronic document (1 volume (various pagings :','','RC454 .Ab2','en',NULL,1,'','Includes bibliographical references and index.','Abnormal_Psychology_By_Kring,Johnson,Davison_and_Neale.jpg.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2017-04-25 00:49:16','2019-07-15 15:31:35',NULL,NULL);
INSERT INTO `biblio` VALUES (338,32,'Abnormal Psychology_Hansell & Damour','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-25 01:03:48','2017-04-25 01:14:19',NULL,NULL);
INSERT INTO `biblio` VALUES (339,32,'Abnormal Psychology_Oltmanns & Emery','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-25 01:19:24','2017-04-25 01:23:14',NULL,NULL);
INSERT INTO `biblio` VALUES (340,32,'Biochemistry for dummies / John T. Moore and Richard Langley','','','9780470194287',205,'2008','1 online resource (xvi, 342 p. :) ill.','For dummies','QP514.2 .M78','en',NULL,1,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-25 01:26:43','2019-06-07 15:03:24',NULL,NULL);
INSERT INTO `biblio` VALUES (341,32,'Biochemistry, The Chemical reactions of living cells','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-25 01:54:04','2017-04-25 02:00:25',NULL,NULL);
INSERT INTO `biblio` VALUES (342,32,'Challenges in Midwifery Care','','','9780333609040',36,'1997','1 electronic document (1 volume (various pagings :','','RG950 .C35','en',NULL,130,'','There is growing recognition in the field of midwifery that there is no single \'best\' system of maternity care for all women, and that not only do individual women have specific needs, but certain groups of women have special needs. The book examines the needs of these groups while continuing to treat the women as individuals.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-25 02:17:30','2019-06-10 10:59:13',NULL,NULL);
INSERT INTO `biblio` VALUES (343,32,'Chemistry for today : general, organic, and biochemistry / Spencer L. Seager, Michael R. Slabaugh.','','','',232,'','1 electronic document (1 volume (various pagings :','','QD31.2 .Se1','en',NULL,131,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-25 02:46:00','2019-06-10 11:29:53',NULL,NULL);
INSERT INTO `biblio` VALUES (344,32,'Color atlas of biochemistry  / Jan Koolman, Klaus-Heinrich Roehm.','','2nd ed.','3-13-100372-3',233,'2005','1 online resource (1 texte électronique (x, 467 p','','QP514.2 .K83','en',NULL,8,'','Totally revised and expanded, the Color Atlas of Biochemistry presents the fundamentals of human and mammalian biochemistry on 215 stunning color plates. Alongside a short introduction to chemistry and the \"classical topics\" of biochemistry, the 2nd edition covers new approaches and aspects in biochemistry, such as links between chemical structure and biological function or pathways for information transfer, as well as recent developments and discoveries, such as the structures of many new important molecules. Key features of this title include: The unique combination of highly effective color graphics and comprehensive figure legends, Unified color-coding of atoms, coenzymes, chemical classes, and cell organelles that allows quick recognition of all involved systems, Computer graphics provide simulated 3D representation of many important molecules. This Flexibook is ideal for students of medicine and biochemistry and a valuable source of reference for practitioners.\r\n',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-25 03:45:18','2019-06-11 14:21:06',NULL,NULL);
INSERT INTO `biblio` VALUES (345,32,'Essentials of Abnormal Psychology_Durand & Barlow','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-25 05:11:50','2017-04-25 05:13:31',NULL,NULL);
INSERT INTO `biblio` VALUES (346,32,'Ethical issues in nursing and midwifery practice : perspectives from Europe / edited by Win Tadd.','','','978-0-333-71005-0',36,'1998','1 online resource (xvi, 263 pages).','','RT85 .Et3','en',NULL,7,'','Aiming to assist the development of knowledge and to break down cultural barriers of working and studying throughout Europe, this book discusses the key ethical issues faced by nurses in a number of European countries.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-25 05:30:43','2019-07-04 14:03:41',NULL,NULL);
INSERT INTO `biblio` VALUES (347,32,'Medical Biochemistry at a Glance','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-25 05:36:08','2017-04-25 05:36:57',NULL,NULL);
INSERT INTO `biblio` VALUES (348,32,'Medical Biochemistry_Human Metabolism in Health and Disease','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-25 05:43:04','2017-04-25 05:44:26',NULL,NULL);
INSERT INTO `biblio` VALUES (349,32,'MIDWIFERY PRACTICE_A research based approach','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-25 05:52:24','2017-04-25 05:53:20',NULL,NULL);
INSERT INTO `biblio` VALUES (350,32,'MIDWIFERY PRACTICE_Core Topics 1','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-25 06:01:03','2017-04-25 06:02:06',NULL,NULL);
INSERT INTO `biblio` VALUES (351,32,'MIDWIFERY PRACTICE_Core Topics 2','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-25 06:09:42','2017-04-25 06:11:03',NULL,NULL);
INSERT INTO `biblio` VALUES (352,32,'MIDWIFERY PRACTICE_Core Topics 3','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-25 06:17:22','2017-04-25 06:18:54',NULL,NULL);
INSERT INTO `biblio` VALUES (353,32,'Profiles and Portfolios_A guide for nurses and midwives','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-25 06:27:14','2017-04-25 06:28:07',NULL,NULL);
INSERT INTO `biblio` VALUES (354,1,'Sociology : the core','','8th','9780073528120',131,'2008','xxxii, 459, R-45, C-1, NI-16, SI-37 pages : illust','','HM585 .H87','en',NULL,47,'','Includes bibliographical references (pages R-1-R-45) and indexes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-25 17:45:02','2017-04-25 17:47:05',NULL,NULL);
INSERT INTO `biblio` VALUES (355,1,'Sociology : the core','','5th','9780070311442',125,'1999','xxiv, 548 pages : illustrations (some color) ; 23','','HM51 .H87','en',NULL,47,'','Previous editions authored by James Wilfrid Vander Zanden.\r\nIncludes bibliographical references (pages 469-521) and indexes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-04-25 17:58:57','2017-04-25 17:59:54',NULL,NULL);
INSERT INTO `biblio` VALUES (356,1,'Nursing administration','','2 nd','9788184486971',53,'2009','xvi, 946 p : ill. ; 28 cm','','RT89 .B29','en',NULL,19,'','Introduction to nursing profession -- Trends in health care system -- Leadership in nursing -- Nurse as a manager -- Concepts of administration -- Planning -- Organizing -- Staffing -- Directing -- Coordinating -- Reporting and recording -- Budgeting -- Human resource management -- Job evaluation -- Administration of health services in India -- Organization of health programs in India -- Management in health care delivery system -- Hospital administration -- Nursing service administration -- Discipline in nursing -- Health care economics and nursing -- Educational administration in nursing -- Clinical supervision -- Quality control -- Staff development -- Administration of wage and salary -- Role of employees union in administration -- Concepts of employees welfare and social security -- Legal and ethical aspects of nursing -- Current issues in nursing.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-18 11:27:59','2017-09-18 11:35:49',NULL,NULL);
INSERT INTO `biblio` VALUES (357,1,'Foundations of nursing and first aid.','','6th','9780582777071',13,'1983','x, 326 pages : illustrations ; 23 cm.','Tropical health series.','RT41 .N93','en',NULL,8,'','Revised edition of: Foundations of nursing and first aid / by Janet S. Ross, Kathleen J.W. Wilson. 5th ed. 1970.\r\nIncludes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-18 11:52:20','2018-06-06 11:04:04',NULL,NULL);
INSERT INTO `biblio` VALUES (358,1,'Phipps\' medical-surgical nursing : health and illness perspectives.','','8th','9780723434566',16,'2007','xxv, 2067 s. : ill. ; 28cm','','RT41 .M45','en',NULL,46,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-18 13:08:00','2017-10-13 12:55:37',NULL,NULL);
INSERT INTO `biblio` VALUES (359,1,'Conversations : in nursing professional development.','','','9780763738303',132,'2002','x, 413 pages : illustrations ; 28 cm','','RT76 .C78','en',NULL,75,'','TABLE OF CONTENTS -- Preparing for a staff development position / Karen J. Kelly Thomas -- Getting a staff development position / Francie Wolgin -- Staff development in hospital settings / Elaine S. Hinojosa -- Staff development in other settings / Adrianne E. Avillion -- Nursing staff development / Rebecca Stafford -- Hospital-wide staff development / Donna S. Bates -- Health system staff development / Pamela B. Edwards -- Educator / Michele L. Deck -- Manager / Theresa A. Herb -- Consultant / Marilynn J. Jackson -- Researcher / Patricia Welch Dittman -- Clinical / Margaret Sturdivant -- Patient education / Karen D. Stallings -- Change agent, facilitator, leader / Mitzi T. Grey -- Assessing learning Needs / Debra P. Shelton -- Writing objectives / Sandra L. Bruce -- Planning / Julia W. Aucoin -- Implementing / Connie S. Wilkinson -- Teaching strategies / Kari L. Schmidt -- Evaluating / Diane Graham Webb -- Accreditation/approval criteria / Pamela S. Dickerson -- Continuing education provider unit / RoAnne Dahlen-Hartfield -- Continuing education approver unit / Marlette Buckner -- Cultural diversity / Linda S. Smith -- Learning styles / Suzanne G. Wilson -- Critical thinking / Bette Case -- Performance improvement / Diane Graham Webb -- Preceptor development / JoAnn Grif Alspach -- Humor in teaching / Brian W. Deck -- Selecting technology / Colleen C. Simmons -- Integrating technology choices into practice / Nancy M. DiMauro -- Teaching about computer use / Donna Gloe -- Preparing online courses / Janice A. Ward -- Delivering distance learning / Laura A. Fennimore -- Collaborative ventures / Mary Theresa Urbano, Robert O. Blackford -- Legal and ethical concerns / Martha Turner -- Evidence-based practice / Mary Krugman -- Standards of practice / Barbara A. Brunt -- Preparing for certification / Julia W. Aucoin -- Advanced education / Andrea Novak -- Making presentation / Michele L. Deck -- Publishing / Belinda E. Puetz -- Entrepreneurship / Patricia Bleynat.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-18 13:40:52','2017-09-19 16:57:10',NULL,NULL);
INSERT INTO `biblio` VALUES (360,1,'Legal aspects of health care administration / George D. Pozgar ; legal review.','','8th','9780763724948',114,'2003','xiii, 487 pages ; 29 cm','','KF3821 .P87','en',NULL,32,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-18 14:14:01','2017-09-18 14:15:52',NULL,NULL);
INSERT INTO `biblio` VALUES (361,1,'Broadribb\'s introductory pediatric nursing.','','4th','9780397549467',102,'1994','xvi, 482, 11, 14, 17 pages : illustrations ; 28 cm','Introductory pediatric nursing','RJ245 .B78','en',NULL,11,'','Revised edition of: Introductory pediatric nursing / Violet Broadribb. 3rd ed. c1983.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-19 16:16:15','2018-05-21 08:46:50',NULL,NULL);
INSERT INTO `biblio` VALUES (362,1,'Nurse management demystified.','','','9780071472418',56,'2007','xii, 252 p. ; 24 cm','','RT89 .M15','en',NULL,8,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-19 17:29:37','2017-09-19 17:37:46',NULL,NULL);
INSERT INTO `biblio` VALUES (363,1,'Moroney\'s surgery for nurses.','','17th','9788131211519',0,'Elsevier','viii, 365 p. : ill. ; 27cm','','RD99 .M82','en',NULL,76,'','Revised edition of: Surgery for nurses. 17th ed. 1982.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-19 21:02:01','2017-09-19 21:05:35',NULL,NULL);
INSERT INTO `biblio` VALUES (364,1,'Davidson\'s principles and practice of medicine.','','21st','9780702030840',120,'2010','xvi, 1360 P. : ill. (chiefly color), color maps ;','Principles and practice of medicine','RC46 .D28','en',NULL,10,'','Part 1 -- Principles of medicine Good medical practice Therapeutics and good prescribing Molecular and genetic factors in disease Immunological factors in disease Environmental and nutritional factors in disease Principles of infectious disease Ageing and disease Part 2 -- Practice of medicine Critical illness Poisoning Medical psychiatry Oncology Pain management and palliative care Infectious disease HIV infection and AIDS Sexually transmitted infections Clinical biochemistry and metabolism Kidney and urinary tract disease Cardiovascular disease Respiratory disease Endocrine disease Diabetes mellitus Alimentary tract and pancreatic disease Liver and biliary tract disease Blood disease Musculoskeletal disease Neurological disease Skin disease Laboratory reference ranges \r\nRevised edition of: Davidson\'s principles & practice of medicine / editors, Nicholas A. Boon ... [et al.]. 20th ed. 2006\r\nIncludes bibliographical references and indexes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-20 09:43:07','2017-09-20 09:45:50',NULL,NULL);
INSERT INTO `biblio` VALUES (365,1,'Introduction to nursing : concepts, issues, and opportunities /','','2nd','9780397549863',24,'1994','xv, 448 p. : ill. ; 24 cm','','RT41 .L64','en',NULL,11,'','Includes bibliogr. ref. and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-20 10:00:24','2017-09-20 10:52:10',NULL,NULL);
INSERT INTO `biblio` VALUES (366,1,'Shared care in mental health.','','','9780198566472',26,'2002','1 online resource (viii, 286 pages) : illustration','','RC456 .Sh2','en',NULL,8,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-20 11:17:14','2017-09-20 11:36:39',NULL,NULL);
INSERT INTO `biblio` VALUES (367,1,'Language development and disorders : a case study approach','','','9780763754006',114,'2009','xv, 422 pages : illustrations ; 23 cm','','RJ496 .L26','en',NULL,77,'','Language development -- Phonological development -- Morphological development -- Syntactic development -- Semantic development -- Pragmatic development -- Language development milestones -- Communication disorders -- Phonological/articulation disorders -- Voice disorders -- Fluency disorders -- Hearing impairments -- Language disorders -- Case study language samples -- Language sample analysis -- Stage 1: 12 months to 18 months -- Stage 2: 18 months to 24 months -- Stage 3: 24 months to 36 months -- Stage 4: 36 months to 48 months -- Stage 5: 48 months to 60 months -- Communication disorders. \r\nIncludes bibliographical references (pages 411-412) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-20 11:23:48','2017-09-20 11:32:58',NULL,NULL);
INSERT INTO `biblio` VALUES (368,1,'Caring for women : obstetric and gynaecological nursing','','4th','9780702014536',17,'1991','viii, 452 pages : illustrations.','','RG951 .B46','',NULL,11,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-20 11:54:12','2017-09-20 11:55:28',NULL,NULL);
INSERT INTO `biblio` VALUES (369,1,'Nursing theory : analysis, application, evaluation','','4th','9780397549429',24,'1994','xiii, 304 pages : illustrations ; 23 cm','','RT84.5 .B23','en',NULL,78,'','What is nursing theory -- Structure underlying theory -- The normative theory of nursing -- Basic assumptions underlying current nursing practice -- Touch or technology: the tension in today\'s nursing theory -- Nursing: the care ideologies -- Nursing: an alternate cure ideology -- Holistic nursing theories -- Spirituality and ethics in nursing theory -- Principle, interpretation, and method -- The nursing process and problem solving -- Systems models in nursing theory -- Criteria for evaluating theories -- Focus on environment -- Common themes in nursing theory -- Theories focusing on the nurse-patient relationship -- Resource-driven nursing: a model for practice and management -- Nursing theory and restructured practice -- Nursing theory and nursing education -- Theory, research, and knowledge. \r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-22 09:17:37','2017-10-23 08:57:42',NULL,NULL);
INSERT INTO `biblio` VALUES (370,1,'Nursing procedures & protocols.','','','9781582552378',44,'2003','x, 661 pages : illustrations ; 23 cm','','RT49 .N93','en',NULL,11,'','Fundamentals -- Infection control-- Medication administration -- Intravascular therapy -- Cardiovascular care -- Pulmonary care -- Neurologic care -- Gastrointestinal care -- Renal and urologic care -- Musculoskeletal care -- Skin care -- Endocrine and hematologic care. \r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-22 09:42:27','2017-09-22 09:52:34',NULL,NULL);
INSERT INTO `biblio` VALUES (371,1,'Developing practical nursing skills','','','9780340760024',19,'2001','xiv, 481 pages : illustrations ; 25 cm','','RT62 .D49','en',NULL,7,'','Includes bibliographical references (pages 462-463) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-22 10:18:20','2017-09-22 10:19:37',NULL,NULL);
INSERT INTO `biblio` VALUES (372,1,'HIV/AIDS care & counselling : a multidisciplinary approach','','2nd','9781868910786',59,'2001','v, 442 pages : illustrations ; 24 cm','HIV/AIDS care and counselling','RC606.6 .D99','en',NULL,79,'','Symptoms and diseases associated with HIV/AIDS ; Diagnosis of HIV infection and AIDS ; Prevention in traditional Africa ; HIV/AIDS counselling ; Care and support for the person living with HIV/AIDS ; Legal, ethical and policy issues. \r\nIncludes bibliographical references (pages 425-432) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-22 10:39:28','2017-09-22 10:45:58',NULL,NULL);
INSERT INTO `biblio` VALUES (373,1,'Textbook of anatomy and physiology for nurses','','2nd','9788184487589',31,'2010','498 pages : ill., color ; 25 cm','','QM26 .As3','en',NULL,19,'','Includes bibliographical references.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-28 16:10:42','2017-09-28 16:12:49',NULL,NULL);
INSERT INTO `biblio` VALUES (374,1,'Rudolph\'s fundamentals of pediatrics','','3rd','9780071124423',133,'2002','xi, 919 pages : illustrations ; 24 cm','Fundamentals of pediatrics','RJ45 .R85','en',NULL,8,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-28 16:41:43','2017-09-28 16:50:43',NULL,NULL);
INSERT INTO `biblio` VALUES (375,1,'Handbook of pediatrics','','8th','9780838536476',134,'1997','xvi, 1029 p. ill. ; 18 cm','','RJ48 .H19','en',NULL,7,'','Includes index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-28 17:22:18','2017-09-28 17:51:24',NULL,NULL);
INSERT INTO `biblio` VALUES (376,1,'Health and social care management','','','9780340614112',19,'1996','x, 220 pages : illustrations ; 24 cm','Health & social care management','RA971 .W58','en',NULL,7,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-28 18:18:20','2017-09-28 18:20:26',NULL,NULL);
INSERT INTO `biblio` VALUES (377,1,'Pediatric nursing','','2nd','9788184485684',31,'2009','xiii, 513 pages : illustrations, plates ; 28 cm','','RJ245 .D26','en',NULL,73,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-28 18:31:19','2017-09-28 18:32:16',NULL,NULL);
INSERT INTO `biblio` VALUES (378,1,'Imaging of the newborn, infant, and young child.','','4th','',63,'1997','viii, 1088 p. : ill. ; 28cm','','RJ255.6 .Sw6','en',NULL,22,'','Includes index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-29 08:39:27','2017-09-29 08:58:06',NULL,NULL);
INSERT INTO `biblio` VALUES (379,1,'Using hospital space profitably','','','087189646X',107,'1987','xxi, 376 pages : illustrations ; 24 cm','','RA965.5 .Us4','en',NULL,80,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-29 09:11:54','2017-09-29 09:28:54',NULL,NULL);
INSERT INTO `biblio` VALUES (380,1,'Managing employee health benefits : a guide to cost control','','','0870945068',135,'1985','xv, 195 pages : illustrations ; 24 cm','','HD7102 .W83','en',NULL,81,'','Includes bibliographical references (pages 185-190) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-29 09:42:01','2017-09-29 10:03:42',NULL,NULL);
INSERT INTO `biblio` VALUES (381,1,'Economic myths and realities : doing more with no more','','','0801665256',101,'1993','xiv, 242 p. ; 24 cm.','Series on nursing administration','RT89 .E7','en',NULL,46,'','Includes index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-29 10:15:10','2017-09-29 10:20:38',NULL,NULL);
INSERT INTO `biblio` VALUES (382,1,'Promoting health : a practical guide','','3rd','9781873853177',64,'1995','xvii, 293 pages : illustrations, facsimiles ; 25 c','','RA408.5 .E5','en',NULL,82,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-29 11:56:17','2017-10-04 10:35:30',NULL,NULL);
INSERT INTO `biblio` VALUES (383,1,'Health promotion in nursing','','','9780827380080',88,'2002','xviii, 453 pages : illustrations ; 28 cm','','RT42 .M44','en',NULL,48,'','Conceptual Foundations and Theoretical Appropaches -- Health Promotion: Past, Present, and Future -- Defining Health Promotion -- Health Promotion: Past -- Sociopolitical Influences for Health Promotion in the 20th Century -- Initiatives for Health Promotion in the 20th Century -- Nursing Practice and Health Promotion -- Health Promotion: Where Is It Going? -- Nursing Concepts and Health Promotion -- Professional Nursing Practice and Health Promotion -- Nursing\'s Metaparadigm -- Defining Nursing -- Person, Environment, Health, and Nursing -- Nursing as a Profession -- Integrating Health Promotion Concepts into Nursing Practice -- Theoretical Foundations -- Organizing Nursing Theory -- Theoretical Foundations and Planning for Health Promotion -- Clarifying Terms -- Theoretical Foundations -- Theories of Human Behavior -- Theories of Human Behavior and Health -- Health Promotion Models -- Developing a Health Promotion Plan -- The Role of the Nurse in Health Promotion -- Domains Fundamental to Nursing Practice in Health Promotion -- Holistic Philosophy -- Holistic Nursing Practice -- Roles of the Nurse in Health Promotion -- Overview of the Nursing Process -- Nursing Process and Health Promotion for the Individual, Families, and Aggregates -- Risk Factors and Health Promotion -- Current Factors Affecting Nursing Roles in Health Promotion -- Factors Related to Health Promotion -- Communication: A Cornerstone In Health Promotion -- Communication and Nursing -- Types of Communication -- Communication and the Therapeutic Relationship.\r\n 	Abstract	This book provides an extensive background on wellness and health promotion concepts within a nursing framework. This textbook is written in easy to understand language that is appropriate for both undergraduate and graduate nursing students who desire an overview of health promotion concepts, nursing theories, and health promotion strategies. Health promotion nursing strategies are highlighted and are appropriate in the care of individuals, communities, and groups. Unique features include the domains identified as they relate to wellness and health promotion. This second edition has added an additional domain that focuses on technology and its influence on health and wellness. It is a very readable text with features that assist students in applying the concepts described. These features include case studies, think about it boxes, nursing tips/alerts, and research notes. The chapter on health promotion for the health professional has been updated to include additional information on issues and strategies that influence the health of the nurse. - Publisher.\r\nIncludes bibliographical references (pages 423-443) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-29 12:16:20','2017-09-29 12:26:32',NULL,NULL);
INSERT INTO `biblio` VALUES (384,1,'Obstetrics / by ten teachers.','','17th','9780340760956',19,'2000','viii, 374 pages : illustrations ; 25 cm','','RG524 .Ob7','en',NULL,7,'','ist of contributors -- Preface -- Acknowledgements -- Commonly-used abbreviations -- 1. Obstetric history taking and examination -- 2. Modern maternity care and changing childbirth -- 3. Maternal and perinatal mortality: the confidential enquiries -- 4. Conception, implantation and embryology -- 5. Physiological changes in pregnancy -- 6. Normal fetal development and growth -- 7. Antenatal imaging and assessment of fetal wellbeing -- 8. Antenatal care -- 9. Labour -- 10. The puerperium -- 11. Disorders of placentation -- 12. Prenatal diagnosis -- 13. Multiple gestation -- 14. Antenatal obstetric complications -- 15. Perinatal infections -- 16. Medical diseases complicating pregnancy -- 17. Second trimester miscarriage -- 18. Preterm labour -- 19. Operative intervention in obstetrics -- 20. Obstetric emergencies -- 21. Psychiatric disorders in pregnancy and the puerperium -- 22. Neonatology -- App. 1. Medicolegal issues -- App. 2. Ethics in obstetric practice -- Index.\r\nPublisher description http://catdir.loc.gov/catdir/enhancements/fy0611/2001273690-d.html',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-29 12:40:39','2017-09-29 12:43:31',NULL,NULL);
INSERT INTO `biblio` VALUES (385,1,'Leadership and management in nursing practice and education','','','9788184484625',52,'2009','x, 212 pages ; 24 cm','','RT89 .Sa4','en',NULL,19,'','A General principles of management -- Introduction of concepts and principles -- Theories -- Leadership styles -- pt. B Management of nursing practice in health care agencies -- Planning -- Organizing -- Patient care management -- Personnel management -- directing -- Controlling -- pt. C Management of nursing educational institutions -- Program planning -- Planning and organization of curriculum -- Evaluation system.\r\nIncludes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-09-29 12:58:55','2017-09-29 13:00:51',NULL,NULL);
INSERT INTO `biblio` VALUES (386,1,'On being in charge : a guide to management in primary health care','','','9241544260',21,'1992','472 p. : ill. ; 24 cm','','RA427 .M22','en',NULL,12,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-02 09:14:22','2017-10-03 16:25:56',NULL,NULL);
INSERT INTO `biblio` VALUES (387,1,'Management support for primary health care : a practical guide to management for health centres and local projects','','','1871188024',136,'1994','iv. (various pagings) : ill. ; 30 cm.','','RA427.9 .J65','en',NULL,6,'','Includes bibliographical references (p. A-5) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-02 09:54:23','2017-10-02 10:13:46',NULL,NULL);
INSERT INTO `biblio` VALUES (388,1,'The year book of dermatology','','','9780815179177',104,'1995','xv, 695 pages : illustrations ; 23 cm','','RL26 .Y3','en',NULL,46,'','Includes bibliographical references and indexes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-02 10:29:06','2017-10-04 11:22:22',NULL,NULL);
INSERT INTO `biblio` VALUES (389,1,'Textbook of anaesthesia','','5th','9780443100857',120,'2007','x, 858 s. : ill. ; 25 cm','','RD81 .T31','en',NULL,8,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-02 11:30:11','2017-10-02 11:31:13',NULL,NULL);
INSERT INTO `biblio` VALUES (390,1,'Principles and practice of infectious diseases, handbook of antimicrobial therapy','','','0443088187',13,'1992','x, 174 pages ; 19 cm','Handbook of antimicrobial therapy','RM267 .M31','en',NULL,8,'','Includes index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-02 11:47:35','2017-10-23 10:18:15',NULL,NULL);
INSERT INTO `biblio` VALUES (391,1,'Handbook of geriatric care management','','','9780763737740',114,'2006','xvi, 336 pages : illustrations ; 27 cm','','RC952.55 .C86','en',NULL,32,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-04 11:42:55','2017-10-04 11:44:30',NULL,NULL);
INSERT INTO `biblio` VALUES (392,1,'The health practice management handbook','','','0749406232',137,'1992','269 pages ; ill. ; 23 cm','','RA440.5 .H34','en',NULL,7,'','includes index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-04 12:06:00','2017-10-04 12:08:41',NULL,NULL);
INSERT INTO `biblio` VALUES (393,1,'Managing money for general practitioners','','2nd','9781846192654',138,'2009','xiii, 218 pages) : illustrations 24 cm','','HF5686 .P88','en',NULL,8,'','Includes index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-04 12:26:29','2017-10-04 12:37:22',NULL,NULL);
INSERT INTO `biblio` VALUES (394,1,'Nursing ethics','','3rd','9780443048111',13,'1994','xii, 253 p. : ill. ; 25 cm','','RT85 .T38','en',NULL,8,'','Includes index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-04 13:47:10','2017-10-04 13:48:40',NULL,NULL);
INSERT INTO `biblio` VALUES (395,1,'Pediatric trauma care','','','0871898810',107,'1988','(xiv, 219 pages) : illustrations','','RD93.5.C4 .P34','en',NULL,80,'','ncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-09 09:25:29','2017-10-09 09:59:31',NULL,NULL);
INSERT INTO `biblio` VALUES (396,1,'Introduction to public health','','','9780763725945',114,'1999','xxxi, 496 pages : illustrations ; 23 cm','','RA425 .Sch5','en',NULL,77,'','Public health: science, politics, and prevention -- Why is public health controversial? -- Powers and responsibilities of government -- Epidemiology: the basic science of public health -- Epidemiologic principles and methods -- Problems and limits of epidemiology -- Statistics: making sense of uncertainty -- The role of data in public health -- The \"conquest\" of infectious diseases -- The resurgence of infectious diseases -- The biomedical basis of chronic diseases -- Genetic diseases and other inborn errors -- Do people choose their own health? -- How psychosocial factors affect health and health behavior -- Tobacco: public health threat number one -- Diet and activity patterns: public health threat number two -- Injuries are not accidents -- Maternal and child health as a social problem -- A clean environment: the basis of public health -- Clean air: is it safe to breathe? -- Clean water: a limited resource -- Solid and hazardous wastes: what to do with the garbage? -- Safe food and drugs: an ongoing regulatory battle -- Population: the ultimate environmental health issue -- Is the medical care system a public health issue? -- Why the U.S. Medical system needs reform -- Health services research: finding what works -- Public health and the aging population -- Public health at the end of the century: achievements and challenges. \r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-09 09:47:37','2017-10-09 09:51:21',NULL,NULL);
INSERT INTO `biblio` VALUES (397,1,'Pediatrics : an approach to independent learning','','3rd','9780801856044',139,'1997','xvi, 421 pages : illustrations ; 26 cm','','RJ48.2 .P34','en',NULL,22,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-09 10:23:33','2017-10-09 10:25:22',NULL,NULL);
INSERT INTO `biblio` VALUES (398,1,'Training manual for traditional birth attendants','','','9780333473061',27,'1990','v, 197 pages : illustrations ; 25 cm','','RJ48 .G66','en',NULL,7,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-09 10:39:46','2017-11-15 11:17:42',NULL,NULL);
INSERT INTO `biblio` VALUES (399,1,'Sociology for nurses','','','9788174733672',96,'2007','vii, 330 pages; 21 cm','','RT86.5 .G29','en',NULL,19,'','Includes index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-09 10:56:41','2017-12-04 10:56:36',NULL,NULL);
INSERT INTO `biblio` VALUES (400,1,'New concise medical dictionary','','5th','9788174733535',140,'2014','1117 pages, 16 pages of plates : illustrations (so','','RT121 .G98','en',NULL,19,'','Section 1: Dictionary -- Section 2: General information: Apgar scoring chart ; Appearance of points of ossification ; Dentition table ; Drugs that may harm the child who is on breastfeeding ; Effects of drugs ; Foramina of the skull and their content ; General measures ; History of medicine ; Medical abbreviations and acronyms ; Medical prefixes and suffixes ; Period of incubation ; Schedule of immunisation ; The muscles of the extremities ; Toxic effect of drugs ; Union of bones and epiphyses ; Units and constants ; Weight for height in males ; Weight for height in females. \r\nIncludes \"general information\" (p. 914-1117) not in dictionary format.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-09 11:34:38','2017-10-09 11:36:03',NULL,NULL);
INSERT INTO `biblio` VALUES (401,1,'Health economics','','2nd','9788174733771',141,'2015','x, 553 pages : illustrations ; 24 cm','','RA410 .An1','en',NULL,19,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-09 11:53:44','2017-10-09 11:55:50',NULL,NULL);
INSERT INTO `biblio` VALUES (402,1,'Management and leadership for nurse administrators','','4th','9780763734862',114,'2006','xx, 498 pages : illustrations ; 28 cm','Introduction to management and leadership for nurse managers','RT89 .Sw2','en',NULL,83,'','Conceptualization of nursing administration: theory and concepts -- Emotionally-intelligent leadership in nursing and health care organizations -- Ethical principles for the nurse administrator -- The components of change: creativity and innovation, critical thinking and planned change -- Decision-making and problem-solving: communication practices and skills -- Organizational structure and analysis -- Leadership and evidence-based management -- Human resource development: managing a culturally diverse workforce -- The planning process -- Staffing and scheduling -- Principles of budgeting -- The directing process -- eNursing -- Health policy, legal and regulatory issues -- Collective bargaining -- Evaluation -- Quality management -- Performance appraisal -- The nurse manager of staff development.\r\n 	Abstract	\"The field of health care is increasingly affected by management changes such as organizational downsizing and restructuring, a rise in the temporary workforce, pay-for-performance, and the implementation of total quality management programs, Management and Leadership for Nurse Administrators, Fourth Edition will keep nurses and nursing students abreast of these changes - an essential aspect of their career development.\" \"Organized around the four key management functions of Planning, Organization, Leadership, and Evaluation, the revised text includes new chapters on total quality management, the theory of human resource development, and collective bargaining. Additionally, new content includes recommendations from the Institute of Medicine (Crossing the Quality Chasm, Educating Healthcare Professionals) as well as content on the Magnet Appraisal process and ethics for the nursing manager.\" \"Designed to provide a substantial management and administrative foundation for nurse managers, Management and Leadership for Nurse Administrators, Fourth Edition explore the appropriate concepts, theories, and practical knowledge that will enable them to succeed and excel in today\'s changing healthcare environment.\"--BOOK JACKET.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-09 12:09:48','2017-10-10 19:50:05',NULL,NULL);
INSERT INTO `biblio` VALUES (403,1,'Drug dosages in neonates and children','','','9788174734136',96,'2014','xiii, 220 pages  ; 13 cm','','QV748 .G55','en',NULL,19,'','Includes index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-10 16:45:20','2017-10-16 14:19:18',NULL,NULL);
INSERT INTO `biblio` VALUES (404,1,'Family planning : a global handbook for providers.','','','9780978856304',139,'2011','xii, 372 pages; : illustrations; 23 cm','Essentials of contraceptive technology.','HQ763.5 .F21','en',NULL,22,'','\"Evidence-based guidance developed through worldwide collaboration.\"\r\n\"A WHO family planning cornerstone.\"\r\nIncludes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-10 17:32:45','2017-10-10 18:01:44',NULL,NULL);
INSERT INTO `biblio` VALUES (405,1,'Developing practical adult nursing skills','','2nd','9780340946268',37,'2007','xviii, 539 pages : illustrations ; 24 cm','Developing practical nursing skills.','RT62 .N93','en',NULL,7,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-10 18:26:27','2017-10-10 18:38:00',NULL,NULL);
INSERT INTO `biblio` VALUES (406,1,'Law for nurses / Gill Korgaonkar, Diana Tribe.','','1st','9781859411322',142,'1995','xix, 205 pages ; 24 cm','','KD3395.Z9 K84','en',NULL,7,'','Publisher description http://catdir.loc.gov/catdir/description/cav051/96211320.html\r\nIncludes index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-10 18:55:17','2017-10-10 19:01:57',NULL,NULL);
INSERT INTO `biblio` VALUES (407,1,'Cultural sensitivity and programming : the case of Government of Ghana-UNFPA 5th country programme 2006-2010 / [principal author, A.K. Awedoba ; principal editor, Mary Esther Kropp Dakubu].','','','9789988118174',143,'2008','iii, 116 pages ; 25 cm','Case of Government of Ghana-UNFPA 5th country programme 2006-2010\r\nCultural sensitivity & programming','HM1271 .C91','en',NULL,84,'','Includes bibliographical references (page 116).',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-10 19:19:07','2017-10-13 12:54:16',NULL,NULL);
INSERT INTO `biblio` VALUES (408,1,'Educational handbook for health personnel / J.-J. Guilbert.','','','924170635X',144,'1987','1 volume (various pagings) : illustrations ; 24 cm','WHO offset publication ; no. 35.','R834 .G94','en',NULL,0,'','Includes bibliographical references (pages 7.01-7.05).',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-10 19:40:44','2017-10-10 19:43:11',NULL,NULL);
INSERT INTO `biblio` VALUES (409,1,'Microbiology for nurses & allied sciences / D.R. Arora.','','','8123912145',95,'2005','xi, 260 pages : illustrations ; 24 cm','','QR46 .Ar6','en',NULL,19,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-10 20:04:29','2017-10-10 20:07:09',NULL,NULL);
INSERT INTO `biblio` VALUES (410,1,'Basic skills : health, hygiene and safety / Di Barton and Wilf Stout.','','','9780719544637',145,'1998','120 pages : illustrations ; 25 cm','Basic skills series','RA776 .B28','en',NULL,7,'','Includes bibliographical references (page 120) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-16 08:38:47','2017-10-16 09:21:22',NULL,NULL);
INSERT INTO `biblio` VALUES (411,1,'A general textbook of nursing / by the late Evelyn Pearce in collaboration with consultants, specialists and other experts.','','20th','0571115586',42,'1980','xvii, 404 pages : illustrations','','RT41 .P31','en',NULL,7,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-16 10:11:25','2017-11-13 10:12:27',NULL,NULL);
INSERT INTO `biblio` VALUES (412,1,'Midwifery practice : a research-based approach / edited by Jo Alexander, Valerie Levy and Sarah Roch.','','','9780333576175',27,'1993','xiv, 200 pages : illustrations ; 24 cm','','RG950 .M58','en',NULL,85,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-16 11:04:14','2017-10-16 14:19:54',NULL,NULL);
INSERT INTO `biblio` VALUES (413,1,'Infection prevention : guidelines for healthcare facilities with limited resources / Linda Tietjen, Débora Bossemeyer, Noel McIntosh.','','','092981780X',146,'2003','1 volume (various pagings) : illustrations ; 28 cm','','RA969 .T44','en',NULL,31,'','Includes bibliographical references.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-16 11:22:01','2017-10-16 14:18:02',NULL,NULL);
INSERT INTO `biblio` VALUES (414,1,'Health promotion : models and values / R.S. Downie, Carol Tannahill, and Andrew Tannahill.','','2nd','9780192625915',26,'1996','xiii, 218 pages : illustrations ; 23 cm.','','RA427.8 .D76','en',NULL,8,'','1. Introduction -- 2. Health -- 3. Health education -- 4. Health promotion -- 5. Evaluation -- 6. Models in action -- 7. Attitudes, beliefs and behaviour -- 8. Objections to health promotion -- 9. Values -- 10. Liberalism, autonomy, and health -- 11. Justice, health, and society. \r\nIncludes bibliographical references (pages 205-214) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-18 10:45:27','2018-03-16 10:07:38',NULL,NULL);
INSERT INTO `biblio` VALUES (415,1,'School health and health education / C.E. Turner, Harriett B. Randall [and] Sara Louise Smith.','','6th','801651336',147,'1970','xiv, 411 pages : illustrations;  26 cm','','LB3405 .T85','en',NULL,0,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-18 11:09:24','2017-10-18 11:11:15',NULL,NULL);
INSERT INTO `biblio` VALUES (416,1,'A dictionary of psychology','','','9789374735435',140,'2014','492 pages : ill. ; 21 cm','','BF31 .K96','en',NULL,73,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-18 11:51:40','2017-10-18 11:53:21',NULL,NULL);
INSERT INTO `biblio` VALUES (417,1,'Clinical biostatistics : an introduction to evidence-based medicine / Graham Dunn and Brian Everitt.','','','9780340595312',49,'1995','vi, 154 pages : illustrations 23 cm','','RA409 .D79','en',NULL,8,'','Clinical Problems and Statistical Solutions -- Diagnosis, Probability and Sampling -- The Variability of Clinical Measurements -- Sampling and Estimation -- The Search for Associations -- Treatment Trials. \r\n 	Abstract	A biostatistics text which is also motivated by clinical problems. It is written in reponse to the increasing number of medical schools moving over to a problem-based curriculum in which clinical skills and basic science are learnt in an integrated manner.\r\nIncludes bibliographical references (pages 145-150) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-23 08:51:29','2017-10-23 08:54:24',NULL,NULL);
INSERT INTO `biblio` VALUES (418,1,'Clinical medicine : a textbook for medical students and doctors / edited by Parveen Kumar, Michael Clark.','','4th','9780702020193',60,'1998','xxiv, 1326 pages : illustrations (some color)','','RB111 .C61','en',NULL,11,'','Infectious diseases, tropical medicine and sexually transmitted diseases -- Cell and molecular biology, genetic disorders and immunology -- Nutrition -- Gastroenterology -- Liver, biliary tract and pancreatic diseases -- Haematological disease -- Medical oncology -- Rheumatology and bone disease -- Renal disease -- Water, electrolytes and acid-base homeostasis -- Cardiovascular disease -- Respiratory disease -- Intensive care medicine -- Adverse drug reactions and poisoning -- Environmental medicine -- Endocrinology -- Diabetes mellitus and other disorders of metabolism -- Neurological disease -- Psychological medicine -- Dermatology. \r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-23 09:17:04','2017-10-23 09:18:58',NULL,NULL);
INSERT INTO `biblio` VALUES (419,1,'General and systematic pathology / ed. by J.C.E. Underwood ; ill. by Robert Britton and Peter Lamb.','','2nd','9780443052828',13,'1996','941 p. : ill. ; 25 cm.','','RB25 .G28','en',NULL,8,'','Includes index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-23 09:29:51','2017-10-23 09:31:21',NULL,NULL);
INSERT INTO `biblio` VALUES (420,1,'Clinical medicine : a textbook for medical students and doctors / edited by Parveen Kumar, Michael Clark.','','5th','9780702025792',15,'2002','vi, 1446 pages : illustrations (some color) ; 27 c','','RC46 .C61','en',NULL,7,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-23 10:02:01','2017-10-23 10:03:56',NULL,NULL);
INSERT INTO `biblio` VALUES (421,1,'Saunders manual of medical practice / [edited by] Robert E. Rakel ; illustrations by Jan Redden.','','2nd','072168002X',60,'2000','xlvi, 1613 pages : illustrations ; 29 cm','','RC55 .Sa8','en',NULL,11,'','Health maintenance and disease prevention -- Eye, ear, nose, and throat problems -- Respiratory diseases -- Cardiovascular diseases -- Gastrointestinal diseases -- Diseases of liver, gallbladder, and bile ducts -- Reproduction and reproductive disorders -- Urinary tract disorders -- Hematologic diseases -- Metabolic and endocrine diseases -- Nutritional diseases -- Diseases of bone -- Diseases of the immune system -- Musculoskeletal/connective tissue diseases -- Infectious diseases -- Protozoan/helminthic diseases -- Skin diseases -- Neurology -- Psychiatric and behavioral disorders -- Poisoning and environmental problems -- Laboratory values. \r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-23 11:12:02','2017-10-23 11:13:07',NULL,NULL);
INSERT INTO `biblio` VALUES (422,1,'WHO guide to mental health in primary care : a guide to mental ill health in adults : adapted for the UK, with permission, from Diagnostic and management guidelines for mental disorders in primary care: ICD chapter V primary care version / editorial board: David Goldberg [and others] ; overall management of the project by: Jo Paton under the direction of Rachel Jenkins.','','UK ed.','9781853154515',148,'2000','xii, 195 pages ; 19 cm','Diagnostic and management guidelines for mental disorders in primary care.','RC454.4 W89','en',NULL,7,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-23 11:39:39','2017-10-23 11:40:46',NULL,NULL);
INSERT INTO `biblio` VALUES (423,1,'Diet, nutrition, and the prevention of chronic diseases / report of a WHO Study Group.','','','9241207973',149,'1990','203 p. : ill. ; 20 cm.','','RA784 .D63','en',NULL,12,'','A WHO Study Group on Diet, Nutrition and Prevention of Noncommunicable Diseases met in Geneva from 6 to 13 March.\r\nMet lit.opg.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-23 11:52:08','2017-10-23 11:53:07',NULL,NULL);
INSERT INTO `biblio` VALUES (424,1,'Therapists in the community : changing the conditions that produce psychopathology / by Matthew P. Dumont.','','','1568214057',150,'1994','196 pages : illustrations ; 22 cm.','','RC455 .D89','en',NULL,86,'','Includes bibliographical references (pages 173-196).',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-23 12:02:27','2017-10-23 12:04:17',NULL,NULL);
INSERT INTO `biblio` VALUES (425,1,'The wards : an introduction to clinical clerkships / Paul L. Fine.','','','9780316283229',151,'1994','xiv, 185 pages : illustrations ; 22 cm','','RC46 .F49','en',NULL,47,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-23 12:11:23','2017-10-23 13:57:06',NULL,NULL);
INSERT INTO `biblio` VALUES (426,1,'Practical mother and child health in developing countries : a manual for the community health nurse and rural health centre staff / G.J. Ebrahim.','','4th','0333552288',28,'1991','v, 153 pages : illustrations ; 22 cm','','RJ101 .Eb7','en',NULL,17,'','Includes Index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-23 13:43:17','2017-10-23 13:47:06',NULL,NULL);
INSERT INTO `biblio` VALUES (427,1,'Mental health issues in primary care : a practical guide / Elizabeth Armstrong.','','','9780333606759',27,'1995','xi, 143 pages : illustrations, 21cm','','RA790 .Ar5','en',NULL,87,'','Includes bibliographical references (pages 127-133) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-25 10:25:58','2017-10-25 10:27:26',NULL,NULL);
INSERT INTO `biblio` VALUES (428,1,'Langman\'s medical embryology / T.W. Sadler ; original illustrations by Jill Leland ; computer illustrations by Susan L. Sadler-Redmond ; scanning electron micrographs by Kathy Tosney ; ultrasound images by Nancy Chescheir and Hytham Imseis','','11th','9781605476568',152,'2010','ix, 385 s. : ill. (chiefly color) ; 26 cm','','QM601 .L26','en',NULL,11,'','Embryology : old and new frontiers and an introduction to molecular regulation and signaling. Gametogenesis : conversion of germ cells into male and female gametes. First week of development : ovulation to implantation. Second week of development : bilaminar germ disc. Third week of development : trilaminar germ disc. Third to eighth weeks : the embryonic period. Third month to birth : the fetus and placenta. Birth defects and prenatal diagnosis. Skeletal system. -- Muscular system. Body cavities. Cardiovascular system. Respiratory system. Digestive system. Urogenital system. Head and neck. Central nervous system. Ear. Eye. Integumentary system \r\n 	Abstract	The brand new 11th edition of this respected text covers all aspects of embryology of interest to medical students & instructors, & includes clinical correlates that provide information on birth defects & other clinical entities directly related to embryologic concepts.\r\nIncludes bibliographical references and index.\r\n',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-25 10:51:15','2017-10-25 10:52:28',NULL,NULL);
INSERT INTO `biblio` VALUES (429,1,'Diabetes and its management / Peter J. Watkins [and others].','','6th','9781405107259',153,'2003','xi, 224 pages : illustrations ; 25 cm','','RC660 .D54','en',NULL,16,'','Diagnosis and classification ; Epidemiology of diabetes ; Synthesis, secretion and actions of insulin ; Metabolic changes in diabetes: a summary ; Aetiology and genetics ; Clinical features of diabetes ; Management of type 2 diabetes ; Management of type 1 diabetes mellitus ; Hypoglycaemia ; Diabetic hyperglycaemic emergencies ; Management of diabetes during surgery and other illnesses ; Pregnancy and diabetes ; Diabetes in children ; An overview of microvascular complications ; Diabetes and the kidney ; Diabetic eye disease ; Diabetic neuropathies ; The diabetic foot ; Cardiovascular disease ; Hypertension ; Living with diabetes ; Organization of care. \r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-25 11:11:19','2017-10-25 11:14:19',NULL,NULL);
INSERT INTO `biblio` VALUES (430,1,'Occupational therapy for children with disabilities / Dorothy E. Penso ; illustrations by Terry Winston.','','','0871893169',107,'1987','vii, 181 p. : ill. ; 22 cm','','RJ53.Oc1','en',NULL,80,'','Includes index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-30 12:30:55','2017-11-15 09:33:30',NULL,NULL);
INSERT INTO `biblio` VALUES (431,1,'Breastfeeding and human lactation / [edited by] Jan Riordan, Kathleen Auerbach.','','2nd','9780763705459',154,'1998','xxii, 874 pages, [8] pages of plates : illustratio','','RJ216 .B74','en',NULL,47,'','Ch. 1. Tides in Breastfeeding Practice -- Ch. 2. The Cultural Context of Breastfeeding -- Ch. 3. Families -- Ch. 4. Anatomy and Physiology -- Ch. 5. The Biological Specificity of Breastmilk -- Ch. 6. Drugs and Breastfeeding -- Ch. 7. Viruses in Human Milk -- Ch. 8. Breastfeeding Education -- Ch. 9. The Breastfeeding Process: The Perinatal and Intrapartum Period -- Ch. 10. The Breastfeeding Process: The Postpartum Period -- Ch. 11. Slow Weight Gain and Failure to Thrive -- Ch. 12. Jaundice and the Breastfeeding Baby -- Ch. 13. Breast Pumps and Other Technologies -- Ch. 14. Breastfeeding the Preterm Infant -- Ch. 15. Breast-Related Problems -- Ch. 16. Maternal Nutrition During Lactation -- Ch. 17. Women\'s Health and Breastfeeding -- Ch. 18. Maternal Employment and Breastfeeding -- Ch. 19. Child Health -- Ch. 20. The Ill Breastfeeding Child -- Ch. 21. Fertility, Sexuality, and Contraception During Lactation -- Ch. 22. Work Strategies and the Lactation Consultant -- Ch. 23. Research and Breastfeeding -- Ch. 24. Donor Human Milk Banking: More Than Nutrition -- A. Composition of Human Colostrum and Mature Breast Milk -- B. Via Christi Health System, St. Joseph Campus Breastfeeding Policies -- C. Via Christi Health System, St. Joseph Campus Breastfeeding Education Protocol -- D. Nursing Diagnosis Related to Breastfeeding -- E. New York State Code in Support of Breastfeeding (Added 1984) -- F. American Academy of Pediatrics: Breastfeeding and the Use of Human Milk -- G. Prototype Lactation Consultant Job Proposal or Description -- H. ILCA Standards of Practice for Lactation Consultants -- I. Tables of Equivalencies and Methods of Conversion -- J. Wellstart International Patient History -- K. Conversion Tables -- L. Standardized Height and Weight Growth Charts. \r\nIncludes bibliographical references and index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-30 12:59:27','2017-11-15 09:37:28',NULL,NULL);
INSERT INTO `biblio` VALUES (432,1,'Sexually transmitted diseases / [edited by] King K. Holmes [and others].','','','0070296758',133,'1984','xxi, 1079 pages, [11] pages of plates : illustrati','','RC200 .Se9','en',NULL,8,'','This chapter reviews current strategies in the US for the control of sexually transmitted diseases (STDs) and outlines recommendations for future strategies. At present, STD control strategies are influenced by 4 basic factors: the health care system, the different levels of government, the response of medical schools, and varying media attention. The 3 tiers of government in the US have different responsibilities for STD control, necessitating a partnership at the federal, state, and local levels. In particular, state and local health officials need to cooperate to ensure an integrated STD program. Medical schools are de-emphasizing instruction in venereology, meaning that many physicians enter practice without adequated knowledge of STD diagnosis and treatment. Overall, the STD intervention program in the US is comprised of the following components: health education and promotion, disease detection, appropriate treatment, partner tracing and patient counseling, clinical services, training, and research. There is a need for epidemiologic investigations to continually estimate the population at risk, broaden the surveillance of unreported STD, re-examine program activities for more cost-effective approaches, determine key patient behaviors such as compliance with prevention, and use cost-benefit and decision analysis models for program evaluation. The US Surgeon General has designated STD as 1 of 15 priority areas for national prevention and control efforts. Target objectives for 1990 include reductions in the rates of gonorrhea (to 280/100,000), gonococcal pelvic inflammatory disease (to 60/100,000), and primary and secondary syphilis (to 7/100,000). Other 1990 objectives are the neonatal herpes rate, the nongonococcal urethritis rate, the percentage of couples using condom or barrier methods, the percentage of high school students receiving adequate STD education, and the percentage of providers able to diagnose and treat STDs. The long-term effects of sexually transmitted diseases (STD) are far worse for women than men, yet their diagnosis and treatment are not given the kind of prestige or importance in the medical-education setting that they deserve. For example, most prevention programs are directed at men, even though they are not as likely to suffer from cancer, destruction of reproduction organs or complications of pregnancy, including the threat to the unborn, resulting from an STD. It is because men are so much less effected by STD that the author claims their importance is also devalued. Other results of STD are sociological and psychological and again the effects are much more damaging for women than for men. The result of ignoring the suffering of women as a result of STD can be seen in many aspects of the medical setting. For instance, the symptoms of STD for women are often poorly defined or very similar to other diseases. The article goes into great detail about the unique effects to women from neisseria gonorrhoea, chlamydia, herpes simplex, trichomonas vaginalis, and condylomta acuminatum. In every case, if left undiagnosed or even worse, misdiagnosed, the complications are far worse for women than for men. The symbolic importance of STD are covered providing support for the differential sociological effect of STD on women. Suggestion to the health care profession about the effects of this differential treatment on patients and their treatment as well as on medical education are also addressed. This paper reviews specific types of sexually tranmitted diseases (STDs) control laws--reporting; screening, contact tracing, and treatment--in the context of a community\'s social and economic situation. It is noted that reporting laws can serve statistical goals or more direct objectives of disease control, and legislation should reflect this distinction. Whenever there is a choice, legislation should enable authorities to offer positive services. Law is an effective device in the control of STDs to the extent that it is part of a comprehensive prevention, diagnosis, treatment, and management strategy. Based on these considerations, a basic plan for the legal control of STDs is outlined. In Phase 1, enabling legislation stating the basic purposes, authority and limitations of public health efforts to control STDs should be enacted, and epidemiologic studies aimed at determining the incidence and prevalence of STDs in each sector of the population should be authorized. Phase II includes the establishment of public clinics, STD specialists, physician extender programs, and appropriate licensing legislation. Reporting of STDs by all professionals and paraprofessionals diagnosing or treating STDs should be required, with a particular emphasis on the reporting of STDs in children. This phase should also authorize contact tracing and health hold orders based on reasonable epidemiologic suspicion of STD exposure. In Phase III, phsicial examinations on an involuntary basis for confined cases should be authorized, as should screening of epidemiologically documented high-risk groups. Finally, if prevalence statistics indicate a need, large-scale screening to issuance of identity cards should be considered. In the US, an estimated 2 million cases of gonorrhea occur a year. There was 72.799 cases of syphilis in 1981, Chlamydia trachomatous is widespread, genital herpes affects 500,000 to 1 million people per year, and pelvic inflammatory disease (PID) afflicts more than 850,000 women annually, which makes it among the most frequent sexually transmitted diseases (STDs). The victims of hepatitis A and hepatitis B are usually homosexual men. Treatment is available for most of these diseases, although it can be expensive. Health promotion targeted at teenagers and cultural groups can be effective, since premarital sex rose from 30% of women aged 15-19 in 1971 to 50% by 1979. Counseling on STDs is vital, but moral and social prophylaxis has also brought results in China as it did during World War II in the US. The condom or other barrier methods failed to protect 9% of women among 52,000 STD clinic attenders during 1977 and 1980, while 21% of nonusers were infected with gonorrhea. Spermicides, antiseptics, and antibiotic solutions also proved effective against infections. Systemic prophylaxis including arsenicals, bismuth, sulfathiazole, benzathine penicillin G, oral doxycycline, and broad spectrum antibiotics have been used as treatment for syphilis and gonorrhea. IUDs have been implicated in PID. The hepatitis B vaccine proved potent, but the gonococcal vaccine failed. Vaccines for group B streptococcal infections, genital herpes, and cytomegalovirus (CMV) are under study. STDs can cause disease, disability, and death to the fetus, thus careful history taking and aggressive use of caesareans is advised in women with STDs. Screening contact tracing, and mass treatment can allow early detection and elimination of STDs. Infectious syphilis among prostitutes and farm workers decreased by 51.3 and 26.8%, respectively, in California in the early 1970s as a result of mass treatment. Vaccines and rapid diagnostic tests can bring STDs under control and eventually eliminate them. This review considers all prominent infections associated with pregnancy, delivery, and the postpartum, explores theories of modes of infection of various tissues involved and organisms responsible, and ends with a section on each of the usual sexually transmitted diseases (STDs) in pregnancy in terms of epidemiology, clinical findings, pathogenesis, diagnosis, transmission, management and treatment for each. In pregnancy the woman\'s immune system is suppressed, and her anatomical relationships change so as to alter susceptibility to infections: disease-host relationships respond in a species specific manner detailed here. Generally young primiparas have more serious disease because of primary infection. Fetal and intrauterine infections, such as chorioamnionitis, may involve syphilis, cytomegalovirus and herpes as well as Group B strep, enteric and anaerobic organisms or polyinfections, are an important risk factor for prematurity miscarriage, and prolonged rupture of membranes. Possibly bacterial products activate the prostaglandin pathway initiating preterm labor. Postpartum endometritis and sepsis may also be caused by typical STD organisms, as well as vaginal, enteric or nosocomial organisms. Chlamydia is an unappreciated cause of puerperal infections. Systemic gonorrhea should be treated prophylactically in neonates at risk. Group B streptococcus should be considered a STD in this context. Several genital mycoplasmas are responsible for puerperal fever; several vaginal anaerobes are probably associated with neonatal sepsis. Cytomegalovirus is the most common cause of congenital viral infection of the fetus and the greatest infectious cause of mental retardation, yet is usually asymptomatic in both mothers and neonates. Obstetric complications of prenatal STD infection is a field needing intense research. This document contains a rationale and plan for managing sexually transmitted diseases (STDs) in basic health services of developing countries. Such services typically offer care to 80-90% of the population in the rural areas through staffs of paramedical and auxiliary workers. Although STDs are receiving higher priority than previously, control programs for them must be practical and economical considering the meager resources available for all types of health care. STDs in developing countries differ from their counterparts in developed countries in being more frequent, more likely to involve genital ulcers, and more likely to lead to complications, which may be severe. A realistic aim of STD control programs is to reduce the incidence of complications, such as pelvic inflammatory disease (PID), urethral stricture, sterility, opthalmia, neonatorum, and congenital syphilis. The 1st steps in such a program should be good management of patients and their contacts, case-finding for syphilis in antenatals, screening and case-finding for gonorrhea in high risk groups, and systematic prophylaxis for opthalmia neonatorum. A realistic approach for basic health services is a problem oriented one following flow charts. The management of urethral discharge, vaginal discharge, PID, and genital ulcers following such principles is described, including general considerations for each type of condition, suggested and alternative strategies, local background information needed to tailor a progam and treatment protocol, and suggestions for health centers with and without laboratory facilities. Examples of procedures, incidence of diseases within the caseload, and results from some STD control programs in basic health services of developing countries are provided. The etiology, differential diagnosis, and treatment of female infertility are discussed. Emphasis is given to the role of sexually transmitted diseases (STD), specifically those caused by gonococci, chlamydia, and mycoplasmas, in infertility. The effects of STD on 5 sites--vagina, cervix, endometrium, tubal and peritubal area, and ovary--are delineated. STD play an especially important role in the development of acute tubal and peritubal disease and subsequent infertility. The primary acute infection is believed to be a mucosal or epithelial process, spreading from the cervix to endometrium and then to the endosalpinx. About 50% of couples with tubal infertility have no previous history of pelvic inflammatory disease (PID). However, significant and permanent tubal disease is suspected to result from subclinical salpingitis. IUDs may contribute to this form of salpingitis. Genital mycoplasmas are thought to play a minor role in tubal infertility relative to gonococcal or chlamydial infections. Later age at marriage and delayed childbearing make it likely that the peak incidence of recognized infertility in women will be delayed beyond the peak incidence of STD. The differentiation of tubal infertility from infertility of other causes is complicated by infertility\'s multifactorial etiology. Determination of whether tubal or peritubal disease was caused by a STD or other organisms or is the result of an infection secondary to an IUD is considered to be of little value in determining an individual patient\'s prognosis after treatment. The major clinical classifications of infertility are outlined, and the diagnostic procedures and usual etiologies and therapies for each are presented. Ovulatory factors are assumed to account for 20-30% of infertility, male factors for 30-40%, cervical factors for 5-15%, and tubal factors for another 15%.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-10-30 13:12:42','2017-10-30 13:13:55',NULL,NULL);
INSERT INTO `biblio` VALUES (433,1,'Instructor\'s manual for Medical terminology : an illustrated guide / Barbara J. Cohen.','','2nd','9780397551361',24,'1994','v, 105 pages, [45] pages : illustrations ; 24 cm','Medical terminology','R123 .C66','en',NULL,11,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-13 08:13:54','2017-11-13 09:17:43',NULL,NULL);
INSERT INTO `biblio` VALUES (434,1,'Nurse-midwifery / Helen Varney.','','2nd','0865420270',155,'1980','xx, 846 pages : illustrations ; 24 cm','','RG951 .V43','en',NULL,47,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-13 09:31:51','2017-11-13 09:50:25',NULL,NULL);
INSERT INTO `biblio` VALUES (435,1,'Internship Textbook for General Nursing and Midwifery.','','','9788184489439',31,'2010','394 pages : illustrations 24 cm','','RT41 .C59','en',NULL,88,'','Includes index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-13 10:06:53','2017-11-15 09:35:37',NULL,NULL);
INSERT INTO `biblio` VALUES (436,1,'Community health nursing: promoting health of aggregates, families, and individuals / [edited by] Marcia Stanhope, Jeanette Lancaster.','','4th','9780815181422',104,'1996','xxvii, 1124 pages : illustrations (some color) ; 2','','RT98 S2 .C73','en',NULL,46,'','Includes bibliographical references and index.','stanhope.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-13 12:13:00','2021-10-15 12:09:05',NULL,NULL);
INSERT INTO `biblio` VALUES (437,32,'A pocket guide to pain management','','4th','9780974009353',196,'2010','vii, 324 pages : illustrations ; Ebook','','','en',NULL,0,'','Other Notes	\r\n\"A companion to www.PainEDU.org.\"\r\nLynette A. Menefee Pujol, Ph. D. on cover.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 15:38:32','2019-05-24 12:06:08',NULL,NULL);
INSERT INTO `biblio` VALUES (438,32,'From tiny tot to toddler : practical guide for parents from pregnancy to age two','','2013 ed','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 16:03:43','2017-11-15 00:41:44',NULL,NULL);
INSERT INTO `biblio` VALUES (439,32,'Alloimmune disorders of pregnancy : anaemia, thrombocytopenia, and neutropenia in the fetus and newborn','','','',0,'','','','','en',NULL,0,'','1. Pathophysiology of the alloimmune cytopenias / Andrew G. Hadley and Craig Turner -- 2. Blood group antibodies in haemolytic disease of the fetus and newborn / Geoff Daniels -- 3. Basis and practice of screening for haemolytic disease of the fetus and newborn / Geoff Poole -- 4. Epidemiology and screening for alloimmune thrombocytopenia / Lorna M. Williamson and Michael F. Murphy -- 5. Principles of antibody-mediated immune suppression and the prevention of maternal RhD alloimmunization / Belinda Kumpel -- 6. The clinical application of anti-D prophylaxis / Stan Urbaniak -- 7. Fetal genotyping / Neil D. Avent -- 8. Laboratory assays to determine the severity of haemolytic disease of the fetus and newborn / Andrew G. Hadley -- 9. Assessing the severity of haemolytic disease of the fetus and newborn: clinical aspects / Shenif Abdel-Fattah and Peter Soothill -- 10. Antenatal therapy for haemolytic disease of the fetus and newborn / Kenneth J. Moise, Jr. and Paul W. Whitecar -- 11. Neonatal therapy for haemolytic disease of the newborn / Glynn Russell and Nic Goulden -- 12. The diagnosis of alloimmune thrombocytopenia / Andrew G. Hadley -- 13. The Immunological diagnosis of alloimmune neutropenia / Geoff Lucas -- 14. Fetal and neonatal treatment of alloimmune thrombocytopenia / Michael F. Murphy, Rachel Rayment and David Allen / [et al.].',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 16:14:55','2017-11-15 00:43:41',NULL,NULL);
INSERT INTO `biblio` VALUES (440,32,'Anxiety & depression workbook for dummies','','','978-0-7645-9793-0',205,'2006','1 online resource 301 pages) : illustrations.','For dummies.','BF575.A6 El6','en',NULL,116,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 16:19:22','2019-05-27 10:34:01',NULL,NULL);
INSERT INTO `biblio` VALUES (441,32,'A practical manual of diabetes in pregnancy','','Kring Johnson','978-1-4051-7904-1',90,'2010','','','RG580 .D54','en',NULL,1,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 16:23:35','2019-05-24 12:09:14',NULL,NULL);
INSERT INTO `biblio` VALUES (442,32,'Ask a midwife','','1st American ed.','978-0-7566-3687-6',229,'2008','1 online resource (324 pages) : color illustration','','RG525 .P22','en',NULL,8,'','This book has your pregnancy and birth questions answered by experienced midwives. It covers what you need to know from conception to the first weeks of life with a new baby.','Ask_a_midwife.jpg.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2017-11-14 16:27:50','2019-07-15 15:39:19',NULL,NULL);
INSERT INTO `biblio` VALUES (443,32,'Basic maternal and newborn care : a guide for skilled providers','','','0-929817-82-6',146,'2004','1 online resource (xxii, 426 pages).','','RG951 .K62','en',NULL,31,'','\"The MBNC manual is intended for use by skilled providers (including midwives, doctors, and nurses) who care for women and newborns in low-resource settings. Basic care can be given in a variety of sites, including the woman\'s home, the peripheral health center, and the district referral hospital. It is assumed that the skilled provider will furnish all basic care services, identify and manage common complications, and stabilize (if necessary) and refer/transfer women and newborns needing additional interventions. It is recognized, however, that some skilled providers will also be capable of treating more complex conditions\" ( --Preface).\r\nIncludes bibliographical references.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 17:03:12','2019-06-07 13:51:10',NULL,NULL);
INSERT INTO `biblio` VALUES (491,1,'Anesthesia for the uninterested / edited by John D. Tolmie, Alexander A. Birch.','','2nd','0871892960',107,'1986','xiii, 263 pages : illustrations ; 23 cm','','RD81 .B53','en',NULL,59,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 10:10:38','2017-11-15 10:23:47',NULL,NULL);
INSERT INTO `biblio` VALUES (492,1,'Conception, pregnancy, and birth / edited by Catherine A. Niven and Anne Walker.','','','9780750622509',112,'1996','xviii, 163 pages ; 24 cm.','','RG103.5 .C74','en',NULL,47,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 10:20:46','2017-11-15 10:22:24',NULL,NULL);
INSERT INTO `biblio` VALUES (493,1,'Caring for sexuality in health and illness / edited by Diane Wells ; authors, Doreen Clifford, Marjorie Rutter, Jane Selby ; foreword by Jan Savage.','','','9780443064432',13,'2000','viii, 326 pages : illustrations','','RT87.S49 C19','en',NULL,8,'','Developing psychosexual awareness -- Life span emotional development and sexuality -- Coaching for psychosexual awareness -- A short history of Balint training. \r\nAbstract	This text will enable medical practitioners to develop their awareness and skills for the provision of sexual care, including an insight into the practitioner-patient relationship, and an understanding of each person\'s unique circumstances.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 10:35:55','2017-11-15 10:36:57',NULL,NULL);
INSERT INTO `biblio` VALUES (445,32,'A book for midwives : care for pregnancy, birth, and women\'s health','','1st ed','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 17:17:42','2017-11-15 01:01:44',NULL,NULL);
INSERT INTO `biblio` VALUES (446,32,'Child psychology and psychiatry : frameworks for practice / David Skuse [and others].','','2nd ed.','978-0-470-97382-0',128,'2011','1 online resource (xii, 306 pages)','','BF721.C43','en',NULL,1,'','Ruma Bose, Sanjida Sattar -- Neurobehavioural Development in Infancy / Cindy H Liu, Ed Tronick -- Genetic and Biological Influences / David Skuse -- Clinical Evaluation of Development from Birth to Five Years / Ajay Sharma, Tony O\'Sullivan -- Early Social and Emotional Experience Matters: The First Year of Life / Howard Steele -- Language Development / Thomas Klee, Stephanie F Stokes -- Development of Social Cognition / Virginia Slaughter -- Social and Emotional Development in Middle Childhood / Alan Carr -- Social-Cognitive Development during Adolescence / Sarah-Jayne Blakemore -- Section 2: Promoting Well-Being. Promoting Infant Mental Health / Christine Puckering -- Promoting Children\'s Well-Being / Paul Stallard -- Fostering Resilience in Adolescents / Angela Veale -- Section 3: Attachment and Separation. Attachment Theory: Research and Clinical Implications / Pasco Fearon -- Children Bereaved by Parent or Sibling Death / Linda Dowdney -- Adoption and Fostering / Jill Hodges -- Section 4: The Impact of Trauma and Maltreatment. Stress and Reactions to Stress in Children / Guinevere Tufnell -- Child Maltreatment / Danya Glaser -- The Neuroscience and Genetics of Childhood Maltreatment / Eamon McCrory, Stephane A De Brito, Essi Viding -- Section 5: Atypical Development. Feeding and Eating Disorders in Infancy and Childhood / Rachel Bryant-Waugh -- Literacy Disorders / Valerie Muter, Margaret J Snowling -- Autism Spectrum Disorders / Tony Charman -- Somatization and Somatoform Disorders / Elena Garralda -- Attention-Deficit Hyperactivity Disorder / Anita Thapar, Antonio Mųoz-Solomando -- Challenges in Child and Adolescent Obsessive-Compulsive Disorder / Elaine Chung, Isobel Heyman -- Anxiety Disorders in Children and Adolescents / Aaron Vallance, Elena Garralda -- Childhood Behavioural Disorders / Graeme Lamb -- Specific Language Impairment / Gina Conti-Ramsden, Kevin Durkin -- Depression and Suicidal Behaviour in Children and Adolescents / Julia Gledhill, Matthew Hodes -- Eating Disorders in Adolescence / Dasha Nicholls -- Substance Misuse in Young People / K A H Mirza, Roshin M Sudesh, Sudeshni Mirza -- Early-Onset Bipolar Disorder / Anthony James -- Emerging Personality Disorder / Eileen Vizard -- Section 6: Assessment. Diagnostic Classification: Current Dilemmas and Possible Solutions / Eric Taylor -- Paediatric Neuropsychological Assessment I: An Assessment Framework / Judith Middleton -- Paediatric Neuropsychological Assessment II: Domains for Assessment / Jane Gilmour, Bettina Hohnen -- Assessment of Child Psychiatric Disorders / Helen Bruce, Navina Evans -- Psychological Assessment / Michael Berger -- Family Therapy Assessment / Alexandra Mary John -- Section 7: Approaches to Intervention. Discovering Psychiatric Pharmacogenomics / David A Mrazek -- Cognitive₆Behavioural Therapy for Children and Adolescents / Cathy Creswell, Thomas G O\'Connor -- Parenting Programmes for Conduct Problems / Stephen Scott, Sajid Humayun -- Systemic and Family Approaches to Intervention / Philip Messent -- Psychotherapeutic Approaches: A Psychodynamic Perspective / Eilis Kennedy -- Paediatric Psychopharmacology: Special Considerations / Paramala J Santosh.\r\nIncludes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 17:22:34','2019-06-10 13:46:39',NULL,NULL);
INSERT INTO `biblio` VALUES (447,32,'Obstetric fistula : guiding principles for clinical management and programme development / [editors, Gwyneth Lewis and Luc de Bernis].','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 17:29:22','2017-11-15 01:06:12',NULL,NULL);
INSERT INTO `biblio` VALUES (448,32,'Overcoming anxiety for dummies','','2nd','',0,'','','','','en',NULL,0,'','\"Get over your anxiety and create a calmer, more peaceful life. Job loss, natural disasters, terrorism--with so many things to worry about today, your anxiety levels can easily skyrocket. This engaging guide is packed with techniques you can use immediately to overcome your worries and gain control of your life. You\'ll pinpoint your triggers, discover the latest therapies, and make lifestyle changes that will have you feeling better fast\"',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 17:37:52','2017-11-15 01:08:29',NULL,NULL);
INSERT INTO `biblio` VALUES (449,32,'Pain-free biochemistry : an essential guide for the health sciences','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 17:42:03','2017-11-15 01:12:49',NULL,NULL);
INSERT INTO `biblio` VALUES (450,32,'Pediatric nutrition in practice','','2nd, revised edition.','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 17:47:02','2017-11-15 01:14:05',NULL,NULL);
INSERT INTO `biblio` VALUES (490,32,'Drugs and pregnancy : a handbook / Bertis B. Little.','','','9780340809174',236,'2006','1 online resource, 372 pages : illustrations.','','RG528 .L72','en',NULL,95,'','Comprehensive, but concise, this practical handbook will assist the physician and nurse prescriber in understanding the effects of drug exposure during pregnancy.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 09:05:37','2019-07-03 11:44:54',NULL,NULL);
INSERT INTO `biblio` VALUES (451,32,'Perinatal and postpartum mood disorders : perspectives and treatment guide for the health care practitioner','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 17:49:44','2017-11-15 01:16:57',NULL,NULL);
INSERT INTO `biblio` VALUES (452,32,'Postpartum mood and anxiety disorders : a clinician\'s guide','','','',0,'','','','','en',NULL,0,'','\"The identification and treatment of postpartum mood and anxiety disorders is a public health issue; untreated illness can lead to altered functioning of women as they develop in their maternal role. Designed for clinicians delivering postpartum care, including midwives, lactation consultants, physicians, OB-GYN nurse practitioners, and women\'s health practitioners, Postpartum Mood and Anxiety Disorders provides an overview of the six different mood and anxiety disorders that may present during the postpartum year.\" \"Every chapter begins with the DSM-IV diagnostic criteria for that particular disorder and elaborates on its relevance to the postpartum period. Each chapter then moves on to information regarding diagnosis, treatment suggestions, and a case study utilizing the authors\' Earthquake Assessment and NURSE Plan.\" \"Postpartum Mood and Anxiety Disorders aims to stimulate creative thinking in the assessment process and treatment plan, with the overall goal of advancing the specialty area of mental health, psychiatry, and women\'s health.\"--Jacket.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 17:55:18','2017-11-15 01:18:26',NULL,NULL);
INSERT INTO `biblio` VALUES (453,32,'International maternal & child health care : a practical manual for hospitals worldwide','','','',0,'','','','','en',NULL,0,'','Section 1: General issues regarding hospital care -- section 2: Pregnancy-related problems -- section 3: Neonatal care -- section 4: Children in hospital -- section 5: The child presenting with a system or organ dysfunction -- section 6: Infections in children -- section 7: Major injuries in pregnancy and childhood -- section 8: Procedures in children and newborn infants -- section 9: Appendix. \r\n\r\n\"This textbook is written to help health workers treating pregnant women and adolescents, their newborn infants, and children admitted to hospitals in countries all over the world. It is especially aimed at those working in settings in which material and human resources are limited, where borders and infrastructures are insecure, and in rural areas where health workers may find it particularly difficult to work.\"--Preface.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 17:55:57','2019-10-11 09:01:12',NULL,NULL);
INSERT INTO `biblio` VALUES (454,32,'Medical management of pregnancy complicated by diabetes','','5th ed.','',0,'','','','','en',NULL,0,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 17:58:12','2017-11-15 01:29:46',NULL,NULL);
INSERT INTO `biblio` VALUES (455,32,'Intrapartum care : a learning programme for professionals','','','',0,'','','','','en',NULL,0,'','Monitoring the condition of the mother during the first stage of labour -- Monitoring the condition of the fetus during the first stage of labour -- Monitoring and management of the first stage of labour -- Skills workshop: examination of the abdomen in labour -- Skills workshop: vaginal examination in labour -- Skills workshop: recording observations on the partogram -- The second stage of labour -- Skills workshop: performing and repairing an episiotomy -- The third stage of labour -- Managing pain during labour -- The puerperium -- Family planning after pregnancy -- Tests. \r\n\r\nBased on the highly successful Perinatal Education Programme, which has brought continuing training to thousands of midwives, neonatal nurses and doctors.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 18:01:36','2019-10-11 09:20:29',NULL,NULL);
INSERT INTO `biblio` VALUES (456,32,'Pregnancy for dummies','','3rd','',0,'','','','','en',NULL,0,'','Offers all of the latest information expecting parents want to know, including expanded coverage on the health and well-being of both mother and child throughout pregnancy. Features new and updated coverage of prenatal genetic screening and diagnosis, amniocentesis, new high-tech ultrasounds, and the revised FDA/USDA food pyramid. It also discusses the recent celebrity trend of \"on-demand\" cesarean sections, multiple births, what to expect in labor and delivery, postpartum care, choosing bottle or breastfeeding, preparing a home (and siblings) for a new baby, caring for preemies, and the mother\'s mental as well as physical health.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 18:02:04','2017-11-15 01:36:41',NULL,NULL);
INSERT INTO `biblio` VALUES (457,32,'The FIGO textbook of pregnancy hypertension : an evidence-based guide to monitoring, prevention and management','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 18:05:20','2017-11-15 01:41:39',NULL,NULL);
INSERT INTO `biblio` VALUES (458,32,'Intrapartum care : care of healthy women and their babies during childbirth','','','',0,'','','','','en',NULL,0,'','Indhold: Introduction ; Summary of recommendations and care pathway ; Planning place of birth ; Care throughout labour ; Coping with pain in labour: non-epidural ; Pain relief in labour: regional analgesia ; Normal labour: first stage ; Normal labour: second stage ; Normal labour: thrid stage ; Normal labour: care of the baby and woman immediately after birth ; Prelabour rupture of membranes at term ; Meconium-stained liquor ; Complicated labour: monitoring babies in labour ; Complicated labour: first stage ; Complicated labour: second stage ; Complicated labour: immediate care of newborn ; Complicated labour: third stage\r\nAppendix: Declarations of interest ; Clinical questions ; Selection criteria and validity scores for included and excluded studies for the systematic review comparing planned home birth and planned hospital birth and the systematic review comparing planned standalone midwife-led unit and obstetric unit birth ; NCC-WCH analysis to obtain the best estimate of intrapartum-related perinatal mortality in England and Wales ; Decision tree modelling framework to assess cost-effectiveness for place of birth ; Economic evaluation for ST analysis',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 18:07:15','2019-10-11 09:10:50',NULL,NULL);
INSERT INTO `biblio` VALUES (459,32,'Management and Therapy of Early Pregnancy Complications : First and Second Trimesters / edited by Antonio Malvasi, Andrea Tinelli, Gian Carlo Di Renzo','','','978-3-319-31377-1',245,'2016','1 online resource (79 pages)','','RG499.2 M31','en',NULL,145,'','\"This richly illustrated book draws on recently acquired knowledge to provide the reader with comprehensive, up-to-date information on the full range of obstetric complications that may be encountered during the first and second trimesters of pregnancy. For all complications, including those potentially involved in malpractice issues, risk factors and clinical presentation are described and detailed guidance is provided on the appropriate treatment. The lucid text is complemented by a wealth of images, diagrams, flow charts, and drawings. The volume has been compiled in collaboration with a large group of gynecologists, obstetricians and internationally renowned scientists to provide an essential guide. Accordingly, this book will be a valuable tool for every obstetrician and gynecologist. Practitioners across the world will be enabled to deepen their knowledge and to refine their approach to complications in daily clinical practice. . \". Font no determinada.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 18:13:49','2019-10-11 12:09:27',NULL,NULL);
INSERT INTO `biblio` VALUES (460,32,'Managing complications in pregnancy and childbirth : a guide for midwives and doctors','','','92 4 154587 9',246,'2003','1 v (various pagings) : ill.','','RG551 .M31','en',NULL,12,'','','Managing_Complications_in.jpg.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2017-11-14 18:16:42','2019-10-11 12:32:18',NULL,NULL);
INSERT INTO `biblio` VALUES (461,32,'Reading essentials for biology : an interactive student textbook','','','',0,'','','','','en',NULL,0,'','This book covers important concepts in biology, offers ideas for how to learn the information, and helps you review what you have learned.-p. vii.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 18:20:39','2017-11-15 01:54:47',NULL,NULL);
INSERT INTO `biblio` VALUES (462,32,'Managing eclampsia','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 18:28:27','2017-11-15 01:56:39',NULL,NULL);
INSERT INTO `biblio` VALUES (463,32,'Managing incomplete abortion','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 18:31:30','2019-12-16 12:38:19',NULL,NULL);
INSERT INTO `biblio` VALUES (464,32,'Managing postpartum haemorrhage','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 18:33:38','2019-10-15 18:22:34',NULL,NULL);
INSERT INTO `biblio` VALUES (465,32,'Managing prolonged and obstructed labour','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 18:35:12','2017-11-15 02:01:54',NULL,NULL);
INSERT INTO `biblio` VALUES (466,32,'Maternal care : a learning programme for professionals','','','',0,'','','','','en',NULL,0,'','\"This book addresses all the common and important problems that occur during pregnancy, labour, delivery, and the puerperium. It includes booking for antenatal care, problems during the antenatal period, monitoring and managing the mother, fetus and progress during labour, medical problems during pregnancy, problems during the three stages of labourand the puerperium, family planning after pregnancy, and regionalised perinatal care. Skills workshops teach the general examination, abdominal and vaginal examination in pregnancy and labour, screening for syphilis and HIV, use of an antenatal card and partogram, and performing and repairing an episiotomy. Maternal care is aimed at professional healthcare workers in level 1 hospitals or clinics.\"--Page 10.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 18:39:06','2019-10-15 18:32:31',NULL,NULL);
INSERT INTO `biblio` VALUES (467,32,'Metabolic Syndrome and Complications of Pregnancy : The Potential Preventive Role of Nutrition','','','9783319168531',247,'2015','1 online resource (x, 238 p. 46 illustrations, 36','','RG499.2 M55','en',NULL,146,'','This book explores the nature of pregnancy and metabolic syndrome as proinflammatory conditions and explains how pregnancy provides a window of opportunity for preventing the lifelong complications of metabolic syndrome, during which key risk factors can be identified and beneficial dietary changes can be implemented. The books opening sections discuss inflammation in the context of pregnancy, including the nature of the placenta as a proinflammatory tissue. In the main body, it points to new possible connections to truncal obesity, inflammation, metabolic syndrome, and major obstetrical syndromes, including preeclampsia, gestational diabetes and pre-term delivery. Based on the insights offered by this analysis, the remainder of the book focuses on a variety of nutritional measures and diets that can be of benefit during and beyond pregnancy. Readers will learn how the higher level of compliance with medical instructions during pregnancy can be capitalized on to ensure enduring health ...',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 18:45:28','2019-10-16 12:48:23',NULL,NULL);
INSERT INTO `biblio` VALUES (468,32,'Recurrent Pregnancy Loss : Causes, Controversies and Treatment','','','',0,'','','','','en',NULL,0,'','Exploring basic science and the clinical applications, Recurrent Pregnancy Loss: Causes, Controversies and Treatment provides an authoritative, comprehensive review of the management of recurrent pregnancy loss. Many subjects in this area are controversial, and occasionally clinical decisions are based on lack of knowledge rather than evidence. For this reason, chapters include debates by leading experts to aid the clinician in deciding on the appropriate clinical management. Chapters cover basic science, genetics, and the application of evidence based medicine as well as mid- trimester loss, l.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 18:45:56','2017-11-15 02:09:02',NULL,NULL);
INSERT INTO `biblio` VALUES (469,32,'Multiple pregnancy : the management of twin and triplet pregnancies in the antenatal period','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 18:51:06','2017-11-15 02:10:31',NULL,NULL);
INSERT INTO `biblio` VALUES (470,32,'Strategic Marketing For Health Care Organizations : Building A Customer-Driven Health System','','','',0,'','','','','en',NULL,0,'','This much-needed text offers an authoritative introduction to strategic marketing in health care and presents a wealth of ideas for gaining the competitive edge in the health care arena. Step by step the authors show how real companies build and implement effective strategies. It includes marketing approaches through a wide range of perspectives: hospitals, physician practices, social marketing, international health, managed care, pharmaceuticals, and biotechnology. With Strategic Marketing for Health Care Organizations, students and future administrators will have a guide to the most successf.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 18:52:52','2017-11-15 02:13:02',NULL,NULL);
INSERT INTO `biblio` VALUES (471,32,'NURSING CARE PLANS : guidelines for individualizing client care across the life span','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 18:53:55','2017-11-15 02:23:12',NULL,NULL);
INSERT INTO `biblio` VALUES (472,32,'Supportive Care and Midwifery','','','',0,'','','','','en',NULL,0,'','This book considers the broad range of support given to mothers including social, psychological and clinical. It also looks at the provision of this service and how different models have been set up internationally to fulfill this important function. It brings together the latest research findings, which examine the nature of care that is provided and consider what constitutes effective and efficient support. This aspect of care is considered a crucial part of the increasing and expanding role of the midwife. The ability of midwives to provide ongoing support throughout childbearing is one of.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 19:11:22','2017-11-15 02:24:51',NULL,NULL);
INSERT INTO `biblio` VALUES (473,32,'Teaching critical thinking in psychology : a handbook of best practices','','','',0,'','','','','en',NULL,0,'','\"Teaching Critical Thinking in Psychology\" features current scholarship on effectively teaching critical thinking skills at all levels of psychology. It offers novel, nontraditional approaches to teaching critical thinking, including strategies, tactics, diversity issues, service learning, and the use of case studies. It provides new course delivery formats by which faculty can create online course materials to foster critical thinking within a diverse student audience. It places specific emphasis on how to both teach and assess critical thinking in the classroom, as well as issues of wider program assessment. It discusses ways to use critical thinking in courses ranging from introductory level to upper-level, including statistics and research methods courses, cognitive psychology, and capstone offerings',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 19:40:42','2017-11-15 02:26:17',NULL,NULL);
INSERT INTO `biblio` VALUES (474,32,'Textbook of clinical embryology','','','',0,'','','','','en',NULL,0,'','\"The success of Assisted Reproductive Technology is critically dependent upon the use of well optimized protocols, based upon sound scientific reasoning, empirical observations and evidence of clinical efficacy. Recently, the treatment of infertility has experienced a revolution, with the routine adoption of increasingly specialized molecular biological techniques and advanced methods for the manipulation of gametes and embryos. This textbook - inspired by the postgraduate degree program at the University of Oxford - guides students through the multidisciplinary syllabus essential to ART laboratory practice, from basic culture techniques and micromanipulation to laboratory management and quality assurance, and from endocrinology to molecular biology and research methods. Written for all levels of IVF practitioners, reproductive biologists and technologists involved in human reproductive science, it can be used as a reference manual for all IVF labs and as a textbook by undergraduates, advanced students, scientists and professionals involved in gamete, embryo or stem cell biology\"',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 19:43:32','2017-11-15 02:28:32',NULL,NULL);
INSERT INTO `biblio` VALUES (475,32,'The Cambridge encyclopedia of child development','','','',0,'','','','','en',NULL,0,'','An authoritative, accessible and up-to-date account of all aspects of child development. Written by an international team of leading experts everything from neonatal development to education, neuroscience, theories and research methods, physical development, social development, cognitive development, psychopathology and parenting are covered. Essential reading for everyone interested in children.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 20:05:28','2017-11-15 02:49:59',NULL,NULL);
INSERT INTO `biblio` VALUES (476,32,'The joy of pregnancy : the complete, candid, and reassuring companion for parents-to-be','','','',0,'','','','','en',NULL,0,'','This comprehensive guide to pregnancy and birth provides a chapter for each month of gestation and another for the postpartum period, covering such topics as fetal development, the effects of pregnancy on the mother\'s body, and how to prepare for the newborn baby as well as for the delivery.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 20:20:43','2017-11-15 02:54:47',NULL,NULL);
INSERT INTO `biblio` VALUES (477,32,'The legal regulation of pregnancy and parenting in the labour market','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 20:24:38','2017-11-15 02:55:40',NULL,NULL);
INSERT INTO `biblio` VALUES (487,32,'Clinical examination a systematic guide to physical diagnosis.','','7th','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 08:51:16','2017-11-17 14:23:08',NULL,NULL);
INSERT INTO `biblio` VALUES (488,32,'Clinical practice guidelines for midwifery & women\'s health / Nell L. Tharpe.','','2006-2009 ed.','978-0-7637-3822-8',114,'2006','1 online resource (xi, 394 pages)','','RG950 . T32','en',NULL,83,'','\"2006-2009 Clinical Practice Guidelines for Midwifery & Women\'s Health presents a compilation of current practices that includes evidence-based, traditional, and empiric care from a wide variety of sources. Each guideline moves through problem identification and treatment using a standardized format for day-to-day clinical practice with diverse populations. The guidelines are currently in use by many practices as a way of meeting the American College of Nurse-Midwives (ACNM) recommendations, and are acceptable for collaboration.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 08:56:39','2019-06-11 12:21:58',NULL,NULL);
INSERT INTO `biblio` VALUES (489,32,'Diabetology of pregnancy / volume editors, J. Djelmis, G. Desoye, M. Ivanisevi','','','3–8055–7925–X',171,'2005','1 online resource (x, 327 s.) illustrations (some','Frontiers in diabetes.','RG580.D5 D46','en',NULL,95,'','Provides a comprehensive yet concise overview of the scientific and clinical characteristics of gestational diabetes as well as type 1 and type 2 diabetes mellitus during pregnancy. The books adopts a multidisciplinary approach and covers aspects such as etiology, physiology, molecular biology and genetics, immunology, pathogenesis, diagnosis, treatment and management, pathology and evidence-based medicine. The role of the placenta as a fetal organ at the interface between mother and fetus is covered in depth.\r\nIncludes bibliographical references and indexes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 09:02:21','2019-07-02 13:33:07',NULL,NULL);
INSERT INTO `biblio` VALUES (479,32,'The new art and science of pregnancy and childbirth : what you want to know from your obstetrician','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 20:34:52','2017-11-15 02:53:41',NULL,NULL);
INSERT INTO `biblio` VALUES (480,32,'The psychology of gender','','4th ed.','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 20:40:33','2017-11-15 02:58:46',NULL,NULL);
INSERT INTO `biblio` VALUES (481,32,'The social meaning of midwifery','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 20:43:40','2017-11-15 03:02:18',NULL,NULL);
INSERT INTO `biblio` VALUES (482,32,'Therapy and the postpartum woman : notes on healing postpartum depression for clinicians and the women who seek their help','','','',0,'','','','','en',NULL,0,'','\"This book provides a comprehensive look at effective therapy for postpartum depression. Using a blend of professional objectivity, evidence-based research, and personal, straight-forward suggestions gathered from years of experience, this book brings the reader into the private world of therapy with the postpartum woman. Based on Psychodynamic and Cognitive-Behavioral theories, and on D.W. Winnicott\'s \"good-enough mother\" and the \"holding environment\" in particular, the book is written by a therapist who has specialized in the treatment of postpartum depression for over 20 years. Therapy and the Postpartum Woman will serve as a companion tool for clinicians and the women they treat.\"--Publisher\'s website.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 20:46:05','2017-11-15 03:04:27',NULL,NULL);
INSERT INTO `biblio` VALUES (483,32,'WHO recommendations for prevention and treatment of pre-eclampsia and eclampsia','','','',0,'','','','','en',NULL,0,'','The majority of deaths due to pre-eclampsia and eclampsia are avoidable through the provision of timely and effective care to the women presenting with these complications. Optimizing health care to prevent and treat women with hypertensive disorders is a necessary step towards achieving the Millennium Development Goals. WHO has developed the present evidence-informed recommendations with a view to promoting the best possible clinical practices for the management of pre-eclampsia and eclampsia.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 20:48:29','2017-11-15 03:05:45',NULL,NULL);
INSERT INTO `biblio` VALUES (484,32,'WHO recommendations for the prevention and treatment of postpartum haemorrhage','','','',0,'','','','','en',NULL,0,'','Postpartum haemorrhage (PPH) is a major cause of mortality, morbidity and long term disability related to pregnancy and childbirth. Effective interventions to prevent and treat PPH exist and can largely reduce the burden of this life-threatening condition. Given the availability of new scientific evidence related to the prevention and treatment of PPH, this document updates previous WHO recommendations and adds new recommendations for the prevention and treatment of PPH. The primary goal of this guideline is to provide a foundation for the implementation of interventions shown to have been effective in reducing the burden of PPH. Health professionals responsible for developing national and local health policies constitute the main target audience of this document. Obstetricians, midwives, general medical practitioners, health care managers and public health policy-makers, particularly in under-resourced settings are also targeted. This document establishes general principles of PPH care and it is intended to inform the development of clinical protocols and health policies related to PPH.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 20:50:56','2017-11-15 03:06:47',NULL,NULL);
INSERT INTO `biblio` VALUES (485,32,'WHO recommendations on antenatal care for a positive pregnancy experience','','','',0,'','','','','en',NULL,0,'','Within the continuum of reproductive health care, antenatal care (ANC) provides a platform for important healthcare functions, including health promotion, screening and diagnosis, and disease prevention. It has been established that, by implementing timely and appropriate evidence-based practices, ANC can save lives. Endorsed, by the UN Secretary-General, this is a comprehensive WHO guideline on routine ANC for pregnant women and adolescent girls. It aims to complement existing WHO guidelines on the management of specific pregnancy-related complications. The guidance aims to capture the complex nature of the issues surrounding ANC health care practices and delivery, and to prioritize person-centred health and well-being, not only the prevention of death and morbidity, in accordance with a human rights-based approach.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 20:52:45','2017-11-15 03:08:30',NULL,NULL);
INSERT INTO `biblio` VALUES (486,32,'WHO recommendations on postnatal care of the mother and newborn','','','',0,'','','','','en',NULL,0,'','The postnatal period is a critical phase in the lives of mothers and newborn babies. Most maternal and infant deaths occur during this time. Yet, this is the most neglected period for the provision of quality care. WHO guidelines on postnatal care have been recently updated based on all available evidence. The guidelines focus on postnatal care of mothers and newborns in resource-limited settings in low- and middle-income countries. The guidelines address timing, number and place of postnatal contacts, and content of postnatal care for all mothers and babies during the six weeks after birth. The primary audience for these guidelines is health professionals who are responsible for providing postnatal care to women and newborns, primarily in areas where resources are limited. The guidelines are also expected to be used by policy-makers and managers of maternal and child health programmes, health facilities, and teaching institutions to set up and maintain maternity and newborn care services. The information in these guidelines is expected to be included in job aids and tools for both pre- and in-service training of health professionals to improve their knowledge, skills and performance in postnatal care. These recommendations will be regularly updated as more evidence is collated and analysed on a continuous basis, with major reviews and updates at least every five years. The next major update will be considered in 2018 under the oversight of the WHO Guidelines Review Committee.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-14 20:55:06','2017-11-15 03:09:27',NULL,NULL);
INSERT INTO `biblio` VALUES (494,1,'Nursing practice : hospital and home : the adult / edited by Margaret F. Alexander, Josephine N. Fawcett, Phyllis J. Runciman.','','2nd','9780443060137',13,'1994','xxiv, 1118 pages : illustrations ; 28 cm','','RT41 .N81','en',NULL,8,'','Section 1. Care of patients with common disorders -- Nursing practice: an introduction -- The cardiovascular system -- The respiratory system -- The gastrointestinal system, liver and biliary tract -- Endocrine and metabolic disorders -- Genetic disorders -- The reproductive systems and the breast -- The urinary system -- The nervous system -- The musculoskeletal system -- Blood disorders -- Skin disorders -- Disorders of the eye -- Disorders of the ear, nose and throat -- Disorders of the mouth -- The immune system and infectious disease -- Section 2. Common patient problems and related nursing care -- Stress -- Shock -- Pain -- Fluid and electrolyte balance -- Nutrition -- Temperature control -- Wound healing -- Continence -- Sleep -- Section 3. Nursing patients with special needs -- The patient facing surgery -- The patient who experiences trauma -- The unconscious patient -- The critically ill patient -- The patient with burns -- The patient with cancer -- The chronically ill person -- The patient receiving palliative care -- The patient in need of rehabilitation -- The older person -- People who use and abuse substances -- The person with HIV /AIDS.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 10:49:50','2017-11-15 10:51:17',NULL,NULL);
INSERT INTO `biblio` VALUES (495,1,'Breastfeeding the newborn : clinical strategies for nurses / Marie Biancuzzo.','','','9780815124535',104,'1996','xvi, 464 pages : illustrations; 23cm','','RJ216 .B73','en',NULL,46,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 11:01:52','2017-11-15 11:03:01',NULL,NULL);
INSERT INTO `biblio` VALUES (496,1,'Impotence : diagnosis and management of male erectile dysfunction / [edited by] R.S. Kirby, Culley C. Carson, G.D. Webster.','','','0750613629',112,'','x, 262 pages : ill. ; 25 cm','','RC889 .D54','en',NULL,51,'','Includes index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 11:31:58','2017-11-15 11:33:03',NULL,NULL);
INSERT INTO `biblio` VALUES (497,1,'A colour atlas of the hair, scalp, and nails / R. Baran, R.P.R. Dawber, G.M. Levene.','','','9780723409380',156,'1991','192 pages : illustrations; 27CM','Atlas of the hair, scalp, and nails','RL151 .B23','en',NULL,7,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 11:45:06','2017-11-15 11:45:55',NULL,NULL);
INSERT INTO `biblio` VALUES (498,1,'Maternal-newborn nursing care : a workbook / Sally B. Olds, Marcia L. London, Patricia A. Ladewig.','','Rev. ed.','0201127997',118,'1984','xi, 317 pages : illustrations ; 28 cm','','RG951 .Ol1','en',NULL,89,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 11:55:53','2017-11-15 11:57:10',NULL,NULL);
INSERT INTO `biblio` VALUES (499,20,'Essential midwifery practice : leadership, expertise and collaborative working','','','',0,'','','','','en',NULL,0,'','Midwifery leadership : theory, practice and potential / Sheena Byrom and Lesley Kay -- Transformational leadership and midwifery : a nested narrative review / Sheena Byrom, Anna Byrom, and Soo Downe -- What do leaders do to influence maternity services? : midwifery leadership as applied to case studies / Sheena Byrom [and others] -- Leadership for effective change in mother and infant health : lessons learned from a programme of work on breastfeeding / Mary Renfrew -- The notion of expertise / Soo Downe & Louise Simpson -- Expertise in intrapartum midwifery practice / Louise Simpson & Soo Downe -- Enhancing expertise and skills through education / Denis Walsh -- What is a skilled birth attendant? : insights from South America / Anne Davenport -- Collaboration : theories, models, and maternity care / Soo Downe and Kenny Finlayson -- Case studies of collaboration in the UK and China / Ngai Fen Cheung and Anita Fleming -- Using collaborative theories to reduce caesarean section rates and improve maternal and infant wellbeing / Alison Brodrick [and others] -- Bringing it all together / Soo Downe, Louise Simpson, Sheena Byrom.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 12:05:28','2017-11-17 14:31:04',NULL,NULL);
INSERT INTO `biblio` VALUES (500,32,'Essentials of clinical mycology','','Second edition.','',0,'','','','','en',NULL,0,'','\"Clinical Mycology\" offers a comprehensive review of this discipline. Organized by types of fungi, this volume covers microbiologic, epidemiologic and demographic aspects of fungal infections as well as diagnostic, clinical, therapeutic, and preventive approaches. Special patient populations are also detailed.\r\n\r\n\r\n	Part 1. Introduction -- part 2. Systemic antifungal drugs -- part 3. Mycoses caused by yeasts -- part 4. Mycoses caused by moulds -- part 5. Mycoses caused by dimorphic fungi -- part 6. Mycoses involving skin and subcutaneous tissues -- part 7. Other Mycoses -- part 8. Special patient populations.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 12:25:02','2017-11-17 14:36:40',NULL,NULL);
INSERT INTO `biblio` VALUES (501,32,'Anatomy and Physiology for Nurses at a Glance','','1st','',0,'','','','','en',NULL,0,'','Title Page -- Copyright Page -- Contents -- Preface -- Abbreviations -- Acknowledgements -- How to use your revision guide -- About the companion website -- Part 1 Foundations -- Chapter 1 The genome -- Genetics -- The double helix of DNA -- RNA -- Nucleotides -- Bases -- Chromosomes -- Protein synthesis -- Gene transference -- Chapter 2 Homeostatic mechanisms -- Homeostasis -- Feedback mechanisms -- Negative feedback -- Positive feedback -- Chapter 3 Fluid compartments -- Total body water -- Fluid regulation -- Chapter 4 Cells and organelles -- Cells -- Cell membrane -- Mitochondria. \r\nEndoplasmic reticulum -- Nucleus -- Cytoplasm -- Lipid bilayer -- Membrane proteins -- Functions of the plasma membrane -- Chapter 5 Transport systems -- Osmosis -- Diffusion -- Facilitated diffusion -- Active transport -- Endocytosis and exocytosis -- Chapter 6 Blood -- Blood -- Formation of blood cells -- RBC -- WBC -- Platelets -- Blood plasma -- Chapter 7 Inflammation and immunity -- Immune system -- Types of immunity -- Chapter 8 Tissues -- Tissues -- Epithelial tissue -- Nervous tissue -- Connective tissue -- Muscle tissue -- Part 2 The nervous system -- Chapter 9 The brain and nerves. \r\nBrain -- Neuron -- Cranial nerves -- Chapter 10 Structures of the brain -- Structures of the brain -- Cerebrum -- Diencephalon -- Brain stem -- Cerebellum -- Limbic system -- Ventricles of the brain -- Cerebrospinal fluid -- Chapter 11 The spinal cord -- Spinal cord -- Spinal cord sections -- Functions of the spinal cord -- Reflex actions -- Spinal nerves -- Chapter 12 The blood supply -- Circle of Willis -- Function of the circle of Willis -- Blood-brain barrier (BBB) -- Function of BBB -- Chapter 13 The autonomic nervous system -- ANS -- Sympathetic nervous system. \r\nParasympathetic nervous system -- Autonomic control by the CNS -- Autonomic reflexes -- Chapter 14 Peripheral nervous system -- PNS -- Peripheral nervous system connections -- Sensory division -- Motor division -- Part 3 The heart and vascular system -- Chapter 15 The heart -- Heart -- Walls of the heart -- Chambers of the heart -- Valves of the heart -- Blood vessels of the heart -- Chapter 16 Blood flow through the heart -- Blood flow -- Pulmonary circulation -- Systemic circulation -- Coronary circulation -- Coronary arteries -- Coronary veins -- Chapter 17 The conducting system. \r\nCardiac conduction -- SA node -- AV node -- Bundle of His -- Left and right bundle branches -- Purkinje fibres -- Cardiac cycle -- Chapter 18 Nerve supply to the heart -- Autonomic nervous system -- Chemical regulation of the heart -- Baroreceptors -- Other factors in heart regulation -- Chapter 19 Structure of the blood vessels -- Blood vessels -- Structure -- Arteries -- Veins -- Capillaries -- Chapter 20 Blood pressure -- What is blood pressure? -- Physiological factors -- Control of blood pressure -- Taking blood pressure -- Chapter 21 Lymphatic circulation -- Lymphatic system.\r\n\r\nAnatomy and Physiology for Nurses at a Glance is the perfect companion for study and revision for pre-registration nursing and healthcare students, from the publishers of the market-leading at a Glance series. Combining superb illustrations with accessible and informative text, this book covers all the body systems and key concepts encountered from the start of the pre-registration nursing or healthcare programme, and is ideal for anyone looking for an overview of the human body. Providing a concise, visual overview of anatomy and physiology and the related biological sciences, this book will help students develop practical skills, enabling them to become caring, kind and compassionate nurses. Superbly illustrated, with full colour illustrations throughout Breaks down complex concepts in an accessible way Written specifically for nursing and healthcare students with all the information they need Includes access to a companion website with self-assessment questions for each chapter Available in a range of digital formats- perfect for \'on the go\' study and revision.\r\n',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 16:25:05','2017-11-17 14:41:36',NULL,NULL);
INSERT INTO `biblio` VALUES (503,32,'Family planning : a global handbook for providers : evidence-based guidance developed through worldwide collaboration.','','','978-0-9788563-7-3',237,'2011','1 online resource (xii, 372 pages) : illustrations','','HQ766 .F21','en',NULL,22,'','1. Combined Oral Contraceptives -- 2. Progestin-Only Pills -- 3. Emergency Contraceptive Pills -- 4. Progestin-Only Injectables -- 5. Monthly Injectables -- 6. Combined Path -- 7. Combined Vaginal Ring -- 8. Implants -- 9. Copper-Bearing Intrauterine Device -- 10. Levonorgestrel Intrauterine Device -- 11. Female Sterilization -- 12. Vasectomy -- 13. Male Condoms -- 14. Femals Condoms -- 15. Spermicides and Diaphragms -- 16. Cervical Caps -- 17. Fertility Awareness Methods -- 18. Withdraw -- 19. Lactational Amenorrhea Method -- 20. Serving Diverse Groups -- 21. Sexuality Transmitted Infections, Including HIV -- 22. Maternal and Newborn Health.\r\n\r\nThis book can help in enabling health care providers to give better care to more people. This book translates scientific evidence into practical guidance on all major contraceptive methods. This guidance reflects the consensus of experts from the world\'s leading health organizations. With this book in hand, a provider can confidently serve clients with many different needs and knowledgeably offer a wide range of methods. The World Health Organization (WHO) appreciates the many contributions to this book made by people from around the world. The collaboration to develop, by consensus, an evidence-based book of this scope and depth is a remarkable achievement.\r\nIncludes index.','Family_planning_a_global_handbook_for_providers.jpg.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2017-11-15 16:51:29','2019-07-19 10:22:25',NULL,NULL);
INSERT INTO `biblio` VALUES (504,32,'Encyclopedia of sociology','','2nd ed.','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 17:19:59','2017-11-17 15:16:05',NULL,NULL);
INSERT INTO `biblio` VALUES (506,32,'Guidelines on basic newborn resuscitation','','','',0,'','','','','en',NULL,0,'','Globally, about one quarter of all neonatal deaths are caused by birth asphyxia. In this document, birth asphyxia is defined simply as the failure to initiate and sustain breathing at birth. Effective resuscitation at birth can prevent a large proportion of these deaths. The need for clinical guidelines on basic newborn resuscitation, suitable for settings with limited resources, is universally recognized. WHO had responded to this need by developing guidelines for this purpose that are contained in the document Basic newborn resuscitation: a practical guide. As this document is over a decade old, a process to update the guidelines on basic newborn resuscitation was initiated in 2009. The objective of these updated WHO guidelines is to ensure that newborns in resource-limited settings who require resuscitation are effectively resuscitated. These guidelines will inform WHO training and reference materials, such as Pregnancy, childbirth, postpartum and newborn care: a guide for essential practice; Essential newborn care course; Managing newborn problems: a guide for doctors, nurses and midwives; and Pocket book of hospital care for children: guidelines for the management of common illnesses with limited resources. These guidelines will assist programme managers responsible for implementing maternal and child health programmes to develop or adapt national or local guidelines, standards and training materials on newborn care.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 17:27:33','2017-11-17 15:32:26',NULL,NULL);
INSERT INTO `biblio` VALUES (507,32,'Handbook of critical psychology / edited by Ian Parker.','','','978-1-31572-652-6',94,'2015','1 online resource (xv, 477 pages)','Routledge international handbooks.','BF39.9 .H19','en',NULL,69,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 18:01:24','2019-10-10 17:27:54',NULL,NULL);
INSERT INTO `biblio` VALUES (508,32,'Handbook of pain management / edited by Ronald Melzack, Patrick D. Wall.','','','9780702036422',13,'2003','1 online resource (xi, 753 p.) : illustrations','Pain management','RB127 .M49','en',NULL,95,'','1. Acute and postoperative pain / Michael Cousins and Ian Power -- 2. Osteoarthritis / Paul Creamer -- 3. Rheumatoid arthritis / Malcolm I. V. Jayson -- 4. Muscles, tendons and ligaments / Dianne J. Newham and Kerry R. Mills -- 5. Chronic back pain / Donlin M. Long -- 6. Upper extremity pain / Anders E. Sola -- 7. Fibromyalgia / Robert Bennett -- 8. Abdominal pain / Laurence M. Blendis -- 9. Heart, vascular and haemopathic pain / Paolo Procacci, Massimo Zoppi and Marco Maresca -- 10. Chronic pelvic pain / Andrea J. Rapkin and Julie A. Jolin -- 11. Obstetric pain / John S. McDonald and Carl R. Noback -- 12. Genitourinary pain / Ursula Wesselmann and Arthur L. Burnett -- 13. Orofacial pain / Yair Sharav -- 14. Trigeminal, eye and ear pain / Joanna M. Zakrzewska -- 15. Headache / Jean Schoenen and Peter S. Sandor -- 16. Postamputation pain / Lone Nikolajsen and Troels Staehelin Jensen -- 17. Peripheral neuropathies / J. W. Scadding -- 18. Complex regional pain syndrome / J. W. Scadding -- 19. Nerve root disorders and arachnoiditis / David Dubuisson -- 20. Central pain / Jorgen Boivie -- 21. Spinal cord injury / Aleksandar Beric -- 22. Antipyretic analgesics / Kay Brune and Hanns Ulrich Zeilhofer -- 23. Psychotropic drugs / Richard Monks and Harold Merskey -- 24. Opioids / Catherine Sweeney and Eduardo Bruera -- 25. Local anaesthetics and epidurals / H. J. McQuay and R. A. Moore -- 26. Atypical analgesic drugs and sympathetic blockers / C. A. Chong, R. Munglani and R. G. Hill -- 27. Disc surgery / Bo Salen and Erik Spangfort -- 28. Orthopaedic surgery / Robert F. McLain and James N. Weinstein -- 29. Central neurosurgery / Jan M. Gybels and Ron R. Tasker -- 30. Transcutaneous electrical nerve stimulation / Per Hansson and Thomas Lundeberg -- 31. Ultrasound, shortwave, microwave, laser, superficial heat and cold in the treatment of pain / Justus F. Lehmann and Barbara J. de Lateur -- 32. Mobilization, manipulation, massage and exercise for the relief of musculoskeletal pain / Scott Haldeman and Paul D. Hooper -- 33. The placebo and the placebo response / Patrick D. Wall -- 34. Relaxation and biofeedback / Vivienne X. Gallegos -- 35. Hypnotic analgesia / Ann Gamsa -- 36. A cognitive-behavioral approach to pain management / Dennis C. Turk and Akiko Okifuji -- 37. Pain in children / Charles B. Berde and Bruce Masek -- 38. Pain in the elderly / Lucia Gagliese and Ronald Melzack -- 39. Sex and gender differences in pain / Anita Holdcroft and Karen J. Berkley -- 40. Peripheral neuropathic pain: an approach to management / Howard L. Fields -- 41. Pain of burns / Manon Choiniere -- 42. Cancer pain syndromes / Nathan I. Cherny -- 43. The management of cancer pain / Nathan I. Cherny -- 44. Cancer pain and palliative care in children / Charles B. Berde and John J. Collins -- 45. Cancer pain and AIDS-related pain: psychiatric and ethical issues / William Breitbart, Steven D. Passik and Barry D. Rosenfeld -- 46. Pain and impending death / Cicely Saunders and Michael Platt.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 18:07:58','2019-10-10 17:43:34',NULL,NULL);
INSERT INTO `biblio` VALUES (510,32,'High-yield gross anatomy / Ronald W. Dudek, Thomas M. Louis.','','5th','978-1-4511-9023-6',240,'2015','1 online resource xi, 308 pages : illustrations (s','High-yield series.','QM31 .D86','en',NULL,11,'','1. Vertebral column -- 2. Spinal cord and spinal nerves -- 3. Autonomic nervous system -- 4. Lymphatic System -- 5. Chest wall -- 6. Pleura, tracheobronchial tree, lungs -- 7. The heart -- 8. Abdominal wall -- 9. Peritoneal cavity -- 10. Abdominal vasculature -- 11. Abdominal viscera -- 12. Sgmod colon, rectum, and anal canal -- 13. Spleen -- 14. Kidney, ureter, bladder, and urethra -- 15. Suprarenal (adrenal) -- 16. Female reproductive system -- 17. Male reproductive system -- 18. Pelvis -- 19. Perineum -- 20. Upper limb -- 21. Lower limb -- 22. Head -- 23. Neck -- 24. Eye -- 25. Ear -- Appendices -- Credits -- Index. \r\n\r\n\r\n\r\n\"High-Yield Gross Anatomy addresses many of the recurring clinical themes of the USMLE Step 1. The information presented in this text prepares you to handle not only the clinical vignettes found on the USMLE Step 1, but also the questions concerning basic gross anatomy concepts\"--Provided by publisher.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 18:29:56','2019-10-10 18:52:21',NULL,NULL);
INSERT INTO `biblio` VALUES (511,32,'Immunology of pregnancy','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 18:34:21','2017-11-17 15:44:59',NULL,NULL);
INSERT INTO `biblio` VALUES (512,32,'Ross and Wilson anatomy & physiology in health and illness','','12th edition.','',0,'','','','','en',NULL,0,'','Introduces the structure and functions of the human body and the effects of disease or illness on normal body function. Uses easy-to-understand language and clear color illustrations to make learning more visual and engaging.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 19:17:58','2017-11-17 15:48:32',NULL,NULL);
INSERT INTO `biblio` VALUES (532,32,'An Introduction to microbiology for nurses','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-19 01:42:35','2017-11-19 01:42:45',NULL,NULL);
INSERT INTO `biblio` VALUES (533,32,'Anatomy and physiology','','','',0,'','','','','en',NULL,0,'','Contents\r\nAnatomy and chemistry basics -- The cell -- Tissues -- The integumentary system -- Bones and skeletal tissues -- The skeletal system -- Joints -- Muscle tissue -- The muscular system -- Nervous tissue -- The nervous system -- The sensory system -- The endocrine system -- The cardiovascular system -- The lymphatic system -- The immune system and other body defenses -- The respiratory system -- The digestive system -- The urinary system -- The reproductive system -- CQR review -- Glossary.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-19 01:52:51','2017-11-19 01:53:05',NULL,NULL);
INSERT INTO `biblio` VALUES (513,32,'Psychology applied to modern life : adjustments in the 21st century','','10th ed.','',0,'','','','','en',NULL,0,'','Filled with comprehensive, balanced coverage of classic and contemporary research, relevant examples, and engaging applications, this book shows you how psychology helps you understand yourself and the world--and uses psychological principles to illuminate the variety of opportunities you have in your life and your future career. While professors cite this bestselling book for its academic credibility and the authors\' ability to stay current with \'hot topics, \' students say it\'s one text they just don\'t want to stop reading. The book and associated workbook are highly readable, engaging, and visually appealing, providing you with a wealth of material you can put to use every day.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 19:39:10','2017-11-17 15:54:07',NULL,NULL);
INSERT INTO `biblio` VALUES (534,1,'Contemporary community nursing / edited by S. Burley . [and others].','','','9780340677339',19,'1997','xiv, 277 pages','','RT98 .C76','en',NULL,7,'','Art and science of community nursing / Sarah Luft, Milly Smith -- Contract culture / Derek Earl -- Issues in health promotion / Karen Melling, Ann Sutton / Needs of older people / Elaine Ryder -- Right to health care? / Eileen Groves -- Advocacy: possibility or ploy? / Elizabeth E. Mitchell -- Collaboration for care / Jenny Newbury, Ann Clarridge, Jo Skinner -- Sharing in partnership / Diane Cuff -- Teamwork and skill mix / Sandra Baulcomb, Sandra Burley -- Quality in community nursing / Milly Smith -- Managing change in the community / Paul Parkin -- Marketing community nursing expertise / Anne Weeks -- Experimental taxonomy in action / Isobel M. Walker -- Reality of clinical supervision / Maggie Dickerson -- Specialist and advances roles / Sarah Luft -- Assessing health needs in the community / Sue Chilton, Eileen Barnes -- Hospital at home / Barbara Johnson -- Nurse prescribing / Marion Brew -- Nursing in Europe / Brian Pateman -- Towards the next milennium / Rita Bell. \r\nIncludes bibliographical references and index.','cover_contemporary_community_nursing_edited_by_s_burley_and_others_.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2017-11-20 08:54:13','2022-02-17 07:38:48',NULL,NULL);
INSERT INTO `biblio` VALUES (515,32,'Psychology : a journey','','4th','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 19:45:39','2017-11-17 16:03:35',NULL,NULL);
INSERT INTO `biblio` VALUES (516,32,'Principles of anatomy & physiology / Gerard J. Tortora, Bryan Derrickson.','','14th','',0,'','','','','en',NULL,0,'','Written and illustrated for two-terms, this book offers a complete teaching and learning environment. It helps in building students\' confidence because it takes the guess work out of studying by providing a clear roadmap.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 19:48:13','2017-11-17 16:06:19',NULL,NULL);
INSERT INTO `biblio` VALUES (517,32,'Pain in childbearing and its control : key issues for midwives and women','','2nd ed.','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 19:50:15','2019-06-07 13:19:42',NULL,NULL);
INSERT INTO `biblio` VALUES (518,32,'Nutrition at a glance','','Second edition.','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 19:54:26','2017-11-17 16:10:19',NULL,NULL);
INSERT INTO `biblio` VALUES (519,32,'Midwifery practice : a research-based approach','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 19:56:54','2017-11-17 16:14:07',NULL,NULL);
INSERT INTO `biblio` VALUES (520,32,'Mayes\' midwifery','','14th','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 20:00:13','2017-11-17 16:18:03',NULL,NULL);
INSERT INTO `biblio` VALUES (521,32,'Introduction to the Anatomy and Physiology of Children : a Guide for Students of Nursing, Child Care and Health','','2nd','0-203-92931-4',8,'2008','1 online resource (270 pages)','','RJ125 .M13','en',NULL,132,'','Thoroughly updated throughout, this new edition provides an introduction to normal, healthy physical development for all professionals who specialise in working with children. The author, an experienced nurse teacher, guides the reader through the key changes in body systems and functions from embryo to birth through childhood and adolescence.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 20:21:26','2019-10-11 10:52:19',NULL,NULL);
INSERT INTO `biblio` VALUES (522,32,'Atkinson & Hilgard\'s introduction to psychology / Edward E. Smith [and others].','','15th','978-1-84480-728-4',0,'2009','1 online resource (62 pages)','Introduction to psychology','BF121 .At1','en',NULL,90,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 20:25:31','2019-05-27 11:40:03',NULL,NULL);
INSERT INTO `biblio` VALUES (523,32,'Introduction to nursing research : developing research awareness / by Andree le May and Susan Holmes.','','','978-1-4441-6491-6',243,'2012','1 online resource (168 pages','','RT81.5 M45','en',NULL,143,'','In an engaging and accessible introduction for student nurses, Introduction to Nursing Research: Developing Research Awareness explains the hows and whys of nursing research, stressing its influence on policy and improving patient care. The book delivers a comprehensive guide to the research process and addresses questions such as: What is research? What is its importance to nursing, nurses, patients, and policy makers? Why is it such an exciting discipline?\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 20:28:25','2019-10-11 10:32:35',NULL,NULL);
INSERT INTO `biblio` VALUES (524,32,'Introduction to community-based nursing / Roberta Hunt.','','4th','978-0-7817-7247-1',20,'2009','1 online resource (xvii, 524 pages)  : illustratio','','RT98 .H92','en',NULL,11,'','Presents foundational concepts pivotal to delivering nursing care in the community setting, with specific attention to the NLN competencies for community-based nursing care.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 20:30:53','2019-10-11 09:56:46',NULL,NULL);
INSERT INTO `biblio` VALUES (525,32,'Fundamentals of anatomy and physiology for nursing and healthcare students','','Second edition.','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 20:32:21','2019-10-10 16:28:39',NULL,NULL);
INSERT INTO `biblio` VALUES (526,32,'Fundamental of research methodology and statistics / Yogesh Kumar Singh.','','','978-81-224-2418-8',198,'2006','1 online resource (323 pages)','','LB1028.25.I4 Si6','en',NULL,19,'','The book approaches research from a perspective different from that taken in other educational research textbooks. The goal is to show educators that the application of research principles can make them more effective in their job of promoting learning. The basic point is that we do not have to stop teaching to do research; research is something we can do while teaching and if we do good research, we will do better teaching. This book includes most of the topics treated in traditional educational research books, but in a different order and with a different emphasis. The important content cons.\r\nIncludes bibliographical references (pages 311-314).',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-15 20:34:25','2019-10-09 10:04:33',NULL,NULL);
INSERT INTO `biblio` VALUES (535,1,'Basic concepts of community health nursing / I. Clement.','','2nd','9788184485455',52,'2009','x, 623 p. : ill. ; 24 cm','','RT98 .C59','en',NULL,19,'','Introduction to community health nursing -- Health and illness -- Historogenesis of health services in India -- Health for all and primary health care -- Environmental health -- Community health aspects of nutrition -- Epidemiology in community health nursing -- Health education -- Personnal and mental health maintenance -- Community health nursing process -- Records and reports in community health nursing -- Family health care -- Reproductive health and child health services -- Family welfare services -- Health planning in India -- International health agencies -- Voluntary health agencies in India -- Staff management and development in community health nursing -- School health services -- Occupational health services -- Community mental health services -- Nursing and disaster -- Communicable and non-communicable diseases -- Community health nursing procedure -- Community standing orders -- Growth and development -- Theories of growth and development -- Health and vital statistics -- Nursing research -- Previous question papers (RGUHS) -- Multiple choice questions.\r\nIncludes bibliographic reference and index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-20 09:12:16','2017-11-20 09:13:33',NULL,NULL);
INSERT INTO `biblio` VALUES (530,32,'Allergy frontiers','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-19 01:24:21','2017-11-19 01:24:27',NULL,NULL);
INSERT INTO `biblio` VALUES (531,32,'Allergy and asthma : practical diagnosis and management','','','',0,'','','','','en',NULL,0,'','Contents	Introduction to the Immune System / Massoud Mahmoudi -- The History and Physical Examination of the Allergic Patient / Mary Alice Murphy -- Prevalence of Allergic Diseases in Children, Adults, and the Elderly / Massoud Mahmoudi -- Allergic Diseases of the Eye / Eric Kavosh and Leonard Bielory -- Prevalence of Pollens in the United States and Elsewhere / Jennifer Yoo and Massoud Mahmoudi -- Allergic Rhinitis: Diagnosis and Treatment / Dennis K. Ledford -- The Effect of Rhinitis on Sleep, Quality of Life, Daytime Somnolence, and Fatigue / Carah Santos and Timothy J. Craig -- Sinusitis / Kevin C. Welch and Andrew N. Goldberg -- Allergic Diseases of the Ear / Doris Lin and Steven W. Cheung -- Cough and Allergic Diseases / Eric M. Chen -- Urticaria and Angioedema / Bettina Wedi and Alexander Kapp -- Atopic Dermatitis / Satoshi Yoshida -- Allergic Contact Dermatitis / Bettina Wedi -- Pediatric Asthma / Sixto F. Guiang -- Adult Asthma / Eric C. Chenworth and Daniel E. Maddox -- Exercise-Induced Asthma / Laura H. Fisher and Timothy J. Craig -- Occupational Asthma / Jonathan A. Bernstein -- Asthma and Pregnancy / Peg Strub -- Pseudoasthma : When Cough, Wheezing, and Dyspnea Are Not Asthma / Miles Weinberger and Mutasim Abu-Hasan -- Hypersensitivity Pneumonitis / Joshua Gibbs and Timothy J. Craig -- Allergic Bronchopulmonary Aspergillosis / Satoshi Yoshida -- Serum Sickness and Immune Complex Disease / Michael R. Nelson -- Complement Systems and Allergy Diseases / Marianne Frieri -- Food Allergy / Oscar L. Frick -- Insect Allergy / Donald F. German -- Latex Allergy / Donald F. German -- Drug Allergy / Schuman Tam -- Smoke, Pollution, and Allergies / Haig Tcheurekdjian and Massoud Mahmoudi -- Sick Building Syndrome / Massoud Mahmoudi -- Allergy in the Elderly / Marianne Frieri -- Diagnostic Testing in Allergic Diseases / Paul Cheng -- Primary Immunodeficiencies / Pedro C. Avila -- HIV Infection / Mitchell H. Katz and Andrew R. Zolopa -- Complementary and Alternative Medicine in the Treatment of Allergic and Asthmatic Disease / Jennifer Heimall and Leonard Bielory -- Nutrition, Diet, and Allergic Diseases / Avraham Giannini -- Prevention and Control Measures in the Management of Allergic Diseases / Shuba Rajashri Iyengar and Massoud Mahmoudi -- Antihistamines and Mast Cell Stabilizers / Giselle S. Mosnaim and Timothy J. Craig -- Bronchodilators / Jennifer S. Kim and Rachel E. Story -- Glucocorticoids / Joseph D. Spahn -- Anti-Immunoglobulin E Therapy / Kari C. Nadeau -- Allergy Immunotherapy / Jeffrey R. Stokes and Thomas B. Casale -- Anaphylaxis and Its Management / Sharon E. Leonard and Lawrence Schwartz.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-19 01:30:27','2017-11-19 01:30:35',NULL,NULL);
INSERT INTO `biblio` VALUES (536,1,'Introduction to psychology : gateways to mind and behavior / Dennis Coon.','','9th','9780534576721',157,'2001','1 volume (various pagings) : illustrations (chiefl','','BF121 .C78','en',NULL,90,'','Includes bibliographical references and indexes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-20 09:21:59','2017-11-20 09:23:14',NULL,NULL);
INSERT INTO `biblio` VALUES (537,1,'Psychology : frontiers and applications / Michael W. Passer [and others].','','1st','9780070891883',158,'2003','1 volume (various pagings) : illustrations (chiefl','','BF121 .P26','en',NULL,62,'','Includes bibliographical references and indexes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-20 09:36:53','2017-11-20 09:38:29',NULL,NULL);
INSERT INTO `biblio` VALUES (538,1,'Human anatomy & physiology / Elaine Marieb.','','4th','9780805341966',159,'1998','XXIII-1192 p. : ill. ; 28 cm','','QP31.2 .M33','en',NULL,91,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-20 10:53:08','2017-11-20 11:11:41',NULL,NULL);
INSERT INTO `biblio` VALUES (539,1,'Clinical examination of the patient / John S.P. Lumley, Pierr-Marc G. Bouloux ; photography by Carole Reeves.','','','9780750616713',112,'1994','307 pages : color illustrations ; 21 cm','','RC76 .L97','en',NULL,47,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-20 11:20:21','2017-11-20 11:22:02',NULL,NULL);
INSERT INTO `biblio` VALUES (540,1,'Minimizing medical mistakes : the art of medical decision making / Richard K. Riegelman.','','1st','9780316745239',151,'1991','xii, 228 pages ; 22 cm','','R729.8 .R44','en',NULL,47,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-20 11:38:10','2017-11-20 11:41:06',NULL,NULL);
INSERT INTO `biblio` VALUES (541,1,'Browse\'s introduction to the symptoms and signs of surgical disease / Norman L. Browse [and others].','','4th','9780340815809',19,'1998','vi, 486 pages : color illustrations ; 25 cm','','RD35 .B82','en',NULL,7,'','History taking and clinical examination -- The symptoms, signs and emergency management of major injuries -- The skin and subcutaneous tissues -- Muscles, tendons, bones and joints -- Conditions peculiar to the hands -- Conditions peculiar to the feet -- The arteries, veins and lymphatics -- General and facial appearance -- The salivary glands -- The mouth -- The neck -- The breast -- The external genitalia -- The abdominal wall, herniae and the umbilicus -- The abdomen -- The kidneys, urinary tract and prostate -- The rectum and anal canal. \r\n 	Abstract	Structured and clearly explained guidance to support the learning of the patient examination. Fully revised new edition with entirely rewritten chapters on the breast, museles and bones. Includes 150 new clinical photographs, and over 150 color line drawings to aid understanding.\r\nRevised edition of: An Introduction to the symptoms and signs of surgical disease / Norman L. Browse. 3rd ed. 1997.\r\nIncludes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-20 13:08:28','2017-11-20 13:09:38',NULL,NULL);
INSERT INTO `biblio` VALUES (542,1,'Application of nursing process and nursing diagnosis : an interactive text for diagnostic reasoning / Marilynn E. Doenges, Mary Frances Moorhouse, Joseph Burley.','','2nd','9780803626768',160,'1995','xxi, 311 pages ; 26 cm','','RT41 .D67','en',NULL,11,'','The nursing process: delivering quality care -- The assessment step: developing the patient data base -- Problem identification step: analyzing the data -- The planning step: creating the plan of care -- The implementation step: putting the plan of care into action -- The evaluation step: determining whether desired outcomes have been met -- Documenting the nursing process -- Interactive care planning: from assessment to patient response. \r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-22 11:17:25','2017-11-22 11:18:33',NULL,NULL);
INSERT INTO `biblio` VALUES (543,1,'Common medical problems in the tropics / Christopher R. Schull.','','','9780333419731',27,'1987','xii, 436 pages : illustrations','','RC961 .Sch1','en',NULL,7,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-22 11:31:49','2017-11-22 11:35:10',NULL,NULL);
INSERT INTO `biblio` VALUES (544,1,'Classic cases in medical ethics : accounts of the cases that have shaped medical ethics, with philosophical, legal, and historical backgrounds / Gregory E. Pence.','','','9780070380929',161,'1990','xxi, 397 pages ; 24 cm','','R724 .P37','en',NULL,92,'','Karen Quinlan -- Elizabeth Bouvia and voluntary death -- Mercy killing in Holland -- Baby Louise Brown\'s in vitro fertilization -- The Baby M case -- Abortion and the trial of Kenneth Edelin -- The Baby Jane Doe case -- The Philadelphia head-injury studies on primates -- The Tuskegee syphilis study -- Christiaan Barnard\'s first heart transplant -- Barney Clark\'s artificial heart -- Baby Fae -- Mayor Koch, Joyce Brown, and involuntary psychiatric commitment -- Preventing undesirable teenage pregnancies -- Nancy Wexler and genetic markers -- Mandatory testing for AIDS. \r\nIncludes bibliographical references (pages 348-373).',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-22 12:09:16','2017-11-22 12:17:26',NULL,NULL);
INSERT INTO `biblio` VALUES (545,1,'Changing nursing practice / edited by Stephen G. Wright.','','2nd','9780340631812',19,'1998','viii, 191 pages : illustrations','','RT42 .C36','en',NULL,7,'','List of contributors -- Preface -- Acknowledgements -- Editor\'s note -- Introduction -- Ch. 1. Change strategies: the classic models -- Ch. 2. Theory into practice: some examples of the application of change strategies -- Ch. 3. The nurse as a change agent -- Ch. 4. The change obstacle course: additional perspectives on the change process -- Ch. 5. Nursing Development Units -- Ch. 6. Studies in change -- a. Struggling for change -- b. Changing practice: changing myself -- c. Macmillan respite at home scheme -- my role in change -- Ch. 7. Costs and conflicts -- Ch. 8. Evaluation -- Ch. 9. Conclusion: nurses and the power of change -- Index.\r\nIncludes bibliographical references and index.\r\n',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-29 09:21:06','2017-11-29 09:33:11',NULL,NULL);
INSERT INTO `biblio` VALUES (546,1,'Human genetics in nursing / Suresh K. Sharma.','','2nd','9788184488128',31,'2010','357 p. : il. ; 24 cm','','RB155 .Sh1','en',NULL,19,'','Includes inde',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-29 09:46:30','2017-11-29 09:48:41',NULL,NULL);
INSERT INTO `biblio` VALUES (547,1,'Community nursing : dimensions and dilemmas / edited by Paul Cain, Val Hyde and Elizabeth Howkins.','','','9780340597996',12,'1995','ix, 213 pages : illustrations ; 24 cm','','RT98 .C73','en',NULL,7,'','Client relations ; Working with carers ; Interprofessional collaboration ; Ethical constraints ; Changes in management ; Community health profiles and political imperatives.\r\n  	Abstract 	As the revolution in community care continues, community nurses are taking on a whole new range of roles and responsibilities. This book explores the changes that are taking place, and how these affect everyday nursing practice. The issues covered include client relations, working with carers, interprofessional collaboration, ethical constraints, changes in management, and community health profiles. There is also a focus on the political imperatives in community nursing, and the impact of recent reports, including The Future of Professional Practice produced by the UKCC in 1994. This is a key text for all community nursing students (both undergraduate and postgraduate), P2000 diploma students, nurse educators, and practitioners alike.\r\nIncludes bibliographical references and index.','cover_community_nursing_dimensions_and_dilemmas_edited_by_paul_cain_val_hyde_and_elizabeth_howkins_.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2017-11-29 10:20:12','2022-02-17 07:42:59',NULL,NULL);
INSERT INTO `biblio` VALUES (548,1,'Public health in action : practicing in the real world / Jan K. Carney.','','','9780763734473',114,'2006','ix, 277 pages ; 23 cm','','RA427 .C21','en',NULL,77,'','How do you know if you have succeeded? -- Act swiftly to protect the public\'s health -- Know how your house is built -- You must earn credibility -- Fighting HIV and AIDS: finding community leaders in public health / Peter D. Galbraith -- How do you know if a population is healthy? -- Be a guest in their home -- How do you keep the balls in the air? -- Strike while the iron is hot -- Respect the unwritten rules -- Always stay on the high road -- Have a code of ethics -- You must be ready for anything -- Don\'t end up in the recycling bin: communicating health information -- The press is not your enemy or your friend -- When you think you have seen it all, look again -- If the public doesn\'t understand it, it won\'t happen -- Listen to the children -- Anthrax and airplanes -- The stinky tubing saga -- Is there a doctor in the county? -- Regulating nursing homes: community health, individual health and public resources in an uneasy balance / Patricia A. Nolan.\r\nClorox and cooling towers -- Breaking down barriers to health: insuring the children -- Knowledge is power: preventing breast cancer deaths -- The great tobacco wars: part 1, changing our culture around tobacco use -- The great tobacco wars: part 2, how we nearly lost our footing -- Rabies: preventing public fatigue about a fatal illness -- Birdbaths and bug spray: West Nile virus -- Investigating cancer clusters: stepping out from behind the podium -- Timing is everything: tattooing and body piercing -- Calling in extra help: diarrhea on a dairy farm -- Restoring public confidence: strengthening the board of medical practice -- Let the data speak for itself -- The devil team -- The ten minute rule / Margaret A. Moran -- When people are angry with you or your department, invite them in -- Preventing childhood lead poisoning: using a public health approach.\r\nSometimes the toughest battles are on the inside: assessing and managing environmental risks -- House calls in public health -- Remember the \"public\" in public health: distributing KI -- Mercury: you can still protect the public when there are things you can\'t control -- Data has no constituency, or does it? -- Be there -- Controversy is an opportunity to focus your message -- Find new ways to involve the public -- Don\'t just preach to the choir -- Walking the extra mile for children\'s health: door-to-door lead screening -- Pertussis: if you look, you will find it -- A vision for health planning -- Outcomes are the bottom line for public health -- We must always be prepared -- Make partnerships how you do business: preventive health care for children and adolescents -- It will take all of us to keep the public healthy -- PR (public relations) is not the same as PH (public health) -- Consider every day an adventure -- Skate where the puck will be -- Two words: public health.\r\nSometimes the toughest battles are on the inside: assessing and managing environmental risks -- House calls in public health -- Remember the public in public health: distributing KI -- Mercury: you can still protect the public when there are things you can\'t control -- Data has no constituency, or does it? -- Be there -- Controversy is an opportunity to focus your message -- Find new ways to involve the public -- Don\'t just preach to the choir -- Walking the extra mile for children\'s health: door-to-door lead screening -- Pertussis: if you look, you will find it -- A vision for health planning -- Outcomes are the bottom line for public health -- We must always be prepared -- Make partnerships how you do business -- It will take all of us to keep the public healthy -- PR (public relations) is not the same as PH (public health) -- Consider every day an adventure -- Skate where the puck will be -- Two words: public health. \r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-29 10:55:53','2017-11-29 10:57:30',NULL,NULL);
INSERT INTO `biblio` VALUES (549,1,'Principles of surgical care in the tropics / Ladé Wosornu.','','','0272796727',162,'1982','xi, 236 pages : illustrations ; 23 cm','','RD27.3.T76 W89','en',NULL,93,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-29 11:12:33','2017-11-29 11:13:54',NULL,NULL);
INSERT INTO `biblio` VALUES (550,1,'Community nursing in developing countries: a manual for the community nurse / Monica Byrne, F.J. Bennett.','','2nd','0194424154',163,'1986','251 pages : illustrations; 25cm','','RT98 .C99','en',NULL,51,'','Includes bibliographical references','cover_community_nursing_in_developing_countries_a_manual_for_the_community_nurse_monica_byrne_f_j_bennett_.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2017-11-30 16:34:38','2022-02-17 07:46:02',NULL,NULL);
INSERT INTO `biblio` VALUES (551,1,'Illustrated handbook of minor surgery and operative technique / Vija K. Sodera, Michael Saleh ; foreword by D.K. Evans ; illustrations Vija K. Sodera.','','','9780433308881',164,'1988','185 pages : illustrations ; 28 cm','','RD32 .S1','en',NULL,7,'','Includes bibliographical references (pages 171-180) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-11-30 16:52:03','2017-11-30 16:53:35',NULL,NULL);
INSERT INTO `biblio` VALUES (552,1,'Physiology of behavior / Neil R. Carlson.','','6th','0205273408',165,'1998','xvii, 701 pages : illustrations (some color) ; 29','','QP360 .C19','en',NULL,47,'','Introduction -- Structure and functions of cells of the nervous system -- Structure of the nervous system -- Psychopharmacology -- Methods and strategies of research -- Vision -- Audition, the body senses, and the chemical senses -- Control of movement -- Sleep and biological rhythms -- Reproductive behavior -- Emotion -- Ingestive behavior : drinking -- Ingestive behavior : eating -- Learning and memory : basic mechanisms -- Relational learning and amnesia -- Human communication -- Schizophrenia and the affective disorders -- Anxiety disorders, autistic disorder, and stress disorders -- Drug abuse. \r\nIncludes bibliographical references (pages 615-674) and indexes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-04 08:40:25','2017-12-04 08:42:45',NULL,NULL);
INSERT INTO `biblio` VALUES (553,1,'Application of nursing process and nursing diagnosis : (a textbook for nurses) / A.M. Rajinikanth ; [foreword Solomon Mathuram].','','1st','9788184487626',31,'2009','[x], 226 pages ; 24 cm','Application of nursing process & nursing diagnosis','RT41 .R13','en',NULL,19,'','Section 1: Nursing process and components: Introduction -- Nursing assessment -- Nursing diagnosis -- Nursing plan and action -- Nursing care evaluation -- Section 2: Nursing process in practice: Medical and surgical nursing process -- Child health nursing process -- Community health nursing process -- Maternity nursing process -- Mental health nursing process -- Geriatric nursing process -- Section 3: Nurse\'s role and nursing -- Nurse\'s role in nursing process. \r\nIncludes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-04 08:49:58','2018-06-13 08:13:26',NULL,NULL);
INSERT INTO `biblio` VALUES (554,1,'Understanding the nursing process : concept mapping and care planning for students / Lynda Juall Carpenito-Moyet.','','','9780781759694',63,'2007','xiv, 639 pages : color illustrations ; 23 cm','','RT48 .C22','en',NULL,11,'','sect. 1. Nursing process and concept mapping. The nursing process and concept mapping -- Nursing process : focus on assessment -- Nursing process : focus on diagnosis -- Nursing process : focus on planning care -- Nursing process : focus on planning care -- Nursing process : focus on evaluation -- Putting it all together in 11 steps -- sect. 2. Nursing diagnoses -- sect. 3. Collaborative problems. \r\nIncludes bibliographical references (pages 615-623) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-04 09:26:12','2017-12-04 09:29:08',NULL,NULL);
INSERT INTO `biblio` VALUES (555,1,'Contraceptive technology : International edition / Robert A. Hatcher [and others].','','','0940549018',166,'1989','xviii, 460 pages : illustrations ; 22 cm','','RG136 .C76','en',NULL,94,'','\"Special section on AIDS.\"\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-04 09:58:52','2017-12-14 12:22:35',NULL,NULL);
INSERT INTO `biblio` VALUES (556,1,'Sociology : an introduction / J. Ross Eshleman, Barbara G. Cashion.','','','',151,'1983','xxii, 596 pages : illustrations (some color) ; 24','','HM51 .Es3','en',NULL,47,'','Includes bibliographical references (pages 575-582).',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-04 10:36:07','2017-12-04 10:39:32',NULL,NULL);
INSERT INTO `biblio` VALUES (557,1,'Social psychology for nurses : understanding interaction in health care / Charles Abraham and Eamon Shanley.','','','9780713145779',167,'1992','xv, 270 pages : illustrations','','RT86.5 .Ab8','en',NULL,7,'','Includes bibliographical references (pages 241-266) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-04 11:48:14','2017-12-04 12:02:01',NULL,NULL);
INSERT INTO `biblio` VALUES (558,1,'Sociology : the core / Michael Hughes, Carolyn J. Kroehler.','','7th','9780072880557',125,'2005','xxxii, 478 pages : illustrations (some color) ; 23','','HM585 .H86','en',NULL,47,'','Developing a sociological consciousness -- Culture and social structure -- Socialization -- Social groups and formal organizations -- Deviance and crime -- Social stratification -- Inequalities of race and ethnicity -- Gender inequality -- Political and economic power -- The family -- Religion, education, and medicine -- Population and environment -- Social change \r\nIncludes bibliographical references (pages R1-R44) and indexes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-04 12:14:24','2017-12-04 12:19:03',NULL,NULL);
INSERT INTO `biblio` VALUES (559,1,'Sociology / Richard T. Schaefer, Robert P. Lamm.','','6th','9780070577718',125,'1998','xxvi, 708 pages : illustrations (some color), colo','','HM51 .Sch1','en',NULL,0,'','Includes bibliographical references (pages 639-688) and indexes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-04 12:56:36','2017-12-04 12:58:29',NULL,NULL);
INSERT INTO `biblio` VALUES (560,1,'General surgery / [edited by] Traves D. Crabtree ; associate editors, Eugene F. Foley, Robert G. Sawyer.','','','9780683306361',152,'2000','xviii, 564 pages : illustrations ; 26 cm.','','RD37.2 .G28','en',NULL,11,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-04 13:16:41','2017-12-04 13:18:17',NULL,NULL);
INSERT INTO `biblio` VALUES (561,1,'Cardiology : an illustrated text/reference / editors, Kanu Chatterjee [and others] ; foreword by Richard Gorlin.','','','039744611X',63,'1991','2 volumes : illustrations (some color) ; 32 cm','','RC667. C18','en',NULL,11,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-04 13:32:14','2017-12-04 13:33:41',NULL,NULL);
INSERT INTO `biblio` VALUES (562,32,'Dictionary of nursing theory and research','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 13:38:59','2017-12-07 02:53:41',NULL,NULL);
INSERT INTO `biblio` VALUES (563,32,'ECG Notes Interpretation and Management Guide','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 13:43:17','2017-12-07 02:54:51',NULL,NULL);
INSERT INTO `biblio` VALUES (564,32,'Anatomy & physiology for dummies / by Maggie Norris and Donna Rae Siegfried.','','2nd edition.','978-0-470-92326-9',228,'2011','1 online resource (xvi, 344 pages, 16 unnumbered p','For dummies','QP34.5 .N79','en',NULL,1,'','This detailed guide helps you understand the meaning of terms in anatomy and physiology, get to know the body\'s anatomical structures, and gain insight into how the structures and systems function.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 13:46:14','2019-05-27 10:56:37',NULL,NULL);
INSERT INTO `biblio` VALUES (565,32,'Encyclopedia of nursing research','','3rd ed.','',0,'','','','','en',NULL,0,'','A comprehensive resource for tracking developments in the nursing field. With over 20 new areas of research, and updates of existing entries, this encyclopedia presents key terms and concepts and their application to practice. Entries provide the most relevant and current research perspectives. New topics include NIH-funded research areas, a survey of major nursing research journals, addictions care, palliative care, translational science, simulation, trauma care, family-centered care, mild cognitive impairment, active surveillance for cancer care, workplace and empowerment research, nurse engagement, nurse-physician collaboration, CAM and empowerment research, spirituality, synthesis and action research, mixed-methods research, systematic review, ethnopharmacology, and more.--From publisher description.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 13:48:12','2017-12-07 02:57:16',NULL,NULL);
INSERT INTO `biblio` VALUES (566,32,'Anatomy at a glance','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 13:53:40','2017-12-07 02:58:39',NULL,NULL);
INSERT INTO `biblio` VALUES (567,32,'Essential midwifery practice. Leadership, expertise and collaborative working / edited by Soo Downe, Sheena Byrom, and Louise Simpson.','','','978-1-4051-8431-1',89,'2011','1 online resource (xiv, 233 pages)','Essential midwifery practice','RG950 .Es7','en',NULL,138,'','Midwifery leadership : theory, practice and potential / Sheena Byrom and Lesley Kay -- Transformational leadership and midwifery : a nested narrative review / Sheena Byrom, Anna Byrom, and Soo Downe -- What do leaders do to influence maternity services? : midwifery leadership as applied to case studies / Sheena Byrom [and others] -- Leadership for effective change in mother and infant health : lessons learned from a programme of work on breastfeeding / Mary Renfrew -- The notion of expertise / Soo Downe & Louise Simpson -- Expertise in intrapartum midwifery practice / Louise Simpson & Soo Downe -- Enhancing expertise and skills through education / Denis Walsh -- What is a skilled birth attendant? : insights from South America / Anne Davenport -- Collaboration : theories, models, and maternity care / Soo Downe and Kenny Finlayson -- Case studies of collaboration in the UK and China / Ngai Fen Cheung and Anita Fleming -- Using collaborative theories to reduce caesarean section rates and improve maternal and infant wellbeing / Alison Brodrick [and others] -- Bringing it all together / Soo Downe, Louise Simpson, Sheena Byrom.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 13:54:23','2019-07-04 10:30:51',NULL,NULL);
INSERT INTO `biblio` VALUES (568,32,'Anesthetic and obstetric management of high-risk pregnancy','','3rd ed.','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 13:55:15','2017-12-07 03:04:16',NULL,NULL);
INSERT INTO `biblio` VALUES (569,32,'Atlas of the newborn','','Vol. 2','1550090321',230,'1997','1 online resource (xi, 188 pages) : illustrations','Neonatal and perinatal medicine.','RJ254 .R83','en',NULL,128,'','Includes indexes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 13:57:58','2019-05-27 12:11:50',NULL,NULL);
INSERT INTO `biblio` VALUES (570,32,'Atlas of the newborn. Vol. 5, Thorax, abdomen, blood, endocrine and metabolic disorders / Arnold J. Rudolph (deceased).','','Vol. 5','1-55009-035-6',230,'1997','1 online resource (xi, 228 pages) : illustrations','Neonatal and perinatal medicine ; v. 5.','RJ254 .R83','en',NULL,128,'','Includes indexes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 14:05:54','2019-05-27 12:41:37',NULL,NULL);
INSERT INTO `biblio` VALUES (571,32,'Basic Epidemiology.','','','9241544465',21,'','1 online resource (viii, 182 p.) : ill','','RA651 .B36','en',NULL,12,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 14:08:17','2019-05-28 16:41:18',NULL,NULL);
INSERT INTO `biblio` VALUES (572,32,'Basic statistics and epidemiology','','','1 85775 589 8',8,'2002','1 online resource (149 pages)','','RA652.2 St4','en',NULL,129,'','Most healthcare professionals need to be able to read and understand clinical evidence, and make a judgement on what treatments are effective. To do this, they need a basic grounding in statistics and epidemiology. These are areas which many people find hard to understand, fear or find distinctly uncomfortable. However, readers of this book will find it stimulates their interest and helps them understand the basics quickly and simply. It provides every doctor, nurse, health manager, researcher and student with a concise, practical guide.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 14:11:14','2019-05-28 16:22:47',NULL,NULL);
INSERT INTO `biblio` VALUES (573,32,'Essential midwifery practice : postnatal care / edited by Sheena Byrom, Grace Edwards, Debra Bick.','','','978-1-4051-7091-8',89,'2010','1 online resource, ( (xix, 260 p.)) : illustration','','RG801 .Es7','en',NULL,137,'','The history of postnatal care, national and international perspectives -- Contemporary postnatal care in the 21st century -- Women\'s and midwives views of early postnatal care -- Transition into parenthood : ideology and reality -- Empowering mothers : strengthening the future -- Morbidity during the postnatal period : impact on women and society -- Baby friendly hospitals : what can they achieve? -- Engaging vulnerable women and families : postnatal care -- Working with partners : forming the future -- Nurture and nature : the healthy newborn -- Sexual health, postnatal care, and parenthood.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 14:11:28','2019-07-04 10:12:13',NULL,NULL);
INSERT INTO `biblio` VALUES (574,32,'Bates\' nursing guide to physical examination and history taking / Beth Hogan-Quigley, Mary Louise Palm, Lynn S. Bickley.','','','0781780691',20,'2012','1 electronic document (1 volume (various pagings :','Nursing guide to physical examination and history taking','RC76 .H67','en',NULL,11,'','Introduction to health assessment -- Critical thinking in health assessment -- Interviewing and communication -- The health history -- Cultural and spiritual assessment -- Physical examination -- Beginning the physical examination : general survey, vital signs, and pain -- Nutrition -- The integumentary system -- The head and neck -- The eyes -- Ears, nose, mouth, and throat -- The respiratory system -- The cardiovascular system -- The peripheral vascular system and lymphatic system -- The gastrointestinal and renal systems -- The breasts and axillae -- The musculoskeletal system -- Mental status -- The nervous system -- Reproductive systems -- Putting it all together -- Assessing children : infancy through adolescence -- Assessing older adults.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 14:54:48','2019-06-07 14:41:11',NULL,NULL);
INSERT INTO `biblio` VALUES (575,32,'Best practices in midwifery : using the evidence to implement change','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 14:57:19','2017-12-07 03:52:47',NULL,NULL);
INSERT INTO `biblio` VALUES (576,32,'Birth by design : pregnancy, maternity care, and midwifery in North America and Europe','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 14:58:44','2017-12-07 03:53:51',NULL,NULL);
INSERT INTO `biblio` VALUES (577,32,'Black\'s medical dictionary','','41st ed./ edited by Harvey Marcovitch.','9781408104194',231,'2005','1 online resource (viii, 814 pages, 16 pages of pl','Medical dictionary','R121 .B56','en',NULL,7,'','Publisher description: For home, reference and all who need clear explanation of medical terms.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 15:01:18','2019-06-10 09:14:00',NULL,NULL);
INSERT INTO `biblio` VALUES (578,32,'Clinical Allergy : Diagnosis and Management / by Gerald W. Volcheck','','','978-1-59745-315-8',210,'2009','1 online resource (502 pages).','Current Clinical Practice','RC583.V88','en',NULL,133,'','Offers a clinical overview for the common disorders encountered in the specialty of Allergy. This book features introductory chapters focusing on the human immune response, environmental allergens, and the different types of allergy testing. It also includes chapters on the common allergic conditions seen in the office or clinic.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 15:07:01','2019-06-11 11:18:04',NULL,NULL);
INSERT INTO `biblio` VALUES (579,32,'Communication and interpersonal skills for nurses / Shirley Bach and Alec Grant.','','','184445438X',234,'2009','1 online resource (192 pages).','Communication & interpersonal skills for nurses','RT23 .B13','en',NULL,7,'','An essential resource for nursing students on communication and interpersonal skills, reflecting the NMC Proficiencies, NOS and Skills for Health Competencies and QAA descriptors.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 15:10:53','2019-06-11 14:35:36',NULL,NULL);
INSERT INTO `biblio` VALUES (580,32,'Congenital and perinatal infections : a concise guide to diagnosis / edited by Cecelia Hutto.','','','1-58829-297-5',211,'2006','1 online resource (xiv, 314 pages) : illustrations','Infectious disease','RG629.I53 D54','en',NULL,134,'','In this title, a distinguished panel of pediatric and infectious disease specialists present in an easily accessible format all the information needed to diagnose a wide variety of infections in both the pregnant woman and the neonate. Organized by specific infection or related infections, the book provides pertinent information about the epidemiology of each infection in the pregnant woman and her neonate, as well as the risk of transmission to the fetus or neonate, the spectrum of clinical disease, and a recommended approach to the diagnosis of the infection in both the mother and neonate.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 15:13:41','2019-06-13 11:45:36',NULL,NULL);
INSERT INTO `biblio` VALUES (581,32,'Essential communication skills for nursing and midwifery / Philippa Sully, Joan Dallas.','','2nd ed.','978 0 7234 3527 3',0,'2010','1 online resource (ix, 239 pages) : illustrations','Essential skills for nurses series.','RT23 .Su5','en',NULL,8,'','Reflecting on practice -- Ensuring respect and dignity -- Empathy and comfort skills -- Interview and assessment skills -- Assertiveness, advocacy, and negotiation skills -- Communicating where barriers exist -- Managing difficult situations -- Working in groups and teams -- Teaching skills.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 15:57:46','2019-07-03 13:04:33',NULL,NULL);
INSERT INTO `biblio` VALUES (582,32,'Anatomy at a glance','','','0-632-05934-6',90,'2002','1 online resource (177 pages)','At a glance series','QM31 .F17','en',NULL,16,'','','Anatomy_at_glance.png.png',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2017-12-05 16:01:31','2019-07-15 15:11:12',NULL,NULL);
INSERT INTO `biblio` VALUES (583,32,'Essential epidemiology : an introduction for students and health professionals','','2nd ed.','978-0-521-17731-3',207,'2011','1 online resource (XIV, 445 p.)','','RA651 .W38','en',NULL,8,'','\"The new edition of this popular textbook remains a clear and practical introduction to epidemiology for students in all areas of health. By emphasising the role of epidemiology across a broad range of health monitoring and research, it gives students an understanding of the fundamental principles common to all areas of epidemiology. It also integrates the study of infectious and chronic diseases as well as public health and clinical epidemiology. Avoiding complex mathematics, it steps through the methods and potential problems underlying health data and reports, while maintaining a balance of rigour and clarity. The nuts-and-bolts of epidemiology are embedded in the wider international health perspective through recent and classical examples across different areas of health to engage students from a range of backgrounds. Concepts are illustrated with charts and graphs, and end-of-chapter questions test understanding (with answers provided). Online resources include further exercises, slides for teaching and useful weblinks\"--Provided by publisher.\r\n\r\n	1. Epidemiology is ... -- 2. How long is a piece of string? Measuring disease frequency -- 3. Who, what, where and when? Descriptive epidemiology -- 4. Healthy research: study designs for public health -- 5. Why? Linking exposure and disease -- 6. Heads or tails?: The role of chance -- 7. All that glitters is not gold: the problem of error -- 8. Muddied waters: the challenge of confounding -- 9. Reading between the lines: reading and writing epidemiological papers -- 10. Who sank the boat? Association and causation -- 11. Assembling the building blocks: reviews and their uses -- 12. Outbreaks, epidemics and clusters -- 13. Watching not waiting: surveillance and epidemiological intelligence -- 14. Prevention: better than cure? -- 15. Early detection: what benefits at what cost? -- 16. A final word ... -- Answers to questions -- Appendix 1. Direct standardisation -- Appendix 2. Standard populations -- Appendix 3. Calculating cumulative incidence and lifetime risk from routine data -- Appendix 4. Indirect standardisation -- Appendix 5. Calculating life expectancy from a life table -- Appendix 6. The Mantel-Haenszel method for calculating pooled odds ratios -- Appendix 7. Formulae for calculating confidence intervals for common epidemiological measures -- Index\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 16:06:26','2019-07-03 13:27:45',NULL,NULL);
INSERT INTO `biblio` VALUES (584,32,'Essential midwifery practice : public health / edited by Grace Edwards, Sheena Byrom','','','978-1-4051-4441-4',90,'2007','1 online resource (xx, 233 p.) illustrations','','RG950 .E7','en',NULL,136,'','The midwifery public health agenda : setting the scene / Debbie Garrod, Sheena Byrom -- Health and inequality : what can midwives do? / Eileen Stringer -- Smoking in pregnancy : a growing public health problem / Grace Edwards, David King -- Teenage pregnancy : everyone\'s business / Vanessa Hollings, Claire Jackson, Clare McCann -- Sexual health : a potential time bomb / Julie Kelly, Grace Edwards -- Substance abuse : what is the problem? / Lyn McIver -- Domestic abuse in pregnancy : a public health issue / Sally Price -- Maternal mental health : working in partnership / Samuel Dearman, Kathryn Gutteridge, Whaquas Waheed -- Supporting breastfeeding : midwives facilitating a community model / Sue Henry, Fiona Dykes, Sheena Byrom, Michelle Atkin, Elaine Jackson -- Normal birth and birth centre care : a public health catalyst for maternal and societal well-being / Soo Downe, Denis Walsh.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 16:09:01','2019-07-03 12:04:46',NULL,NULL);
INSERT INTO `biblio` VALUES (585,32,'Essential psychology for nurses and other health professionals / Graham Russell','','','0-203-02744-2',94,'1999','1 online resource (xiv, 230 p.) illustrations','','R726.7 .R91','en',NULL,95,'','pt. 1. Understanding Ourselves and Others. 1. Self-awareness and reflective practice. 2. The self-system. 3. The development of the self in childhood -- Focus on clinical practice: children\'s reactions to separation. 4. Evaluating and protecting the self -- pt. 2. Reactions to Change, Challenging Events and Loss. 5. Stress, appraisal and coping. 6. Anxiety in clinical practice. 7. Anger and aggression in clinical practice. 8. Depression in clinical practice -- Focus on clinical practice: the myth of ageing and inevitable decline. 9. Dying, bereavement and loss -- pt. 3. Promoting and Maintaining Health. 10. Health protective behaviour -- Focus on clinical practice: quality of life. 11. Compliance and non-compliance with medical advice -- pt. 4. Psycho-Physiology: The Relationship between Mind and Body. 12. Psycho-physiological reactions to acute and chronic stress -- Focus on clinical practice: stress and self-awareness -- 13. Personality type and disease -- 14. Psychological perspectives on pain -- pt. 5. Applying Psychological Knowledge in Clinical Practice. 15. Building and applying a psychological framework in clinical practice.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 16:13:09','2019-07-03 12:17:50',NULL,NULL);
INSERT INTO `biblio` VALUES (586,32,'Essentials of clinical genetics in nursing practice','','','',0,'','','','','en',NULL,0,'','The basics -- Genomics in health care -- Basic and molecular concepts in biology -- Human diversity and variation : we are not all genetically identical -- Types of genetic disorders : influences on chromosome and gene action and inheritance modes -- Prevention, genetic testing, and treatment of genetic disease -- The integration of genetics into nursing courses and curricula -- The application of genomics to pharmacology -- Assessing patients with a genetic \"eye\" : histories, pedigrees, and physical assessment -- Maternal-child nursing : obstetrics -- Maternal-child nursing : pediatrics -- Adult health and illness and medical-surgical nursing -- Psychiatric and mental health nursing -- Community and public health nursing and genomics -- Trends, social policies, and ethical issues in genomics.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 16:15:14','2017-12-07 04:56:42',NULL,NULL);
INSERT INTO `biblio` VALUES (587,32,'Essentials of medical genetics for health professionals','','','',0,'','','','','en',NULL,0,'','Diagnostic techniques in medical genetics -- Development and teratogenesis -- Neurodegenerative diseases -- Hereditary breast and ovarian cancer syndrome -- Colorectal cancer -- Chronic myelogenous leukemia -- Hemophilia -- Sickle cell disease -- Hemochromatosis -- Cystic fibrosis -- Familial thoracic aortic aneurysms and dissections -- Familial hypercholesterolemia -- Hereditary cardiomyopathies -- Marfan syndrome -- Polycystic kidney disease -- Neurofibromatosis -- Familial malignant melanoma -- Pharmacogenomics -- Gene therapy -- Ethical, legal, and social issues.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 16:17:44','2017-12-07 04:57:35',NULL,NULL);
INSERT INTO `biblio` VALUES (588,32,'Essentials of nursing leadership & management / Patricia Kelly','','2nd ed.','978-14354-53562',197,'2010','1 online resource (xxx, 457 pages) : illustrations','Essentials of nursing leadership and management','RT89 .K29','en',NULL,113,'','Nursing leadership, management, and motivation -- Health care environment -- Nursing today -- Decision making, critical thinking, and technology -- Leadership and management of the interdisciplinary team -- Health care communication -- Change, innovation, and conflict -- Power and politics -- Leadership and management of patient centered care -- Delegation of patient care -- Effective staffing -- Budgeting for patient care -- Planning care -- Time management and setting patient care priorities -- Quality improvement of patient outcomes -- Quality improvement and evidence-based patient care -- Legal aspects of health care -- Ethical aspects of health care -- Culture, generational differences, and spirituality -- Leadership and management of self and the future -- NCLEX-RN preparation and your first job -- Career planning and achieving balance.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 16:21:49','2019-07-04 12:19:39',NULL,NULL);
INSERT INTO `biblio` VALUES (589,32,'Essentials of anatomy and physiology','','5th ed.','',0,'','','','','en',NULL,0,'','Organization and general plan of the body -- Some basic chemistry -- Cells -- Tissues and membranes -- The integumentary system -- The skeletal system -- The muscular system -- The nervous system -- The senses -- The endocrine system -- Blood -- The heart -- The vascular system -- The lymphatic system and immunity -- The respiratory system -- The digestive system -- Body temperature and metabolism -- The urinary system -- Fluid-electrolyte and acid-base balance -- The reproductive systems -- Human development and genetics -- An introduction to microbiology and human disease.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 16:28:19','2017-12-07 05:05:15',NULL,NULL);
INSERT INTO `biblio` VALUES (590,32,'Essentials of anatomy and physiology','','Seventh edition.','',0,'','','','','en',NULL,0,'','\"Leading the way for nearly 25 years with unsurpassed clarity, content, and completeness.Make anatomy and physiology fun and easy to study. Through six editions, this best-selling text has led the way with exactly what you need to build a firm foundation in this must-know subject. A student-friendly writing style, superb art program, a wealth of learning opportunities in every chapter, and online activities instill confidence every step of the way. It\'s the perfect introduction to the world of anatomy.The 7th Edition delivers even more of what nursing and allied health students in a variety of disciplines need to meet the challenges of health care today. And, it\'s ready-made for multiple learning styles\" -- Provided by publisher.\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\nOrganization and general plan of the body -- Some basic chemistry -- Cells -- Tissues and membranes -- The integumentary system -- The skeletal system -- The muscular system -- The nervous system -- The senses -- The endocrine system -- Blood -- The heart -- The vascular system -- The lymphatic system and immunity -- The respiratory system -- The digestive system -- Body temperature and metabolism -- The urinary system -- Fluid-electrolyte and acid-base balance -- The reproductive systems -- Human development and genetics -- An introduction to microbiology and human disease.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 16:33:37','2017-12-07 05:08:52',NULL,NULL);
INSERT INTO `biblio` VALUES (591,32,'Essentials of psychiatric mental health nursing : concepts of care in evidence-based practice','','4th ed.','',0,'','','','','en',NULL,0,'','Mental health and mental illness -- Concepts of personality development -- Biological implications -- Ethical and legal issues -- Cultural and spiritual concepts relevant to psychiatric/mental health nursing -- Relationship development and therapeutic communication -- The nursing process in psychiatric/mental health nursing -- Milieu therapy : the therapeutic community -- Intervention in groups -- Intervening in crises -- Psychopharmacology -- Complementary and psychosocial therapies -- Delirium, dementia, and amnestic disorders -- Substance-related disorders -- Schizophrenia and other psychotic disorders -- Mood disorders -- Anxiety disorders -- Anxiety-related disorders -- Disorders of human sexuality -- Eating disorders -- Personality disorders -- Children and adolescents -- Victims of abuse or neglect -- The aging individual -- Community mental health nursing -- The bereaved individual -- Appendix A : DSM-IV-TR classification : Axes I and II categories and codes -- Appendix B : NANDA nursing diagnoses : taxonomy II domains, classes, and diagnoses -- Appendix C : assigning nursing diagnoses to client behaviors -- Appendix D : mental status assessment.\r\n\r\n\r\n\r\n	Mental health and mental illness -- Concepts of personality development -- Biological implications -- Ethical and legal issues -- Cultural and spiritual concepts relevant to psychiatric/mental health nursing -- Relationship development and therapeutic communication -- The nursing process in psychiatric/mental health nursing -- Milieu therapy : the therapeutic community -- Intervention in groups -- Intervening in crises -- Psychopharmacology -- Complementary and psychosocial therapies -- Delirium, dementia, and amnestic disorders -- Substance-related disorders -- Schizophrenia and other psychotic disorders -- Mood disorders -- Anxiety disorders -- Anxiety-related disorders -- Disorders of human sexuality -- Eating disorders -- Personality disorders -- Children and adolescents -- Victims of abuse or neglect -- The aging individual -- Community mental health nursing -- The bereaved individual -- Appendix A : DSM-IV-TR classification : Axes I and II categories and codes -- Appendix B : NANDA nursing diagnoses : taxonomy II domains, classes, and diagnoses -- Appendix C : assigning nursing diagnoses to client behaviors -- Appendix D : mental status assessment. \r\nCD-ROM contains: Electronic test bank -- Student workbook -- Links to online resources: Animated drug pathways for the neurobiological brain images ; Care plans ; Concept map care plan template ; Sample client teaching guide ; Interactive learning activities ; Meet the author.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 16:37:19','2017-12-07 05:10:58',NULL,NULL);
INSERT INTO `biblio` VALUES (592,32,'Ethics in paediatric nursing / edited by Gosia M. Brykczyńska.','','','978-1-4899-3268-6',202,'1989','1 online resource (xiv, 157 pages)','','RJ245 .E3','en',NULL,7,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 16:41:03','2019-07-04 14:15:08',NULL,NULL);
INSERT INTO `biblio` VALUES (593,32,'Contemporary medical surgical nursing / Rick Daniels, Leslie H. Nicoll.','','2nd ed.','978-1-439-05860-2',200,'2012','1 online resource; illustrations','','RT41 .D22','en',NULL,113,'','Includes bibliographical references and indexes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 16:43:31','2019-06-13 11:53:32',NULL,NULL);
INSERT INTO `biblio` VALUES (594,32,'Evidence based midwifery : applications in context','','','',0,'','','','','en',NULL,0,'','This title offers international perspectives on evidence-based midwifery practice. It focuses on the use of evidence to enhance midwifery practice.\r\n\r\nThe nature and use of evidence in midwifery care -- Development of EB midwifery in the Netherlands -- Vaginal birth after caesarean -- Midwives and maternity services in Greece -- Reflections on running an evidence course -- EBP and problem based learning -- Supervision of midwifery and EBP -- \'Is there enough evidence to meet the expectations of a changing midwifery agenda?\' -- Guidelines and the consultant midwife : the challenges of the interdisciplinary guideline group -- Unpicking the rhetoric of midwifery practice -- The potential of service user groups to support EBM -- Evidence based midwifery : current ststus and future priorities.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 16:47:01','2017-12-07 05:16:40',NULL,NULL);
INSERT INTO `biblio` VALUES (595,32,'Evidence-based leadership success strategies for nurse administrators, Advance Practice Nurses (APN), and Doctors of Nursing Practice (DNP)','','','',0,'','','','','en',NULL,0,'','List of nursing theories by chapter and situation -- Non-nursing theories used by chapter and situation -- Assisting toward goal-attainment / Cheryl Goddard, Darlene Sredl, Yakima Young-Shields -- Clinical specialties / Darlene Sredl, Cheryl Goddard, Deann Wilson, Lawrence (Lance) Gutierrez -- Retaining good employees / Beth Vesper, Joan Ruppert, Marge Phillips -- Communication facilitators / Marge Phillips, Ann K. Shelton, Paul Pfennig, Traci Wagoner and Darlene Sredl, Jenn Sredl, Peter Tehua Kao, Lanette Tanaka, Steve Sredl -- Becoming an architect for moral good within your sphere of influence / Anonymous, Angela Christian Pellerito, Fred Brown and Darlene Sredl -- Quality of care / Theresa Martin and Darlene Sredl, Dortha Wieland, Paul Pfennig, Rachel Mundy, Niang-Huei Peng, Frederick Brown and Darlene Sredl, Jean Krampe -- Changing corporate culture / Claudia Horton, Lewis Griffith, Darlene Sredl, Lynn Lenker, Lanette Tanaka, Iris Schneider -- Harassment / Frederick Brown, Darlene Sredl -- Cultural considerations / Barbara Bogomolov, Marge Phillips, Kuei-HsiangHsueh, Esther Christian, Joyce Parrone -- Contemporary issues / Frederick Brown, Leah Nguyen, Rita Csapso-Sweet -- Gather inspiration / Beth Vesper, A letter from Eileen Phillips, C. Betz -- Reframing a difficult situation / Claudia Horton, Lee Williams, Betty Sawyer, Teresa M. Bovia.\r\n\r\n',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 16:49:50','2017-12-07 05:09:54',NULL,NULL);
INSERT INTO `biblio` VALUES (596,32,'Examination of the newborn : a practical guide / Helen Baston and Heather Durward.','','','0-203-97716-5',94,'2001','1 online resource (xiv, 207 pages) : illustrations','','RJ255.5 .B29','en',NULL,95,'','1. In the beginning : Becoming a mother ; Premature and mature motherhood ; Infertility ; Questions that new parents may ask -- 2. Fetal development: influential factors : Fetal development -- 3. Assessment of fetal wellbeing : Antenatal care -- 4. Risks to the fetus during childbirth : Prolonged pregnancy ; Prolonged and premature rupture of the membranes ; Anomalies of the fetal heart rate in labour ; Meconium-stained liquor ; Pharmacological pain relief ; Water birth ; Presentation of the fetus in labour ; Mode of delivery ; Resuscitation at birth ; Injuries and abnormalities noticed at birth -- Neonatal examination : Step 1: preparation ; Step 2: observation ; Step 3: examination ; Step 4: explanation to the parent(s) ; Step 5: documentation -- 6. Abnormal findings and congenital abnormalities : Abnormal findings ; Specific abnormalities ; Specific syndromes -- 7. Accountability and effective care : Acknowledging professional responsibilities and boundaries ; Accountability ; Achieving and maintaining best practice -- Appendix 1 : Useful addresses -- Appendix 2 : Safe sleeping environment for babies: advice for parents.\r\nIncludes bibliographical references (pages 190-198) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 16:52:41','2019-07-15 14:14:29',NULL,NULL);
INSERT INTO `biblio` VALUES (597,32,'Contemporary psychiatric-mental health nursing / Carol Ren Kneisl, Eileen Trigoboff.','','3rd ed.','978-0-13-255777-1',6,'2013','1 online resource xxxiii, 806 pages : illustration','','RC440 .K73','en',NULL,47,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 16:56:28','2019-07-01 12:06:02',NULL,NULL);
INSERT INTO `biblio` VALUES (598,32,'Core Anatomy - Illustrated.','','','9781444113723',214,'2007','1 online resource (109 pages)','','QM23.2.P23','en',NULL,7,'','\"The authors are to be congratulated on covering such a wide range of essential material in a concise manner while still providing an engaging and readable text.\" Clive Lee, Royal College of Surgeons in Ireland.\r\n',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 16:59:03','2019-07-02 10:53:37',NULL,NULL);
INSERT INTO `biblio` VALUES (599,32,'Counselling for maternal and newborn health care : a handbook for building skills.','','','9789240684874',21,'2009','1 online resource (232 pages)','','RG940 .C83','en',NULL,12,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 17:06:36','2019-07-02 10:07:57',NULL,NULL);
INSERT INTO `biblio` VALUES (600,32,'General microbiology','','5th ed.','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 17:11:49','2017-12-07 07:23:20',NULL,NULL);
INSERT INTO `biblio` VALUES (601,32,'Davis\'s comprehensive laboratory and diagnostic test handbook : with nursing implications','','Complimentary version.','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-05 17:15:04','2017-12-07 07:27:17',NULL,NULL);
INSERT INTO `biblio` VALUES (603,32,'Managing newborn problems : a guide for doctors, nurses, and midwives.','','','9241546220',22,'2003','1 online resource (338 pages) : illustrations','','RJ254 .M31','en',NULL,12,'','Every year an estimated three million newborn babies die during the first week of life due to problems such as sepsis tetanus or asphyxia or problems associated with trauma low birth weight or preterm birth. This guide is written for the doctors nurses senior midwives and other health care workers at the first referral level in low resource settings who are responsible for thecare of newborn babies with problems during the first week(s) of life. The guide based on the latest available evidence provides up-to-date authoritative clinical guidelines that are relevant to a facility with basic lab.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 08:28:59','2019-10-15 17:58:43',NULL,NULL);
INSERT INTO `biblio` VALUES (604,32,'Marks\' basic medical biochemistry : a clinical approach','','','0781721458',63,'2005','1 online resource (xliii, 977 pages) : color illus','Basic medical biochemistry','QP514.2 .Sm5','en',NULL,7,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 08:31:36','2019-01-24 12:10:09',NULL,NULL);
INSERT INTO `biblio` VALUES (605,32,'Heading home with your newborn : from birth to reality','','','',0,'','','','','en',NULL,0,'','Includes chapters on breastfeeding, baby formulas, bottles and nipples, peeing and pooping, sleep, crying, diapering, bathing, clothing and accessories, car safety, air travel, choosing a pediatrician, health, fevers, jaundice, photography.\r\n\r\n	Breastfeeding -- Formulas -- Bottles and nipples -- Peeing and pooping -- Burping -- Hiccups -- Spitting up and vomiting -- Sleep -- Crying (colic?) -- Diapering and diapers -- Bathing -- Clothing and accessories -- Taking care of yourself --Car safety -- Flying -- Finding the right doctor -- Care and keeping of the cord -- Body parts -- Treating a fever -- Jaundice -- Birth memories --Capturing moments along the way.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 09:54:49','2017-12-07 07:39:27',NULL,NULL);
INSERT INTO `biblio` VALUES (606,32,'Health promotion in midwifery : principles and practice','','2nd ed','0 340 888 806',214,'2006','1 online resource (229 pages)','','RG950 .H34','en',NULL,121,'','\"This book provides a comprehensive review of the basic principles of general health promotion and also explores issues within the wider public health role of the midwife ... The chapters are all laid out in a similar format which leads the reader into and through each topic in a logical progression ... This text, like the previous edition, will be an invaluable resource for midwives and students alike. It is also appropriate for other health professionals; particularly those working with women, public health nurses and sexual health workers.\" The Journal of Advanced Nursing.\r\n',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 09:59:41','2019-05-06 10:57:31',NULL,NULL);
INSERT INTO `biblio` VALUES (607,32,'Human anatomy and physiology : based on Schaum\'s outline of theory and problems of human anatomy and physiology','','','978-0-07-181080-7',226,'','1 online resource (ix, 414 pages) : illustrations.','At head of title:Schaum\'s outlines\r\nSchaum\'s outline of human anatomy and physiology','QP41 .V26','en',NULL,95,'','ch. 1. Introduction to the human body -- ch. 2. Cellular chemistry -- ch. 3. Cell structure and function -- ch. 4. Tissues -- ch. 5. Integumentary system -- ch. 6. Skeletal system -- ch. 7. Muscle tissue and mode of contraction -- ch. 8. Muscular system -- ch. 9. Nervous tissue -- ch. 10. Central nervous system -- ch. 11. Peripheral and autonomic nervous system -- ch. 12. Sensory organs -- ch. 13. Endocrine system -- ch. 14. Cardiovascular system : blood -- ch. 15. Cardiovascular system : the heart -- ch. 16. Cardiovascular system : vessels and blood circulation -- ch. 17. Lymphatic system and body immunity -- ch. 18. Respiratory system -- ch. 19. Digestive system -- ch. 20. Metabolism, and temperature regulation -- ch. 21. Urinary system -- ch. 22. Water and electrolyte balance -- ch. 23. Reproductive system.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 10:55:06','2019-04-11 19:43:09',NULL,NULL);
INSERT INTO `biblio` VALUES (608,32,'Human anatomy and physiology','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 11:33:27','2017-12-07 07:52:10',NULL,NULL);
INSERT INTO `biblio` VALUES (609,32,'Mayo Clinic guide to a healthy pregnancy','','','9781561487172',0,'','1 online resource (611 pages)','Guide to a healthy pregnancy','RG525 .M45','en',NULL,127,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 11:34:00','2019-04-04 17:47:52',NULL,NULL);
INSERT INTO `biblio` VALUES (610,32,'Human microbiology','','','0-203-16440-7',8,'2002','1 online resource (529 pages)','','QR46 .H22','en',NULL,69,'','Demystifying the increasing reportage of human infections, this book examines the biology of microorganisms and considers the key features of those that cause illness as well as those that do not. Useful for anyone studying biological science.\r\n\r\n	Book Cover; Title; Contents; Series editor\'s preface; Introduction; INTRODUCTION TO MICRO-ORGANISMS; Bacterial structure and function; Bacterial growth; Viruses; Fungi; Microbial death; Microbial taxonomy; MICROBIAL INFECTIONS OF HUMANS; Types of association; Bacteria as parasites; Viruses as parasites; Fungi as parasites; Control of microbial infections; Index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 11:42:34','2019-04-04 17:18:19',NULL,NULL);
INSERT INTO `biblio` VALUES (611,32,'BMA illustrated medical dictionary','','','9781405331210',108,'2002','1 online resource (608 pages) : color illustration','BMA illustrated medical dictionary Illustrated medical dictionary','R121 .B77','en',NULL,7,'','','BMA_illustrated_medical_dictionary.jpg.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2017-12-06 11:44:02','2019-07-15 15:48:11',NULL,NULL);
INSERT INTO `biblio` VALUES (612,32,'International handbook of psychiatry : a concise guide for medical students, residents, and medical practitioners / editors, Laura Weiss Roberts, Joseph B. Layde, Richard Balon ; [in-house editor, Veronica Low].','','','978-9814405607',241,'2013','1 online resource (xxxii, 924 pages)','','RC454 .In8','en',NULL,142,'','Machine generated contents note: ch. 1 Impact of Mental Illness / Joseph B. Layde -- ch. 2 International Issues in Psychiatry / Cyril Hoschl -- ch. 3 Psychiatric Diagnosis / John Lauriello -- ch. 4 Psychiatric Genetics / David Mrazek -- ch. 5 Psychiatric Interviewing: What to Do, What Not to Do / Mara Pheister -- ch. 6 Psychological and Neuropsychological Testing / Jonathan E. Romain -- ch. 7 Psychiatric Disorders in Childhood and Adolescence / Joerg M. Fegert -- ch. 8 Schizophrenia and Other Psychotic Disorders / Scott Van Sant -- ch. 9 Mood Disorders / J. Michael Bostwick -- ch. 10 Anxiety Disorders / Dan J. Stein -- ch. 11 Substance Use Disorders / Pedro Ruiz -- ch. 12 Cognitive Disorders / Dilip V. Jeste -- ch. 13 Somatoform Disorders / Christina L. Wichman -- ch. 14 The Dissociative Disorders / Jean M. Goodwin -- ch. 15 Sleep Disorders in Psychiatry / Oludamilola A. Salami -- ch. 16 Eating Disorders / W. Stewart Agras -- ch. 17 Sexual Disorders / Richard Balon. \r\nContents note continued: ch. 18 Adjustment Disorder / Matteo Balestrieri -- ch. 19 Personality Disorders / Joel Paris -- ch. 20 Geriatrics / Randall Espinoza -- ch. 21 Emergency Psychiatry / Michelle Riba -- ch. 22 Outpatient Psychiatry / Bryan Touchet -- ch. 23 General Hospital Psychiatry / Mark T. Wright -- ch. 24 Psychiatric Education / Michelle B. Riba -- ch. 25 Residency Training / Sidney Zisook -- ch. 26 Methods of Psychiatric Research / Philip Gorwood -- ch. 27 World Suicide / Morton M. Silverman -- ch. 28 AIDS Psychiatry / Mary Ann Cohen -- ch. 29 Pharmacogenomic Variability Associated with Psychotropic Medication Response / Bhanu Prakash Kolla -- ch. 30 Ethics in Psychiatry / Kristi Estabrook -- ch. 31 The Culturally Competent Psychiatric Assessment / Dinesh Bhugra -- ch. 32 Traditional Healing for Psychiatric Disorders / Wendy Wong -- ch. 33 International Perspective on Homelessness / Daryn Reicherter. \r\nContents note continued: ch. 34 Mental Health Consequences of War and Political Conflict / Rena Sugarbaker -- ch. 35 Stigma / Travis Fisher -- ch. 36 Legal Aspects of Psychiatry / Joseph B. Layde.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 11:45:52','2019-12-16 08:29:55',NULL,NULL);
INSERT INTO `biblio` VALUES (613,32,'Introducing psychology for nurses and healthcare professionals','','','978-0-273-72144-4',224,'2010','1 online resource (xiv, 274 pages) : illustrations','','RT86 .Up8','en',NULL,60,'','Introduction: psychology in nursing care -- Psychological approaches to understanding people -- Psychology across the lifespan -- Social processes -- Perception, memory and providing information -- Stress and stress management -- The psychology of pain.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 11:47:52','2019-04-03 11:41:41',NULL,NULL);
INSERT INTO `biblio` VALUES (614,32,'Medical microbiology for the new curriculum : a case-based approach / Roberta B. Carey, Mindy G. Schuster, Karin L. McGowan','','','978-0-471-47933-8',225,'2008','1 online resource (xix, 289 p.) illustrations (chi','','QR46 .C18','en',NULL,116,'','Case one : boy with acute pharyngitis. Case two : student with dysuria. Case three : boy with vomiting and diarrhea after a school picnic. Case four : chronic diarrhea in a traveler. Case five : boy with skin lesions. Case six : student with a skin lesion following a trip to India. Case seven : man with a surgical wound after a prosthetic hip placement. Case eight : boy with fever and right leg pain following a canoe accident. Case nine : woman with acute abdominal pain and cervical discharge. Case ten : woman with acute fever and productive cough. Case eleven : nursing home resident with fever, cough, and myalgias. Case twelve : baby with fever, rhinitis and bronchiolitis. Case thirteen : woman with fever, cough, and weight loss. Case fourteen : student with chronic fever, dry cough and pneumonia . Case fifteen : bone marrow transplant recipient with nodular pneumonia. Case sixteen : boy with acute fever, headache, and confusion. Case seventeen : woman with lymphocytic meningitis. Case eighteen : neonate with fever and vesicular rash. Case nineteen : renal transplant recipient with chronic meningitis. Case twenty : man with acute fever and periumbilical pain. Case twenty one : man with two weeks of fever and a systolic murmur. Case twenty two : young man with fatigue and an abnormal liver test. Case twenty three : fever of unknown origin in a traveler. Case twenty four : student with fever, lymphadenopathy and hepatosplenomegaly.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 11:49:30','2019-04-03 12:00:06',NULL,NULL);
INSERT INTO `biblio` VALUES (615,32,'Introduction to statistics for nurses / John Maltby, Liz Day, Glenn Williams.','','','9781408212486',6,'2007','1 online resource (xvii, 268 pages) : illustration','','RT81.5 M29','en',NULL,60,'','\"This book will help you to understand the use of statistics in nursing literature, and show you how to use statistics effectively in answering your own research questions. Case studies throughout show how statistics are applied in nursing research and frequent exercises help you test your own knowledge as you progress.\"--Jacket.\r\n\r\n	Ch. 1. introduction to statistics -- Ch. 2. Variables -- Ch. 3. Descriptive statistics : the Florence Nightingale way -- Ch. 4. Effective data cleaning and management -- Ch. 5. Critical appraisal of analysis and reporting of descriptive statistics -- Ch. 6. introduction to inferential statistics -- Ch. 7. Correlational statistics -- Ch. 8. Comparing average scores : statistics for all sorts of groups and occasions -- Ch. 9. Critical appraisal of analysis and reporting of inferential statistics -- Ch. 10. Advanced thinking with probability and significance : where to next?',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 11:50:05','2019-04-03 11:26:07',NULL,NULL);
INSERT INTO `biblio` VALUES (616,32,'Medical-surgical nursing : an integrated approach','','3rd ed.','978-1-4354-8802-1',197,'2013','1 online resource (xliii, 1468 pages) : color illu','','RT41 .M46','en',NULL,113,'','\"Medical-surgical nursing: an integrated approach 3-Eis a comprehensive, reader friendly resource for the practical/vocational nursing student. The 3rd Edition has been completely reinvisioned and thoroughly updated in all aspects of its coverage, with chapters now broken out into smaller, more manageable portions. In addition to rich coverage of all body systems with anatomy & physiology, data collection, disease information, and a strong focus on the nursing process, exciting new chapters on family processes and issues, psychobiological issues, bioterrorism and more have been added. Engaging features including case studies, critical thinking exercises, evidence-based practice boxes, informatics boxes, memory tricks, and more support student learning and retention throughout the text. NCLEX style questions and Theory to Practice activities provide opportunities to test understanding and apply concepts. This is the ideal choice for instructors looking for depth of coverage and student-focused features.\"--Publisher\'s website.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 11:51:41','2019-01-23 14:52:20',NULL,NULL);
INSERT INTO `biblio` VALUES (617,32,'Introductory statistics for health and nursing using SPSS / Louise Marston.','','','978-1-84787-482-5',223,'2010','1 online resource (251 pages) : illustrations','','R853.St2','en',NULL,126,'','\'Introductory Statistics for Health & Nursing using SPSS\' is an impressive introductory statistics text ideal for all health science & nursing students. Health & nursing students can be anxious & lacking in confidence when it comes to handling statistics. This book has been developed with this readership in mind.\r\nIncludes bibliographical references (pages 243-246) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 11:52:06','2019-04-03 10:01:59',NULL,NULL);
INSERT INTO `biblio` VALUES (618,32,'Medical-surgical nursing : assessment and management of clinical problems','','9th ed.','978-0-323-08678-3',221,'2014','','','RT41 .M46','en',NULL,125,'','Over the past three decades, more and more nursing educators have turned to Lewis: Medical-Surgical Nursing for its accurate and up-to-date coverage of the latest trends, hot topics, and clinical developments in the field of medical-surgical nursing - and the new ninth edition is no exception! Written by a dedicated team of expert authors led by Sharon Lewis, Medical-Surgical Nursing, 9th Edition offers the same easy-to-read style that students have come to love, along with the timely and thoroughly accurate content that educators have come to trust. Completely revised and updated content explores patient care in various clinical settings and focuses on key topics such as prioritization, critical thinking, patient safety, and NCLEX exam preparation. Best of all - a complete collection of interactive student resources creates a more engaging learning environment to prepare you for clinical practice.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 11:53:35','2019-04-03 09:42:48',NULL,NULL);
INSERT INTO `biblio` VALUES (619,32,'Medical-surgical nursing : assessment and management of clinical problems','','Ninth edition.','978-0-323-08678-3',221,'2014','1 online resource (xi, 61pages)','','RT41 .M46','en',NULL,125,'','Over the past three decades, more and more nursing educators have turned to Lewis: Medical-Surgical Nursing for its accurate and up-to-date coverage of the latest trends, hot topics, and clinical developments in the field of medical-surgical nursing - and the new ninth edition is no exception! Written by a dedicated team of expert authors led by Sharon Lewis, Medical-Surgical Nursing, 9th Edition offers the same easy-to-read style that students have come to love, along with the timely and thoroughly accurate content that educators have come to trust. Completely revised and updated content explores patient care in various clinical settings and focuses on key topics such as prioritization, critical thinking, patient safety, and NCLEX exam preparation. Best of all - a complete collection of interactive student resources creates a more engaging learning environment to prepare you for clinical practice.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 11:54:19','2019-03-29 12:48:27',NULL,NULL);
INSERT INTO `biblio` VALUES (620,32,'Living with allergies / Paul M. Ehrlich with Elizabeth Shimer Bowers.','','','978-0-8160-7327-6',220,'2009','1 online resource (168 pages).','','RC584 .Eh8','en',NULL,95,'','Includes bibliographical references (pages 158-159) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 11:55:17','2019-03-29 12:06:21',NULL,NULL);
INSERT INTO `biblio` VALUES (621,32,'Medical Biochemistry : Rao, N.Mallikarjuna','','2nd ed.','978-81-224-2300-6',198,'2006','1 online resource (xii, 824 s.) illustrations','','RB112.5 .R18','en',NULL,19,'','The 2nd edition of the book is revised, updated and efforts are made to enhance usefulness of the book for various courses. New subject matter is added to each chapter. Further this freshly updated 2nd edition contains five new chapters. They are: Biochemistry of apoptosis Biochemistry of cell cycle Biochemistry of Blood Organ function tests Biochemical Technology Apart from updating each chapter, new unsolved problems are added and in references books, reviews, research articles are included. Thus, the 2nd edition of the book contains 34 chapters, 536 references, 191 essay-type question.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 11:56:04','2019-01-23 15:11:24',NULL,NULL);
INSERT INTO `biblio` VALUES (679,1,'Bailey & Love\'s short practice of surgery / edited by R.C.G. Russell, N.S. Williams and C.J.K. Bulstrode.','','23rd','9780340759493',19,'2000','x, 1348 pages : illustrations (some color) ; 29 cm','','RD31 .B15','en',NULL,7,'','This edition offers information on trauma, orthopaedic surgery, plastic surgery, neurosurgery and maxillofacial surgery. Chapters have been added to include the role of radiology in surgical practice, surgical ethics among others.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-02-28 08:48:24','2018-02-28 08:49:35',NULL,NULL);
INSERT INTO `biblio` VALUES (680,1,'Brunner & Suddarth\'s textbook of medical-surgical nursing.','','8th','9780397550739',63,'1996','xxxi, 2066, 78 pages : color illustrations ; 28 cm','','RT41 .T32','en',NULL,11,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-03-12 10:56:11','2018-05-23 12:17:39',NULL,NULL);
INSERT INTO `biblio` VALUES (623,32,'Medical Biochemistry_Bhagavan','','4th','0-12-095440-0',199,'2001','1 Online resource (1066 pages)','','QP514.2 .B39','en',NULL,114,'','Thoroughly updated and in a new two-color format, this well- respected text presents the fundamentals of biochemistry and related topics to students pursuing a one- or two-semester course in pre-med biochemistry or medical programs. The second edition is equally applicable to other health-related fields such as clinical chemistry, medical technology or pharmacology. \"Medical Biochemistry, Fourth Edition\" focuses on the foundations and clinically relevant applications of normal human biochemistry and pathology. It is abundantly illustrated with four-color plates. It includes revised chapters on molecular biology that reflect the latest research in the field. The reference quality appendices include practical information on clinical lab parameters used to diagnose a range of diseases.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 11:59:38','2019-01-23 15:32:46',NULL,NULL);
INSERT INTO `biblio` VALUES (624,32,'Medical microbiology','','4th ed.','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 12:08:53','2017-12-07 08:25:11',NULL,NULL);
INSERT INTO `biblio` VALUES (625,32,'Medical-surgical nursing certification examination : review / Scott H. Plantz [and others].','','','0-07-151117-2',222,'2007','1 online resource (ix, 170 pages).','','RT55 .M46','en',NULL,95,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 12:18:58','2019-10-15 18:59:02',NULL,NULL);
INSERT INTO `biblio` VALUES (626,32,'MedSurg notes : nurse\'s clinical pocket guide / Tracey Hopkins, Ehren Myers.','','2nd ed.','0-8036-1868-9',217,'2008','1 online resource (236 pages) : color illustration','Davis\'s notes.','RT51 .H77','en',NULL,11,'','Legal issues in medsurg care -- Focused assessment of the CV system -- Focused respiratory system assessment -- Neurological assessment -- Focused renal/GU systems assessment -- Focused GI assessment -- Focused endocrine assessment -- Focused assessment of musculoskeletal system -- Standard precautions -- Assessment in an emergency -- High-alert medications -- Electrical conduction of the heart. \r\nIncludes bibliographical references (page 227) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 12:22:30','2019-04-03 10:37:40',NULL,NULL);
INSERT INTO `biblio` VALUES (627,32,'Microbiology and immunology','','','0385-56001348-0421',248,'1977-','1 online resource: volumes : illustrations','','QR1 .J25','en',NULL,147,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 12:29:55','2019-10-16 13:16:46',NULL,NULL);
INSERT INTO `biblio` VALUES (681,1,'Watson\'s clinical nursing & related sciences.','','5th','9780702023712',64,'1997','xix, 998 pages : illustrations','Clinical nursing & related sciences','RT65 .W29','en',NULL,11,'','1. The Nature of Nursing -- 2. Mental Health -- 3. Caring for those with a Learning Disability -- 4. Children and Family Care -- 5. Ageing and Health -- 6. Infection and Disease -- 7. Pain Prevention and Relief -- 8. Wound and Skin Care -- 9. Caring for the Patient with Cancer -- 10. Caring for the Patient Undergoing Surgery -- 11. Caring for the Patient with a Cardiovascular Disorder -- 12. Caring for the Patient with a Haematological Disorder -- 13. Caring for the Patient with a Disorder of the Respiratory System -- 14. Caring for the Patient with a Disorder of the Gastrointestinal System -- 15. Caring for the Patient with Disorders of Liver, Biliary Tract and Exocrine Pancreas -- 16. Caring for the Patient with a Nutritional Disorder -- 17. Caring for the Patient with a Disorder of the Endocrine System -- 18. Caring for the Patient with a Disorder of the Renal System -- 19. Caring for the Patient with a Disorder of the Nervous System -- 20. Reproduction and Sexual Health -- 21. Caring for the Patient with Musculoskeletal Trauma -- 22. Caring for the Patient with Bone and Joint Disease -- 23. Caring for the Patient with a Disorder of the Senses -- 24. Caring for the Patient with a Disorder of the Breast. \r\n 	Abstract	Provides practical applications which show the importance of microbiology in today\'s demanding healthcare environment.\r\nRevised edition of: Watson\'s medical-surgical nursing and related physiology. 4th ed. / edited by Joan A. Royle and Mike Walsh. 1992.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-03-12 11:24:38','2018-03-12 11:28:49',NULL,NULL);
INSERT INTO `biblio` VALUES (629,32,'Neonatal pain : suffering, pain, and risks of brain damage in the fetus and newborn / Giuseppe Buonocore, Carlo V. Bellieni, editors ; foreword by Ignacio Carrasco de Paula.','','','978-88-470-0731-4',210,'2008','1 online resource (xv, 169 p. :) ill.','','RJ251 .N35','en',NULL,95,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 12:36:13','2019-03-25 09:06:07',NULL,NULL);
INSERT INTO `biblio` VALUES (630,32,'Notter\'s Essentials of Nursing Research','','6th ed.','0-8261-1599-3',219,'1999','1 online resource (225 pages)','','RT81.5.N84','en',NULL,95,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 12:38:58','2019-03-22 11:46:32',NULL,NULL);
INSERT INTO `biblio` VALUES (631,32,'Nurse\'s Pocket Guide : Diagnosis, Prioritized Interventions and Rationales (10th Edition)','','10th ed.','9780-8036-1480-2',217,'2006','1 online resource (811 pages)','','RT48.6 D67','en',NULL,11,'','Cover ; Nurse\'s Pocket Guide: Diagnoses, Prioritized Interventions, and Rationales, Edition 10 ; Copyright © 2006 by F.A. Davis Company; Contents; How to Use the Nurse\'s Pocket Guide; Chapter 1: The Nursing Process ; Chapter 2: Application of the Nursing Process; Chapter 3: Putting Theory into Practice: Sample Assessment Tools, Plan of Care, Mind Mapping, and Documentation ; SECTION 1: Assessment Tools for Choosing Nursing Diagnoses ; Adult Medical/Surgical Assessment Tool ; Excerpt from Psychiatric Assessment Tool ; Excerpt from Prenatal Assessment Tool. \r\nExcept from Intrapartal Assessment Tool SECTION 2: Diagnostic Divisions: Nursing Diagnoses Organized According to a Nursing Focus ; SECTION 3: Client Situation and Prototype Plan of Care ; Another Approach to Planning Client Care-Mind Mapping ; SECTION 4: Documentation Techniques: SOAP and Focus Charting® ; Chapter 4: Nursing Diagnoses in Alphabetical Order ; Chapter 5: Health Conditions and Client Concerns with Associated Nursing Diagnoses; APPENDIX 1: NANDA\'s Taxonomy II ; APPENDIX 2: Definitions of Taxonomy II Axes ; Bibliography; INDEX.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 14:55:10','2019-03-22 11:33:50',NULL,NULL);
INSERT INTO `biblio` VALUES (632,32,'Nurses! Test yourself in anatomy and physiology / Katherine M.A. Rogers and William N. Scott','','','978-0-33-524163-7',218,'2011','1 online resource (xix, 224 p.) illustrations','','QP34.5 .R63','en',NULL,124,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 14:57:55','2019-03-22 11:07:41',NULL,NULL);
INSERT INTO `biblio` VALUES (633,32,'Essential calculation skills / Katherine M.A. Rogers and William N. Scott','','','978-0-33-524359-4',131,'2011','1 online resource (xvii, 133 p.) illustrations','Nurses! Test yourself in ...','QA11.2 .R63','en',NULL,124,'','This book is in the new Test Yourself! series and is designed as a revision and self test book for student nurses to use to build their calculations and maths skills - a core skill that is required at every stage of the nursing course, from pre-entry acceptance to qualification.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 15:01:09','2019-03-22 10:55:08',NULL,NULL);
INSERT INTO `biblio` VALUES (634,32,'Nurse\'s manual of laboratory and diagnostic tests / Bonita Morrow Cavanaugh','','4th ed.','',217,'2003','1 online resource (689 pages) : illustrations, tab','','RT48.5 .C31','en',NULL,123,'','This updated 4th edition offers detailed overviews of physiology to help students think critically and understand the results of laboratory and diagnostic tests and their implications for therapy.\r\nIncludes bibliographical references at the end of each chapters and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 15:05:53','2019-03-22 10:33:18',NULL,NULL);
INSERT INTO `biblio` VALUES (635,32,'Oxford handbook of midwifery','','2nd ed.','9780199584673',0,'2011','1 online resource (768 pages).','Oxford Handbooks in Nursing','RG950 .Ox2','en',NULL,0,'','Fully revised and updated to include the most up-to-date guidelines, references and resources, this new edition of the bestselling Oxford Handbook of Midwifery provides a concise and logical approach to midwifery practice in all its varied care settings. Giving a complete picture of the role of the midwife, the handbook reflects the mother\'s journey through conception, pregnancy and birth to the final postnatal examination of mother and baby. This new edition includes recent advances in midwifery practice including developments in antenatal care, labour, postnatal care and infant feeding. \r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 15:08:26','2019-04-09 19:26:06',NULL,NULL);
INSERT INTO `biblio` VALUES (636,32,'Paediatric handbook / edited by Kate Thomson, Dean Tey, Michael Marks.','','8th ed.','978-1-4051-7400-8',89,'2009','1 online resource (vi, 659 pages) : illustration','','RJ48 .P13','en',NULL,1,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 15:11:42','2019-03-11 13:00:17',NULL,NULL);
INSERT INTO `biblio` VALUES (637,32,'Paediatric advanced life support : a practical guide for nurses / Philip Jevon.','','2nd ed.','978-14051-9776-2',0,'2012','1 online resource (vi, 256 pages) : illustrations','','RJ370 .J53','en',NULL,0,'','In the event of a paediatric cardiac arrest, it is essential to be able to respond rapidly, providing safe and effective care. The second edition of this successful text provides you with a practical and systematic guide to the rapid assessment and delivery of appropriate resuscitation to infants and children. Conforms to current European Resuscitation Council GuidelinesBased on up-to-date research and evidence-based practice protocolsSynoptic approach enables rapid delivery of effective treatmentWritten by experts in the field of both resuscitation and paediatrics. \"Paediatric Advanced Life Support 2e\" is a succinct yet comprehensive guide and is an essential purchase for any health professional likely to encounter an emergency situation.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 15:15:53','2019-03-08 14:23:10',NULL,NULL);
INSERT INTO `biblio` VALUES (638,32,'Paediatrics : a clinical guide for nurse practitioners','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 15:19:58','2019-02-14 09:28:05',NULL,NULL);
INSERT INTO `biblio` VALUES (639,32,'Pediatric allergy, asthma and immunology / Arnaldo Cantani.','','','',203,'2008','1 online resource; color ill.','Allergologia e immunologia pediatrica.','RJ385 .C16','en',NULL,69,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 15:25:00','2019-02-13 14:36:41',NULL,NULL);
INSERT INTO `biblio` VALUES (640,32,'Perspectives in paediatric oncology nursing  / edited by Faith Gibson, Louise Soanes, and Beth Sepion.','','','1861562934  97818615',216,'2004','1 online resource (xviii, 357 pages) : illustratio','','RJ245 .P43','en',NULL,11,'','\"This is a text for all nurses working with children and young people who have cancer. The book brings together the latest research and practice development from three perspectives: practice, management, and education. At the end of each section there is a commentary by a practitioner, manager or researcher, which aims to offer a helpful critique on the papers in their section guiding the reader to consider other areas of research and practice development.\"\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 15:27:34','2019-06-10 10:00:06',NULL,NULL);
INSERT INTO `biblio` VALUES (641,32,'Melloni\'s pocket illustrated medical dictionary','','','',0,'','','','','en',NULL,0,'','\"This new pocket dictionary is an abbreviated version of an award-winning and highly acclaimed dictionary. It is a convenient, highly portable, rapid reference and yet it still features a surprisingly wide range of beautifully drawn and carefully labeled illustrations to accompany the large number of expert, but concise, medical definitions.\"',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 15:31:21','2019-10-15 19:44:25',NULL,NULL);
INSERT INTO `biblio` VALUES (642,32,'Practical statistics for nursing and health care / Jim Fowler, Phil Jarvis and Mel Chevannes','','','978-0-471-49715-8',128,'2002','1 online resource (xiv, 213 p.) : illustrations, g','','RA409 .F82','en',NULL,50,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 15:34:16','2019-03-08 13:48:36',NULL,NULL);
INSERT INTO `biblio` VALUES (643,32,'Practical handbook of microbiology / edited by Emanuel Goldman, Lorrence H. Green.','','2nd ed.','978-0-8493-9365-5',214,'2009','1 online resource (xx, 853 pages) : illustrations','','QR72.5 .P88','en',NULL,122,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 15:56:37','2019-12-16 09:27:52',NULL,NULL);
INSERT INTO `biblio` VALUES (644,32,'Pregnancy for dummies / by Joanne Stone, Keith Eddleman, and Mary Duenwald.','','3rd Edition','978-0-470-38767-2',205,'2009','1 online resource (xx, 388 pages) : illustrations.','','RG525 .St7','en',NULL,116,'','Now updated--our bestselling guide to a safe and healthy pregnancyWith robust sales and its own four-part cable TV series, Pregnancy For Dummies has been a perennial favorite, giving parents-to-be authoritative, friendly, up-to-date advice on every aspect of pregnancy and childbirth. This new edition offers all of the latest information expecting parents want to know, including expanded coverage on the health and well-being of both mother and child. It takes readers through the first, second, and third trimesters, providing new and updated coverage of prenatal genetic screening and diagnosis.\r\nIncludes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 16:00:48','2019-03-01 11:26:04',NULL,NULL);
INSERT INTO `biblio` VALUES (645,32,'Pregnancy, childbirth, postpartum and newborn care : a guide for essential practice.','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 16:03:34','2017-12-07 13:35:17',NULL,NULL);
INSERT INTO `biblio` VALUES (646,32,'Psychology for Nurses : Theory and Practice / by Anne Byrne, Don Byrne.','','','978-1-349-13113-6',0,'1992','1 online resource (XI, 248 pages) : online resourc','','RT1 .B99','en',NULL,7,'','The practice of nursing is intricately tied to a thorough working knowledge of human behaviour. Psychology for Nurses has identified those areas of psychology most directly pertinent to the daily work of the nurse, and presents the contemporary evidence, both from a scientific and an applied viewpoint, on the role psychology plays in the practice of nursing. In this sense it is not simply an introductory text of psychology but a work on psychology specifically directed to the needs of nurses. It combines theory with practice so nurses may better understand the behaviour of their patients and use psychology both in patient management and in the management of their own, professional lives.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 16:05:18','2019-02-13 14:08:57',NULL,NULL);
INSERT INTO `biblio` VALUES (647,32,'Microbiology : PreTest self-assessment and review / [edited by] Richard C. Tilton.','','10th ed.','0-07-138970-9',131,'2002','1 online resource (vii, 264 pages) : illustrations','','QR46 .M58','en',NULL,8,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 16:06:42','2019-10-16 12:55:14',NULL,NULL);
INSERT INTO `biblio` VALUES (648,1,'Psychology for nurses and health professionals','','Second edition.','978-1-4441-7993-4',215,'2014','1 online resource (xv, 515 pages ) : illustrations','','RT86 .G91','en',NULL,122,'','\"Psychology for Nurses and Allied Health Professionals is a practical and accessible guide providing comprehensive coverage of psychology for nurses and health care professionals in training and practice. Key features include: fully updated and restructured to ensure content matches training requirements for nurses and healthcare practitioners; stronger focus on the biopsychosocial model, therapeutic relationships and self-awareness; more practical examples to highlight application with theories demonstrated through scenarios relevant to all fields of practice; accessible style with case studies, reflection points, key points, summary boxes and glossary; free HodderPlus website with lecturer PowerPoints, extension material, MCQs and exercises. Written by the bestselling psychology author, Richard Gross, and Nancy Kinnison, a highly experienced nurse and lecturer, this is an essential guide to applying theoretical aspects of psychology to the practical aspects of nursing and health care\"--Provided by publisher.\r\nIncludes bibliographical references (pages 457-496) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 16:09:25','2019-03-01 10:46:57',NULL,NULL);
INSERT INTO `biblio` VALUES (649,32,'Psychiatric and mental health nursing : theory and practice / William Reynolds and Desmond Cormack.','','','978-1-4899-3011-8',202,'1990','1 online resource (xi, 473 pages)','','RC440 .R 33','en',NULL,7,'','Psychiatric and Mental Health Nursing: Theory and practice was conceived as a result of three major premises which, in the view of the editors, relate to the practice of psychiatric and mental health nursing. First, that high-quality psychiatric and mental health nursing can be practised only if it is under pinned by appropriate nursing theory. Secondly, that there exists a body of theory which can and should be applied to psychiatric and mental health nursing. Thirdly, that there is a need for a text which will assist teachers, students and clinicians to apply available nursing and borrowed theory to clinical practice. The general aim of this book is to introduce nursing students to a theory based approach to caring for people with psychiatric and mental health problems. The phrase psychiatric and mental health problems indicates that the text relates to clients with a psychiatric diagnosis, and also to those who have mental health problems but who do not necessarily have such a diagnosis. The client group to which the material in this text applies will include those who are, or have been, hospitalized and those in the community who have not been, and may never be, hospitalized. The intended readership is all students of psychiatric and mental health nursing issues, for example basic and post-basic nurses, and their teachers.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 16:10:23','2019-02-12 11:47:38',NULL,NULL);
INSERT INTO `biblio` VALUES (650,32,'Psychiatric and Mental Health Nursing : the Craft of Caring','','2nd ed.','978 0 340 94763 0',214,'2009','1 online resource (780 pages).','','RC440.P99','en',NULL,121,'','Cover; Book title; Contents; List of contributors; Poem: The Cleansing has Begun; The Space I\'m in; Poem: Half dead; Preface to the second edition; Acknowledgements; Section 1 THE NEED FOR NURSING; Preface to Section 1; 1 The nature of nursing; 2 Getting personal: being human in mental health care; 3 The care and confinement of the mentally ill; 4 Evidence-based practice in mental health; 5 The craft of psychiatric-mental health nursing practice; 6 Leading developments in the craft of caring; 7 Recovery: a personal perspective. \r\n8 Recovery and reclamation: a pilgrimage in understanding who and what we areSection 2 ASSESSMENT IN PRACTICE; Preface to Section 2; 9 Assessment: the foundation of practice; 10 Assessment methods; 11 The craft of interviewing; 12 Developing collaborative assessment; 13 The context of family assessment; 14 The assessment of feelings, thoughts and beliefs; Section 3 THE STRUCTURE OF CARE; Preface to Section 3; 15 Psychiatric diagnosis; 16 Psychiatric diagnosis: living the experience; 17 Nursing diagnosis; 18 Collaboration with patients and families; Section 4 SPECIFIC NEEDS FOR NURSING. \r\nPreface to Section 419 The person who experiences anxiety; 20 The person who experiences depression; 21 The person who is suicidal; 22 The person who self-harms; 23 The person who hears disturbing voices; 24 The person who experiences disturbing beliefs; 25 The person with a diagnosis of schizophrenia; 26 The person who appears aggressive or violent; 27 The person with a diagnosis of bipolar disorder; 28 The person with a diagnosis of personality disorder; 29 The person who experiences mental health and substance use problems; 30 The person who appears paranoid or suspicious. \r\n31 The person with experience of sexual abuse32 The person with an eating disorder; 33 The person who is homeless; 34 The person with dementia; 35 The person with a diagnosis of autism; Section 5 SOME MODELS OF THERAPEUTIC PRACTICE; Preface to Section 5; 36 Developing therapeutic one-to-one relationships; 37 Developing empathy; 38 Groupwork with children and adolescents; 39 Psychodynamic approaches with individuals; 40 Psychodynamic approaches to working in groups; 41 Using counselling approaches; 42 Bereavement and grief counselling; 43 Cognitive-behavioural therapy. \r\n44 Using solution-focused approaches45 Mindfulness; 46 Therapeutic communities; Section 6 THE ORGANIZATION OF CARE; Preface to Section 6; 47 The acute care setting; 48 The psychiatric intensive care unit: coercion, control or care; 49 Mental health nursing in community care; 50 Crisis assessment and resolution; 51 Assertive outreach; 52 Family support: growing the family support network; 53 The liaison psychiatric service; 54 Services for people requiring secure forms of care: a global problem; 55 Services for children and young people.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 16:12:32','2019-03-01 10:22:39',NULL,NULL);
INSERT INTO `biblio` VALUES (651,32,'Psychiatric mental health nursing : concepts of care in evidence-based practice','','6th ed.','',87,'2009','Online resource, (xxix, 896 pages) : color illustr','','RC440 .T66','en',NULL,11,'','Accompanying CD-ROM has an electronic test bank of 400 NCLEX-style questions that can be customized by chapter and by NCLEX descriptor and a student workbook with learning activities, more than 50 psychotropic drug monographs, more than 20 sample client education teaching guides, a medication assessment tool for levels of anxiety, a table for assigning nursing diagnoses to client behaviors, and care plans. Includes Adobe Reader software for opening PDF files.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 16:16:22','2019-01-29 15:33:21',NULL,NULL);
INSERT INTO `biblio` VALUES (652,32,'Psychiatric nursing certification review guide for the generalist and advanced practice : psychiatric and mental health nurse','','3rd ed.','978-0-7637-7599-5',114,'2011','1 online resource (ix, 290 pages)','Psychiatric nursing certification review guide : for the generalist and advanced practice psychiatric and mental health nurse','RC440 .P99','en',NULL,120,'','\"The Perfect Study Guide for the ANCC Exam!\"\r\nRevised edition of: Psychiatric certification review guide for the generalist and clinical specialist in adult, child, and adolescent psychiatric and mental health nursing / editor, Clare Houseman . 2nd ed. c1998.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 16:18:08','2019-02-28 17:01:21',NULL,NULL);
INSERT INTO `biblio` VALUES (653,32,'Psychiatry and behavioral science : an introduction and study guide for medical students / editors, David Baron and Ellen H. Sholevar.','','','978-1-59213-531-8',213,'2009','1 online resource (ix, 313 pages)','','RC457 .P99','en',NULL,11,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 16:19:31','2019-02-25 11:40:02',NULL,NULL);
INSERT INTO `biblio` VALUES (654,32,'Psychology for nurses and the caring professions','','3rd ed.','9780335223855',212,'2007','1 online resource (xi, 289 pages) : illustrations','','R726.5 P99','en',NULL,29,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 16:24:14','2019-02-25 11:13:38',NULL,NULL);
INSERT INTO `biblio` VALUES (655,32,'Public health microbiology : methods and protocols / edited by John F.T. Spencer, Alicia L. Ragout de Spencer.','','','1-59259-766-1',211,'2004','1 online resource (570 pages) : illustrations.','Methods in molecular biology','QR67 .P96','en',NULL,119,'','The world abounds with microorganisms that are hazardous to human health in the normal course of life. In Public Health Microbiology: Methods and Protocols, expert investigators describe in step-by-step detail the laboratory techniques they have perfected for determining the nature and character of a diverse group of hazardous bacteria, viruses, and fungi. For bacterial and viral pathogens, the authors give special attention to PCR methods for detecting genes resistant to tetracycline, for resistance in Salmonella enterica, for identifying and typing Campylobacter coli, and for detecting the abundance of enteric, hepatitis A, and rotaviruses in sewage, as well as bacteriophages infecting the O157:H7 strain of Escherichia coli. For fungi the authors offer methods for computerized analysis and typing of fungal isolates, for the isolation and enumeration of fungi in foods, and for the determination of aflatoxin and zearalenone. Other methods deal with hazard analysis, the use of disinfectants, microbiological analysis of cosmetics, microbiological tests for sanitation equipment in factories, and the uses of animals in studies of various characteristics of lactobacilli. Review articles address the spread of pathogens from livestock and poultry production, including the threat of prion-based diseases. All protocols presented follow the successful Methods in Molecular Biology™ series format, each one offering step-by-step laboratory instructions, an introduction outlining the principle behind the technique, lists of equipment and reagents, and tips on troubleshooting and avoiding known pitfalls. Timely and highly practical, Public Health Microbiology: Methods and Protocols offers researchers and public health specialists alike a wide-ranging collection of methods for the determination of many important pathogenic microorganisms, their effects on health, and possible measures that can be taken to counter these effects.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 16:31:58','2019-02-25 10:42:49',NULL,NULL);
INSERT INTO `biblio` VALUES (656,32,'Research methods for nursing and healthcare / John Maltby ... [et al.].','','','978-0-273-71850-5',59,'2010','1 online resource (xiii, 401 pages) : illustration','','RT81.5 .R31','en',NULL,8,'','Take the fear out of research methods and analysis with this comprehensive yet accessible, practical and applied book for nurses and healthcare professionals. Taking an evidence-based approach, Research Methods for Nursing and Healthcare demonstrates the use and relevance of research methods in modern healthcare, and demonstrates how you can become effective and successful.\" --Book Jacket.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 16:34:51','2019-02-25 10:03:43',NULL,NULL);
INSERT INTO `biblio` VALUES (657,32,'Springhouse review for medical-surgical nursing certification','','4th ed.','978-1-58255-507-2',63,'2007','1 online resource (viii, 416 pages) : illustration','Review for medical-surgical nursing certification\r\nMedical-surgical nursing certification\r\n','RT55 .Sp8','en',NULL,11,'','Medical-surgical nursing certification -- Foundations of nursing -- Legal and ethical aspects of nursing -- Principles of medical-surgical nursing -- Principles of wound care -- Disruptions in homeostasis -- Cardiovascular disorders -- Hematological disorders -- Respiratory disorders -- Neurologic disorders -- Muskuloskeletal disorders -- Gastrointestinal disorders -- Skin disorders -- Endocrine disorders -- Renal and urinary tract disorders -- Reproductive system disorders -- Immune system disorders -- Eye, ear, and nose disorders -- Perioperative nursing.\r\nIncludes bibliographical references',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 16:39:00','2019-02-20 09:50:45',NULL,NULL);
INSERT INTO `biblio` VALUES (658,32,'Statistics for advanced practice nurses and health professionals / Manfred Stommel, Katherine J. Dontje.','','','978-0-8261-9824-2',210,'2014','1 online resource (xi, 350 pages):illustrations','','RT68 .St1','en',NULL,95,'','The role of statistics in research and clinical practice -- Properties of variables: levels of measurement -- Descriptive univariate statistics -- Probabilities -- Logic of statistical inference: the sampling distribution and significance tests -- Standard errors, confidence intervals and the power of statistical tests -- Research designs and statistical analysis -- T-test -- One-way analysis of variance -- Linear regression and Pearson\'s r correlation -- Factorial analysis of variance and analysis of covariance -- Multiple linear regression -- Repeated-measures analysis of variance -- Introduction to mixed-effects regression models -- Nonparametric/ordinal statistics -- Frequency cross-tabulations: 2x2 tables -- Logistic regression with one independent variable -- Logistic regression models with multiple predictors -- Incidence rates, life tables and survival function -- Comparing survival functions in different groups and hazard regression -- Reliability coefficients and medical test evaluation -- Factor analysis -- Data management and privacy concerns.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 16:41:41','2019-02-20 09:30:39',NULL,NULL);
INSERT INTO `biblio` VALUES (659,32,'Psychiatric mental health nursing success : a course review applying critical thinking to test taking','','','',209,'2009','','','','en',NULL,11,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 16:42:37','2019-02-20 09:10:15',NULL,NULL);
INSERT INTO `biblio` VALUES (660,32,'Statistics for nursing and allied health / Stacey B. Plichta, Laurel S. Garzon.','','','978-0-7817-5459-0',208,'2009','1 online resource (434 pages)','','RT68 .P71','en',NULL,78,'','Using research and statistics in health care -- Descriptive statistics : getting to know the data -- Building blocks for using inferential statistics -- Inferential statistics : finding relationships in the data -- The independent T-test and the Mann-Whitney U-test: comparing the means of two unrelated groups -- The paired T-test and the Wilcoxon matched-pairs test: comparing the means of two related groups -- The one-way Anova and the Kruskal-Wallis H-test: comparing the means of three or more unrelated groups -- The repeated-measures Anova and the Friedman\'s Anova by rank : comparing the means of three or more related groups -- The Pearson and the Spearman correlation coefficients : measuring the association of two variables -- The chi-square statistic and the McNemar test : examining relationships between categorical variables -- Model building with linear and logistic regression -- Writing for publication.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 16:43:20','2019-02-20 09:29:30',NULL,NULL);
INSERT INTO `biblio` VALUES (661,32,'Study skills for nursing and midwifery students / Philip A. Scullion and David A. Guest','','','0 335 22221 8',51,'2007','1 online resource (viii, 234 p.)','Successful studying','RT73 .Sc4','en',NULL,118,'','\"This book ... covers key skills and knowledge needed, such as: Study strategies; Reflective practice; Critical thinking; Evidence-based research; Exam techniques; Literature searching; How to succeed in assessments. The book also has an accompanying website, www.openup.co.uk/nursingsuccess, that is written specifically for this market, and includes tips on: Writing CVs and covering letters; Finding a good job; Interview skills; Continuing professional development (CPD) for nurses and midwives; Career progression. Study Skills for Nursing and Midwifery Students has been carefully structured to be used throughout a nursing career.\"--Publisher\'s description.\r\n\r\n	The student nurse and midwife as a novice learner -- Beginning to develop effective study skills -- Becoming competent: advanced learning for nursing and midwifery students -- Demonstrating proficiency through assessment -- Expertise for success: the lifelong learner in nursing and midwifery.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 16:45:39','2019-04-11 19:47:17',NULL,NULL);
INSERT INTO `biblio` VALUES (662,32,'Survival analysis for epidemiologic and medical research : a practical guide / Steve Selvin.','','','978-0-511-38852-1',207,'2008','1 online resource (xiii, 297 pages) : illustration','Practical guides to biostatistics and epidemiology','R853.Se4','en',NULL,95,'','For readers with a minimal background in statistics, this text shows how to analyze and interpret epidemiological and medical survival data.\r\n\r\n	Rates and their properties -- Life tables -- Two especially useful estimation tools -- Product-limit estimation -- Exponential survival time probability distribution -- Weibull survival time probability distribution -- Analysis of two-sample survival data -- General hazards model: parametric -- General hazards model: nonparametric.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 16:47:21','2019-02-15 14:43:08',NULL,NULL);
INSERT INTO `biblio` VALUES (663,32,'Microbiology','','','',0,'','','','','en',NULL,0,'','There is a need in small group teaching for a readable module that provides a balanced treatment of the four main areas of medical microbiology-bacteriology, mycology, virology and parasistology. It need not be encyclopedic in scope nor didactic, but it should emphasise principles and concepts. Any existing gaps in this type of presentation are, of course, left for the student to fill. Some subject material has been excluded. An example is a chapter on laboratory procedures including PCR for rapid bacterial and viral diagnosis. The discussion of bacterial sexually transmitted diseases does not cover goncoccal infections. This is not a serious matter because the tutor can assign the topic to the students. Moreover, we have reluctantly omitted a separate chapter on anaerobic bacteria. The subject of nosocomial pathogens is touched upon but not in sufficient detail (e.g., control). These bacteria (e.g., S. aureus, E. coli and pseudomonas) are found in hospitals and are resistant to disinfectants and antibiotics. A new but serious problem is the emergence of resistance to antiviral agents. Without question, molecular biology owes more to the study of viruses than bacteria. The fact remains, however, that effective therapy against most viral diseases is not yet available. Perhaps one of the most dramatic examples of this situation is the fight against the AIDS virus and the search for a vaccine. The public health challenge of AIDS remains formidable in spite of the recent encouraging results obtained with protease inhibitor therapy. At the moment at least six receptors for HIV are known to be present in human cells. One of them is the CCR5 receptor in the absence of which cells fail to get infected with the virus. Drugs that can interrupt CCR5 binding sites on the virus envelope are being vigorously sought. Thus, Volume 9B gives a large place to HIV disease. The last group of chapters highlight several features of microbiology which are also of clinical importance and heuristic value. The chapter on fever of unknown origin provides fertile soil for problem based learning.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 16:49:07','2017-12-07 14:50:22',NULL,NULL);
INSERT INTO `biblio` VALUES (664,32,'Test Success : Test Taking Techniques for Beginning Nursing Students.','','Sixth edition.','9780803677210',0,'2008','1 online resource (348 pages)','','RT55 .N89','en',NULL,11,'','The practice questions in the text and on the BONUS CD-ROM introduce beginning nursing students to a variety of testing formats they will encounter throughout their nursing education and on the NCLEX exam. It contains a complete review of core concepts, and more than 800 questions including alternate format and test-taking hints and rationales for correct and incorrect answers. An easy-to-follow format organizes information into 14 content areas. Its coverage enhances critical thinking, time management, and effective study habits through proven techniques, improving classroom performance and test-taking. Thoroughly updated and revised, the 6th Edition provides more alternate item format questions reflecting the latest NCLEX-RN test plan, more coverage of the latest advances in medical technology, and the most recent guidelines and standards of care for nursing practice, as well as test-taking tips to reduce anxiety and build confidence.\r\n\r\n\r\n	1. Empowerment -- 2. Critical Thinking -- 3. Time Management -- 4. Study Techniques -- 5. The Multiple-Choice Question -- 6. The Nursing Process -- 7. Test-Taking Techniques -- 8. Testing Formats Other Than Multiple-Choice Questions -- 9. Computer Applications in Education and Evaluation -- 10. Analyze Your Test Performance -- 11. Practice Questions With Answers and Rationales -- 12. Comprehensive Final Book Exam -- Index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 16:51:55','2019-02-28 18:15:06',NULL,NULL);
INSERT INTO `biblio` VALUES (665,32,'Textbook of immunology','','2nd ed.','978-93-5090-474-9',52,'2014','1 online resource; color ill.','','QR181 .M72','en',NULL,19,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 16:57:10','2019-01-29 15:16:54',NULL,NULL);
INSERT INTO `biblio` VALUES (666,32,'The desk encyclopedia of microbiology','','1st ed.','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 17:04:43','2017-12-07 14:53:38',NULL,NULL);
INSERT INTO `biblio` VALUES (667,32,'The basics of genetics','','','978-1-4361-6994-3',206,'2009','1 online resource (105 pages)','The modern scholar','QH431 .D98','en',NULL,117,'','\"Professor Betsey Dexter Dyer examines the wide-ranging field of genetics, which is the study of the hereditary information of organisms, how it is used, and how it is transferred through generations. These fascinating lectures also address DNA sequences and how they apply to \'genetic engineering, \' viruses, and genetic diseases such as cancers and birth defects. In addition to examining why people look and act the way they do, the course also considers the philosophical issues associated with such controversial topics as cloning and genetic ID cards\"--Container.\r\n\r\n	The long history of practical genetics -- What did Gregor Mendel do? -- What did Mendel do next? -- A cookie factory in a black box designed by Rube Goldberg -- How mammals get their colors -- The importance of environment : in the short term -- Environment over the long term : the genetics of populations -- DNA (Deoxyribonucleic acid) -- Transcription and translation : the metaphor of an error-prone medieval monk in a scriptorium -- Chromosomes, mitosis, and meiosis : how DNA is packaged for moving -- Mutations -- Regulating the genes and the dramatic consequences of regulatory mutations -- Viruses, jumping genes, and symbionts : whose DNA is it and what are the new philosophical questions? -- Conclusions.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 17:10:19','2019-02-15 13:54:28',NULL,NULL);
INSERT INTO `biblio` VALUES (668,32,'Legal aspects of midwifery','','3rd ed.','0 7506 8817 3',91,'2006','1 online resource (733 pages)','','KD2968 .M58','en',NULL,54,'','Written in clear, accessible language, without legal jargon, the third edition of this text includes a new chapter on the laws relating to teenage pregnancy. It also covers many of the recommendations from NICE relevant to midwifery practice and considers their legal significance.\r\n\r\n	1. The legal system -- 2. Midwifery : professional regulation -- 3. Midwifery supervision -- 4. Professional accountability and the NMC -- 5. The midwives rules and code of practice, the code of professional conduct and the scope of professional practice -- 6. Woman-centred care -- 7. Consent -- 8. The duty to inform -- 9. Letting die and euthanasia -- 10. Confidentiality and access to records -- 11. Complaints -- 12. Teenage pregnancies -- 13. Negligence -- 14. Specific situations in negligence and civil court procedure -- 15. Record keeping, statements and report writing -- 16. Family planning and sterilisation -- 17. The status and rights of the unborn -- 18. Criminal liability -- 19. Health and safety -- 20. Medication -- 21. The structure of the NHS and the provision of hospital, community and primary care services -- 22. Employment law -- 23. The independent midwife and private maternity hospitals -- 24. Midwifery management -- 25. Criminal law and confinements -- 26. Termination of pregnancy -- 27. Legal issues relating to fertilisation, embryology and genetics -- 28. Vaccine damage payments -- 29. Infectious diseases and the midwife -- 30. Midwife teachers, clinical instructors, preceptors and mentors -- 31. Midwifery research -- 32. Child protection -- 33. Mental disorder and mental incapacity -- 34. Complementary therapies -- App. 1. Human Rights Act 1998 : schedule 1 : the articles -- App. 2. Congenital Disabilities (Civil Liability) Act 1976.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 17:15:38','2019-02-15 12:26:51',NULL,NULL);
INSERT INTO `biblio` VALUES (669,32,'Understanding medical-surgical nursing (2nd Edition)','','2nd ed.','0-8036-1037-8',87,'2003','1 online resource; xxviii, 1124 pages : color illu','','RT41 .W69','en',NULL,11,'','Unit One: Understanding health care issues -- Unit Two: Understanding health and illness -- Unit Three: Understanding life span influences on health and illness -- Unit Four: Understanding the cardiovascular system -- Unit Five: Understanding the hematopoietic and lymphatic systems -- Unit Six: Understanding the respiratory system -- Unit Seven: Understanding the gastrointestinal system -- Unit Eight: Understanding the liver, gallbladder, and pancreas -- Unit Nine: Understanding the renal and urinary system -- Unit Ten: Understanding the endocrine system -- Unit Eleven: Understanding the genitourinary and reproductive system -- Unit Twelve: Understanding the musculoskeletal system -- Unit Thirteen: Understaning the neurological system -- Unit Fourteen: Understanding the sensory system -- Unit Fifteen: Understanding the integumentary system -- Unit Sixteen: Understanding the immune system.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 17:20:06','2019-01-29 14:41:13',NULL,NULL);
INSERT INTO `biblio` VALUES (670,32,'Understanding medical surgical nursing (3rd Edition)','','3rd ed.','978-0-8036-1491-8',201,'2003','1 Online resource; xxxvii, 1353 pages : illustrati','','RT41 .W69','en',NULL,78,'','Critical thinking and the nursing process -- Issues in nursing practice -- Cultural influences on nursing care -- Alternative and complementary therapies -- Nursing care of patients with fluid, electrolyte, and acid-base imbalances -- Nursing care of patients receiving intravenous therapy -- Nursing care of patients with infections -- Nursing care of patients in shock -- Nursing care of patients in pain -- Nursing care of patients with cancer -- Nursing care of patients having surgery -- Nursing care of patients with emergent conditions and disaster/bioterrorism response -- Developmental considerations in the nursing care of adults -- Nursing care of older adult patients -- Nursing care of the patient at home -- Nursing care of patients at the end of life -- Immune system function, assessment, and therapeutic measures -- Nursing care of patients with immune disorders -- Nursing care of patients with HIV disease and AIDS -- Cardiovascular system function, assessment, and therapeutic measures -- Nursing care of patients with hypertension -- Nursing care of patients with inflammatory and infectious cardiovascular disorders -- Nursing care of patients with occlusive cardiovascular disorders -- Nursing care of patients with cardiac valvular disorders -- Nursing care of patients with cardiac dysrhythmias -- Nursing care of patients with heart failure -- Hematopoietic and lymphatic system function, assessment, and therapeutic measures -- Nursing care of patients with hematological and lymphatic disorders. \r\nRespiratory system function, assessment, and therapeutic measures -- Nursing care of patients with upper respiratory tract disorders -- Nursing care of patients with lower respiratory tract disorders -- Gastrointestinal, hepatic, and pancreatic systems function, assessment, and therapeutic measures -- Nursing care of patients with upper gastrointestinal disorders -- Nursing care of patients with lower gastrointestinal disorders -- Nursing care of patients with liver, gallbladder, and pancreatic disorders -- Urinary system function, assessment, and therapeutic measures -- Nursing care of patients with disorders of the urinary system -- Endocrine system function and assessment -- Nursing care of patients with endocrine disorders -- Nursing care of patients with disorders of the endocrine pancreas -- Genitourinary and reproductive system function and assessment -- Nursing care of women with reproductive system disorders -- Nursing care of male patients with genitourinary disorders -- Nursing care of patients with sexually transmitted diseases -- Musculoskeletal function and assessment -- Nursing care of patients with musculoskeletal and connective tissue disorders -- Neurological function, assessment, and therapeutic measures -- Nursing care of patients with central nervous system disorders -- Nursing care of patients with cerebrovascular disorders -- Nursing care of patients with peripheral nervous system disorders -- Sensory system function, assessment, and therapeutic measures: vision and hearing -- Nursing care of patients with sensory disorders: vision and hearing -- Integumentary function, assessment, and therapeutic measures -- Nursing care of patients with skin disorders -- Nursing care of patients with burns -- Mental health function, assessment, and therapeutic measures -- Nursing care of patients with mental health disorders.\r\n	Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 17:41:33','2019-01-29 15:02:37',NULL,NULL);
INSERT INTO `biblio` VALUES (671,32,'Vitamin and mineral requirements in human nutrition','','2nd ed.','92 4 154612 3',21,'2004','1 online resource','Vitamin & Mineral Requirements in Human Nutrition','QP771.V83','en',NULL,0,'','The Joint FAO/WHO group of experts reviewed the full scope of vitamin and minerals requirements, including their role in normal human physiology and metabolism and in deficiency disease conditions. The focus was on the requirements of the essential vitamins and minerals, including vitamins A, C, D, E, and K; the B vitamins; calcium; iron; magnesium; zinc; selenium; and iodine. The report provides recommended nutrient intakes for vitamins A, C, D, E, and K; the B vitamins; calcium; iron; magnesium; zinc; selenium; and iodine. The report also provides practical advice and recommendations which will constitute an authoritative source of information for all those who work in the area of nutrition, agriculture, food production and distribution, and health promotion.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 17:45:51','2019-02-14 12:11:18',NULL,NULL);
INSERT INTO `biblio` VALUES (678,1,'Fundamentals of nursing : caring and clinical judgement / [edited by] Helen Harkreader, Mary Ann Hogan','','2nd','9780721691411',110,'2004','xli, 1346 s. : ill. ; 29 cm','','RT41 .F97','en',NULL,46,'','Includes index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-02-15 17:22:50','2018-02-15 17:27:50',NULL,NULL);
INSERT INTO `biblio` VALUES (673,32,'Webster\'s new world medical dictionary','','3rd ed.','978-0-470-18928-3',205,'2008','1 online resource (470 pages) : illustrations','Medical dictionary','R121 .W38','en',NULL,116,'','\"If you\'re like most Americans, you\'re taking a more active role in your healthcare and that of your family. You want reliable, understandable information about symptoms, diseases, medical procedures, and drug therapies. You want to be able to communicate clearly with your doctor.\" \"This new edition offers more than 8,500 entries, including 500 new terms. Authored by the doctors and experts at WebMD, it\'s accurate and authoritative, yet still understandable. Webster\'s New World Medical Dictionary, Third Edition has everything you need to decipher complicated medical jargon.\"--Jacket.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 17:52:05','2019-02-14 11:37:30',NULL,NULL);
INSERT INTO `biblio` VALUES (674,32,'World of microbiology and immunology / K. Lee Lerner and Brenda Wilmoth Lerner, editors.','','','0-7876-6541-X',204,'2003','Vol.1:1 online resource','','QR9 .W89','en',NULL,115,'','Contains six hundred alphabetically arranged entries that provide information about topics in microbiology and immunology, including profiles of pioneers in the field, and features a historical chronology and general index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 17:54:36','2019-02-14 11:12:37',NULL,NULL);
INSERT INTO `biblio` VALUES (677,1,'Medical surgical nursing / B.T. Basavanthappa.','','2nd','9788184486353',168,'2009','1312 pages : illustrations ; 28 cm','','RT52 .B29','en',NULL,19,'','Brief history of medicine and nursing in India -- Nursing process application -- Common problems of adult patient -- Human genetics and genomic nursing -- Immunological problems and nursing -- Perioperative nursing -- Critical care nursing -- Oncological nursing -- Respiratory nursing -- Gastrointestinal nursing -- Hepatobiliary pancreatic nursing -- Cardiovascular nursing -- Orthopedic nursing -- Neurological nursing -- Hematological nursing -- Endocrinological nursing -- Urological and renal nursing (Renourological) -- Reproductive health nursing -- Dermatological nursing or integumentary nursing -- Ophthalmic and otologic nursing -- Organ transplantation and nursing -- Nursing the poisoned client. \r\nIncludes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-02-15 16:31:23','2018-03-12 11:05:05',NULL,NULL);
INSERT INTO `biblio` VALUES (676,32,'Psychology and psychological medicine for nurses','','','',199,'2014 (1957)','','','RT86 .H73','en',NULL,7,'','Psychology and Psychological Medicine for Nurses provides a survey of psychology and psychological medicine specifically tailored for the use of nurses who will take the examinations for the Certificate of General Nursing of the General Nursing Council for England and Wales. The text covers topics on the development of human behavior or how the upbringing of children can influence their behavior when they become adults; care of mentally ill patients; and the bearing of childhood experience on the behavior of adults when they are ill. Nursing students will find the book a very good sour.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2017-12-06 18:28:56','2019-02-14 10:51:56',NULL,NULL);
INSERT INTO `biblio` VALUES (682,1,'Family planning methods and practice : Africa.','','','',169,'1983','(xvi, 698 pages) : illustrations','','HQ766.5.A3 F6','en',NULL,94,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-03-12 11:59:22','2018-03-12 12:23:04',NULL,NULL);
INSERT INTO `biblio` VALUES (683,1,'The art and science of midwifery Louise Silverton','','','9780130467072',6,'1993','XVI, 638 p. ; 23 cm','','RG524 .M59','en',NULL,95,'','Includes bibliographical references and index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-03-13 16:06:50','2018-03-13 16:16:45',NULL,NULL);
INSERT INTO `biblio` VALUES (684,1,'Instructor\'s manual with test bank for Nursing in today\'s world : challenges, issues, and trends / Janice Rider Ellis, Celia Love Hartley.','','5th','9780397551811',24,'1995','vii, 174 pages ; 23 cm','Nursing in today\'s world : challenges, issues and trends','RT82 .El4','en',NULL,11,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-03-13 16:58:12','2018-03-13 17:51:37',NULL,NULL);
INSERT INTO `biblio` VALUES (685,1,'Mayes\' midwifery: a textbook for midwives.','','8th','0702004359',64,'1972','viii, 530 pages; illustrations; 23 cm','','RG524 .M45','en',NULL,7,'','Imprint covered by label: The Williams & Wilkins Company, Baltimore.\r\nFirst-6th ed. published under title: Handbook for midwives; 7th ed. (1967) published under title: Handbook of midwifery.\r\nIncludes bibliographical references.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-03-14 08:26:10','2018-03-14 08:38:12',NULL,NULL);
INSERT INTO `biblio` VALUES (686,1,'MYLES textbook for Midwives / ed. by V. Ruth Bennett, Linda K. Brown ; foreword by Mary E. Uprichard.','','12th','0443046026',13,'1993','xv, 838 p. : ill. ; 2 8 cm.','','RG524 .M99','en',NULL,10,'','Include index. \r\nInclude bibliography.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-03-14 09:01:38','2018-03-14 09:04:08',NULL,NULL);
INSERT INTO `biblio` VALUES (687,1,'The elements of nursing : a model for nursing based on a model of living / Nancy Roper, Winifred W. Logan, Alison J. Tierney.','','4th','9780443052019',13,'1998','xiv, 437 pages : illustrations ; 28 cm','','RT41 .R68','en',NULL,10,'','Preface to the Fourth Edition -- Preface to the Third Edition -- Preface to the Second Edition -- Preface to the First Edition -- Foreword to the First Edition -- 1. Nursing in health and illness -- 2. A model of living -- 3. A model for nursing -- 4. Maintaining a safe environment -- 5. Communicating -- 6. Breathing -- 7. Eating and drinking -- 8. Eliminating -- 9. Personal cleansing and dressing -- 10. Controlling body temperature -- 11. Mobilizing -- 12. Working and playing -- 13. Expressing sexuality -- 14. Sleeping -- 15. Dying -- Appendix 1: Example of a patient/client assessment form and nursing plan -- Index.\r\n 	Abstract	For beginning nursing students. While it does not cover all aspects of nursing knowledge and practice it encourages a logical mode of thinking about nursing in the framework of a model for nursing.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-03-16 10:40:23','2018-03-16 10:42:54',NULL,NULL);
INSERT INTO `biblio` VALUES (688,1,'Operative surgery / [edited by] Sir Roy Y. Calne, Stephen G. Pollard.','','','',81,'1992','(various pagings) : illustrations','','RD32 .Op2','en',NULL,8,'','\"A slide atlas of Operative surgery based on the contents of this book, is available\"--Title page verso.\r\nIncludes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-03-16 10:56:34','2018-03-16 10:59:57',NULL,NULL);
INSERT INTO `biblio` VALUES (689,1,'Nutrition for developing countries / Felicity Savage King, Ann Burgess','','2nd','0192622331',26,'1993','xv, 461 P. : illustrations; 24 cm.','','QP141 .Sa9','en',NULL,51,'','En lærebog om ernæring og underernæring i u-landene. Velegnet for folk, der arbejder i felten, da den i et lettilgængeligt sprog og med mange illustrative tegninger, forklarer, hvordan de kan behandle underernærede børn og hvordan de kan formidl e deres viden i lokalsamfundene og i skoler. Med index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-03-16 11:13:34','2018-03-16 11:14:42',NULL,NULL);
INSERT INTO `biblio` VALUES (690,1,'Learning with modules : an approach for nurse midwife teachers.','','2nd','0950750328',170,'1984','x, 266 pages : illustrations ; 25 cm.','Facilitating teaching.','RG524 .L67','en',NULL,7,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-03-16 11:35:44','2018-06-06 10:50:50',NULL,NULL);
INSERT INTO `biblio` VALUES (691,1,'Good nutrition : perspectives for the 21st century / editors, Manfred Eggersdorfer, Klaus Kraemer, John B. Cordaro, Jess Fanzo, Mike Gibney, Eileen Kennedy, Alain Labrique, Jonathan Steffen (technical editor).','','','9783318059649',171,'2016','x, 381 pages : color illlustrations, color maps ;','','RA427.8 .G59','en',NULL,95,'','Includes bibliographical references and index.','scan0001.jpg.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2018-03-22 15:58:58','2018-05-31 16:23:04',NULL,NULL);
INSERT INTO `biblio` VALUES (692,1,'Essentials of computer for nurses / J. Selvasekaran.','','','9788184483413',168,'2008','276 pages : illustrations ; 24 cm','','RT50.5 Se4','en',NULL,19,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-18 12:30:11','2019-05-06 10:57:06',NULL,NULL);
INSERT INTO `biblio` VALUES (693,1,'Basic science in obstetrics and gynaecology : a textbook for MRCOG, Part I / edited by Michael de Swiet, Geoffrey Chamberlain.','','2nd ed.','9780443042294',13,'1992','x, 298 pages : illustrations ; 25 cm','','R129 .B29','en',NULL,7,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-18 12:48:12','2018-05-23 14:03:39',NULL,NULL);
INSERT INTO `biblio` VALUES (694,1,'Essential study skills / Christine Ely, Ian Scott.','','','9780723433712',46,'2007','ix, 228 pages : illustrations ; 24 cm','Essential study skills for nursing','RT73 .Es2','en',NULL,8,'','How to become a successful student nurse -- How to manage your time and study effectively -- Learning resources -- How to find information -- Writing and presenting -- How to pass assessments -- How to learn practical nursing skills -- How to learn from experience : becoming a reflective practitioner -- How to have confidence with numbers. \r\n 	Abstract	Study skills are essential to nursing and the aim of this book is to provide you with an easy-to-use guide that will help you to develop the study skills necessary to your academic and professional life.\r\nIncludes bibliographical references (pages 219-221) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-18 13:06:19','2018-05-23 14:04:54',NULL,NULL);
INSERT INTO `biblio` VALUES (695,1,'Bedside obstetrics and gynecology / Richa Saxena.','','','9788184489880',52,'2010','xi, 556 p. : il. (algunas color), 27cm','','RG101 .Sa9','en',NULL,19,'','Includes index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-18 14:01:31','2018-05-23 14:05:35',NULL,NULL);
INSERT INTO `biblio` VALUES (696,1,'Operative obstetrics and gynecology / editors, Randhir Puri, Narendra Malhotra ; co-editors, Jaideep Malhotra, Pranay Shah.','','','9788184485370',172,'2009','xxi, 876 pages : illustrations (some color) ; 28 c','','RG725 Op2','en',NULL,19,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-18 14:12:07','2018-05-18 14:14:24',NULL,NULL);
INSERT INTO `biblio` VALUES (697,1,'First aid manual : the authorised manual of St. John Ambulance, St. Andrew\'s Ambulance Association, and the British Red Cross.','','8th ed','9780751337044',108,'2002','288 pages : color illustrations, color portrait ;','','RC86.7 .F51','en',NULL,7,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-18 14:45:23','2018-05-23 12:15:23',NULL,NULL);
INSERT INTO `biblio` VALUES (698,1,'Nursing care plans : guidelines for individualizing patient care / Marilynn E. Doenges, Mary Frances Moorhouse, Alice C. Geissler-Murr.','','Ed. 6.','9780803609464',87,'2002','xxviii, 873 pages : illustrations ; 28 cm + 1 CD-R','','RT49 .D67','en',NULL,11,'','Abstract	Accompanying CD-ROM contains care plans for nearly 200 diseases/conditions.\r\nIntroduction -- Issues and trends in medical/surgical nursing -- Nursing process : planning care with nursing diagnoses -- Critical thinking : adaptation of theory to practice -- Cardiovascular -- Respiratory -- Neurological/sensory disorders -- Gastrointestinal disorders -- Metabolic and endocrine disorders -- Diseases of the blood/blood-forming organs -- Renal and urinary tract -- Women\'s reproductive -- Orthopedic -- Integumentary -- Systemic infections and immunological disorders -- General. \r\nIncludes bibliographical references (pages 861-868) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-21 09:06:43','2018-05-21 09:08:44',NULL,NULL);
INSERT INTO `biblio` VALUES (699,1,'Intervention in emergency nursing : the first 60 minutes / edited by Sharon Blanz Cahill, Marytherese Balskus.','','','0871893622',107,'1986','xxiv, 664 pages : illustrations ; 24 cm','','RT120 .Em1','en',NULL,80,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-21 09:32:36','2018-05-21 09:34:56',NULL,NULL);
INSERT INTO `biblio` VALUES (700,1,'Introduction to the human body : the essentials of anatomy and physiology / Gerard J. Tortora, Bryan Derrickson.','','7th ed.','',5,'2007','611 pages : illustrations ; 29 cm','','QP36 .T63','en',NULL,95,'','Includes Index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-21 10:07:00','2018-05-21 10:09:00',NULL,NULL);
INSERT INTO `biblio` VALUES (701,1,'Notes for students of midwifery; by A.P. Bentall and D.J. Fairs, with the assistance of J.P. Quinton [et al.].','','','0700015159',173,'1971','viii, 196 pages illustrations','','RG524 .B44','en',NULL,22,'','For students of midwifery who already have had nursing training.\r\nIncludes Index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-21 10:38:33','2018-05-21 10:46:35',NULL,NULL);
INSERT INTO `biblio` VALUES (702,1,'Nurses\' guide to clinical procedures / Jean Smith-Temple, Joyce Young Johnson.','','2nd ed.','',24,'1994','xviii, 746 pages : illustrations (some color) ; 19','Clinical procedures','RT51 .Sm4','en',NULL,11,'','Includes bibliographical references (pages 715-719) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-21 11:12:52','2018-06-01 09:05:57',NULL,NULL);
INSERT INTO `biblio` VALUES (703,1,'Aids to practical nursing: Marjorie Houghton and Mary Whittow. With a foreword by M.L. Rosenheim.','','10th ed.','',174,'1968','xii, 369 pages illustrations 18 cm.','The Nurses\' aids series','RT62 .H81','en',NULL,96,'','Cover title: Practical nursing.\r\nIncludes bibliographical references (page 145).',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-21 11:27:32','2018-05-21 11:45:32',NULL,NULL);
INSERT INTO `biblio` VALUES (704,1,'Practical nursing : hospital and community nursing and health perspectives / Margaret Clarke.','','14th ed.','0702014117',64,'1991','x, 462 pages : illustrations ; 18 cm.','','RT62 .C55','en',NULL,11,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-21 11:54:30','2018-05-21 11:55:33',NULL,NULL);
INSERT INTO `biblio` VALUES (705,1,'Personal hygiene for nurses / N. K. Anand, Shikha Goel.','','2nd ed.','9788174733580',96,'2013','viii, 254p. ; 21cm.','','RT67 .An1','en',NULL,19,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-22 11:05:37','2018-05-22 11:06:50',NULL,NULL);
INSERT INTO `biblio` VALUES (706,1,'Bansal\'s nurses\' dictionary : english-english / edited by Shrinandan Bansal.','','','9789374734797',141,'2016','399p. : ill. ; 21cm.','','RT21 .B22','en',NULL,19,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-22 11:21:32','2018-05-23 08:16:20',NULL,NULL);
INSERT INTO `biblio` VALUES (707,1,'Textbook of nursing research and statistics / A. Mustafa.','','','9789374734742',96,'2014','612p. : ill. ; 24cm.','','RT68 M99','en',NULL,19,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-22 11:31:18','2018-05-23 08:17:55',NULL,NULL);
INSERT INTO `biblio` VALUES (708,1,'Business mathematics and statistics / Andre Francis.','','6th','9781844801282',175,'2004','vi, 666 pages : illustrations ; 25 cm','','HF5691 .F85','en',NULL,7,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-22 11:59:12','2018-05-22 11:59:12',NULL,NULL);
INSERT INTO `biblio` VALUES (709,1,'Jaypee\'s midwifery dictionary / UN Panda.','','1st ed.','9788184487404',0,'2010','180 pages ; 17 cm','Midwifery dictionary','RG45 .P19','en',NULL,19,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-23 09:04:08','2018-05-23 09:05:22',NULL,NULL);
INSERT INTO `biblio` VALUES (710,1,'Illustrated nurses\' dictionary / edited and compiled by L. C. Gupta, Kusum Gupta, Abhishek Gupta.','','','9788174731333',141,'2016','690 p. : ill. ; 20 cm.','','RT21 .Il6','en',NULL,97,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-23 09:18:46','2018-05-23 09:20:08',NULL,NULL);
INSERT INTO `biblio` VALUES (711,1,'The student nurse handbook / Bethann Siviter.','','','9780702027307',64,'2004','xvi, 262 pages : illustrations ; 22 cm','','RT73 .Si9','en',NULL,54,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-23 09:43:16','2018-05-23 09:45:18',NULL,NULL);
INSERT INTO `biblio` VALUES (712,1,'Psychology for nurses / Krishne Gowda.','','','',95,'2009','189 pages : illustrations ; 22 cm','','RT55 .G72','en',NULL,97,'','Includes bibliographical references.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-23 10:28:12','2018-05-23 10:29:45',NULL,NULL);
INSERT INTO `biblio` VALUES (713,1,'Maternal and child health care / Suraiya Hossain.','','1st ed.','9789374735343',176,'2014','142p. : ill. ; 22cm.','','RA1671 .H79','en',NULL,19,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-23 10:45:40','2019-04-09 19:31:38',NULL,NULL);
INSERT INTO `biblio` VALUES (714,1,'Medical genetics / G.P. Pal.','','1st ed.','9788174734013',96,'2015','xii, 207 pages : illustrations (chiefly color) ; 2','','RB155 .P18','en',NULL,98,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-23 11:09:02','2018-05-23 14:02:04',NULL,NULL);
INSERT INTO `biblio` VALUES (715,1,'Manual of medicine / U. N. Panda.','','1st ed.','9788174731722',177,'2016','467p. ; 24cm.','','R130 .P19','en',NULL,98,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-23 11:31:12','2018-05-23 11:51:16',NULL,NULL);
INSERT INTO `biblio` VALUES (716,1,'Textbook of social medicine : for students of medicine and social sciences / B. Sridhar Rao.','','2nd ed.','9788174734518',178,'2016','xv, 238 pages : illustrations ; 24 cm','','RA418 .R19','en',NULL,99,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-23 12:05:36','2018-05-23 12:08:45',NULL,NULL);
INSERT INTO `biblio` VALUES (717,1,'Practical statistics for experimental biologists / Alastair C. Wardlaw','','2nd ed.','9780471988229',1,'2000','ix, 249 p. : illustrations; 24cm.','','QH323.5 .W21','en',NULL,100,'','Includes Index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-28 13:48:27','2018-05-28 13:50:21',NULL,NULL);
INSERT INTO `biblio` VALUES (718,1,'Handbook of dermatology and venereology / A. S. M. T. Hossain.','','2nd ed.','9788185386904',179,'2013','v, 298 pages : illustrations ; 25 cm','','RL74 .H79','en',NULL,55,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-28 14:07:25','2018-05-28 14:08:38',NULL,NULL);
INSERT INTO `biblio` VALUES (719,1,'Teaching and learning in schools of nursing / Maya George.','','2nd ed.','9788174733740',96,'2012','v, 293p. : ill. ; 22cm.','','RT71 .G55','en',NULL,19,'','Preface -- An introduction to nursing -- Nursing theories -- Education process -- Nature of learning -- Learning environment -- Curriculum -- Course preparation -- Teaching methods -- Communication in nursing education -- Educational communication media -- Philosophy: aims and objectives -- Index. \r\nIncludes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-28 14:16:52','2018-05-28 14:18:18',NULL,NULL);
INSERT INTO `biblio` VALUES (720,1,'Pediatric nursing / U. N. Panda.','','2nd ed.','8174734082',180,'2013','','','RJ245 .P19','en',NULL,19,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-28 14:30:55','2019-04-09 19:29:49',NULL,NULL);
INSERT INTO `biblio` VALUES (721,1,'General psychology and psychiatry for nurses / Anujeet.','','','9788174734549',96,'2012','xiv, 240 pages : illustrations ; 22 cm','','RC454 .An7','en',NULL,98,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-28 14:42:53','2018-05-28 14:44:05',NULL,NULL);
INSERT INTO `biblio` VALUES (722,1,'Handbook of medicine / U. N. Panda.','','','9788174732736',96,'2016','487p. ; 23cm.','','RC55 .P19','en',NULL,98,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-28 14:51:29','2018-05-28 14:53:01',NULL,NULL);
INSERT INTO `biblio` VALUES (723,1,'Principles of community medicine / by B. Sridhar Rao.','','','9788174731708',141,'2015','v, 766p. : ill. ; 26cm.','','RA529 .R18','en',NULL,98,'','Basic concepts -- Social medicine -- Statistics -- Epidemiological tools and concepts -- Entomology -- Rats: ecology and control -- Nutrition -- Environmental sanitation -- Communicable diseases: an overview -- Vaccine preventable diseases -- Communicable diseases of national importance -- Communicable diseases of regional importance -- Demography and family welfare -- Reproductive and child health care -- Occupational health -- Preventive geriatrics -- Non-communicable diseases -- Health education -- Health management -- Health administration -- Health planning / policies in India -- National health programmes -- International health. Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-29 19:00:27','2018-05-29 19:02:34',NULL,NULL);
INSERT INTO `biblio` VALUES (724,1,'Principles and practice of geriatric medicine / editors, M.S. John Pathy, Alan J. Sinclair, John E. Morley.','','4th ed.','9780470090558',128,'2006','2 v. (xxiv, 2016 p.) : il. ; 29 cm','','RC952 .P27','en',NULL,100,'','Includes bibliographical references and index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-29 19:14:29','2018-05-29 19:15:46',NULL,NULL);
INSERT INTO `biblio` VALUES (725,1,'Clinical diabetes mellitus : a problem-oriented approach / [edited by] John K. Davidson.','','3rd ed.','086577840X',68,'2000','xxx, 970 pages : illustrations (some color) ; 28 c','','RC660 .D29','en',NULL,8,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-29 19:26:56','2018-05-29 19:52:02',NULL,NULL);
INSERT INTO `biblio` VALUES (726,1,'Operative orthopaedics / edited by Michael W. Chapman ; Michael Madison, managing editor ; 290 contributors.','','2nd ed.','0397510756',117,'1993','4 volumes (xl, 3512, 91 pages) : illustrations ; 2','','RD731 .Op2','en',NULL,11,'','Includes bibliographical references and index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-29 20:14:18','2018-05-29 20:20:32',NULL,NULL);
INSERT INTO `biblio` VALUES (727,1,'Exploring psychology / David G. Myers.','','','0879014393',47,'1990','xxiv, 549 pages : illustrations (some color) ; 27','','BF121 .M99','en',NULL,101,'','Introducing psychology -- Biological roots of behavior -- The developing person through the life span -- Sensation and perception -- States of consciousness -- Learning -- Memory -- Thinking, language, and intelligence -- Motivation -- Emotion -- Personality -- Psychological disorders -- Therapy -- stress and health -- Social behavior. \r\n	Includes bibliographical references (pages 492-524).',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-30 08:01:22','2018-05-30 08:05:21',NULL,NULL);
INSERT INTO `biblio` VALUES (728,1,'Psychology : core concepts / Philip G. Zimbardo, Robert L. Johnson, Ann L. Weber','','5th ed.','9780205474455',181,'2006','XXXI, 605, [82] str. : barvne ilustr. ; 29 cm.','','BF121 .Z6','en',NULL,47,'','Bibliographical references',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-30 08:37:50','2018-05-30 08:39:46',NULL,NULL);
INSERT INTO `biblio` VALUES (729,1,'Psychology / David G. Myers.','','7th ed.','9780716758426',47,'2004','xxx, 752, [151] pages : illustrations (chiefly col','','BF121 .M94','en',NULL,95,'','Prologue: the story of psychology -- Thinking critically with psychological science -- Neuroscience and behavior -- The nature and nurture of behavior -- The developing person -- Sensation -- Perception -- States of consciousness -- Learning -- Memory -- Thinking and language -- Intelligence -- Motivation and work -- Emotion -- Stress and health -- Personality -- Psychological disorders -- Therapy -- Social psychology. \r\nIncludes bibliographical references.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-30 08:53:39','2018-05-30 08:55:06',NULL,NULL);
INSERT INTO `biblio` VALUES (730,1,'Psychology / Carole Wade, Carol Tavris.','','7th ed.','9780130982636',6,'2003','xxxi, 766 pages : illustrations (some color) ; 28','','BF121 .W11','en',NULL,58,'','Includes bibliographical references (pages 682-729) and indexes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-30 09:04:14','2018-05-30 09:05:09',NULL,NULL);
INSERT INTO `biblio` VALUES (731,1,'Colour atlas of human anatomy / Miquel Ridola . [and others].','','','9788123914589',95,'2007','558 pages : illustrations ; 33 cm.','','QM25 .C11','en',NULL,19,'','Includes bibliographical references.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-30 09:39:28','2018-05-30 09:40:59',NULL,NULL);
INSERT INTO `biblio` VALUES (732,1,'Decision-making in nursing : thoughtful approaches for practice / [edited by] Sandra B. Lewenson, Marie Truglio-Londrigan.','','','9780763744359',114,'2008','xxv, 208 pages : illustrations ; 23 cm.','','RT42 .D58','en',NULL,83,'','Know yourself : reflective decision-making -- Looking back : history and decision-making in health care -- Right or wrong : legal and ethical issues and decision-making -- More than prayer : spirituality and decision-making -- Culture and decision-making -- Who is family? : family and decision-making -- Media and decision-making -- Flattening the field : group decision-making -- Evidence-based decision-making -- Right on the money : economics and decision-making -- Getting involved : public policy and the decision-making process. \r\n 	Abstract	\"Decision-Making in Nursing explores a variety of decision-making approaches that combine with evidence and other ways of knowing to enable nurses to be reflective, critical, flexible, and comfortable with the many daily decisions they make. In today\'s complex health care arena, nurses considering patient, family, or community needs must align their decision-making with a multidimensional care environment. This book helps guide students and professionals through this process and shows them how current evidence, along with historical, legal, spiritual, and political factors affect their decision-making.\"--Jacket.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-30 09:51:28','2018-05-30 09:53:12',NULL,NULL);
INSERT INTO `biblio` VALUES (733,1,'The physician assistant in a changing health care environment / Gretchen Engle Schafft, James F. Cawley.','','','0871898705',107,'1987','xiv, 229 pages ; 24 cm.','','R697.P53','en',NULL,102,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-30 10:16:26','2018-05-30 10:19:45',NULL,NULL);
INSERT INTO `biblio` VALUES (734,1,'Gateways to psychology : visual guides and technology tools / Dennis Coon and A.D. Vandeventer.','','10th ed.','9780534612276',175,'2004','Xliii, 758 pages : illustrations, color ; 29 cm.','','BF121 .C78','en',NULL,37,'','Includes bibliographical references and  index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-30 10:36:43','2018-05-30 10:40:25',NULL,NULL);
INSERT INTO `biblio` VALUES (735,1,'Recent advances in high risk in pregnancy / editor, Dilip Kumar Dutta.','','','9788184489552',52,'2010','ix, 409 pages : illustrations ; 24 cm','','RG571 .R24','en',NULL,19,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-30 10:51:58','2018-05-30 11:00:40',NULL,NULL);
INSERT INTO `biblio` VALUES (736,1,'Sociology / John J. Macionis, Linda M. Gerber.','','Updated 4th Canadian ed.','9780131218000',105,'2004','xxvii, 691 p. : ill. (some col.), maps (some col.)','','HM586 .M11','en',NULL,62,'','Includes bibliographical references: p. 638-663.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-30 11:10:01','2018-05-30 11:11:25',NULL,NULL);
INSERT INTO `biblio` VALUES (737,1,'Sociology in our times / Diana Kendall.','','3rd ed.','053457078X',0,'2001','xxx, 681 pages : color illustrations, color maps ;','','HM447 .K33','en',NULL,103,'','Includes bibliographical references (pages 654-675) and indexes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-30 11:22:22','2018-05-30 11:23:43',NULL,NULL);
INSERT INTO `biblio` VALUES (738,1,'Sociology / John J. Macionis.','','7th ed.','9780130953919',6,'19997','xxxv, 700 pages : illustrations (some color), colo','','HM51 .M11','en',NULL,58,'','Intended for freshman/sophomore-level courses in Introduction to Sociology. This title offers a contemporary perspective - with a focus on the major methods, theories, and findings of the field.\r\nIncludes bibliographical references (pages 658-683) and indexes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-31 16:20:04','2018-05-31 16:21:24',NULL,NULL);
INSERT INTO `biblio` VALUES (739,1,'A guide for new principals / Mike Pringle, Jacky Hayden, and Andrew Procter.','','','9780192625366',26,'1996','vii, 213 pages : illustrations ; 23 cm','','R728 .P93','en',NULL,95,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-31 16:36:27','2018-05-31 16:37:30',NULL,NULL);
INSERT INTO `biblio` VALUES (740,1,'Research methodology / Prof. (Dr.) A. Mustafa.','','2nd ed.','9788174734495',140,'2015','x, 251 pages : illustrations ; 25 cm','','HD30.4 .M97','en',NULL,97,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-31 16:47:15','2018-05-31 16:50:30',NULL,NULL);
INSERT INTO `biblio` VALUES (741,1,'Essential elements of obstetric care at first referral level.','','','9241544244',21,'1991','vii, 72 pages ; 24 cm','','RG530 .Es7','en',NULL,12,'','Members of WHO\'s Technical Working Group on Essential Obstetric Functions at First Referral Level have prepared a book geared towards district, provincial, regional, national, and international decision makers, particularly those in developing countries, whose areas of expertise include planning, financing, and organization and management of obstetric services. The guidelines should allow them to improve referral services\' standards at the district level. They should also help them decide how far and by what means they may possibly expand some of these services to more peripheral levels, e.g., renovating facilities and improving staff. When developing these guidelines, WHO took in consideration that many countries confront serious economic obstacles. The book\'s introduction briefly discusses maternal morbidity and mortality in developing countries and maternity care in district health systems. The second chapter, which makes up the bulk of the book, addresses primary components of obstetric care related to causes of maternal death. This chapter\'s section on surgical obstetrics examines cesarean section and repair of high vaginal and cervical tears among others. Its other sections include anesthesia, medical treatment, blood replacement, manual procedures and monitoring labor, family planning support, management of women at high risk, and neonatal special care. The third section provides guidelines for implementation of these services, including cost and financial considerations. It emphasizes the need at the first referral level to have the least trained personnel perform as many health care procedures as possible, as long as they can do so safely and effectively. Other implementation issues are facilities, equipment, supplies, drugs, supervision, evaluation, and research. Annexes list the required surgical and delivery equipment, materials for side ward laboratory tests and blood transfusions, essential drugs, and maternity center facilities and equipment.\r\nIncludes bibliographical references (pages 46-47).',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-31 17:02:16','2018-05-31 17:03:04',NULL,NULL);
INSERT INTO `biblio` VALUES (742,1,'The risk approach in health care : with special reference to maternal and child health, including family planning / E. Maurice Backett, A. Michael Davies, Angèle Petros-Barvazian.','','','9241300760',21,'1984','viii, 113 pages : illustrations ; 24 cm.','','RG940 .B13','en',NULL,12,'','Includes bibliographical references (pages 104-110).',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-31 17:16:11','2018-05-31 17:17:31',NULL,NULL);
INSERT INTO `biblio` VALUES (743,1,'Caring for sexuality in health and illness / edited by Diane Wells ; authors, Doreen Clifford, Marjorie Rutter, Jane Selby ; foreword by Jan Savage.','','','9780443064432',182,'2000','viii, 326 pages : illustrations; 23 cm.','','RT87.Se9','en',NULL,95,'','This text will enable medical practitioners to develop their awareness and skills for the provision of sexual care, including an insight into the practitioner-patient relationship, and an understanding of each person\'s unique circumstances.\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-31 17:27:23','2018-05-31 17:28:27',NULL,NULL);
INSERT INTO `biblio` VALUES (744,1,'The physician assistant in a changing health care environment / Gretchen Engle Schafft, James F. Cawley.','','','0871898705',107,'1987','xiv, 229 pages ; 24 cm.','','R697.P56','en',NULL,80,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-05-31 17:41:45','2018-05-31 17:42:40',NULL,NULL);
INSERT INTO `biblio` VALUES (745,1,'Family stress / David Rosenthal, volume editor.','','','0894436228',107,'1987','xv, 124 pages ; 24 cm.','','RC455.4.F21','en',NULL,80,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-06-01 08:45:18','2018-06-01 08:46:59',NULL,NULL);
INSERT INTO `biblio` VALUES (746,1,'Atlas of ophthalmology / Michael G. Glasspool.','','','',183,'1982','128 pages : illustrations','','RE71 .G46','en',NULL,104,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-06-01 08:59:19','2018-06-01 09:00:26',NULL,NULL);
INSERT INTO `biblio` VALUES (747,1,'Introduction to psychology : gateways to mind and behavior / Dennis Coon.','','','9780495318668',157,'2007','1v. (various pagings) : ill. (chiefly col.) ; 29cm','','BF121 C78','en',NULL,90,'','Includes bibliographical references and indexes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-06-05 12:03:51','2018-06-05 17:21:18',NULL,NULL);
INSERT INTO `biblio` VALUES (748,1,'The Royal Marsden hospital manual of clinical nursing procedures.','','5th ed.','9780632052356',0,'1992','xiv, 725 pages : illustrations','Manual of clinical nursing procedures','RT42 .R82','en',NULL,105,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-06-06 09:30:39','2018-06-13 08:04:45',NULL,NULL);
INSERT INTO `biblio` VALUES (749,1,'What is psychology? / by Susann Doyle-Portillo, Ellen Pastorino.','','3rd ed.','9781111347000',184,'2012','1 volume (various pagings) : illustrations (some c','','BF121 .P95','en',NULL,106,'','Includes bibliographical references and indexes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-06-06 09:49:09','2018-06-06 09:50:13',NULL,NULL);
INSERT INTO `biblio` VALUES (753,1,'The ICD-10 classification of mental and behavioural disorders Elektronische Daten : clinical descriptions and diagnostic guidelines / [10th revision by the World Health Organization].','','','9789241544221',0,'2006','v, 362 pages ; 21 cm.','','RC455.2.C61','en',NULL,107,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-06-06 11:58:28','2018-06-06 12:00:53',NULL,NULL);
INSERT INTO `biblio` VALUES (751,1,'BNF for Children 2011-2012.','','','9780853699590',185,'2011','xx, 844 pages : illustrations ; 22 cm','','RJ560 .B61','en',NULL,7,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-06-06 10:12:49','2018-06-06 11:40:44',NULL,NULL);
INSERT INTO `biblio` VALUES (752,1,'Obstetrics and gynaecology in the tropics and developing countries [edited by] J.B. Lawson [and] D.B. Stewart.','','','0713141336',19,'1974','630 pages, illustrations; 23 cm.','','RG103 .L44','en',NULL,7,'','Includes bibliographies.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-06-06 11:23:04','2018-06-06 11:26:18',NULL,NULL);
INSERT INTO `biblio` VALUES (754,1,'Nutritional anemias / editors, Samuel J. Fomon, Stanley Zlotkin.','','','0881679429',186,'1992','xii, 220 pages : illustrations ; 25 cm.','','RJ416.I75 N95','en',NULL,95,'','Includes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-06-13 08:24:34','2018-06-13 08:25:51',NULL,NULL);
INSERT INTO `biblio` VALUES (755,1,'Biochemistry for nurses / Sharma D.C and Manminder Riyat.','','','9789374734735',99,'2015','xiii, 398p. : ill. ; 21cm.','','QP514.2 Sh1','en',NULL,98,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-06-13 08:35:46','2018-06-13 08:36:48',NULL,NULL);
INSERT INTO `biblio` VALUES (756,1,'Introduction to clinical medicine : a student-to-student manual / Roger M. Macklis, Michael E. Mendelsohn, Gilbert H. Mudge ; student ed. Rushika Fernandopulle, Bradley Marino.','','3rd ed.','9780316542425',187,'1994','IX, [3], 308 p.,  color. : ill. ; 22 cm','','RC55 .M32','en',NULL,47,'','Bibliographical references and index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-06-13 08:47:09','2018-07-25 13:57:10',NULL,NULL);
INSERT INTO `biblio` VALUES (757,1,'HIV counseling and testing for youth : a manual for providers / Suzanne Fischer with Heidi Reynolds [and others].','','','0939704951',188,'2007','88p. : ill. ; 22cm.','','RA643.8 .H64','en',NULL,108,'','Includes bibliographical references',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-06-13 09:09:27','2018-06-13 09:10:28',NULL,NULL);
INSERT INTO `biblio` VALUES (758,1,'Antenatal care / edited by Jo Alexander, Val Levy and Sarah Roch.','','','9780333513699',189,'1990','ix, 159 pages','','RG551 .An8','en',NULL,109,'','Includes index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-06-13 09:22:41','2018-06-13 09:23:48',NULL,NULL);
INSERT INTO `biblio` VALUES (759,1,'Assignment children : a journal concerned with children, women and youth in development.','','','00045128',190,'1981','244p. : ill. ; 21cm.','','HV701 .C3','en',NULL,107,'','A journal concerned with children, women and youth in development.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-06-13 10:55:18','2018-06-13 10:56:37',NULL,NULL);
INSERT INTO `biblio` VALUES (760,1,'A textbook for midwives in the tropics / O.A. Ojo and Enang Bassey Briggs.','','','0713144912',40,'1976','xi, 468 pages : illustrations ; 22 cm','','RG526 .M58','en',NULL,7,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-06-13 11:21:37','2018-07-25 10:52:33',NULL,NULL);
INSERT INTO `biblio` VALUES (761,1,'Effective training in reproductive health : course design and delivery : trainer\'s manual / Katherine Turner, Christina Wegs, and Betsy Randall-David ; editor, Jill Molloy.','','','1882220528',191,'2003','vii, 204 pages : illustrations, forms ; 28 cm','Effective training in reproductive health : course design and delivery : trainer\'s manual and reference manual.','RA427.2 .T85','en',NULL,110,'','Includes bibliographical references (pages 202-204).',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-07-25 10:04:16','2018-07-25 10:19:55',NULL,NULL);
INSERT INTO `biblio` VALUES (762,1,'Pictorial midwifery : an atlas of midwifery for pupil midwives / by Sir Comyns Berkeley.','','5th ed.','702001708',173,'1956','xii, 166 pages : illustrations; 23cm.','','RG520 .B24','en',NULL,22,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-07-25 11:42:16','2018-07-25 11:44:33',NULL,NULL);
INSERT INTO `biblio` VALUES (775,32,'Provider and pharmacy directory','','','',0,'2015','444 pages : illustrations','','ebook','en',NULL,148,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-11-08 20:46:07','2019-12-16 12:34:51',NULL,NULL);
INSERT INTO `biblio` VALUES (765,1,'BIBLE HISTORY OLD TESTAMENT','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-09-10 11:33:43','2018-09-10 11:35:41',NULL,NULL);
INSERT INTO `biblio` VALUES (766,32,'bible history','','','',0,'','','','','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-09-10 12:05:35','2018-09-10 12:07:31',NULL,NULL);
INSERT INTO `biblio` VALUES (768,1,'AIDS : pathology, diagnosis, treatment & prevention / Govind Srivastava, Amita Srivastava.','','3rd ed.','9788123914206',95,'2007','204 pages : illustrations ; 22 cm','','RC607 .G74','en',NULL,19,'','Includes bibliographical references (pages 187-200) and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-09-14 10:45:48','2018-09-14 10:45:48',NULL,NULL);
INSERT INTO `biblio` VALUES (769,1,'Basic anatomy and physiology / N. Kumar.','','','9788174734426',194,'2015','vi, 314p. : ill. ; 21cm.','','QM23.2 K96','en',NULL,19,'','Includes index',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-09-14 11:03:25','2018-09-14 11:05:38',NULL,NULL);
INSERT INTO `biblio` VALUES (770,1,'Essentials of mental health and psychiatric nursing / N.K. Anand, Shikha Goel.','','2nd','9788174734068',0,'2014','x, 398 pages : illustrations ; 21 cm','','RA790.5 An1','en',NULL,0,'','Includes index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-09-17 11:13:33','2018-09-17 11:23:07',NULL,NULL);
INSERT INTO `biblio` VALUES (771,1,'Nursing ethics : across the curriculum and into practice / Janie B. Butts, Karen L. Rich.','','','9780763747350',58,'2005','xvi, 277 pages : illustrations ; 23 cm','','RT85 .B97','en',NULL,83,'','\"Spanning the nursing curriculum, Nursing Ethics: Across the Curriculum and into Practice is derived from theoretical foundations, clinical evidence, and case study. Based on the concept that compassionate relationships between nurses and patients form a vital element of humanistic nursing, this text provides foundational knowledge about ethics and decision-making strategies to prepare nurses for the moral issues they experience daily.\" \"Ideal for current nursing students and practicing professionals alike, Nursing Ethics includes decision-making approaches and models, rationale for decisions, and management of care for various topics. Addressing a wide array of nursing moral issues, this text includes current scholarly literature, related news briefs, and research and legal findings regarding ethical issues.\"\r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-10-24 09:49:01','2018-10-24 09:50:27',NULL,NULL);
INSERT INTO `biblio` VALUES (772,1,'Our planet, our health : report of the WHO Commission on Health and Environment.','','','9241561483',21,'1992','282 p. : ill. ; 24 cm.','','RA565 .Our7','en',NULL,12,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-10-24 10:54:25','2018-10-24 10:55:48',NULL,NULL);
INSERT INTO `biblio` VALUES (773,1,'Critical care nursing : a holistic approach / [edited by] Carolyn M. Hudak, Barbara M. Gallo ; special editor, Julie J. Benz.','','6th ed.','0397549857',24,'1994','xxi, 1079, 29 pages : illustrations (some color) ;','','RT120.I5 C86','en',NULL,111,'','Concept of holism applied to critical care nursing practice -- Professional practice issues in the critical care unit -- Critical care nursing process applied to alterations in core body systems -- Multisystem organ failure conditions. \r\nIncludes bibliographical references and index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-10-24 11:07:23','2018-10-24 11:32:26',NULL,NULL);
INSERT INTO `biblio` VALUES (774,1,'The Year book of infectious diseases.','','','07439261',195,'1996','volumes : illustrations ; 24 cm','Yearbook of infectious diseases','RC109 .Y3','en',NULL,36,'','Periodicals.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2018-10-24 11:52:00','2018-10-24 14:37:27',NULL,NULL);
INSERT INTO `biblio` VALUES (776,32,'Research for nurses : methods and interpretation','','','9.78E+12',87,'2002','xiii, 752 pages : illustrations','','','en',NULL,78,'','Introduction to Nursing Research -- Research and Nursing: Parallel Processes -- Conceptualizing Research in Nursing -- The Varieties of Nursing Knowledge -- Acquiring Nursing Knowledge through Research -- Key Methodological Approaches in Nursing Science -- Types of Research: Some Important Distinctions -- Research as a Professional Mandate -- Understanding Theory -- Explanation -- Theory -- Concepts and Statements: Building Blocks of Theory -- Theoretical Frameworks -- Testing and Using Theory in Research -- Points of Agreement on Theory and Research -- Deciding What to Study -- Choosing a Topic and Stating the Problem -- Reviewing the Literature -- Specifying the Model -- Specifying Hypotheses and Procedures of Analysis -- Understanding Research Design -- Predictable Setbacks and Challenges -- Determining Your Readiness to Start the Project -- Research Designs and Approaches -- Experimental and Quasi-experimental Designs -- Basics of Experimental Designs -- Pre-experimental Designs -- Classic Experimental Designs -- Quasi-experimental Designs -- Advantages and Limitations of Experimental Designs -- Survey Designs -- A Short History of the Survey -- The Rationale for Surveys -- Steps in Survey Research -- Guidelines for the Administration of Questionnaires -- Comparative Studies -- Secondary Data Analysis -- Advantages and Limitations of Survey Designs -- Qualitative Research Designs -- Entering the World of Qualitative Research -- Qualitative Research Designs -- Scientific Adequacy of Qualitative Research.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 09:42:01',NULL,NULL);
INSERT INTO `biblio` VALUES (777,32,'Abnormal psychology','','11th','9780470380086',227,'2010','1 volume (various pagings) : illustrations (chiefl','','','en',NULL,1,'','Contents Introduction and historical overview -- Current paradigms in psychopathology -- Diagnosis and assessment -- Research methods in the study of pschopathology -- Anxiety disorders -- Dissociative disorders and somatoform disorders -- Stress and health -- Mood disorders -- Eating disorders -- Substance-related disorders -- Schizophrenia -- Personality disorders -- Sexual and gender identity disorders -- Disorders of childhood -- Late-life and psychological disorders -- Psychological treatment -- Legal and ethical issues.\r\n Abstract \"Psychologists rely on Abnormal Psychology because it sets the standard for clarity, cutting-edge coverage, authoritative content, and clinical emphasis. It helps them fully integrate the details of all the disorders and distinguish between the more important concepts. The Big Picture feature emphasizes the important comparisons and contrasts to other concepts presented in the chapters. A new discussion on mental disorders shows how the interpretation of behaviors is dependent on the context in which those behaviors occur. The eleventh edition also demonstrates how context drives the definitions of normal and abnormal behavior. With the new features, psychologists will find the material to be more accessible, engaging, and informative.\"',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 10:01:09',NULL,NULL);
INSERT INTO `biblio` VALUES (778,32,'Ross and Wilson anatomy and physiology in health and illness','','','',13,'2001','','','','en',NULL,149,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 10:03:55',NULL,NULL);
INSERT INTO `biblio` VALUES (779,32,'Introduction to psychology : gateways to mind and behavior','','12th','',249,'2010','xxx, 622, [79] pages : illustrations (chiefly colo','','','en',NULL,90,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 10:07:46',NULL,NULL);
INSERT INTO `biblio` VALUES (780,32,'Principles of anatomy & physiology','','13th','',1,'2012','1 volume (various pagings) : illustrations (chiefl','','','en',NULL,149,'','Contents V. 1. Organization, support and movement and control systems of the human body -- v. 2. Maintenance and continuity of the human body.\r\nAbstract The authors maintained a balance between structure and function and continue to emphasize the correlations between normal physiology and pathophysiology, normal anatomy and pathology, and homeostasis and homeostatic imbalances. The acclaimed illustration program continues to be refined and is unsurpassed in the market. The thirteenth edition is fully integrated with a host of innovative electronic media, including WileyPlus 5.0. No other text and package offers a teaching and learning environment as rich and complete.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 10:12:53',NULL,NULL);
INSERT INTO `biblio` VALUES (781,32,'Life-span development','','13th','',250,'2011','xliv, 643, [112] pages : illustrations (chiefly co','','','en',NULL,8,'','Contents Section 1. The life-span perspective. Introduction -- Section 2. Beginnings. Biological beginnings -- Prenatal development and birth -- Section 3. Infancy. Physical development in infancy -- Cognitive development in infancy -- Socioemotional development in infancy -- Section 4. Early childhood. Physical and cognitive development in early childhood -- Socioemotional development in early childhood -- Section 5. Middle and late childhood. Physical and cognitive development in middle and late childhood -- Socioemotional development in middle and late childhood -- Section 6. Adolescence. Physical and cognitive development in adolescence -- Socioemotional development in adolescence -- Section 7. Early adulthood. Physical and cognitive development in early adulthood -- Socioemotional development in early adulthood -- Section 8. Middle adulthood. Physical and cognitive development in middle adulthood -- Socioemotional development in middle adulthood -- Section 9. Late adulthood. Physical development in late adulthood -- Cognitive development in late adulthood -- Socioemotional development in late adulthood -- Section 10. Endings. Death, dying, and grieving.\r\n  Abstract Helps students complete and understand the assigned material in a number of ways. This book provides a comprehensive roadmap to the text material, pointing out the core concepts fundamental to students\' learning and performance.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 10:17:52',NULL,NULL);
INSERT INTO `biblio` VALUES (782,32,'Imaging of the Newborn, Infant, and Young Child','','5th','',240,'2015','1 online resource (1225 pages)','','','en',NULL,149,'','Contents IMAGING OF THE NEWBORN, INFANT, AND YOUNG CHILD; CONTENTS; PREFACE; RESPIRATORY SYSTEM; NORMAL CHEST; NORMAL VARIATIONS AND ARTIFACTS; ROTATION OF THE CHEST: PSEUDOHYPERLUCENT LUNG; THE THYMUS: NORMAL AND ABNORMAL; RESPIRATORY DISTRESS IN THE NEWBORN; MEDICALLY TREATED CAUSES OF RESPIRATORY DISTRESS; SURGICALLY TREATED CAUSES OFRESPIRATORY DISTRESS; MISCELLANEOUS NEONATAL CHEST PROBLEMS; POSTNATAL PULMONARY INFECTIONS; REFERENCES; OTHER PULMONARY ABNORMALITIES; 1-ANTITRYPSIN DEFICIENCY; CHEST MASSES; INTRATHORACIC CYSTS; MISCELLANEOUS MEDIASTINAL LESIONS; INTRAPULMONARY MASSES AND NODULES.\r\nCHEST WALL MASSESMISCELLANEOUS CHEST WALL PROBLEMS; BREAST DISEASE; NASAL PASSAGES, MANDIBLE, AND UPPER AIRWAY; ABNORMALITIES OF THE NASAL PASSAGES; ABNORMALITIES OF THE TONGUE; ABNORMALITIES OF THE SALIVARY GLANDS; ABNORMALITIES OF THE MANDIBLE; NECK MASSES; ABNORMALITIES OF THE PHARYNX; ABNORMALITIES OF THE LARYNX AND UPPER TRACHEA; PULMONARY EDEMA AND UPPER AIRWAY OBSTRUCTION; THYROID AND PARATHYROID GLANDS; CARDIOVASCULAR SYSTEM; NORMAL HEART AND VARIATIONS; NORMAL ROENTGENOGRAPHIC ANATOMY; ANGIOCARDIOGRAPHIC ANATOMY; MAGNETIC RESONANCE IMAGING ANATOMY.\r\nPHYSIOLOGIC CONSIDERATIONS IN CONGENITAL HEART DISEASEBASIC PULMONARY VASCULAR PATTERNS ; SPECIFIC CHAMBER ENLARGEMENT; ANCILLARY FINDINGS; AERATION DISTURBANCES ; THE LEFT-TO-RIGHT SHUNTS; INTRAAND EXTRACARDIAC MIXING LESIONS WITH CYANOSIS; DECREASED PULMONARY VASCULARITY; LEFT-SIDE OBSTRUCTION; CARDIAC MALPOSITIONS; VASCULAR RINGS AND OTHER ARTERIAL ABNORMALITIES; ASYMPTOMATIC VASCULAR ANOMALIES; MISCELLANEOUS AORTIC ANOMALIES; MISCELLANEOUS CONGENITAL CARDIAC PROBLEMS; SUPERIOR AND INFERIOR VENA CAVA ABNORMALITIES; ACQUIRED CARDIOVASCULAR DISEASE.\r\nMISCELLANEOUS CARDIAC DISEASES RESULTING IN CARDIAC FAILUREPERICARDIAL ABNORMALITIES; VASCULAR ABNORMALITIES; MISCELLANEOUS CARDIOVASCULAR DISEASES; ALIMENTARY TRACT; ESOPHAGUS; ESOPHAGEAL ABNORMALITIES; MISCELLANEOUS ESOPHAGEAL LESIONS; STOMACH; ABNORMALITIES OF THE STOMACH; DUODENUM; DUODENAL ABNORMALITIES; SMALL INTESTINE; ABNORMALITIES OF THE SMALL BOWEL; MISCELLANEOUS SMALL BOWEL DISEASE; ABNORMALITIES OF THE COLON; MISCELLANEOUS COLON ABNORMALITIES; GALLBLADDER AND BILE DUCTS; ABNORMALITIES OF THE GALLBLADDER AND BILE DUCTS; LIVER; REFERENCES; ABNORMALITIES OF THE LIVER; SPLEEN.\r\nABNORMALITIES OF THE SPLEENPANCREAS; ABNORMALITIES OF THE PANCREAS; ABDOMEN; ABNORMAL GAS PATTERNS; ABDOMINAL MASSES: IMAGING APPROACH; SPECIFIC ABDOMINAL MASSES; EXTRAINTESTINAL AIR COLLECTIONS; PERITONITIS, ASCITES, AND HEMOPERITONEUM; THE APPENDIX; OTHER MISCELLANEOUS ABDOMINAL AND GASTROINTESTINAL ABNORMALITIES; GENITOURINARY TRACT AND ADRENAL GLANDS; UPPER URINARY TRACT; ANOMALIES OF THE UPPER URINARY TRACT; URINARY TRACT INFECTION; URETERAL REFLUX; RENAL VASCULAR DISEASE; RENAL MASSES; URETERAL ABNORMALITIES; LOWER URINARY TRACT; ABNORMALITIES OF THE BLADDER AND URETHRA.\r\n  Abstract The new edition of this popular textbook of pediatric radiology presents a clear and concise overview of pediatric disease in the neonate, infant, and young child. Organized by organ system, each chapter covers normal anatomy and variations, congenital anomalies, and common disease processes. Many normal films are included as a basis for understanding pathology and recognizing normal variants that are easily confused with abnormal findings. New to the Fifth Edition: an appendix of differential diagnosis/summary tables for quick reference, expanded chapters on the abdomen and head, and material.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 10:20:56',NULL,NULL);
INSERT INTO `biblio` VALUES (783,32,'Psychiatric and Mental Health Nursing : the craft of caring','','2nd','',214,'2012','1 online resource (780 pages)','','','en',NULL,149,'','Contents Cover; Book title; Contents; List of contributors; Poem: The Cleansing has Begun; The Space I\'m in; Poem: Half dead; Preface to the second edition; Acknowledgements; Section 1 THE NEED FOR NURSING; Preface to Section 1; 1 The nature of nursing; 2 Getting personal: being human in mental health care; 3 The care and confinement of the mentally ill; 4 Evidence-based practice in mental health; 5 The craft of psychiatric-mental health nursing practice; 6 Leading developments in the craft of caring; 7 Recovery: a personal perspective.\r\n8 Recovery and reclamation: a pilgrimage in understanding who and what we areSection 2 ASSESSMENT IN PRACTICE; Preface to Section 2; 9 Assessment: the foundation of practice; 10 Assessment methods; 11 The craft of interviewing; 12 Developing collaborative assessment; 13 The context of family assessment; 14 The assessment of feelings, thoughts and beliefs; Section 3 THE STRUCTURE OF CARE; Preface to Section 3; 15 Psychiatric diagnosis; 16 Psychiatric diagnosis: living the experience; 17 Nursing diagnosis; 18 Collaboration with patients and families; Section 4 SPECIFIC NEEDS FOR NURSING.\r\nPreface to Section 419 The person who experiences anxiety; 20 The person who experiences depression; 21 The person who is suicidal; 22 The person who self-harms; 23 The person who hears disturbing voices; 24 The person who experiences disturbing beliefs; 25 The person with a diagnosis of schizophrenia; 26 The person who appears aggressive or violent; 27 The person with a diagnosis of bipolar disorder; 28 The person with a diagnosis of personality disorder; 29 The person who experiences mental health and substance use problems; 30 The person who appears paranoid or suspicious.\r\n31 The person with experience of sexual abuse32 The person with an eating disorder; 33 The person who is homeless; 34 The person with dementia; 35 The person with a diagnosis of autism; Section 5 SOME MODELS OF THERAPEUTIC PRACTICE; Preface to Section 5; 36 Developing therapeutic one-to-one relationships; 37 Developing empathy; 38 Groupwork with children and adolescents; 39 Psychodynamic approaches with individuals; 40 Psychodynamic approaches to working in groups; 41 Using counselling approaches; 42 Bereavement and grief counselling; 43 Cognitive-behavioural therapy.\r\n44 Using solution-focused approaches45 Mindfulness; 46 Therapeutic communities; Section 6 THE ORGANIZATION OF CARE; Preface to Section 6; 47 The acute care setting; 48 The psychiatric intensive care unit: coercion, control or care; 49 Mental health nursing in community care; 50 Crisis assessment and resolution; 51 Assertive outreach; 52 Family support: growing the family support network; 53 The liaison psychiatric service; 54 Services for people requiring secure forms of care: a global problem; 55 Services for children and young people.\r\n  Abstract The Need for Nursing The nature of nursing Getting personal: being human in mental health care The care and confinement of the mentally ill Evidence-based practice in mental health The craft of psychiatric-mental health nursing practice Leading developments in the craft of caring Recovery: a personal perspective Recovery and reclamation: a pilgrimage in understanding who and what we are Assessment in Practice Assessment: the foundation of practice Assessment methods The craft of interviewing Developing collaborative assessment The context of family assessment The assessment of feelings, thoughts and beliefs The Structure for Care Psychiatric diagnosis Psychiatric diagnosis: living the experience Nursing diagnosis Collaboration with patients and families Specific Needs for Nursing The person who experiences anxiety The person who experiences depression The person who is suicidal The person who self-harms The person who hears disturbing voices The person who experiences disturbing beliefs The person with a diagnosis of schizophrenia The person who appears aggressive or violent The person with a diagnosis of bipolar disorder The person with a diagnosis of personality disorder The person who experiences mental health and substance use problems The person who appears paranoid or suspicious he person with experience of sexual abuse The person with an eating disorder The person who is homeless The person with a dementia The person with a diagnosis of autism Some Models of Therapeutic Practice Developing therapeutic one-to-one relationships Developing empathy Groupwork with children and adolescents Psychodynamic approaches with individuals Psychodynamic approaches to working in groups Using counselling approaches Bereavement and grief counselling Cognitive-behavioural therapy Using solution-focused approaches Mindfulness Therapeutic communities The. Organizationof Care The acute care setting The psychiatric intensive care unit: coercion, control or care Mental health nursing in community care Crisis assessment and resolution Assertive outreach Family support: growing the family support network The liaison psychiatry service Services for people requiring secure forms of care: a global problem Services for children and young people Services for older people with mental health conditions Early interventions in psychosis Services for women Services for asylum seekers and refugees Some Standardized Processes of Nursing Practice Admission to psychiatric unit Assessing risk of suicide and self-harm Engagement and observation of people at risk Record-keeping Discharge planning The nurse\'s role in the administration of electroconvulsive therapy Mental health promotion and prevention Mental health nurse prescribing Legal, Ethical and Moral Issues Mental health, the law and human rights Ethics and nursing Sexuality and gender Freedom and consent Providing culturally safe care Spirituality, nursing and mental health The Development of Mental Health Nursing Clinical supervision The possibility of genuine mental health nursing Building practice from research Reclamation: beyond recovery The Future of Psychiatric-Mental Health Nursing in Context The United Kingdom context The European context The Japanese context The United States context The Canadian context The Australian and New Zealand context The politics of caring.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 10:24:32',NULL,NULL);
INSERT INTO `biblio` VALUES (784,32,'Nutrition and health in Developing countries','','','',211,'2001','xvii, 569 pages : illustrations','','','en',NULL,150,'','Contents 1. Nutrition and Development: A Historical Perspective / Richard D. Semba -- 2. Maternal Mortality in Developing Countries / Carine Ronsmans -- 3. Low Birth Weight and Perinatal Morality / Michael S. Kramer and Cesar G. Victoria -- 4. Child Growth and Development / Mercedes de Onis -- 5. Diarrheal Diseases / Claudio F. Lanata and Robert E. Black -- 6. Acute Lower-Respiratory Infections / Claudio F. Lanata and Robert E. Black -- 7. Measles / Gregory Hussey -- 8. Malaria / Anuraj H. Shankar -- 9. Tuberculosis / Christopher Whalen and Richard D. Semba -- 10. Human Immunodeficiency Virus Infection / Richard D. Semba and Glenda E. Gray -- 11. Vitamin A Deficiency / Keith West, Jr. and Ian Darnton-Hill.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 10:26:28',NULL,NULL);
INSERT INTO `biblio` VALUES (785,32,'Medical-surgical nursing certification examination : review','','','',222,'2007','x, 158 pages','','','en',NULL,149,'','Contents Cardiovascular pearls -- Musculoskeletal, trauma and orthopedic pearls -- Eyes, ears, nose, and throat (EENT) pearls -- Pulmonary pearls -- Gastrointestinal pearls -- Homeostastasis, metabolic and endocrine pearls -- Neurology pearls -- Infectious disease/rheumatology/immunology pearls -- Genitourinary/renal pearls -- Resuscitation and shock pearls -- Hematology/oncology pearls -- Reproductive system pearls -- Dermatology pearls -- Patient care management pearls -- Organization and personnel management pearls -- Legal issues and quality improvement pearls -- Wound care pearls -- Perioperative pearls.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 10:28:58',NULL,NULL);
INSERT INTO `biblio` VALUES (786,32,'Public health nutrition in developing countries','','','',251,'2011','xxxvi, 2 volumes, 1244 pages : illustrations','','','en',NULL,73,'','Contents 29. Vitamin A and zinc supplements for child survival: experiences and challenges ahead -- 30. Addressing micronutrient malnutrition through food fortification -- 31. Agriculture, food and nutrition security -- 32. Food and nutrition situation in India -- 33. Food and nutrition in natural and manmade disasters -- 34. Nutrition for the aged -- 35. Nutrition related non-communicable chronic disorders -- 36. Planning result-oriented public health nutrition programs: theory and practice -- 37. Monitoring and evaluation of public health nutrition programmes -- 38. District and village planning: a decentralised implementation approach in public health in India -- 39. Nutrition: health education and communication for improving women and child nutrition -- 40. From research to programs: applying knowledge to improve nutrition outcomes -- 41. Research methods in public health nutrition: critical factors -- 42. Reducing malnutrition: an analysis of the Integrated Child Development Services (ICDS) scheme -- 43. National Rural Health Mission.\r\nPt I 1. Principles of epidemiology and epidemiologic methods -- 2. Nutrition epidemiology for developing countries -- 3. Undernutrition in children -- 4. Dual nutrition burden in women: causes, consequences, and control measures -- 5. Measuring undernutrition and overnutrition in children -- 6. Essential new-born care and child survival -- 7. Integrating breastfeeding in public health programming: scientific facts, current status and future directions -- 8. Complementary feeding of infants and young children -- 9. Options and strategies to reach under-two children through complementary feeding with ARF in the South Asian countries -- 10. Diarrhea and undernutrition -- 11. Prevention and management of protein energy malnutrition -- 12. Severe acute malnutrition in children -- 13. Prevention and management of overweight and obesity in children -- 14. Human immunodeficiency virus (HIV) and nutrition -- 15. Vitamin A metabolism -- 16. Vitamin A deficiency: prevention and control -- 17. Vitamin A prevention and control programme in India: past efforts and current status -- 18. Iodine metabolism and indicators of iodine status -- 19. Sustaining iodine deficiency disorders (IDD) control programme -- 20. Iodine deficiency and iodine deficiency disorders (IDD) control program -- 21. Universal salt iodization (USI) -- 22. National iodine deficiency disorders control programme of India -- Pt II 23. Metabolism of iron, folic acid and vitamin B12 -- 24. Iron deficiency and iron deficiency anemia in young children -- 25. Iron and multiple micronutrient supplementation in children: evidence from systematic reviews -- 26. Nutritional anemia during pregnancy, early childhood and adolescence: the critical development periods -- 27. Iron deficiency and iron deficiency anemia in adolescent girls -- 28. Zinc: an essential micronutrient for health and development.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 10:31:39',NULL,NULL);
INSERT INTO `biblio` VALUES (787,32,'Obstetrics by ten teachers','','16th','',151,'1995','xvi, 368 pages : illustrations','','','en',NULL,7,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 10:39:21',NULL,NULL);
INSERT INTO `biblio` VALUES (788,32,'Brunner & Suddarth\'s textbook of medical-surgical nursing','','12th','',20,'2010','xxvii, 2240 pages, 96 pages : illustrations (some','','','en',NULL,149,'','Contents Health care delivery and nursing practice -- Community-based nursing practice -- Critical thinking, ethical decision making, and the nursing process -- Health education and health promotion -- Adult health and nutritional assessment -- Homeostasis, stress, and adaptation -- Individual and family considerations related to illness -- Perspectives in transcultural nursing -- Genetics and genomics perspectives in nursing -- Chronic illness and disability -- Principles and practices of rehabilitation -- Health care of the older adult -- Pain management -- Fluid and electrolytes: balance and disturbance -- Shock and multiple organ dysfunction syndrome -- Oncology: nursing management in cancer care -- End-of-life care -- Preoperative nursing management -- Intraoperative nursing management -- Postoperative nursing management -- Assessment of respiratory function -- Management of patients with upper respiratory tract disorders -- Management of patients with chest and lower respiratory tract disorders -- Management of patients with chronic pulmonary disease -- Respiratory care modalities -- Assessment of cardiovascular function -- Management of patients with dysrhythmias and conduction problems -- Management of patients with coronary vascular disorders -- Management of patients with structural, infectious, and inflammatory cardiac disorders -- Management of patients with complications from heart disease -- Assessment and management of patients with vascular disorders and problems of peripheral circulation -- Assessment and management of patients with hypertension -- Assessment and management of patients with hematologic disorders -- Assessment of digestive and gastrointestinal function -- Management of patients with oral and esophageal disorders\r\nGastrointestinal intubation and special nutritional modalities -- Management of patients with gastric and duodenal disorders -- Management of patients with intestinal and rectal disorders -- Assessment and management of patients with hepatic disorders -- Assessment and management of patients with biliary disorders -- Assessment and management of patients with diabetes mellitus -- Assessment and management of patients with endocrine disorders -- Assessment of renal and urinary tract function -- Management of patients with renal disorders -- Management of patients with urinary disorders -- Assessment and management of female physiologic processes -- Management of patients with female reproductive disorders -- Assessment and management of patients with breast disorders -- Assessment and management of problems related to male reproductive processes -- Assessment of immune function -- Management of patients with immunodeficiency -- Management of patients with HIV infection and AIDS -- Assessment and management of patients with allergic disorders -- Assessment and management of patients with rheumatic disorders -- Assessment of integumentary function -- Management of patients with dermatologic problems -- Management of patients with burn injury -- Assessment and management of patients with eye and vision disorders -- Assessment and management of patients with hearing and balance disorders -- Assessment of neurologic function -- Management of patients with neurologic dysfunction -- Management of patients with cerebrovascular disorders -- Management of patients with neurologic trauma -- Management of patients with neurologic infections, autoimmune disorders, and neuropathies -- Management of patients with oncologic or degenerative neurologic disorders -- Assessment of musculoskeletal function -- Musculoskeletal care modalities -- Management of patients with musculoskeletal disorders -- Management of patients with musculoskeletal trauma -- Management of patients with infectious diseases -- Emergency nursing -- Terrorism, mass casualty, and disaster nursing.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 10:45:14',NULL,NULL);
INSERT INTO `biblio` VALUES (789,32,'Diet, nutrition and the prevention of chronic diseases','','','',21,'2003','x, 149 p. : ill.','','','en',NULL,149,'','Abstract This report reviews scientific evidence on the effects of diet, nutrition and physical activity on chronic diseases and makes recommendations for public health policies and programmes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 10:47:29',NULL,NULL);
INSERT INTO `biblio` VALUES (790,32,'Atlas of Ophthalmology','','','',252,'1982','128 pages','','','en',NULL,133,'','Contents 1 Anatomy and Physiology -- 2 Examination of the Eye -- 3 Errors of Refraction and their Correction -- 4 The External Eye Part I -- 5 The External Eye Part II -- 6 The Internal Eye -- 7 The Fundus Part I -- 8 The Fundus Part II -- 9 Trauma to the Eye Part I -- 10 Trauma to the Eye Part II -- 11 Cataract -- 12 Glaucoma -- 13 Squint -- 14 Congenital Deformities -- 15 The Eye in Systemic Disease -- 16 Neuro-ophthalmology -- 17 Ocular Pharmacology.\r\n  Abstract This book is designed to be a pictorial guide to ophthalmology and not a comprehensive textbook. It includes chapters on anatomy, physiology and optics to explain the simple elements of the basic sciences that are needed to understand ophthalmology. The section on examination describes the common investigations in an eye department in the hope that reports from ophthalmologists may become more easily understood. The clinical chapters represent 5 years of ophthalmic referrals by local family doctors in a part rural and part suburban area. This selection of eye disease therefore excludes some of the rare conditions, but includes those common problems that can worry not only the busy family doctor, but also the hard pressed medical student. 7 Anatomy and Physiology The sense of vision depends on the integrity of a set of Internal Eye anatomical and physiological factors, a study of which The eye consists of three concentric layers. The outer will simplify the understanding of ocular disease. most fibrous sclera is opaque and accounts for five sixths of the globe. It is continued anteriorly into the External Eye transparent cornea. The middle vascular coat or uveal The eyeball lies in the anterior part of the orbit, which tract is made up of the choroid, ciliary body and iris. is approximately pyramidal in shape. The bony orbital The innermost layer is the light sensitive retina formed margin, which outlines the base of the pyramid, affords embryologically from the forebrain vesicle.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 10:49:21',NULL,NULL);
INSERT INTO `biblio` VALUES (791,32,'Basic & clinical pharmacology','','14th','',250,'2018','xi, 1250 pages : illustrations (chiefly color)','','','en',NULL,149,'','Contents Sect. I: Basic principles -- Sect. II: Autonomic drugs -- Sect. III: Cardiovascular-renal drugs -- Sect. IV: Drugs with important actions on smooth muscle -- Sect. V: Drugs that act in the central nervous system -- Sect. VI: Drugs used to treat diseases of the blood, inflammation, & gout -- Sect. VII: Endocrine drugs -- Sect. VIII: Chemotherapeutic drugs -- Sect. IX: Toxicology -- Sect. X: Special topics.\r\n  Abstract \"The fourteenth edition of Basic & Clinical Pharmacology continues the extensive use of full-color illustrations and expanded coverage of transporters, pharmacogenomics, and new drugs of all types emphasized in prior editions. In addition, it reflects the major expansion of large-molecule drugs in the pharmacopeia, with numerous new monoclonal antibodies and other biologic agents. Case studies accompany most chapters, and answers to questions posed in the case studies appear at the end of each chapter. The book is designed to provide a comprehensive, authoritative, and readable pharmacology textbook for students in the health sciences. Frequent revision is necessary to keep pace with the rapid changes in pharmacology and therapeutics; the 2-3 year revision cycle of this text is among the shortest in the field, and the availability of an online version provides even greater currency. The book also offers special features that make it a useful reference for house officers and practicing clinicians.\"',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 10:52:25',NULL,NULL);
INSERT INTO `biblio` VALUES (792,32,'Basic concepts of psychiatric-mental health nursing','','8th','',20,'2012','xviii, 654 pages : color illustrations','','','en',NULL,149,'','Contents Psychiatric-mental health nursing. Self-awareness ; History and trends in psychiatric-mental health nursing ; Development of psychiatric-mental health nursing theory -- Special issues related to psychiatric-mental health nursing. Spiritual, cultural, and ethnic issues ; Ethical and legal issues ; Forensic nursing practice ; Loss, grief, and end-of-life care ; Continuum of care -- Components of the nurse-client relationship. Assessment of psychiatric-mental health clients ; Nursing diagnosis, outcome identification, planning, implementation, and evaluation ; Therapeutic communication and relationships ; The therapeutic milieu -- Interactive therapies. Crisis and disaster intervention ; Individual psychotherapy ; Family, couple, and group therapy -- Special treatment modalities. Psychopharmacology ; Somatic therapies ; Complementary and alternative medicine -- Clients with psychiatric disorders. Anxiety disorders ; Somatoform and dissociative disorders ; Mood disorders ; Schizophrenia and schizophrenic-like disorders ; Eating disorders ; Personality development and personality disorders ; Substance-related disorders ; Sexuality and sexual disorders ; Cognitive disorders ; Delusional and shared psychotic disorders -- Special populations. Infant, child, and adolescent clients ; Aging clients with psychosocial needs ; Suicidal clients ; Clients with a dual diagnosis ; Clients experiencing abuse and violence ; Clients coping with acquired immunodeficiency syndrome (AIDS) ; Seriously and persistently mentally ill, homeless, or incarcerated clients.\r\n  Abstract This 8th edition has been updates for currency and retains key features that have been well-received in previous editions, specifically self-awareness prompts, clinical examples, and recurring boxes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 10:55:45',NULL,NULL);
INSERT INTO `biblio` VALUES (793,32,'Basic science in obstetrics and gynaecology : a textbook for MRCOG Part I','','4th','',13,'2010','viii, 386 pages : illustrations','','','en',NULL,10,'','Contents Structure and function of the genome / Peter Dixon -- Clinical genetics / Dorothy Trump -- Embryology / Kate Hardy -- Fetal and placental physiology / Sailesh Kumar -- Applied anatomy / Sarah Paterson-Brown -- Pathology / Neil Sebire -- Microbiology and virology / Geoffrey Ridgway & Paul Taylor -- Immunology / Andrew George -- Biochemistry / Fiona Lyall -- Physiology / David Williams, Anna Kenyon & Dawn Adamson -- Endocrinology / Mark Johnson -- Drugs and drug therapy / Hassan Shehata -- Physics / David Talbot -- Statistics and evidence-based health care / Louise Brown -- Clinical research methodology / Andrew Shennan & Annette Briley -- Multiple choice questions.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 11:46:26',NULL,NULL);
INSERT INTO `biblio` VALUES (794,32,'Chapman\'s orthopaedic surgery','','3rd','',63,'2001','4 volumes (xxxi, 4601, 97 pages) : illustrations','','','en',NULL,11,'','Contents Surgical principles and techniques -- Fractures, dislocations, nonunions, and malunions -- The hand -- Sports Medicine -- Joint reconstruction, arthritis, and arthrosplasty -- The foot -- Neoplastic, infections, neurologic and other skeletal disorders -- The spine -- Pediatric disorders.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 11:58:44',NULL,NULL);
INSERT INTO `biblio` VALUES (795,32,'Cloherty and Stark\'s manual of neonatal care','','8th','',253,'2017','1,068 pages : illustrations','','','en',NULL,11,'','Contents Section I: Prenatal assessment and conditions. Fetal assessment and prenatal diagnosis -- Maternal diabetes mellitus -- Preeclampsia and related conditions -- Section II: Assessment and treatment in the immediate postnatal period. Resuscitation in the delivery room -- Non-immune hydrops fetalis -- Birth trauma -- Identifying the high-risk newborn and evaluating gestational age, prematurity, postmaturity, large-for-gestational age, and small-for-gestational age infants -- Assessment of the newborn history and physical examination of the newborn -- Nursery care of the well newborn -- Section III: General newborn condition. Genetic issues presenting in the nursery -- Multiple births -- Maternal drug use, infant exposure and neonatal abstinence syndrome -- Care of the extremely low-birth-weight infant -- Developmentally supportive care -- Temperature control -- Follow-up care of very low-birth-weight infants -- Neonatal transport -- NICU discharge planning -- Decision-making and ethical dilemmas -- Management of neonatal death and bereavement follow-up -- Section IV: Fluid electrolytes nutrition, gastrointestinal and renal issues. Nutrition -- Breastfeeding and maternal medications -- Fluid and electrolyte management -- Hypoglycemia and hyperglycemia -- Abnormalities of serum calcium -- Neonatal hyperbilirubinemia -- Necrotizing enterocolitis -- Neonatal kidney conditions -- Section V: Respiratory disorders. Mechanical ventilation. Blood gas and pulmonary function monitoring -- Apnea -- Transient tachypnea of the newborn -- Respiratory distress syndrome -- Bronchopulmonary dysplasia/chronic lung disease -- Meconium aspiration -- Persistent pulmonary hypertension of the newborn -- Pulmonary hemorrhage -- Pulmonary air leak -- Extracorporeal membrane oxygenation -- Section VI: Cardiovascular disorders. Shock -- Cardiac disorders -- Section VII: Hematologic disorders. Blood products used in newborns -- Bleeding -- Neonatal thrombosis -- Anemia -- Polycythemia -- Thrombocytopenia -- Section VIII: Infectious diseases. Viral infections -- Bacterial and fungal infections -- Congenital toxoplasmosis -- Syphilis -- Tuberculosis -- Lyme disease -- Section IX: Neurologic disorders -- Intracranial hemorrhage/PVL -- Perinatal asphyxia -- Neonatal seizures -- Neural tube defects -- Section X: Bone conditions. Orthopaedic problems -- Osteopenia (metabolic bone disease) of prematurity -- Section XI: Metabolism. Inborn errors of metabolism -- Section XII: Endocrinology. Thyroid disorders -- Neonatal effects of maternal diabetes -- Disorders of sex development -- Section XIII: Surgery. Surgical emergencies in the newborn -- Section XIV: Dermatology. Skin care -- Section XV: Vascular anomolies -- Section XVI: Auditory and ophthalmologic disorders. Retinopathy of prematurity -- Hearing loss in neonatal intensive care unit graduates -- Section XVII: Common neonatal procedures. Common neonatal procedures and premedication -- Section XVIII: Pain and stress control. Preventing and treating pain and stress among infants in the newborn intensive care unit -- Appendices. Common NICU medication guidelines -- Appendix B: Effects of maternal drugs on the fetus -- IBC drug dosing guide -- IFC intubation sedation guidelines.\r\n  Abstract \"Concise and easy to read, this popular manual has provided a practical approach to the diagnosis and medical management of problems in the newborn through seven outstanding editions. The Eighth Edition of Cloherty and Stark\'s Manual of Neonatal Care maintains that tradition of excellence, offering NICU physicians, neonatal-perinatal fellows, residents, and neonatal nurse practitioners quick access to key clinical information, fully updated to reflect recent advances in the field. Written in an easy-access outline format, this extensively revised edition covers current, practical approaches to the evaluation and management of routine and complex conditions encountered in the fetus and the newborn\".',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 11:59:48',NULL,NULL);
INSERT INTO `biblio` VALUES (796,32,'Comprehensive gynecology','','7th','',254,'2016','xii, 956 pages : illustrations (chiefly color)','','','en',NULL,11,'','Includes bibliographical references.\r\n1. Fertilization and Embryogenesis 2. Reproductive Genetics 3. Reproductive Anatomy 4. Reproductive Endocrinology 5. Evidence-Based Medicine and Clinical Epidemiology 6. Medical-Legal Risk Management 7. History, Physical Examination, and Preventive Health Care 8. Interaction of Medical Diseases and Female Physiology 9. Emotional Aspects of Gynecology 10. Endoscopy: Hysteroscopy and Laparoscopy 11. Congenital Abnormalities of the Female Reproductive Tract 12. Pediatric and Adolescent Gynecology 13. Family Planning 14. Menopause and Care of the Mature Woman 15. Breast Diseases 16. Spontaneous Abortion and Recurrent Pregnancy Loss 17. Ectopic Pregnancy 18. Benign Gynecologic Lesions 19. Endometriosis 20. Anatomic Defects of the Abdominal Wall and Pelvic Floor 21. Lower Urinary Tract Function and Disorders 22. Anal Incontinence 23. Genital Tract Infections 24. Preoperative Counseling and Management 25. Perioperative Management of Complications 26. Abnormal Uterine Bleeding 27. Principles of Radiation Therapy and Chemotherapy in Gynecologic Cancer 28. Intraepithelial Neoplasia of the Lower Genital Tract (Cervix, Vagina, Vulva) 29. Malignant Diseases of the Cervix 30. Neoplastic Diseases of the Vulva 31. Malignant Diseases of the Vagina 32. Neoplastic Diseases of the Uterus 33. Neoplastic Diseases of the Ovary 34. Fallopian Tube and Peritoneal Carcinoma 35. Gestational Trophoblastic Disease 36. Molecular Oncology in Gynecologic Cancer 37. Primary and Secondary Dysmenorrhea, Premenstrual Syndrome, and Premenstrual Dysphoric Disorder 38. Primary and Secondary Amenorrhea and Precocious Puberty 39. Hyperprolactinemia, Galactorrhea, and Pituitary Adenomas 40. Hyperandrogenism and Androgen Excess 41. Polycystic Ovary Syndrome 42. Infertility 43. In Vitro Fertilization.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 12:01:57',NULL,NULL);
INSERT INTO `biblio` VALUES (797,32,'Contemporary psychiatric-mental health nursing','','3rd','',224,'2013','xxxiii, 806 pages : color illustrations','','','en',NULL,47,'','Contents Mental health, mental disorder, and psychiatric-mental health clients : Who are they? -- Psychiatric-mental health nurses : Who are they? -- Self-awareness and the psychiatric-mental health nurse -- The therapeutic nurse-client relationship -- Theories for interdisciplinary care in psychiatry -- The biologic basis of behavioral and mental disorders -- The science of psychopharmacology -- Stress, anxiety, and coping -- Cultural competence -- Therapeutic communication -- Psychiatric-mental health assessment -- Ethics, clients\' rights, and legal and forensic issues -- Creating hospital and community-based therapeutic environments -- Cognitive disorders -- Substance-related disorders -- Schizophrenia -- Mood disorders -- Anxiety disorders -- Dissociative, somatoform, and factitious disorders -- Gender identity and sexual disorders -- Eating disorders -- Personality disorders -- Clients at risk for suicide and self-destructive behavior -- Intrafamily violence : Physical and sexual abuse -- Children -- Adolescents -- Elders -- Therapeutic groups -- Family-focused interventions -- Cognitive and behavioral interventions -- Psychopharmacologic nursing interventions -- Recovery and psychiatric rehabilitation strategies -- Complementary, alternative, and integrative healing practices -- Crisis intervention -- Anger management and intervention in psychiatric-mental health settings -- Appendix A : DSM-IV-TR classification -- Index.\r\n  Abstract CONTEMPORARY PSYCHIATRIC-MENTAL HEALTH NURSING, 3/e is the most up-to-date, evidence-based, culturally competent, authoritative, and comprehensive resource for psychiatric-mental health nursing. The authors emphasize the importance of empathy and client empowerment, while providing the knowledge and clinical competence that psychiatric-mental health nurses can use to help diverse clients heal on both psychobiologic and spiritual levels. They prepare students to tailor and humanize interventions for traditional as well as \"new\" psychiatric-mental health clients encountered in forensic settings, homeless shelters, and in other community and rehab settings. Since advances in neuroscience and genetics are redefining the scientific understanding of mental disorders, the authors offer a solid grounding in psychobiology, including brain imaging assessment and new psychopharmacologic treatment options. This edition adds a full chapter on Recovery and Psychiatric Rehabilitation Strategies, and many new boxed features showing how psychiatric disorders are portrayed in the news and movies.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 12:03:00',NULL,NULL);
INSERT INTO `biblio` VALUES (798,32,'Daily readings from Love your life : devotions for living happy, healthy, and whole','','1st','',255,'2011','289 pages','','','en',NULL,8,'','Contents Understanding your influence -- Living with confidence -- Embracing what\'s important -- Keeping the right perspective -- Making the most of what you have -- Recovering lost opportunities -- Overcoming offenses -- Enjoying rich relationships -- Discovering what others need -- Being a people builder -- Receiving love.\r\n  Abstract A guide to help you transform your life and love it more. Each reading offers insight, scriptures, stories, and uplifting messages focusing on the eleven themes found in the book Love your life.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 12:04:20',NULL,NULL);
INSERT INTO `biblio` VALUES (799,32,'Digital health entrepreneurship','','1st','',203,'2019','VIII, 226 pages 19 illustrations, 15 illustrations','','','en',NULL,151,'','Contents Introduction -- Overview of digital health technologies and applications -- Digital health startup overview -- Regulatory affairs -- Protecting your digital health intellectual property -- Financing your digital health venture -- Digital health business models -- Legal environment of digital health -- Overcoming the barriers to dissemination and implementation -- Digital health cybersecurity -- Summary.\r\n  Abstract This book presents a hands on approach to the digital health innovation and entrepreneurship roadmap for digital health entrepreneurs and medical professionals who are dissatisfied with the existing literature on or are contemplating getting involved in digital health entrepreneurship. Topics covered include regulatory affairs featuring detailed guidance on the legal environment, protecting digital health intellectual property in software, hardware and business processes, financing a digital health start up, cybersecurity best practice, and digital health business model testing for desirability, feasibility, and viability. Digital Health Entrepreneurship is directed to clinicians and other digital health entrepreneurs and stresses an interdisciplinary approach to product development, deployment, dissemination and implementation. It therefore provides an ideal resource for medical professionals across a broad range of disciplines seeking a greater understanding of digital health innovation and entrepreneurship.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 12:05:18',NULL,NULL);
INSERT INTO `biblio` VALUES (800,32,'Essentials of nursing informatics','','6th','',226,'2015','xxiii, 886 pages : illustrations','','','en',NULL,8,'','Contents Nursing informatics technologies -- System life cycle -- Informatics theory standards -- foundations of nursing informatics -- Nursing informatics leadership -- Advanced nursing informatics in practice -- Nursing informatics -- complex applications -- Educational applications -- Research applications -- Big data initiatives -- International perspectives.\r\n  Abstract \"Written by leaders in nursing informatics, this comprehensive up-to-date text helps you understand how informatics can enhance every aspect of the nursing profession. This edition of Essentials of Nursing Informatics is highlighted by an outstanding team of international contributors and content that reflects the very latest concepts, technologies, policies, and required skills.\"',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 12:07:58',NULL,NULL);
INSERT INTO `biblio` VALUES (801,32,'Family planning : a global handbook for providers','','','',256,'2007','xii, 372 pages : illustrations, photographs','','','en',NULL,22,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 12:13:26',NULL,NULL);
INSERT INTO `biblio` VALUES (802,32,'First aid manual : the authorised manual of St John Ambulance, St Andrews First Aid and the British Red Cross','','Revised 10th','',108,'2016','288 pages : illustrations (colour)','','','en',NULL,7,'','Abstract \'First Aid Manual\' covers all aspects of first aid, from emergency first aid and first aid for babies and children, to resuscitation. Find out how to treat over 100 different conditions, from splinters and sprained ankles, to strokes and unconsciousness and how to use essential equipment.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 12:43:53',NULL,NULL);
INSERT INTO `biblio` VALUES (803,32,'Formational units in sign languages','','','',257,'2011','352 p.','','','en',NULL,152,'','Contents Introduction: Phonetics, Phonology, Iconicity and Innateness; Part I. Observation; Marked Hand Configurations in Asian Sign Languages; The phonetics and phonology of the TID (Turkish Sign Language) bimanual alphabet; Child-directed signing as a linguistic register; Part II. Experiment; Sign language comprehension: Insights from misperceptions of different phonological parameters; Lexical and Articulatory Influences on Phonological Processing in Taiwan Sign Language; When does a system become phonological? Potential sources of handshape contrast in sign languages\r\nA phonological awareness test for deaf children using Brazilian Sign LanguagePhonological category resolution in a new Sign Language: A comparative study of handshapes; American Sign Language Tone and Intonation: A Phonetic Analysis of Eyebrow Properties; Part III. Theory; Are dynamic features required in signs?; A constraint-based account of distributional differences in handshapes; ASL Movement Phonemes and Allophones; Movement types, Repetition, and Feature Organization in Hong Kong Sign Language; Language index; Subject index\r\n  Abstract Sign languages and spoken languages have many fascinating differences, caused primarily by the reaction of the human mind to different modalities, but also by some important social differences. This book examines the effects of these and other differences on sign language phonology and phonetics using observation, experimentation and theory. Languages examined include Asian, Middle Eastern, European and American sign languages, and language situations include home signers and small village signers, children, gesturers, adult signers and non-native signers.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 12:45:53',NULL,NULL);
INSERT INTO `biblio` VALUES (804,32,'Foundations of nursing research','','7th','',224,'2018','xxiv, 403 pages','','','en',NULL,149,'','Contents Pt. I: Introduction to nursing research -- Development of nursing research -- Evidence-based nursing practice -- Research evidence in nursing practice -- Ethical issues in nursing research -- An overview of quantitative and qualitative research -- Pt. II: Preliminary steps in the research process -- Identifying research problems -- Review of the literature -- Theory and nursing research -- Hypotheses -- Pt. III: Research designs -- Quantitative research designs -- Qualitative and mixed methods research designs -- Pt. IV: Obtaining study participants and collection of data -- Populations and samples -- Measurement and data collection -- Data-collection methods -- Pt. V: Data analysis -- Descriptive statistics -- Inferential statistics -- Presectation and discussion of study findings -- Pt. VI: Research findings and nursing practice -- Communication and utilization of nursing research -- Nursing research and healthcare economics -- Critique of research reports.\r\n  Abstract \"Illuminates all steps of the nursing research process, helping students understand the importance of research to evidence-based nursing practice, evaluate and critique research, and determine whether study findings are ready to apply in practice. Its conversational tone explains research simply and clearly\".',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 12:47:59',NULL,NULL);
INSERT INTO `biblio` VALUES (805,32,'Fundamentals of anatomy and physiology for nursing and healthcare students','','2nd','',258,'2016','(xl, 614 pages) : color illustrations','','','en',NULL,136,'','Contents Basic scientific principles of physiology / Peter S. Vickers -- Cells, cellular compartments, transport systems, fluid movement between compartments / Muralitharan Nair -- Genetics / Peter S. Vickers -- Tissue / Anthony Wheeldon -- The skeletal system / Ian Peate -- The muscular system / Janet G. Migliozzi -- Circulatory system / Muralitharan Nair -- The cardiac system / Carl Clare -- The digestive system / Louise McErlean -- The renal system / Muralitharan Nair -- The respiratory system / Anthony Wheeldon -- The reproductive systems / Ian Peate -- The nervous system / Louise McErlean and Janet G. Migliozzi -- The senses / Carl Clare -- The endocrine system / Carl Clare -- The immune system / Peter S. Vickers -- The skin / Ian Peate.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 12:51:44',NULL,NULL);
INSERT INTO `biblio` VALUES (806,32,'Gynaecology by Ten Teachers','','19th','',259,'2011','217 pages','','','en',NULL,7,'','Contents Cover; Book title; Contents; The Ten Teachers; Acknowledgements; Commonly used abbreviations; CHAPTER 1 The gynaecological history and examination; CHAPTER 2 Embryology and anatomy; CHAPTER 3 Normal and abnormal sexual development and puberty; CHAPTER 4 The normal menstrual cycle; CHAPTER 5 Disorders of the menstrual cycle; CHAPTER 6 Genital infections in gynaecology; CHAPTER 7 Fertility control, contraception and abortion; CHAPTER 8 Subfertility; CHAPTER 9 Problems in early pregnancy; CHAPTER 10 Benign diseases of the uterus and cervix; CHAPTER 11 Endometriosis and adenomyosis\r\nCHAPTER 12 Diseases of the ovaryCHAPTER 13 Malignant disease of the uterus; CHAPTER 14 Premalignant and malignant disease of the cervix; CHAPTER 15 Conditions affecting the vagina and vulva; CHAPTER 16 Urogynaecology; CHAPTER 17 Pelvic organ prolapse; CHAPTER 18 The menopause; CHAPTER 19 Psychosocial and ethical aspects of gynaecology; Appendix 1; Appendix 2; Index\r\n  Abstract A thoroughly-revised edition of this highly successful and much-loved obstetrics and gynaecology duo.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 12:53:52',NULL,NULL);
INSERT INTO `biblio` VALUES (807,32,'Gynaecology by ten teachers','','20th','',260,'2017','xviii, 254 pages','','','en',NULL,143,'','Contents The development and anatomy of the female sexual organs and pelvis -- Gynaecological history, examination and investigations -- Hormonal control of the menstrual cycle and hormonal disorders -- Disorders of menstrual bleeding -- Implantation and early pregnancy -- Contraception -- Sub-fertility -- The menopause and post reproductive health -- Genitourinary problems -- Urogynaecology and pelvic floor problems -- Benign conditions of the ovary and pelvis -- Benign conditions of the uterus, cervix and endometrium -- Benign conditions of the vulva and vagina and psychosexual disorders -- Malignant disease of the ovary -- Malignant disease of the uterus -- Premalignant and malignant disease of the lower genital tract -- Gynaecological surgery and therapeutics.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 12:55:49',NULL,NULL);
INSERT INTO `biblio` VALUES (808,32,'Hacker & Moore\'s essentials of obstetrics & gynecology','','6th','',254,'2016','xii, 497 pages : color illustrations','','','en',NULL,78,'','Contents Part I: Introduction -- A life-course perspective for women\'s health care / Calvin J. Hobel and Joseph C. Gambone -- Clinical approach to the patient / Joseph C. Gambone -- Female reproductive anatomy and embryology / Joseph C. Gambone -- Female reprodutive physiology / Joseph C. Gambone.\r\nPart II: Obstetrics -- Endocrinology of pregnancy and parturition / Joseph C. Gambone and Calvin J. Hobel -- Maternal physiologic and immunologic adaptation to pregnancy / Brian J. Koos and Calvin J. Hobel -- Antepartum care / Calvin J. Hobel and John Williams III -- Normal labor, delivery, and postpartum care / Calvin J. Hobel and Mark Zakowski -- Fetal surveillance during labor / Calvin J. Hobel and Amy R. Lamb -- Obstetric hemorrhage / Calvin J. Hobel and Amy R. Lamb -- Uterine contractility and dystocia / Calvin J. Hobel and Amy R. Lamb -- Obstetric complications / Calvin J. Hobel -- Multifetal gestation and malpresentation / Calvin J. Hobel -- Hypertensive disorders of pregnancy / Lony C. Castro and Calvin J. Hobel -- Rhesus alloimmunization / Lony C. Castro and Calvin J. Hobel -- Common medical and surgical consitions complicating pregnancy / Lony C. Castro and Joseph C. Gambone -- Obstetric procedures / Calvin J. Hobel.\r\nPart III: Gynecology -- Benign conditions and congenital anomalies of the vulva and vagina / Anita L. Nelson and Joseph C. Gambone -- Benign conditions and congenital anomalies of the uterine corpus and cervix / William H. Parker and Joseph C. Gambone -- Benign conditions and congenital anomalies of the ovaries and fallopian tubes / William H. Parker and Joseph C. Gambone -- Pelvic pain / Andrea J. Rapkin and Joseph C. Gambone -- Infectious diseases of the female reproductive and urinary tract / Bassam H. Rimawi and David E. Soper -- Pelvic floor disorders / Amy E. Rosenman -- Ectopic pregnancy / Anita L. Nelson and Joseph C. Gambone -- Endometriosis and adenomyosis / Joseph C. Gambone -- Abnormal uterine bleeding / Anita L. Nelson and Joseph C. Gambone -- Family planning / Anita L. Nelson -- Sexuality and female sexual dysfunction / Joseph C. Gambone -- Intimate partner and family violence, sexual assault, and rape / Joseph C. Gambone -- Breast disease / Neville F. Hacker and Michael L. Friedlander -- Gynecologic procedures / Joseph C. Gambone.\r\nPart IV: Reproductive endocrinology and infertility -- Puberty and disorders of pubertal development / Sara Churchill and Carolyn J. Alexander -- Amenorrhea, oligomenorrhea, and hyperandrogenic disorders / Daniel A. Dumesic and Joseph C. Gambone -- Infertility and assisted reproductive technologies / Joseph C. Gambone and Ingrid A. Rodi -- Menopause and perimenopause / Joseph C. Gambone -- Menstrual cycle-influenced disorders / Joseph C. Gambone.\r\nPart V: Gynecologic oncology -- Principles of cancer therapy / Neville F. Hacker -- Cervical dysplasia and cancer / Neville F. Hacker -- Ovarian, fallopian tube, and peritoneal cancer / Jonathan S. Berek -- Vulvar and vaginal cancer / Neville F. Hacker -- Uterine corpus cancer / Neville F. Hacker -- Gestational trophoblastic diseases / Jonathan S. Berek.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 13:13:25',NULL,NULL);
INSERT INTO `biblio` VALUES (809,32,'Health education and health promotion','','','',261,'2004','(285 pages) : illustrations, portraits','','','en',NULL,153,'','Abstract This book is a comprehensive resource for theory, research and action in health education and health promotion. The authors describe strategies and actions for health education and health promotion based on theories for understanding, predicting and changing behavioural, social and environmental determinants of health. The book also offers a conceptual framework for planning, evaluation and research and discusses ethical issues in health promotion. Health education and health promotion is addressed to bachelor and masters students, scholars, practitioners, policymakers and change managers. It offers a useful guide for a variety of professional and volunteer organisations and their workers, such as health service managers and environmental health officers, community nurses and dieticians, midwives and paediatricians, dentists, general practitioners, epidemiologists as well as psychologists, sociologists and social workers. This is a useful guide for all those who carry.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 13:14:13',NULL,NULL);
INSERT INTO `biblio` VALUES (810,32,'Introducing psychology for nurses and healthcare professionals','','','',224,'2010','xiv, 274 pages : illustrations, portraits','','','en',NULL,154,'','Contents Introduction: psychology in nursing care -- Psychological approaches to understanding people -- Psychology across the lifespan -- Social processes -- Perception, memory and providing information -- Stress and stress management -- The psychology of pain.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 13:15:22',NULL,NULL);
INSERT INTO `biblio` VALUES (811,32,'Introduction to maternity and pediatric nursing','','8th','',254,'2019','xxiii, 855 pages : illustrations (some color)','','','en',NULL,125,'','Contents The past, present, and future -- Human reproductive anatomy and physiology -- Fetal development -- Prenatal care and adaptations to pregnancy -- Nursing care of women with complications during pregnancy -- Nursing care of mother and infant during labor and birth -- Nursing management of pain during labor and birth -- Nursing care of women with complications during labor and birth -- The family after birth -- Nursing care of women with complications after birth -- The nurse\'s role in women\'s health care -- The term newborn -- Preterm and postterm newborns -- The newborn with a perinatal injury or congenital malformation -- An overview of growth, development, and nutrition -- The infant -- The toddler -- The preschool child -- The school-age child -- The adolescent -- The child\'s experience of hospitalization -- Health care adaptations for the child and family -- The child with a sensory or neurological condition -- The child with a musculoskeletal condition -- The child with a respiratory disorder -- The child with a cardiovascular disorder -- The child with a condition of the blood, blood-forming organs, or lymphatic system -- The child with a gastrointestinal condition -- The child with a genitourinary condition -- The child with a skin condition -- The child with a metabolic condition -- Childhood communicable diseases, bioterrorism, natural disasters, and the maternal-child patient -- The child with an emotional or behavioral condition -- Complementary and alternative therapies in maternity and pediatric nursing.\r\n  Abstract Get a solid foundation in maternity and pediatric nursing! Written in a clear, concise, friendly style, \"Introduction to Maternity and Pediatric Nursing, 8th Edition\" is the complete guide to caring for maternity and pediatric patients. This best-selling text is organized by developmental stages, discussions of pediatric disorders by body system from simple-to-complex and health-to-illness, and includes a focus on family health. This edition also contains newly updated NCLEX style review questions, new case studies, new content on zika virus, QSEN and safety, and expanded phases of pregnancy. -- From product description.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 18:28:37',NULL,NULL);
INSERT INTO `biblio` VALUES (812,32,'Introduction to psychology : gateways to mind and behavior','','13th','',262,'2013','1 volume (various pagings) : illustrations','','','en',NULL,90,'','Contents Introduction to psychology and research methods -- Brain and behavior -- Human development -- Sensation and perception -- States of consciousness -- Conditioning and learning -- Memory -- Cognition, language, and creativity -- Intelligence -- Motivation and emotion -- Sex, gender, and sexuality -- Personality -- Health, stress, and coping -- Psychological disorders -- Therapies -- Social thinking and social influence -- Prosocial and antisocial behavior -- Applied psychology.\r\n  Abstract The Thirteenth Edition\'s hallmark continues to be its pioneering integration of the proven-effective SQ4R learning system (Survey, Question, Read, Reflect, Review, Recite), which promotes critical thinking as it guides students step-by-step to an understanding of psychology\'s broad concepts and diversity of topics. Throughout every chapter, these active learning tools, together with the book\'s example-laced writing style, discussions of positive psychology, cutting-edge coverage of the field\'s new research findings, and excellent media resources, ensure that users find the study of psychology fascinating, relevant, and above all, accessible.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 18:31:46',NULL,NULL);
INSERT INTO `biblio` VALUES (813,32,'Jawetz, Melnick & Adelberg\'s medical microbiology','','28th','',226,'2019','x, 867 pages : illustrations','','','en',NULL,69,'','Contents Fundamentals of microbiology -- Immunology -- Bacteriology -- Virology -- Mycology -- Parasitology -- Diagnostic medical microbiology and clinical correlation -- Review questions.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 18:39:48',NULL,NULL);
INSERT INTO `biblio` VALUES (814,32,'Kozier & Erb\'s fundamentals of nursing : concepts, practice, and process','','10th','',224,'2016','xxvi, 1486 pages : illustrations, portraits','','','en',NULL,47,'','Contents Historical and contemporary nursing practice -- Evidence-based practice and research in nursing -- Nursing theories and conceptual frameworks -- Legal aspects of nursing -- Values, ethics, and advocacy -- Health care delivery systems -- Community nursing and care continuity -- Home care -- Electronic health records and information technology -- Critical thinking and clinical reasoning -- Assessing -- Diagnosing -- Planning -- Implementing and evaluating -- Documenting and reporting -- Health promotion -- Health, wellness, and illness -- Culturally responsive nursing care -- Complementary and alternative healing modalities -- Concepts of growth and development -- Promoting health from conception through adolescence -- Promoting health in young and middle-aged adults -- Promoting health in older adults -- Promoting family health -- Caring -- Communicating -- Teaching -- Leading, managing, and delegating -- Vital signs -- Health assessment -- Asepsis -- Safety -- Hygiene -- Diagnostic testing -- Medications -- Skin integrity and wound care -- Perioperative nursing -- Sensory perception -- Self-concept -- Sexuality -- Spirituality -- Stress and coping -- Loss, grieving, and death -- Activity and exercise -- Sleep -- Pain management -- Nutrition -- Urinary elimination -- Fecal elimination -- Oxygenation -- Circulation -- Fluid, electrolyte, and acid-base balance.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 18:42:53',NULL,NULL);
INSERT INTO `biblio` VALUES (815,32,'Manson\'s tropical diseases','','23rd','',263,'2014','illustrations (chiefly color), maps (chiefly color','','','en',NULL,11,'','Contents History of Tropical Medicine, and Medicine in the Tropics -- Global Health -- Global Health Governance and Tropical Diseases -- The Economic Case for Devoting Public Resources to Health -- Ethics and Tropical Diseases : Some Global Considerations -- Issues and Challenges of Public-Health Research in Developing Countries -- Emergency and Intensive Care Medicine in Resource-Poor Settings -- Ultrasound in Tropical Medicine -- HIV : Epidemiology in the Tropics -- Clinical Features and Management of HIV/AIDS -- HIV/AIDS in Children -- HIV/AIDS Prevention -- Viral Hepatitis -- Arbovirus Infections -- Dengue -- Viral Haemorrhagic Fevers -- Rabies -- Rotavirus and Other Viral Diarrhoea -- Respiratory Viruses and Atypical Bacteria -- Viral Exanthems -- Virus Infections of the Nervous System -- Tropical Rickettsial Infections -- Sexually Transmitted Infections (Excluding HIV) -- Bacterial Enteropathogens -- Salmonella Infections -- Pneumococcal Disease -- Bacterial Meningitis -- Brucellosis -- Noma, Actinomycosis and Nocardia -- Bartonellosis, Cat-scratch Disease, Trench Fever, Human Ehrlichiosis -- Anthrax -- Tetanus -- Plague -- Melioidosis -- Diphtheria -- Endemic Treponematosis Including Yaws and Other Spirochaetes -- Leptospirosis -- Fungal Infections -- Pneumocystis jirovecii Infection -- Tuberculosis.\r\nLeprosy -- Mycobacterium ulcerans Disease -- Malaria -- Babesiosis -- Human African Trypanosomiasis -- American Trypanosomiasis : Chagas Disease -- Leishmaniasis -- Toxoplasmosis -- Intestinal Protozoa -- Pathogenic and Opportunistic Free-living Amoebae : Agents of Human and Animal Disease -- Trichomonas vaginalis -- Schistosomiasis -- Food-borne Trematodes -- The Filariases -- Soil-transmitted Helminths (Geohelminths) -- Echinococcosis -- Other Cestode Infections : Intestinal Cestodes, Cysticercosis, Other Larval Cestode Infections -- Scabies -- Louse Infestation -- Other Ectoparasites : Leeches, Myiasis and Sand Fleas -- Non-communicable Diseases : Equity, Action and Targets -- Cardiovascular and Vascular Disease in the Tropics Including Stroke, Hypertension and Ischaemic Heart Disease -- Diabetes in the Tropics -- Cancer in the Tropics -- Haematological Diseases in the Tropics -- Renal Disease in the Tropics -- Ophthalmology in the Tropics and Sub-tropics -- Dermatological Problems -- Musculoskeletal -- Respiratory Problems in the TropicsDisorders -- Tropical Neurology -- Pstchiatry -- Tropical Oral Health -- Environmental Stress -- Venomous and Poisonous Animals -- Plant Poisons and Traditional Medicines -- Nutrition-associated Disease -- Obesity in the Tropics -- Obstetrics in the Tropics -- Paediatrics in the Tropics -- Appendix 1 Clinical Laboratory Diagnosis -- Appendix 2 Parasitic Protozoa -- Appendix 3 Medical Helminthology -- Appendix 4 Medical Acarology and Entomology -- Appendix 5 Sources of Information in Tropical Medicine.\r\n  Abstract From the difficult to diagnose to the difficult to treat, Manson\'s Tropical Diseases prepares you to effectively handle whatever your patients may have contracted. Featuring an internationally recognized editorial team, global contributors, and expert authors, this revised and updated medical reference book provides you with the latest coverage on parasitic and infectious diseases from around the world. Incorporate the latest therapies into your practice, such as recently approved drugs and new treatment options. Find what you need easily and apply it quickly with highlighted key information, convenient boxes and tables, extensive cross-referencing, and clinical management diagrams.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 18:49:27',NULL,NULL);
INSERT INTO `biblio` VALUES (816,32,'Medical-surgical nursing : assessment and management of clinical problems','','9th','',264,'2014','2 volumes (xxxi, 1708 pages, 82 variously numbered','','','en',NULL,125,'','Contents Professional nursing practice -- Health disparities and culturally competent care -- Health history and physical examination -- Patient and caregiver teaching -- Chronic illness and older adults -- Complementary and alternative therapies -- Stress and stress management -- Sleep and sleep disorders -- Pain -- Palliative care at end of life -- Substance abuse -- Inflammation and wound healing -- Genetics and genomics -- Altered immune responses and transplantation -- Infection and human immunodeficiency virus infection -- Cancer -- Fluid, electrolyte, and acid-base imbalances -- Nursing management preoperative care -- Nursing management intraoperative care -- Nursing management postoperative care -- Nursing assessment visual and auditory systems -- Nursing management visual and auditory problems -- Nursing assessment integumentary system -- Nursing management integumentary problems -- Nursing management burns -- Nursing assessment respiratory system -- Nursing management upper respiratory problems -- Nursing management lower respiratory problems -- Nursing management obstructive pulmonary diseases -- Nursing assessment hematologic system -- Nursing management hematologic problems -- Nursing assessment cardiovascular system -- Nursing management hypertension -- Nursing management coronary artery disease and acute coronary syndrome -- Nursing management heart failure -- Nursing management dysrhythmias -- Nursing management inflammatory and structural heart disorders -- Nursing management vascular disorders -- Nursing assessment gastrointestinal system -- Nursing management nutritional problems -- Nursing management obesity -- Nursing management upper gastrointestinal problems -- Nursing management lower gastrointestinal problems -- Nursing management liver, pancreas, and biliary tract problems -- Nursing assessment urinary system -- Nursing management renal and urologic problems -- Nursing management acute kidney injury and chronic kidney disease -- Nursing assessment endocrine system -- Nursing management diabetes mellitus -- Nursing management endocrine problems -- Nursing assessment reproductive system -- Nursing management breast disorders -- Nursing management sexually transmitted infections -- Nursing management female reproductive problems -- Nursing management male reproductive problems -- Nursing assessment nervous system -- Nursing management acute intracranial problems -- Nursing management stroke -- Nursing management chronic neurologic problems -- Nursing management Alzheimer\'s disease, dementia, and delirium -- Nursing management peripheral nerve and spinal cord problems -- Nursing assessment musculoskeletal system -- Nursing management musculoskeletal trauma and orthopedic surgery -- Nursing management musculoskeletal problems -- Nursing management arthritis and connective tissue diseases -- Nursing management critical care -- Nursing management shock, systemic inflammatory response syndrome, and multiple organ dysfunction syndrome -- Nursing management respiratory failure and acute respiratory distress syndrome -- Nursing management emergency, terrorism, and disaster nursing -- Appendixes : A. Basic life support for health care providers ; B. Nursing diagnoses ; C. Laboratory reference intervals.\r\n  Abstract Over the past three decades, more and more nursing educators have turned to Lewis: Medical-Surgical Nursing for its accurate and up-to-date coverage of the latest trends, hot topics, and clinical developments in the field of medical-surgical nursing - and the new ninth edition is no exception! Written by a dedicated team of expert authors led by Sharon Lewis, Medical-Surgical Nursing, 9th Edition offers the same easy-to-read style that students have come to love, along with the timely and thoroughly accurate content that educators have come to trust. Completely revised and updated content explores patient care in various clinical settings and focuses on key topics such as prioritization, critical thinking, patient safety, and NCLEX exam preparation. Best of all - a complete collection of interactive student resources creates a more engaging learning environment to prepare you for clinical practice.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 18:55:39',NULL,NULL);
INSERT INTO `biblio` VALUES (817,32,'Mental health issues in primary care : a practical guide','','','',27,'1995','(xi, 143 pages) : illustrations','','','en',NULL,130,'','Contents Mental Health and Illness in Primary Care -- Facilitating Change -- Depression: Cause and Recognition -- Depression: Options for Treatment -- Anxiety and Related Problems -- Schizophrenia in Primary Care -- Prevention of Mental Illness -- Promoting Mental Health -- Meeting the Targets.\r\n  Abstract This book sets out to demystify primary mental health care. It looks at the major mental health problems encountered by doctors and community nurses in general practice, health centres and other primary care settings. It provides a down-to-earth guide for effectively meeting the needs of patients and clients and is based on both current research and practical experience. Written for primary care nurses this book will also be invaluable for health promotion officers, facilitators, FHSA advisers, GPs and anyone wishing to improve the primary care contribution to meeting the Health of the Nation mental illness targets.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 18:56:44',NULL,NULL);
INSERT INTO `biblio` VALUES (818,32,'Sociology and health care : an introduction for nurses, midwives and allied health professionals','','','',51,'2005','','','','en',NULL,29,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 18:57:48',NULL,NULL);
INSERT INTO `biblio` VALUES (819,32,'Microbiology : an introduction','','13th','',224,'2019','1 volume (various pagings) : illustrations (some c','','','en',NULL,47,'','Contents The microbial world and you -- Chemical principles -- Observing microorganisms through a microscope -- Functional anatomy of prokaryotic and eukaryotic cells -- Microbial metabolism -- Microbial growth -- The control of microbial growth -- Microbial genetics -- Biotechnology and DNA technology -- Classification of microorganisms -- The prokaryotes: domains bacteria and archaea -- The eukaryotes: fungi, algae, protozoa, and helminths -- Viruses, viroids, and prions -- Principles of disease and epidemiology -- Microbial mechanisms of pathogenicity -- Innate immunity: nonspecific defenses of the host -- Adaptive immunity: specific defense of the host -- Practical applications of immunology -- Disorders associated with the immune system -- Antimicrobial drugs -- Microbial diseases of the skin and eyes -- Microbial diseases of the nervous system -- Microbial diseases of the cardiovascular and lymphatic systems -- Microbial diseases of the respiratory system -- Microbial diseases of the digestive system -- Microbial diseases of the urinary and reproductive systems -- Environmental microbiology -- Applied and industrial microbiology.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 18:58:41',NULL,NULL);
INSERT INTO `biblio` VALUES (820,32,'Midwifery by Ten Teachers','','','',214,'2014','359 pages','','','en',NULL,132,'','Contents Front Cover; Book title; Contents; The Ten Teachers; Foreword; Preface; Acknowledgements; Abbreviations and conventions; 1. The midwife and modern maternity care; 2. Conception, implantation and embryology; 3. Normal fetal development and growth; 4. Physiological changes in pregnancy; 5. Antenatal care; 6. Antenatal imaging and assessment of fetal well-being; 7. Prenatal diagnosis; 8. Antenatal complications; 9. Multiple pregnancy; 10. Disorders of placentation; 11. Preterm labour; 12. Medical conditions associated with pregnancy; 13. Perinatal infections; 14. Labour.\r\n15. Operative and assisted birth16. Childbirth emergencies; 17. The puerperium; 18. Mental health in pregnancy and the puerperium; 19. Neonatal care; 20. Law and ethics relating to midwifery practice; Appendix: Levels of evidence; Index; A; B; C; D; E; F; G; H; I; J; K; L; M; N; O; P; R; S; T; U; V; W; X; Z; Back Cover.\r\n  Abstract Modern maternity care and the midwife Conception and implantation Normal fetal growth and development Physiological changes in pregnancy Antenatal care Antenatal imaging Prenatal diagnosis Antenatal complications Multiple pregnancy Disorders of placentation Pre-term labour Medical disorders Perinatal infections Labour and delivery Assisted births Obstetric emergencies The puerperium Mental health and childbearing Neonates Law and ethics.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:00:07',NULL,NULL);
INSERT INTO `biblio` VALUES (821,32,'Myles textbook for midwives','','16th','',13,'2014','1016 pages : illustrations','','','en',NULL,16,'','Contents Section 1 The midwife in context -- 1. The midwife in contemporary midwifery practice -- 2. Professional issues concerning the midwife and midwifery practice -- Section 2 Human anatomy and reproduction -- 3. The female pelvis and the reproductive organs -- 4. The female urinary tract -- 5. Hormonal cycles: fertilization and early development -- 6. The placenta -- 7. The fetus -- Section 3 Pregnancy -- 8. Antenatal education for birth and parenting -- 9. Change and adaptation in pregnancy -- 10. Antenatal care -- 11. Antenatal screening of the mother and fetus -- 12. Common problems associated with early and advanced pregnancy -- 13. Medical conditions of significance to midwifery practice -- 14. Multiple pregnancy -- Section 4 Labour -- 15. Care of the perineum, repair and female genital mutilation -- 16. Physiology and care during the first stage of labour -- 17 Physiology and care during the transition and second stage phases of labour -- 18. Physiology and care during the third stage of labour -- 19 Prolonged pregnancy and disorders of uterine action.\r\n20. Malpositions of the occiput and malpresentations -- 21. Operative births -- 22. Midwifery and obstetric emergencies -- Section 5 Puerperium -- 23. Physiology and care during the puerperium -- 24. Physical health problems and complications in the puerperium -- 25. Perinatal mental health -- 26. Bereavement and loss in maternity care -- 27. Contraception and sexual health in a global society -- Section 6 The neonate -- 28. Recognizing the healthy baby at term through examination of the newborn screening -- 29. Resuscitation of the healthy baby at birth: the importance of drying, airway management and establishment of breathing -- 30. The healthy low birth weight baby -- 31. Trauma during birth, haemorrhages and convulsions -- 32. Congenital malformations -- 33 Significant problems in the newborn baby -- 34. Infant feeding.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:05:44',NULL,NULL);
INSERT INTO `biblio` VALUES (822,32,'Natural family planning : a guide to provision of services','','','',21,'1988','vi, 82 pages : illustrations','','','en',NULL,12,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:06:44',NULL,NULL);
INSERT INTO `biblio` VALUES (823,32,'Neeb\'s fundamentals of mental health nursing','','4th','',217,'2014','xvi, 416 pages','','','en',NULL,11,'','Contents History of mental health nursing -- Basics of communications -- Ethics and law -- Developmental psychology throughout the life span -- Sociocultural influences on mental health -- Nursing process in mental health -- Coping and defense mechanisms -- Mental health treatments -- Alternative and complementary treatment modalities -- Anxiety, anxiety-related disorders, and somatoform disorders -- Depressive disorders -- Bipolar disorders -- Suicide -- Personality disorders -- Schizophrenia spectrum and other psychotic disorders -- Neurocognitive disorders : delirium and dementia -- Substance use and addictive disorders -- Eating disorders -- Childhood and adolescent mental health issues -- Postpartum issues in mental health -- Aging population -- Victims of abuse and violence.\r\n  Abstract Now with DSM-5 content!Here\'s the must-know information LPN/LVN students need to care for patients with mental health disorders where they\'ll encounter them-in general patient care settings.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:07:57',NULL,NULL);
INSERT INTO `biblio` VALUES (824,32,'Nurse management demystified','','','',250,'2007','xii, 252 pages','','','en',NULL,8,'','Contents The Evolving Healthcare Delivery System -- Rules and Regulations in the Healthcare System -- Publicly Operated vs. Privately Operated Healthcare Facilities -- Organizational Structure of a Healthcare Facility -- Challenges Facing Hospitals -- Challenges Facing Long-Term Care Facilities -- Challenges Facing Residential Care Facilities -- Challenges Facing Ambulatory Care Centers -- Challenges Facing Home Healthcare Agencies -- Challenges Facing Managed Care Organizations -- Challenges Facing Preferred Provider Organizations -- Work Rules and Unions -- Nursing Leadership and Management -- Nurse Management: A Look Back -- Nurse Manager Roles and Management Styles -- Nursing Leadership -- Standards of Practice of Professional Performance -- Emotional Intelligence -- Nursing Care Delivery Models and Staffing -- What Is a Nursing Care Delivery Model? -- Staffing -- Union and Union Contracts -- Delegation and Supervision -- Crunch Time-The Pressure to Do More with Fewer Staff -- What Is Delegation? -- What Is Supervision? -- Effective Communication and Conflict Resolution -- The Art of Communication -- Conflict Resolution -- Policy -- What Is a Policy -- Creating a Policy -- Work Rules and Policy -- When a Policy Is Not a Policy -- Enforcing Policy -- Policy and Power -- Legal Issues -- Legal Environment -- Legally Prepared -- Nurse Practice Acts -- Exposure to Legal Claims -- Living Wills and Durable Power of Attorney -- Health Insurance Portability and Accountability Act -- Medical Orders -- Personnel Law -- Healthcare Economics -- Basic Economics -- The Development of the Unique U.S. Healthcare Economy -- The Business of Healthcare -- Nurse Managers and Healthcare Economics -- Budget Planning and Financial Management -- Financial Structure of a Healthcare Facility -- The Nurse Manager\'s Fiscal Responsibilities -- Unions, Management, and Employee Relations -- The Changing Labor Environment -- Provoking Unionization -- Unionizing -- Pros and Cons of a Union -- Collective Bargaining -- Negotiating -- The Collective Bargaining Agreement -- On Strike -- Contract Signing -- The Workplace Changes -- Discipline, Suspension, and Terminations -- Time Management -- How Do You Use Your Time? -- It\'s a Matter of Time -- Schedules -- Time Wasters -- Productive Meetings -- Nursing Informatics and Measurement -- What Is Informatics? -- What Is Measurement? -- Electronic Informatics and Measurement -- Nursing Informatics -- Electronic Medical Record -- Technology 101 -- Nursing Informatics Applications in Home Healthcare -- The Informatics Team -- Risk Management -- What Is Risk Management? -- Managing Risk -- The Incident Report -- Common Risk Exposures -- The Risk Management Department -- The Nurse Manager and Managing Risk -- Managing Scarce Resources -- What Is a Scarce Resource? -- Causes of Scarce Resources -- Managing Scarce Resources Using Technology -- Managing Scarce Resources Through Better Organization -- Strategies for Managing Scarce Nonhuman Resources.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:08:47',NULL,NULL);
INSERT INTO `biblio` VALUES (825,32,'Nursing and informatics for the 21st century : an international look at practice, education and EHR trends','','2nd','',265,'2010','','','','en',NULL,149,'','Contents Section 1. Revolutionizing nursing : technology\'s role / Charlotte A. Weaver -- section 2. Nursing education and IT / Connie White Delaney -- section 3. Innovation through applied informatics / Patrick Weber -- section 4. EHR initiatives across the globe / Robyn L. Carr -- section 5. The near future and nursing / Charlotte A. Weaver.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:09:36',NULL,NULL);
INSERT INTO `biblio` VALUES (826,32,'Nursing care plans : guidelines for individualizing client care across the life span','','9th','',217,'2014','xxxii, 951 pages','','','en',NULL,11,'','Contents Issues and trends in nursing and healthcare delivery -- The nursing process : planning care using nursing diagnoses -- Critical thinking : adaptation of theory to practice -- Cardiovascular -- Respiratory -- Neurological/sensory disorders -- Gastrointestinal disorders -- Metabolic and endocrine disorders -- Diseases of the blood/blood-forming organs -- Renal and urinary tract -- Women\'s reproductive -- Orthopedic -- Integumentary -- Systemic infections and immunological disorders -- General.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:11:40',NULL,NULL);
INSERT INTO `biblio` VALUES (827,32,'Nursing in today\'s world : trends, issues & management','','10th','',20,'2012','xvi, 608 p. : ill.','','','en',NULL,11,'','Contents Exploring the growth of nursing as a profession -- Educational preparation for nursing -- Credentials for healthcare providers -- Making professional goals a reality -- The world of healthcare employment -- The healthcare environment and its financing -- Legal responsibilities for practice -- Ethical concerns in nursing practice -- Bioethical issues in healthcare -- Safety concerns in healthcare -- The nursing profession and the community -- Initiating the leadership and management role -- Working with others in a leadership role -- Facing the challenges of todays workplace -- Valuing the political process -- Applying research and technology to nursing practice.','cover_nursing_in_today_s_world_trends_issues_management.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2022-02-17 03:44:24',NULL,NULL);
INSERT INTO `biblio` VALUES (828,32,'Nursing procedures & protocols','','','',63,'2003','x, 661 pages : illustrations','','','en',NULL,11,'','Contents Fundamentals -- Infection control-- Medication administration -- Intravascular therapy -- Cardiovascular care -- Pulmonary care -- Neurologic care -- Gastrointestinal care -- Renal and urologic care -- Musculoskeletal care -- Skin care -- Endocrine and hematologic care.\r\n  Abstract Procedures and Protocols is designed to help nurses react to clinical situations appropriately with little or no guidance from colleagues. Protocols represent the framework for management of a specific disorder or clinical situation, while the procedures that compliment a specific protocol represent the numerous detailed steps for implementing that protocol. This book features over 300 major peer-reviewed protocols and nursing procedures on a wide range of clinical topics. Each procedure is described in sequential step-by-step detail. Also included are over 300 illustrations, checklists, tables, and flowcharts.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:13:27',NULL,NULL);
INSERT INTO `biblio` VALUES (829,32,'Nursing Research in Action : Developing Basic Skills','','2nd','',266,'1994','(XII, 193 pages)','','','en',NULL,7,'','Contents Overview of Research Progress -- Planning Your Research Project -- Searching the Literature -- Approaches to Methodology -- Choosing a Research Method Quantitive -- Methods of Collecting Data -- Qualitative Methods of Collecting Data -- Methods of Analysing Data -- Understating the Research Project -- Writing the Research Report -- Using Computers to Manage Your Research Project.\r\n  Abstract The first edition of Nursing Research in Action was published in 1990. Since its publication, nurse education has changed dramatically, with Project 2000 commencing, and most nurse education linked with colleges, further, and higher education. The second edition of this successful book is taking this into consideration. It now addresses both the needs of Project 2000 students and undergraduate degree students. It offers more details on how to do qualitative research. The revised edition offers more information on each of the topics in each of the chapters. The activities and exercises remain while some new ones are added. A wider range of research sources are referred to. This new edition is more comprehensive and appropriate to an even wider market.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:14:15',NULL,NULL);
INSERT INTO `biblio` VALUES (830,32,'Obstetrics by ten teachers 16th Edition','','16th','',19,'1995','xvi, 368 pages : illustrations','','','en',NULL,47,'','\"First published in Great Britain 1917 as Midwifery\"--Title page verso.\r\n\"Eleventh edition published 1966 as Obstetrics\"--Title page verso.\r\nSimultaneously published in the USA by Oxford University Press.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:17:31',NULL,NULL);
INSERT INTO `biblio` VALUES (831,32,'Obstetrics by ten teachers 20th Edition','','20th','',215,'2017','xviii, 341 pages','','','en',NULL,143,'','Contents Obstetric history taking and examination -- Antenatal care -- Normal fetal development and growth -- Assessment of fetal wellbeing -- Prenatal diagnosis -- Antenatal obstetric complications -- Multiple pregnancy -- Pre-term labour -- Hypertensive disorders of pregnancy -- Medical complications : diabetes, renal cardiac haematological/sle others -- Perinatal infections -- Labour : normal and abnormal -- Operative delivery -- Obstetric emergencies -- The puerperium -- The neonate.\r\n  Abstract \"First published in 1917 as \'Midwifery\', Obstetrics by Ten Teachers is well established as a concise, yet comprehensive, guide within its field. The twentieth edition has been thoroughly updated by a new team of \'teachers\', integrating clinical material with the latest scientific developments that underpin patient care. Each chapter is highly structured, with learning objectives, definitions, aetiology, clinical features, investigations, treatments, case histories and key point summaries and additional reading where appropriate. New themes for this edition include \'professionalism\' and \'global health\' and information specific to both areas is threaded throughout the text. Along with its companion Gynaecology by Ten Teachers the book will continue to provide an accessible \'one stop shop\' in obstetrics and gynaecology for a new generation of doctors.\"',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:19:47',NULL,NULL);
INSERT INTO `biblio` VALUES (832,32,'Diabetes and its management','','6th','',242,'2003','xi, 224 pages, 4 unnumbered pages of plates : illu','','','en',NULL,155,'','Contents 1. Diagnosis and classification -- 2. Epidemiology of diabetes -- 3. Synthesis, secretion and actions of insulin -- 4. Metabolic changes in diabetes: a summary -- 5. Aetiology and genetics -- 6. Clinical features of diabetes -- 7. Management of type 2 diabetes -- 8. Management of type 1 diabetes mellitus -- 9. Hypoglycaemia -- 10. Diabetic hyperglycaemic emergencies -- 11. Management of diabetes during surgery and other illnesses -- 12. Pregnancy and diabetes -- 13. Diabetes in children -- 14. An overview of microvascular complications -- 15. Diabetes and the kidney -- 16. Diabetic eye disease -- 17. Diabetic neuropathies -- 18. The diabetic foot -- 19. Cardiovascular disease -- 20. Hypertension -- 21. Living with diabetes -- 22. Organization of care.\r\n  Abstract A concise manual that distills essential recent developments into practical advice. This book is intended for doctors and all healthcare professionals who care for patients with diabetes valuable for those studying for the MRCP a compact, but complete, practical manual which also gives and excellent grounding in the underlying disease processes divided into sections on pathogenesis, clinical management, diabetic complications and all aspects of diabetic care updated and rewritten to include all the recent advances in diabetes.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:20:47',NULL,NULL);
INSERT INTO `biblio` VALUES (833,32,'Prevention of tropical diseases','','2nd','',267,'1988','','','','en',NULL,156,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:21:38',NULL,NULL);
INSERT INTO `biblio` VALUES (834,32,'Problems in Ophthalmology','','','',252,'1982','141 pages','','','en',NULL,133,'','Contents Series Foreword -- 1 History -- 2 Examination -- visual acuity -- visual fields -- colour vision -- external examination -- internal examination -- opthalmoscopy -- 3 The red eye -- conjunctivitis -- episcleritis -- keratitis -- iritis -- acute glaucoma -- 4 The external eye -- lids -- conjunctiva -- 5 The internal eye -- Examination of the inner eye -- alteration in pigment -- toxoplasmosis -- toxocara -- opaque nerve fibres -- 6 Sudden loss of vision -- migraine -- amaurosis fugax -- renal artery occlusion -- temporal arteritis -- retinal vein occlusion -- vitreous -- retinal detachment -- 7 Slow loss of vision -- cataract -- chronic glaucoma -- macular degeneration -- 8 Trauma -- superficial injuries -- lacerations -- penetrating injuries -- blunt injury -- chemical injuries -- radiation injuries -- 9 Paediatric ophthalmology -- squint -- watering eyes -- ptosis -- congenital glaucoma -- retinoblastoma -- 10 The eye and systemic disease -- thyroid disease -- the fundus -- hypertension -- diabetes -- papilloedema -- multiple sclerosis -- 11 Ocular pharmacology.\r\n  Abstract This series of books is designed to help general practitioners. So are other books. What is unusual in this instance is their collec tive authorship; they are written by specialists working at district general hospitals. The writers derive their own experi ence from a range of cases less highly selected than those on which textbooks are traditionally based. They are also in a good position to pick out topics which they see creating difficulties for the practitioners of their district, whose personal capacities are familiar to them; and to concentrate on contexts where mistakes are most likely to occur. They are all well-accustomed to working in consultation. All the authors write from hospital experience and from the viewpoint of their specialty. There are, therefore, matters important to family practice which should be sought not within this series, but elsewhere. Within the series much practical and useful advice is to be found with which the general practitioner can compare his existing performance and build in new ideas and improved techniques. These books are attractively produced and I recommend them.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:22:24',NULL,NULL);
INSERT INTO `biblio` VALUES (835,32,'Psychiatric and mental health nursing','','4th','',254,'2017','xii, 652 pages : illustrations','','','en',NULL,157,'','Contents Pt. 1. Preparing for psychiatric and mental health nursing -- 1. The effective nurse / Louise O\'Brien -- 2. Recovery as the context for practice / Vicki Stanton, Barbara Tooth and Simon Champ -- 3. Historical foundations / Katie Evans -- 4. Professional, legal and ethical issues / Phil Maude and Anthony O\'Brien -- 5. Settings for mental health / Julie Sharrock, Phil Maude, Lina Wilson and Michael Olasoji -- Pt. 2. Influences on mental health -- 6. Mental health theory and influence across the lifespan / Debra Nizette and Patricia Barkway -- 7. Trauma, crisis, loss and grief / Rachel Rossiter and Robin Scott -- 8. Physical health / Andrew Watkins and Tanya Park -- Pt. 3. The people with whom mental health nurses work -- 9. Mental health and wellness in Australia and New Zealand / Wendy Cross, Kim Ryan, Anne Brebner and Tish Siaosi -- 10. Working with families in mental health / Kim Foster, Kim Usher and Kerry Hawkins -- 11. Indigenous mental health in Australia and New Zealand / Deanne Hellsten and Hineroa Hakiaha -- 12. Disorders of childhood and adolescence / Deb O\'Kane and Kristin Henderson -- 13. Mental disorders of older age / Wendy Moyle -- 14. Intellectual disabilities / Charles Harmon, Philip Petrie and Chris Taua -- 15. Forensic mental health nursing / Brian McKenna, Tessa Maguire and Trish Martin -- Pt. 4. Mental disorders that people experience -- 16. Schizophrenia and psychotic disorders / Katie Evans -- 17. Mood disorders / Peter Athanasos -- 18. Personality disorders / Michelle Cleary and Toby Raeburn -- 19. Anxiety, trauma and stress-related disorders / Anna Elders -- 20. Eating disorders / Gail Anderson and Peta Marks -- 21. Substance use and comorbid mental health disorders / Peter Athanasos -- Pt. 5. What mental health nurses can do to help -- 22. Mental health promotion, prevention and primary healthcare / Tom Meehan -- 23. Assessment in mental health nursing / Anthony O\'Brien and Mandy Allman -- 24. Challenging behaviour, risk and responses / Scott Brunero and Scott Lamont -- 25. Therapeutic interventions / Christine Palmer -- 26. Psychopharmacology / Kim Usher.\r\n  Abstract Psychiatric and Mental Health Nursing has established itself as Australia and New Zealand\'s foremost mental health nursing text and is an essential resource for all undergraduate nursing students. This new edition has been thoroughly revised and updated to reflect current research and changing attitudes about mental health, mental health services and mental health nursing in Australia and New Zealand. Set within a recovery and consumer-focused framework, this text provides vital information for approaching the most familiar disorders mental health nurses and students will see in clinical practice, along with helpful suggestions about what the mental health nurse can say and do to interact effectively with consumers and their families.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:25:38',NULL,NULL);
INSERT INTO `biblio` VALUES (836,32,'Psychiatric nursing certification review guide for the generalist and advanced practice : psychiatric and mental health nurse','','3rd','',114,'2011','ix, 290 pages','','','en',NULL,83,'','Contents Test taking strategies and techniques -- Essentials of psychiatric nursing care -- Major theoretical frameworks for psychiatric nursing -- Substance-related mental disorders -- Anxiety and stress-related disorders -- Schizophrenia and other psychotic disorders -- Mood disorders -- Behavioral syndromes and disorders of adult personality -- Cognitive mental disorders and geropsychiatric nursing -- Behavioral and emotional disorders of childhood and adolescence -- The larger mental health environment.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:26:36',NULL,NULL);
INSERT INTO `biblio` VALUES (837,32,'Psychology for nurses and the caring professions','','4th','',218,'2012','(vii, 302 pages) : illustrations','','','en',NULL,29,'','Contents Psychology for Nurses and the Caring Professions -- Contents -- Tables -- Figures -- Preface -- Dedication and acknowledgements -- 1. Psychology in healthand social care --2. Perceptions of self and others -- 3. Development and change across the lifespan -- 4. Improving memory, understanding and communication -- 5. Learning and behaviour -- 6. Social influences and interactions -- 7. Stress and coping -- 8. Emotional well-being -- 9. Psychology applied to health and illness -- 10. Pain : reducing suffering -- Glossary -- References -- Index.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:27:54',NULL,NULL);
INSERT INTO `biblio` VALUES (838,32,'Rang and Dale\'s pharmacology','','9th','',254,'2019','(xiv, 755 pages) : illustrations (some color)','','','en',NULL,10,'','Contents Section 1: General principles. What is pharmacology? -- How drugs act: general principles -- How drugs act: molecular aspects -- How drugs act: cellular aspects excitation, contraction and secretion -- Biopharmaceuticals and gene therapy -- Cell proliferation, apoptosis, repair and regeneration -- Cellular mechanisms: host defence -- Method and measurement in pharmacology -- Absorption and distribution of drugs -- Drug metabolism and elimination -- Pharmacokinetics -- Individual Variation, pharmacogenomics and personalised medicine -- Section 2: Chemical mediators. Chemical mediators and the autonomic nervous system -- Cholinergic transmission -- Noradrenergic transmission -- 5-Hydroxytryptamine and the Pharmacology of Migraine -- Purines -- Local hormones 1: histamin and the biologically active lipids. -- Local hormones 2: peptides and proteins -- Cannabinoids -- Nitric oxide and other gaseous mediators -- Section 3: Drugs affecting major organ systems. The heart -- The vascular system -- Atherosclerosis and lipid metabolism -- Haemostasis and thrombosis -- Haemopoietic system -- Anti-inflammatory and immunosuppressant drugs -- Skin -- Respiratory system -- The Kidney and urinary system -- The Gastrointestinal tract -- The control of blood glucose and drug treatment of diabetes mellitus -- Obesity -- The Pituitary and the adrenal cortex -- Thyroid -- The reproductive system -- Bone metabolism -- Section 4: Nervous system. Chemical transmission and drug action in the nervous system -- Amino acid transmitters -- Other transmitters and modulators -- Neurodegenerative diseases -- General anaesthetic agents -- Analgesic drugs -- Local anaesthetics and other drugs affecting sodium channels -- Anxiolytic and hypnotic drugs -- Antiepileptic drugs -- Antipsychotic drugs -- Antidepressant drugs -- CNS stimulants and psychotomimetic drugs -- Drug addiction, dependence and abuse -- Section Drugs used for the treatment of infections and cancer -- Basic principles of antimicrobial chemotherapy -- Antibacterial drugs -- Antiviral drugs -- Antifungal drugs -- Antiprotozoal drugs -- Anthelmintic drugs -- Anti-cancer drugs -- Section 5: Special topics. Harmful effects of drugs -- Lifestyle drugs and drugs in sport -- Drug discovery and development.\r\n  Abstract \"Comprehensive yet easy to use, Rang and Dale\'s Pharmacology has been providing core basic and clinical science information to students and healthcare practitioners worldwide for more than 25 years. The fully revised 9th Edition keeps you up to date with all that\'s new in the field, including new and emerging drugs and recent studies. From cover to cover, you\'ll progressively increase your knowledge of all relevant aspects of pharmacology, from a molecular understanding of receptors and drug actions through clinical uses of key groups of drugs\"--Publisher\'s description.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:29:21',NULL,NULL);
INSERT INTO `biblio` VALUES (839,32,'Ross and Wilson anatomy & physiology in health and illness','','12th','',14,'2014','xii, 509 pages : color illustrations','','','en',NULL,10,'','Contents Introduction to the human body -- Introduction to the chemistry of life -- The cells, tissues and organisation of the body -- The blood -- The cardiovascular system -- The lymphatic system -- The nervous system -- The special senses -- The endocrine system -- The respiratory system -- Introduction to nutrition -- The digestive system -- The urinary system -- The skin -- Resistance and immunity -- The musculoskeletal system -- Introduction to genetics -- The reproductive systems.\r\n  Abstract Introduces the structure and functions of the human body and the effects of disease or illness on normal body function. Uses easy-to-understand language and clear color illustrations to make learning more visual and engaging.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:32:29',NULL,NULL);
INSERT INTO `biblio` VALUES (840,32,'Ross and Wilson anatomy and physiology in health and illness','','9th','',13,'2001','(484 pages) : color illustrations','','','en',NULL,10,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:36:12',NULL,NULL);
INSERT INTO `biblio` VALUES (841,32,'World Health Day \"Safe motherhood\" 7 April 1998 ; [WHD] ; [based on the outcomes of the Technical Consultation on Safe Motherhood]','','','',268,'1998','','','','en',NULL,12,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:37:42',NULL,NULL);
INSERT INTO `biblio` VALUES (842,32,'Shaw\'s textbook of gynaecology','','16th','',269,'2015','(xi, 583 pages) : illustrations','','','en',NULL,19,'','Contents Front cover; Front matter; Copyright; Dedication; Preface to the 16th edition; Preface to the 10th edition; Table of contents; 1 Anatomy; The vulva; Labia majora; Bartholin\'s gland; Labia minora; The vagina; Relations of vagina; Anterior relation; Posterior relations; Lateral relations; Superior relations; The uterus; Perimetrium; Myometrium; Endometrium; Position of the uterus; The uterine appendages; Fallopian tubes; The ovaries; The urethra; Relations; The bladder; Nerve supply; The ureter; The rectum and anal canal; The lymphatics; Breasts; The pelvic musculature; Pelvic diaphragm.\r\nUrogenital diaphragmSuperficial muscles; The pelvic cellular tissue; The pelvic blood vessels; The vaginal arteries; The arteries of the vulva and perineum; The pelvic veins; The lymphatic system; The lymphatic glands or nodes; The inguinal glands; The glands of the parametrium; External iliac glands; Common iliac glands; The sacral group; The lumbar group of glands; The nerve supply; Applied anatomy and its clinical significance; Self-assessment; Suggested reading; 2 Normal histology; The ovary of the newborn; The primordial follicle; The graafian follicle (figure 2.2).\r\nThe fate of the graafian follicleOvulation; Corpus luteum (figure 2.7a and b); Menstruation; Corpus luteum of pregnancy; The endometrium of the uterus; The proliferative phase; The secretory phase; The menstruating endometrium; Regeneration; Endometrium; The decidua of pregnancy; Ectopic decidual cells; Vaginal epithelium; Ovarian function; Pregnancy; Menopausal endometrium; Cervical mucus; Process of fertilization; Testis; Self-assessment; Suggested reading; 3 Physiology; Hypothalamus; Pituitary gland (adenohypophysis); Follicle-stimulating hormone; Luteinizing hormone.\r\nHuman chorionic gonadotropin (hcg)Prolactin; Posterior pituitary gland (neurohypophysis); Oxytocin; Vasopressin; Ovarian steroidogenesis; Oestrogen; Actions of oestrogens (figure 3.4); Progesterone; Actions of progesterones; Side effects; Relaxin; Inhibin; Activin; Anti-m',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:40:23',NULL,NULL);
INSERT INTO `biblio` VALUES (843,32,'Social psychology','','12th','',250,'2017','1 volume (various pagings) : illustrations (chiefl','','','en',NULL,69,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:42:39',NULL,NULL);
INSERT INTO `biblio` VALUES (844,32,'Sociology : a global introduction','','4th','',105,'2008','(xi, 953 pages) : color illustrations, maps','','','en',NULL,158,'','Contents 1. The sociological imagination -- 2. Thinking sociologically, thinking globally -- 3. Doing social science: an introduction to method -- 4. Societies -- 5. Culture -- 6. Groups, organisations and the rise of the network society -- 7. Micro-sociology: the social construction of everyday life -- 8. Social divisions and social stratification -- 9. Global inequalities and poverty -- 10. Class, poverty and welfare -- 11. Racism, ethnicities and migration -- 12. The gender order and sexualities -- 13. Age stratification, children and later life -- 14. Disabilities, care and the humanitiarian society -- 15. Economies, work and consumption -- 16. Power, governance and social movements -- 17. Control, crime and deviance -- 18. Families, households and personal cultures -- 19. Religion and belief -- 20. Education -- 21. Health, medicine and well-being -- 22. Communication and the new media -- 23. Science, cyberspace and the risk society -- 24. Populations, cities and the space of things to come -- 25. Social change and the environment -- 26. Livng in the twenty-first century.\r\n  Abstract Sociology: A Global Introduction, with its international outlook and cultural diversity, represents a unique and complete learning resource for sociology students worldwide. Each chapter addresses a new change in society, and reveals how progress in society often comes at a price. This text has been fully updated to include the latest key debates, topics and data, and also highlights the importance of technology in contemporary social life.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:45:14',NULL,NULL);
INSERT INTO `biblio` VALUES (845,32,'Society, culture, and health : an introduction to sociology for nurses','','','',26,'2007','xii, 276 pages : illustrations','','','en',NULL,159,'','Contents 1. What is sociology and why is it relevant to nurses? -- 2. Approaching health and illness -- 3. Lay, folk and consumer ideas about health and illness -- 4. The media and health -- 5. Health and illness patterns in Australia -- 6. The Health Effects of Marginalisation and Exclusion -- 7. The Health of Aboriginal and Torres Strait Islander peoples -- 8. The Body, Risk and Lifestyle -- 9. The Illness experience: Chronic illness -- 10. Contemporary Debates about Health and Illness -- 11. Health care systems and the health workforce -- 12. Complementary and Alternative Medicine (CAM) -- 13. Nursing in Contemporary Australia.\r\n  Abstract Society, Culture and Health takes a sociological approach to issues of relevance for students studying nursing and related health professions. The book examines the sources of ideas about health and illness, including the biomedical model, folk and lay approaches and the influence of the media. It includes coverage of the impact on health of social marginalisation through a careful examination of structural variables. The experiences of health and illness are explained through the analysis of the body in contemporary society and issues such as chronic illness and disability. Society, Culture and Health gives an overview of the role of nursing in the health care system and its relationship with medicine and alternative health practices. Taking a practical approach, and using case studies to examine a range of issues such as domestic violence, occupational health, indigenous health and refugee health, it prepares students for working in health professions which are wide-ranging in settings, systems and clients.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:46:09',NULL,NULL);
INSERT INTO `biblio` VALUES (846,32,'Standards and Tools for Monitoring Adolescent & Youth Friendly Health Services (AYFHS) in Ghana','','','',270,'','','','','en',NULL,149,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-20 09:29:24','2020-04-20 19:47:04',NULL,NULL);
INSERT INTO `biblio` VALUES (847,32,'The Logistics Handbook : A Practical Guide for the Supply Chain Management of Health Commodities','','2nd','',271,'2011','','','','en',NULL,108,'','Abstract\r\nThe Logistics Handbook: A Practical Guide for the Supply Chain Management of Health Commodities offers practical guidance in managing the supply chain, with an emphasis on health commodities. his handbook will be particularly useful for program managers who design,manage, and assess logistics systems for health programs. In addition, policymakers, system stakeholders, and anyone working in logistics will also ind it helpful as a system overview and overall approach.','The_Logistics_Handbook.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-21 04:46:00','2020-04-21 05:04:20',NULL,NULL);
INSERT INTO `biblio` VALUES (848,32,'Logistics System Assessment Tool (LSAT)','','','',271,'2009','','','','en',NULL,108,'','','logistics-system-assessment-tool.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-21 04:54:07','2020-04-21 05:03:38',NULL,NULL);
INSERT INTO `biblio` VALUES (849,32,'LOGISTICS INDICATORS ASSESSMENT TOOL (LIAT)','','','',271,'2008','','','','en',NULL,108,'','','assesment_tool.png.png',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-21 05:00:56','2020-04-21 05:01:26',NULL,NULL);
INSERT INTO `biblio` VALUES (850,32,'Advances in the sign language development of deaf and hard-of-hearing children','','','9780195180947',26,'2005','416 pages : illustrations','','','en',NULL,160,'','Contents Introduction and historical overview -- Current paradigms in psychopathology -- Diagnosis and assessment -- Research methods in the study of pschopathology -- Anxiety disorders -- Dissociative disorders and somatoform disorders -- Stress and health -- Mood disorders -- Eating disorders -- Substance-related disorders -- Schizophrenia -- Personality disorders -- Sexual and gender identity disorders -- Disorders of childhood -- Late-life and psychological disorders -- Psychological treatment -- Legal and ethical issues.\r\n Abstract \"Psychologists rely on Abnormal Psychology because it sets the standard for clarity, cutting-edge coverage, authoritative content, and clinical emphasis. It helps them fully integrate the details of all the disorders and distinguish between the more important concepts. The Big Picture feature emphasizes the important comparisons and contrasts to other concepts presented in the chapters. A new discussion on mental disorders shows how the interpretation of behaviors is dependent on the context in which those behaviors occur. The eleventh edition also demonstrates how context drives the definitions of normal and abnormal behavior. With the new features, psychologists will find the material to be more accessible, engaging, and informative.\"',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-22 07:41:29','2020-04-22 07:43:23',NULL,NULL);
INSERT INTO `biblio` VALUES (851,32,'Basic epidemiology','','2nd','9789241547079',21,'2006','219 p.','','','en',NULL,12,'','Chapter 1. What is epidemiology? Chapter 2. Measuring health and disease Chapter 3. Types of studies Chapter 4. Basic biostatistics: concepts and tools Chapter 5. Causation in epidemiology Chapter 6. Epidemiology and prevention: chronic noncommunicable diseases Chapter 7. Communicable diseases: epidemiology, surveillance and response Chapter 8. Clinical epidemiology Chapter 9. Environmental and occupational epidemiology Chapter 10. Epidemiology, health policy and planning Chapter 11. First steps in practical epidemiology',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-22 07:41:29','2020-04-22 07:44:31',NULL,NULL);
INSERT INTO `biblio` VALUES (852,32,'Emergency nursing : the profession, the pathway, and the practice','','','',244,'2016','463 pages','','','en',NULL,161,'','Contents  Emergency nursing defined / Renee Semonin Holleran -- The traditional role of the emergency nurse / Darin L. Durham and Jeff Solheim -- Unique roles of the emergency nurse / Patricia L. Clutter -- Education of the emergency nurse / Nicholas A. Nelson -- The emergency nurse as a professional / Linda Laskowski-Jones -- Self-care and the emergency nurse / William Schueler -- Types of emergency departments / Aaron Wolff -- Common areas within the emergency department / Debra Delaney and Jeff Solheim -- Key players in the emergency department / Pamela D. Bartley, Melanie Stoutenburg, and Jeff Solheim -- The emergency nurse in the role of triage / Rebecca S. McNair and Jeff Solheim -- Common challenges faced by emergency nurses / Brian Selig, Fred Neis, and Jeff Solheim -- Risk management and quality issues affecting the emergency nurse / Laurel Grisbach -- Emergency nursing throughout the lifespan / Gayle Walker-Cillo, Renee Semonin Holleran, and Jeff Solheim -- Challenging patient populations encountered by the emergency nurse / Gayle Walker-Cillo, Renee Semonin Holleran, and Jeff Solheim -- The emergency nurse and the abused patient / Gayle Walker-Cillo, Renee Semonin Holleran, and Christi Thornhill -- The emergency nurse caring for diverse cultures and ethnicities / Patricia L. Clutter.\r\nAbstract With over 136.3 million patient visits to the Emergency Department, emergency nurses are not only in high demand but a continuously growing segment of the nursing profession. Emergency nurses find themselves in high-risk, faced-paced, physically and emotionally demanding, and difficult situations on a constant bases, which many nurses will describe as both stressful and surprisingly, extremely fulfilling. But there are so many variables, moving pieces, and different roles when it comes to emergency nurses. How do you begin to understand or know if this is the right career for you when there is so much to know? Emergency Nurse: The Profession, the Pathway, and the Practice provides students, new nurses, and existing emergency nurses the tools and information they need to pursue and sustain a successful career in emergency healthcare. Author Jeff Solheim informs readers about the career opportunities that exist within emergency nursing, introduces nurses to the emergency department and how it differs from other healthcare settings, and explains the challenges and patient populations that emergency nurses will face on a regular basis. Filled with fun facts, notes, and practical advice, this book is a fantastic resource for a nurse eager to learn more about emergency care.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-22 07:41:29','2020-04-22 07:45:18',NULL,NULL);
INSERT INTO `biblio` VALUES (853,32,'Human communication:make it smart, keep it real','','4th','978-0-07-34068-0',272,'2011','','','','en',NULL,69,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-22 07:41:29','2020-04-22 07:46:03',NULL,NULL);
INSERT INTO `biblio` VALUES (854,32,'Procurement Procedure : Manual Standard Operating Procedures for Procurement in the Public Health Sector','','2nd','',273,'2004','','','','en',NULL,66,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-22 07:41:29','2020-04-22 07:46:44',NULL,NULL);
INSERT INTO `biblio` VALUES (855,32,'Nursing informatics : scope and standards of practice','','2nd','',274,'2015','(viii, 225 pages) : illustrations','','','en',NULL,162,'','Contents Metastructures, concepts, and tools of nursing informatics -- Functional areas of nursing informatics -- Evolution of informatics competencies -- Informatics competencies : spanning careers and roles -- Preparation for nursing informatics specialty practice -- Ethics in nursing informatics -- The future of nursing informatics -- Trends in regulatory changes and quality standards -- Trends in care delivery models and innovation -- Significance of the standards -- Standards practice for nursing informatics -- Standards of professional performance for nursing informatics.\r\nAbstract \"Nursing informatics (NI) is the specialty that integrates nursing science with multiple information and analytical sciences to identify, define, manage and communicate data, information, knowledge and wisdom in nursing practice. For many people, NI, and health care informatics in general, are about technology. This is especially true of electronic health records (EHRs) that are required of all care facilities. That is just one among many aspects of nursing informatics, a distinctive practice specialty that is the focus of this new publication. The second edition of Nursing Informatics: Scope and Standards of Practice is the most comprehensive, up-to-date resource available in this subject area. The book covers the full scope of nursing informatics and outlines the competency level of nursing practice and professional performance expected from all informatics nurses and nurse specialists. In addition, it details the nursing informatics competencies needed by any RN, spans all nursing careers and roles, and reflects the impact of informatics in any health care practice environment. This is a must-read for nurses, as informatics touches on every RN\'s practice.\"',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-22 07:41:29','2020-04-22 07:47:33',NULL,NULL);
INSERT INTO `biblio` VALUES (856,32,'Oxford handbook of emergency nursing','','2nd','',26,'2017','xxii, 806 pages : illustrations','','','en',NULL,16,'','Contents General principles of emergency nursing -- First principles -- Investigations -- Emergency care of the infant and child -- Obstetric emergencies -- Neurological emergencies -- Respiratory emergencies -- Cardiovascular emergencies -- Musculoskeletal injuries -- Gastrointestinal emergencies -- Genitourinary emergencies -- Skin emergencies -- Ophthalmological emergencies -- ENT emergencies -- Major trauma -- Endocrine and metabolic emergencies -- Haematological emergencies -- Overdose and poisoning -- Mental health emergencies -- Emergencies in older patients -- Skills reminder.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-22 07:41:29','2020-04-22 07:48:27',NULL,NULL);
INSERT INTO `biblio` VALUES (857,32,'Psychiatric and mental health nursing demystified','','','',275,'2014','xix, 523 pages : illustrations','','','en',NULL,8,'','Contents 1. Foundation of psychiatric and mental health nursing. Mental illness : Models of human behavior ; Therapeutic relationship ; Therapeutic communication ; Barriers to communication ; Defense mechanisms ; Legal environment ; Psychiatric therapies ; Psychiatric assessment tests ; American Nurses Association Standards of Care ; Nursing assessment ; Mental status examination ; Summarize the nursing assessment ; Developing a nursing diagnosis -- 2. Childhood and adolescent psychiatric disorders. Childhood and adolescent mental illness -- Diagnosing -- Treatment -- Working with a difficult child : Attention deficit hyperactivity disorder ; Autistic disorder ; Conduct disorder ; Oppositional defiant disorder ; Major depression disorder ; Mental retardation ; Tourette Syndrome -- 3. Anxiety and anxiety disorders. Anxiety : Acute stress disorder ; Generalized anxiety disorder ; Obsessive-compulsive disorder ; Panic disorder ; Phobia ; Posttraumatic stress disorder ; Substance abuse anxiety disorder -- 4. Somatoform and dissociative disorders. What are somatoform disorders and dissociative disorders? -- Factitious disorders and malingering disorders : Body dysmorphic disorder ; Conversion disorder ; Hypochondriasis ; Pain disorder ; Somatization disorder ; Depersonalization disorder ; Dissociative amnesia ; Dissociative fugue ; Dissociative identity disorder -- 5. Schizophrenia. What is schizophrenia disorder? -- Hallucinations -- Delusion -- Positive and negative symptoms -- Phases of schizophrenia disorder -- Degrees of schizophrenia disorder -- Antipsychotic medication adverse side effects : Paranoid schizophrenia disorder ; Disorganized schizophrenia disorder ; Undifferentiated schizophrenia disorder ; Residual schizophrenia disorder ; Catatonic schizophrenia disorder.\r\n6. Personality disorders. Personality and personality disorders -- Clusters : Antisocial personality disorder ; Avoidant personality disorder ; Borderline personality disorder ; Dependent personality disorder ; Histrionic personality disorder ; Narcissistic personality disorder ; Obsessive-compulsive personality disorder ; Paranoid personality disorder ; Schizoid personality disorder ; Schizotypal personality disorder -- 7. Mood disorders. Mood -- Mood disorder : Bipolar disorder ; Cyclothymic disorder ; Dysthymic disorder ; Major depressive disorder -- 8. Substance abuse. Abuse, dependency, and addiction -- Dependency and pain medication -- Detoxification -- Recovery, cravings, and triggers -- Social support problems -- Common signs of substance abuse : Alcohol dependence disorder ; Amphetamine abuse disorder ; Anxiolytic, hypnotic, sedative dependent disorder ; Cannabis abuse disorder ; Cocaine abuse disorder ; Hallucinogen abuse disorder ; Inhalant abuse disorder ; Nicotine dependent disorder ; Opioid dependent disorder -- 9. Eating disorders. Anorexia nervosa disorder ; Bulimia nervosa disorder -- 10. Sleeping disorders. Sleep -- Measuring sleep -- Missed sleep -- Sleeping habits -- Stages of sleep -- Physiology during sleep -- Dreams : Breathing-related sleep disorder ; Circadian rhythm sleep disorder ; Narcolepsy disorcer ; Primary hypersomnia disorder ; Primary insomnia disorder.\r\n11. Sexual disorders. Sexual activity ; Gender identity ; Paraphilia : Gender identity disorder ; Paraphilia disorder ; Sexual dysfunction disorder -- 12. Therapeutic communications. A therapeutic relationship ; Therapeutic communication ; Therapeutic interventions ; Mediating conflicts ; Crisis ; Developing a therapeutic relationship ; Running groups ; Addiction intervention ; Legal considerations ; Nurse process report ; Milieu -- 13. Patient psychiatric assessment and patient psychiatric care plans. Mental health diagnosis ; Psychiatric nursing process ; Behavioral assessment ; Psychiatric nursing diagnosis ; Psychiatric care plan -- 14. Physiologic basis of mental illness. Mental illness : Neurologic system ; Neurotransmitters ; Nervous system and mental illness ; Medication ; Substance abuse.\r\n  Abstract \"Key concepts, major theories, and advanced trends simplified and explained Whether you\'re a student seeking to excel in a course or a professional nurse transitioning into psychiatric and mental health nursing, this is the book you need to quickly and easily understand the key concepts and advanced trends of this specialty. In order to make the learning process as effective as possible, Psychiatric and Mental Health Nursing DeMYSTiFieD includes learning objectives in every chapter, along with key terms, a brief overview of topics, content summaries, chapter-ending review questions, and explanatory tables and diagrams. The book also includes a comprehensive final exam with NCLEX-style quesions covering all of the content found in the book\"',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-22 07:41:29','2020-04-22 07:49:44',NULL,NULL);
INSERT INTO `biblio` VALUES (858,32,'Psychiatric and mental health nursing','','4th','',254,'2017','xii, 652 pages : illustrations','','','en',NULL,157,'','Contents Pt. 1. Preparing for psychiatric and mental health nursing -- 1. The effective nurse / Louise O\'Brien -- 2. Recovery as the context for practice / Vicki Stanton, Barbara Tooth and Simon Champ -- 3. Historical foundations / Katie Evans -- 4. Professional, legal and ethical issues / Phil Maude and Anthony O\'Brien -- 5. Settings for mental health / Julie Sharrock, Phil Maude, Lina Wilson and Michael Olasoji -- Pt. 2. Influences on mental health -- 6. Mental health theory and influence across the lifespan / Debra Nizette and Patricia Barkway -- 7. Trauma, crisis, loss and grief / Rachel Rossiter and Robin Scott -- 8. Physical health / Andrew Watkins and Tanya Park -- Pt. 3. The people with whom mental health nurses work -- 9. Mental health and wellness in Australia and New Zealand / Wendy Cross, Kim Ryan, Anne Brebner and Tish Siaosi -- 10. Working with families in mental health / Kim Foster, Kim Usher and Kerry Hawkins -- 11. Indigenous mental health in Australia and New Zealand / Deanne Hellsten and Hineroa Hakiaha -- 12. Disorders of childhood and adolescence / Deb O\'Kane and Kristin Henderson -- 13. Mental disorders of older age / Wendy Moyle -- 14. Intellectual disabilities / Charles Harmon, Philip Petrie and Chris Taua -- 15. Forensic mental health nursing / Brian McKenna, Tessa Maguire and Trish Martin -- Pt. 4. Mental disorders that people experience -- 16. Schizophrenia and psychotic disorders / Katie Evans -- 17. Mood disorders / Peter Athanasos -- 18. Personality disorders / Michelle Cleary and Toby Raeburn -- 19. Anxiety, trauma and stress-related disorders / Anna Elders -- 20. Eating disorders / Gail Anderson and Peta Marks -- 21. Substance use and comorbid mental health disorders / Peter Athanasos -- Pt. 5. What mental health nurses can do to help -- 22. Mental health promotion, prevention and primary healthcare / Tom Meehan -- 23. Assessment in mental health nursing / Anthony O\'Brien and Mandy Allman -- 24. Challenging behaviour, risk and responses / Scott Brunero and Scott Lamont -- 25. Therapeutic interventions / Christine Palmer -- 26. Psychopharmacology / Kim Usher.\r\n  Abstract Psychiatric and Mental Health Nursing has established itself as Australia and New Zealand\'s foremost mental health nursing text and is an essential resource for all undergraduate nursing students. This new edition has been thoroughly revised and updated to reflect current research and changing attitudes about mental health, mental health services and mental health nursing in Australia and New Zealand. Set within a recovery and consumer-focused framework, this text provides vital information for approaching the most familiar disorders mental health nurses and students will see in clinical practice, along with helpful suggestions about what the mental health nurse can say and do to interact effectively with consumers and their families.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-22 07:41:29','2020-04-22 07:50:56',NULL,NULL);
INSERT INTO `biblio` VALUES (859,32,'Psychiatric-mental health nursing','','8th','',276,'2020','xiv, 525 pages : color illustrations','','','en',NULL,11,'','Contents Foundations of psychiatric-mental health nursing -- Neurobiologic theories and psychopharmacology -- Psychosocial theories and therapy -- Treatment settings and therapeutic programs -- Therapeutic relationships -- Therapeutic communication -- Client\'s response to illness -- Assessment -- Legal and ethical issues -- Grief and loss -- Anger, hostility, and aggression -- Abuse and violence -- Trauma and stressor-related disorders -- Anxiety and anxiety disorders -- Obsessive-compulsive and related disorders -- Schizophrenia -- Mood disorders and suicide -- Personality disorders -- Addiction -- Eating disorders -- Somatic symptom illnesses -- Neurodevelopmental disorders -- Disruptive behavior disorders -- Cognitive disorders.\r\n  Abstract \"With an accessible, clear, and student-friendly approach, \"Psychiatric-Mental Health Nursing\" clarifies challenging concepts and helps you build a foundation for working successfully with clients experiencing mental health challenges regardless of care setting. The text explores the full spectrum of psychiatric nursing, helping you master specific nursing interventions, hone your therapeutic communication skills, and learn to apply content effectively within the framework of the nursing process.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-22 07:41:29','2020-04-22 07:51:43',NULL,NULL);
INSERT INTO `biblio` VALUES (860,32,'Psychology for nurses and allied health professionals','','','',37,'2007','xiii, 416 pages : illustrations, portraits','','','en',NULL,7,'','Contents Ch. 1. What is psychology? -- Ch. 2. Theoretical approaches -- Ch. 3. Psychological aspects of illness -- Ch. 4. Social cognition and health behaviour -- Ch. 5. Stress -- Ch. 6. Personality and health behaviour -- Ch. 7. Substance use and abuse -- Ch. 8. Social perception -- Ch. 9. Attribution -- Ch. 10. Attitudes and attitude change -- Ch. 11. Prejudice and discrimination -- Ch. 12. Conformity and group influence -- Ch. 13. Obedience -- Ch. 14. Early experience and social development -- Ch. 15. Cognitive development -- Ch. 16. Development of the self-concept -- Ch. 17. Adolescence -- Ch. 18. Adulthood -- Ch. 19. Late adulthood -- Ch. 20. Death and dying.\r\n  Abstract \'Psychology for Nurses and Allied Health Professionals\' is a textbook written for all those studying and working in nursing and in the allied health professions, including midwifery and health visiting. It provides comprehensive coverage of the core subject areas.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-22 07:41:29','2020-04-22 07:52:26',NULL,NULL);
INSERT INTO `biblio` VALUES (861,32,'Self-assessment by ten teachers : EMQS, MCQS SAQS and OSCES in obstetrics & gynaecology','','','',37,'2007','136 pages','','','en',NULL,7,'','Contents Cover; Book title; Contents; Acknowledgements; Commonly used abbreviations; SECTION 1 OBSTETRICS; 1. Extended matching questions; Answers; 2. Multiple choice questions; Answers; 3. Short answer questions (and answers); 4. Objective structured clinical examination questions; Answers; SECTION 2 GYNAECOLOGY; 5. Extended matching questions; Answers; 6. Multiple choice questions; Answers; 7. Short answer questions (and answers); 8. Objective structured clinical examination questions; Answers;',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-22 07:41:29','2020-04-22 07:53:26',NULL,NULL);
INSERT INTO `biblio` VALUES (862,32,'Signed language interpreting in the 21st century : an overview of the profession','','','',277,'2018','vii, 231 pages : illustrations, portraits','','','en',NULL,41,'','Contents 1: Interpreting: an overview / Len Robinson -- 2: Historical foundations of a trust-based profession / Carolyn Ball -- 3: Promoting the use of normative ethics in the practice profession of community interpreting / Robyn K. Dean and Robert Q Pollard, Jr. -- 4: Aptitude and disposition: learned vs. nurtured characteristics of student interpreters / Sherry Shaw -- 5: Interpreting in healthcare settings: more than needles, blood, and terminology / Laurie Swabey -- 6: Interpreting in vocational rehabilitation centers / Linda K. Stauffer -- 7: Interpreting in legal contexts / Carla M. Mathers -- 8: Interpreting for people who are deafblind / Sherry Shaw -- 9: Credentialing and regulation of signed language interpreters / Anna Witter-Merithew -- 10: International perspectives on interpreting: isn\'t everything just like at home? / Debra Russell.\r\n  Abstract \"This text provides interpreting students with a broad knowledge base that encompasses the latest research, addresses current trends and perspectives of the Deaf community, and promotes critical thinking and open dialogue about the working conditions, ethics, boundaries, and competencies needed by a highly qualified interpreter in various settings. This volume expands the resources available to aspiring interpreters, including Deaf interpreters, and incorporates the voices of renowned experts on topics relevant to today\'s practitioners.\"',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-22 07:41:29','2020-04-22 07:54:19',NULL,NULL);
INSERT INTO `biblio` VALUES (863,32,'Introduction to statistics for nurses','','','',109,'2007','xvii, 268 pages : illustrations (some color)','','','en',NULL,163,'','Contents Ch. 1. introduction to statistics -- Ch. 2. Variables -- Ch. 3. Descriptive statistics : the Florence Nightingale way -- Ch. 4. Effective data cleaning and management -- Ch. 5. Critical appraisal of analysis and reporting of descriptive statistics -- Ch. 6. introduction to inferential statistics -- Ch. 7. Correlational statistics -- Ch. 8. Comparing average scores : statistics for all sorts of groups and occasions -- Ch. 9. Critical appraisal of analysis and reporting of inferential statistics -- Ch. 10. Advanced thinking with probability and significance : where to next?\r\nAbstract \"This book will help you to understand the use of statistics in nursing literature, and show you how to use statistics effectively in answering your own research questions. Case studies throughout show how statistics are applied in nursing research and frequent exercises help you test your own knowledge as you progress.\"',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-22 07:41:29','2020-04-22 07:55:34',NULL,NULL);
INSERT INTO `biblio` VALUES (864,32,'Statistics for nursing : a practical approach','','3rd','',92,'2019','xii, 301 pages','','','en',NULL,164,'','Contents Introduction to statistics and levels of measurement -- Presenting data -- Descriptive statistics, probability, and measures of central tendency -- Measuring data -- Sampling methods -- Generating the research idea -- Sample size, effect size, and power -- Chi-square -- Student t-Test -- Analysis of variance (ANOVA) -- Correlation coefficients -- Regression analysis -- Relative risk, odds ratio, and attributable risk.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-22 07:41:29','2020-04-22 07:56:15',NULL,NULL);
INSERT INTO `biblio` VALUES (865,32,'The ethics of research with human subjects : protecting people, advancing science, promoting trust','','','',203,'2018','(xiii, 316 pages) : illustrations','','','en',NULL,151,'','Contents Intro; Dedication; Acknowledgements; Contents; Abbreviations; Chapter 1: Introduction; 1.1 Perinatal HIV Prevention Trials; 1.2 The SUPPORT Study; 1.3 Hospital Quality Improvement Research; 1.4 Henrietta Lacks; 1.5 The Facebook Study; 1.6 Overview of This Book; Chapter 2: Historical Background; 2.1 Research with Human Subjects Before World War II; 2.2 Research with Human Subjects During World War II; 2.3 Research with Human Subjects After World War II; 2.4 The Belmont Report; 2.5 The U.S. Federal Regulations; 2.6 Continuing Scandals and Controversies\r\n2.7 Concerns About Integrity in Biomedical Research2.8 Jesse Gelsinger\'s Death; 2.9 Concerns About Research on Human Biosamples; 2.10 Conclusion: Human Research Regulations and Guidelines in Historical Context; Chapter 3: Moral Theory; 3.1 What Is a Moral Theory?; 3.2 Moral Subjectivism and Relativism; 3.3 Classifying Moral Theories; 3.4 Divine Command Theory; 3.5 Virtue Ethics; 3.6 Natural Law Theory; 3.7 Utilitarianism; 3.8 Kantianism; 3.9 Natural Rights Theories; 3.10 Pluralistic Theories; 3.11 Conclusion: Toward aA? Decision-Making Framework\r\nChapter 4: Trust as a Foundation for Research with Human Subjects4.1 What Is Trust?; 4.2 Trust inA? Research Involving Research with Human Subjects; 4.3 Trust as a Foundation for the Ethics of Research with Human Subjects: Some Alternative Views; 4.4 Trust as a Foundation for the Ethics of Research with Human Subjects: My View; 4.5 Promoting Trust inA? Research withA? Human Subjects; 4.6 The Relationship Between Moral Principles and Research Regulations and Guidelines; 4.7 The Role of Trust in Resolving Ethical Dilemmas in Research withHuman Subjects\r\n4.8 Objections to My View4.9 Conclusion; Chapter 5: Informed Consent; 5.1 Trust andA? Informed Consent; 5.2 The Elements of Consent; 5.3 Disclosure Standards; 5.4 Documentation; 5.5 Consent by Parties Other than the Subject; 5.6 Research Without Consent; 5.7 Opt-Out Consent; 5.8 General Consent; 5.9 Deception in Research; 5.10 Assent; 5.11 Payment for Research Participation; 5.12 The Right to Withdraw; 5.13 Conclusion; Chapter 6: Privacy and Confidentiality; 6.1 Privacy, Confidentiality, andTrust; 6.2 Sharing and Publishing Data andSamples\r\n6.3 Justifiable Breaches of Privacy and Confidentiality6.4 Harm to Self; 6.5 Harm to Others; 6.6 Suspected Abuse/Neglect; 6.7 Communicable Disease Reporting; 6.8 Informing Family Members About Genetic Diseases; 6.9 Conclusion; Chapter 7: Risks; 7.1 What Is Risk?; 7.2 Types of Risk Related to Research Participation; 7.3 Risk andA? Trust; 7.4 Assessing Risk; 7.5 Minimizing Risk; 7.6 Minimal Risk; 7.7 Research onA? Healthy Volunteers; 7.8 Phase I Trials onA? Patients; 7.9 Randomized Controlled Trials; 7.10 Placebo-Controlled Trials; 7.11 Risks toA? Researchers andThird Parties.\r\nAbstract This book provides a framework for approaching ethical and policy dilemmas in research with human subjects from the perspective of trust. It explains how trust is important not only between investigators and subjects but also between and among other stakeholders involved in the research enterprise, including research staff, sponsors, institutions, communities, oversight committees, government agencies, and the general public. The book argues that trust should be viewed as a distinct ethical principle for research with human subjects that complements other principles, such as autonomy, beneficence, non-maleficence, and justice. The book applies the principle of trust to numerous issues, including informed consent, confidentiality, risk minimization, risks and benefits, protection of vulnerable subjects, experimental design, research integrity, and research oversight. This work also includes discussions of the history of research involving human subjects, moral theories and principles, contemporary cases, and proposed regulatory reforms. The book is useful for undergraduate and graduate students studying ethical policy issues related to research with human subjects, as well as for scientists and scholars who are interested in thinking about this topic from the perspective of trust.',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-04-22 07:41:29','2020-04-22 07:57:23',NULL,NULL);
INSERT INTO `biblio` VALUES (866,32,'An introduction to nursing informatics : evolution and innovation','','','',214,'2019','xxiv, 179 pages','','','en',NULL,143,'','Contents A Discipline Defined / Susan K. Newbold and Carol A. Romano -- The Origins and Evolution of Nursing Informatics / Sejal Patel, Grischa Metlan, Kathy Lesh, and Linda Fischetti -- Nursing, Informatics, and Technology Today / Kimberly Ellis Krakowski and Patricia Mook -- Nursing, Informatics, and Technology: A Look Forward / Mary Beth Mitchell -- Advanced Analytics / Charles M. Boicey -- Nursing Informatics - A Day in the Life / edited by Tina Dieckhaus -- Tips and Advice for Obtaining Your First Nursing Informatics Job / Patricia P. Sengstack.\r\n  Abstract \"Nursing informatics (NI) is the specialty that integrates nursing science with information management and analytical sciences to identify, define, manage, and communicate data, information, knowledge, and wisdom in nursing practice. Nursing Informatics supports nurses, consumers, patients, the interprofessional healthcare team, and other stakeholders in a wide variety of roles and settings to achieve desired outcomes. This is accomplished through the use of information structures, information processes, and information technology.\"','infor1.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-05-03 07:44:28','2020-05-03 07:51:36',NULL,NULL);
INSERT INTO `biblio` VALUES (867,32,'Behavioral healthcare and technology : using science-based innovations to transform practice','','','',26,'2015','xvi, 348 pages : illustrations','','','en',NULL,165,'','Contents Technology and the stage model of behavioral intervention development / Lisa S. Onken, Varda Shoham -- Theoretical models to inform technology-based health behavior interventions / William T. Riley -- Behavioral monitoring and assessment via sensing technologies / Santosh Kumar, J. Gayle Beck, Emre Ertin, Marcia Scott -- Technology-based behavioral interventions for alcohol and drug use problems / Aimee Campbell, Frederick Muench, Edward V. Nunes -- Using behavioral intervention technologies to reduce the burden of mood and anxiety disorders / Stephen M. Schueller, Miraj Chokshi, David C. Mohr -- Technologies for people with serious mental illness / Dror Ben-Zeev, Robert E. Drake, Rachel M. Brian -- Applying technology to medication management and adherence / Leah L. Zullig, Ryan J. Shaw, Hayden B. Bosworth -- Technological approaches to assess and treat cigarette smoking / Jesse Dallery, Sarah Martner -- Technology-based interventions to promote diet, exercise and weight control / Deborah Tate, Carmina Valle -- Evidence-based approaches to harnessing technology to provide social-emotional support / Timothy Bickmore -- mHealth analytics / Daniel M. Smith, Theodore A. Walls -- Research designs to develop and evaluate technology-based health behavior interventions / Jesse Dallery, William Riley, Inbal Nahum-Shani -- Evaluating mechanisms of behavior change to inform and evaluate technology-based interventions / Amanda N. Baraldi, Ingrid C. Wurpts, David P. MacKinnon, Ginger Lockhart -- Economics analysis of technology-based behavioral health care systems / Daniel Polsky -- Models for effective dissemination and implementation of technology-based behavioral health care systems / Sarah Lord -- Privacy, security, and regulatory considerations as related to behavioral health information technology / Penelope P. Hughes, Melissa M. Goldstein -- Harnessing mHealth in low-resource settings to overcome health system constraints and achieve universal access to health / Garrett Mehl, Lavanya Vasudevan, Lianne Gonsalves, Matt Berg, Tamsyn Seimon, Marleen Temmerman, Alain Labrique -- Open architecture and standards in mobile health / Julia E. Hoffman, Kelly M. Ramsey, Deborah Estrin -- Using technology to integrate behavioral health into primary care / Lola Awoyinka, David H. Gustafson, Roberta Johnson -- The potential of technology solutions for behavioral healthcare disparities / Michael Christopher Gibbons -- Behavioral health information technology adoption in the context of a changing healthcare landscape / Wendy Nilsen, Misha Pavel -- Envisioning the future : transformation of health care systems via technology','behavior2.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-05-03 07:44:28','2020-05-03 07:54:08',NULL,NULL);
INSERT INTO `biblio` VALUES (868,32,'Fundamentals of nursing models, theories and practice','','','',278,'2014','245 pages','','','en',NULL,166,'','Abstract \"A concise, accessible introduction to the development, application and evaluation of nursing theories, this new edition of Fundamentals of Nursing Models, Theories & Practice provides a thorough overview of the body of knowledge on the topic, and a clear outline of their relevance to everyday nursing practice. Linking the development of theory to practice, this full-updated text features learning outcomes, key concept summaries and reflective exercises to aid the study of this key element of all modern nursing courses. Special Features- Clearly examines the relationship between nursing theory, clinical practice and nursing roles- Accessible and user-friendly with a range of features to help study, including key concepts, learning objectives and reflective exercises- Useful for all pre-registration nursing students, as well as newly qualified nurses- Accompanied by an online resource centre featuring case studies, multiple choice questions, exercises and activities\"','models112.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-05-03 07:44:28','2020-05-03 07:56:00',NULL,NULL);
INSERT INTO `biblio` VALUES (869,32,'Sociology for nurses','','2nd','',279,'2014','585 pages','','','en',NULL,97,'','Abstract In its pursuit to bring about an awakening among students of nursing about human social behavior, this second edition of Sociology for Nurses continues to build on sociological theories that are of relevance to the nursing community. Conforming to the syllabus prescribed by the Indian Nursing Council and catering to the needs of second year B. Sc Nursing students, this book provides jargon-free explanation of even the most difficult concepts to the student\'s benefit.','sociology56.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-05-03 07:44:28','2020-05-03 07:58:33',NULL,NULL);
INSERT INTO `biblio` VALUES (870,32,'Nursing Career Fulfillment : Statistics and Statements from Registered Nurses','','January-February 2005 /Vol. 23 / No. 1','',280,'2005','7 Pages','','','en',NULL,149,'','','nurscareer1.png.png',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-05-03 07:44:28','2020-05-03 08:00:59',NULL,NULL);
INSERT INTO `biblio` VALUES (871,32,'Statistics for health care professionals : an introduction','','','',281,'2005','(vi, 241 pages) : illustrations','','','en',NULL,167,'','Contents Statistics for health care research ; The statistical approach: when should it be applied? / Debbie Mazhindu and Ian Scott -- Measuring, sampling and error / Ian Scott and Debbie Mazhindu -- Questionnaires / Debbie Mazhindu and Ian Scott -- The studies / Ian Scott and Debbie Mazhindu -- Descriptive statistics ; Displaying data / Kathie Moore, Ian Scott and Debbie Mazhindu -- Hypothesis testing ; Distributions and probabilities ; Making predictions ; Testing for differences between means ; Errors and ANOVAs ; Not normal ; Non-parametric tests ; Tests for association (1) Chi-square ; Tests for association (2) Correlation and regression ; Analysing data from systematic reviews ; Choosing test statistics / Ian Scott and Debbie Mazhindu -- Appendices. A guide to analysing statistics critically / Debbie Mazhindu and Ian Scott -- Statistical tables ; Answers to exercises ; The common symbols and abbreviations used in statistics','stats456.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-05-03 07:44:28','2020-05-03 08:04:23',NULL,NULL);
INSERT INTO `biblio` VALUES (872,32,'Therapeutic communication in mental health nursing : aesthetic and metaphoric processes in the engagement with challenging patients','','','',282,'2017','75 pages','','','en',NULL,168,'','Contents The gestural bridge -- Metaphor, play, and the representation of ideas in body-based analogies : meeting people where they are -- Garden-variety metaphors -- The house as grammatical form -- Rhythms and regularities in a musical bridge -- Nursing knowledge and nursing art : implications for learning and professional development.\r\n  Abstract This book introduces an innovative technique for therapeutic communication in mental health nursing, expanding the toolkit for nurses seeking to engage challenging patients who have not responded to more conventional therapeutic methods. Linking nursing communication to current research on metaphor and figuration, it is illustrated with accessible clinical examples. Metaphor is a key component of talk-based psychotherapies. But many of the patients whom nurses encounter in the inpatient setting are not good candidates for talk-based approaches, at least initially, because they are violent, withdrawn, highly regressed, or otherwise lacking a vocabulary to convey thoughts and feelings. This book offers specific clinical examples of an approach called the \"gestural bridge.\" This is a method for structuring games and physical activities which connect metaphorically to a patient\'s personal themes, activating narrative and observational agency and enabling an exchange of meaning to begin at a time when conventional language is not available. Rooted in what nursing theorists have called the \"embodied\" or \"aesthetic\" way of knowing, this approach is both specific and easily grasped. Therapeutic Communication in Mental Health Nursing is important reading for advanced-level practitioners, students, and researchers interested in communication and relationship-building in nursing.\"','thera23.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-05-03 07:44:28','2020-05-03 08:07:06',NULL,NULL);
INSERT INTO `biblio` VALUES (873,32,'Therapeutic nursing : improving patient care through self-awareness and reflection','','','',223,'2002','xi, 198 pages : illustrations','','','en',NULL,169,'','Contents The Therapeutic Use of Self in Nursing / Dawn Freshwater -- The Practitioner\'s Perspective -- The Importance of Philosophical Congruence for Therapeutic Use of Self in Practice / Roderick McKenzie -- Therapeutic Nursing and Technology: Clinical Supervision and Reflective Practice in a Critical Care Setting / Jill Down -- The Role of the Internal Supervisor in Developing Therapeutic Nursing / Gillian Todd -- The Educationalist\'s Perspective -- Transformative Learning: Enabling Therapeutic Nursing / Jacqueline Randle -- Aesthetic Ways in Day-to-day Nursing / Marilyn E. Parker -- Nursing Students\' Development of Caring Self Through Creative Reflective Practice / A. Lynne Wagner -- The Researcher\'s Perspective -- A Praxis Model of Research for Therapeutic Nursing / Carol Picard -- Individual Identity or Deviant Case? / Tessa Muncey -- Reflexive Research and the Therapeutic Use of Self / Gary Rolfe.\r\n  Abstract \"Gaining self-awareness is a vital aspect of professional development for all who work in the caring professions. In nursing especially, the ability to evaluate oneself affects all areas of practice, including direct patient care, working relationships with colleagues and maintaining one\'s own well-being in the often pressured environment of health care. This is an innovative text which explores the ways in which self-awareness can be used as a practical tool for continuing professional development and practice improvement. Divided into three parts, the book examines the role of the nurse as therapeutic practitioner, reflective learner and reflexive researcher. For all those wishing to develop their skills as autonomous, reflective, accountable practitioners, this book will be an inspiring read. It will be of immense use to those who teach and supervise nurses at all levels.\"','thera45.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-05-03 07:44:28','2020-05-03 08:11:40',NULL,NULL);
INSERT INTO `biblio` VALUES (874,32,'An introduction to the sociology of health and illness','','','',281,'2002','x, 196 pages','','','en',NULL,169,'','Contents Sociology, Genetics, Social Mobility and Lifestyle -- The Sociological Perspective -- Postmodernity and Sociology -- Sociological Approaches to Health and Illness -- Political Economy and Marxist Approaches -- Parsonian Sociology of Health -- Foucault\'s Sociology of Health -- Feminist Approaches -- Bringing the Approaches Together -- The Social Construction of Medical Knowledge -- Making Reality Problematic: The Problem of the Medical Model of Disease -- Medical Knowledge Mediates Social Relations -- Masturbatory Insanity -- Hysteria -- The Technical Realm of Medical Practice -- Medical Technology and Social Relations -- The Sociology of Medical Knowledge -- Fleck and Representations -- Fleck\'s Sociology of Medical Knowledge -- Syphilis -- Anatomical Drawings -- Fleck, Foucault and Kuhn -- Applying Fleck -- The Development of the Sociology of Health -- The Relationship Between Sociology and Medicine -- Medical Bias in the Sociology of Health -- Challenging Medicine -- Social Aspects of Disease -- The Critique of the Medical Model -- Key Concepts in the Sociology of Health -- The Concept of Medicalization -- Disease: Nature or Society -- Medicalization and Women -- The Social Functions of Medical Knowledge and Practice -- The Development of Medicalization -- Case Study: Gambling -- Case Study: Alcoholism -- Developments in the Medical Profession -- Characteristics of the Medicalization of Society -- Case Study: Learning Disabilities, Dyslexia and the Medicalization of the Classroom -- Assessing Medicalization.\r\nAbstract \"This book demonstrates that disease is socially produced and distributed, arguing that becoming sick and unhealthy is not merely the result of individual misfortune or an accident of nature, it is a consequence of the social, political and economic organization of society.\"','soci2.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-05-17 00:18:33','2020-05-17 00:23:41',NULL,NULL);
INSERT INTO `biblio` VALUES (875,32,'Global perspectives on women\'s sexual and reproductive health across the lifecourse','','','',203,'2018','xvii, 441 pages : illustrations','','','en',NULL,146,'','Contents Part I: Childhood and emerging adulthood. Girl child marriage : a persistent global women\'s health and human rights violation / Anita Raj, Emma Jackson, and Serena Dunham -- The role of premarital agency in delaying marriage and reproductive decision making in urban India / Marie A. Brault, Stephen L. Schensul, and Shweta Bankar -- The case for a multi-sectoral approach to preventing child marriage and early childbearing in sub-Saharan Africa / Eunice Muthengi and Karen Austrian -- Reframing the way we think about teenage motherhood / Brittany D. Chambers and Jennifer Toller Erausquin -- Part II: Childbearing. Vaginal birth after cesarean section (VBAC) : informed choice and a source of empowerment among Black women in the United States / Kara Francisco and Morgan Sanchez -- \"Sickness of shame\" : investigating challenges and resilience among women living with obstetric fistula in Kenya / Charlotte E. Warren, Pooja Sripad, Annie Mwangi, Charity Ndwiga, Wilson Liambila, and Ben Bellows -- Empowering women in India to influence maternal healthcare quality through mobile phones and crowdsourcing / Aparajita Gogoi, Manju Katoch, and Priya Agarwal -- Part III: Reproductive control. The role of Balinese culture in explaining inconsistencies between fertility intentions and reproductive outcomes / Mellissa Withers, Carole Browner, and I. Nengah Ardika Adinata -- Knowing client rights and meeting their needs : provider knowledge and attitudes toward meeting the reproductive needs and rights of people living with HIV in South Africa / Deborah Mindry, Pranitha Maharaj, Thabo Letsoalo, Chantal Munthree, and Tamaryn Crankshaw -- Claiming the abortion narrative : a qualitative exploration of mainstream and social media reflections on abortion / Natalie Whaley and Jenn Brandt -- The criminalization of women for abortion in Chile / Michele Eggers -- Part IV: Violence. From violence to sex work : agency, escaping violence, and HIV risk among establishment-based female sex workers in Tijuana, Mexico / Shonali M. Choudhury, Debbie Anglade, and Kyuwon Park -- A continuum of severity of sexual intimate parter violence among Black women in the United States / Jamila K. Stockman and Kristin K. Gundersen -- A conceptual framework and intervention approach for addressing intimate partner violence in pregnancy : the safe & sound model in South Africa / Abigail M. Hatcher, Nataly Woollett, Christina C. Pallitto, and Claudia Garcia-Moreno -- Invisible survivors : causes and consequences of violence against older women and promising solutions / Jennifer McCleary-Sills, Cailin Crockett, and Bergen Cooper -- Women\'s exposure to sexual violence across the life cycle : an African perspective / Lillian Artz, Talia Meer, and Alex Mu?ller -- Part V: Beyond reproduction. Economic empowerment to improve sexual and reproductive health among women and girls / Elizabeth Reed, Brooke S. West, Marissa Salazar, and Ricardo Vera Monroy -- Women\'s HIV knowledge and condom use across diverse relationship types in the Dominican Republic and Haiti / Jennifer Toller Erausquin -- Women\'s partner relationships and reproductive and sexual health in Lusaka, Zambia / Lwendo Moonzwe Davis -- Women\'s sexual pleasure and the intimate spaces of heterosexual sex in Cape Town, South Africa / Laura Pascoe -- Cervical cancer prevention in East Africa : moving from evidence to implementation / Megan J. Huchko -- Menopause : a contextualized experience among social structures / Engida Yisma and Stephanie Ly.\r\n  Abstract This expansive survey spotlights pervasive issues affecting girls\' and women\'s sexual and reproductive health across the lifecourse. Research from diverse countries around the world analyzes the complex relationships among biological, psychological, sociocultural, and economic issues--particularly in terms of inequities--as they shape women\'s lives. Major challenges and possibilities for intervention are examined in their national context and with their global implications, including child marriage/motherhood, reproductive care and access, fertility, childbearing, contraception, abortion, HIV/STIs, gender-based violence, sexual pleasure, and menopause. In these forceful dispatches, a consistent human rights perspective emphasizes women\'s control, autonomy, and agency in all stages of their lives. A sampling of topics covered: Girl child marriage: a persistent global women\'s health and human rights violation; Investigating challenges and resilience among women living with obstetric fistula in Kenya; A qualitative exploration of mainstream and social media reflections on abortion; A continuum of severity of sexual intimate partner violence among black women in the United States; Economic empowerment to improve sexual and reproductive health among women and girls; Summarizing an interdisciplinary field on research and practical levels, Global Perspectives on Women\'s Sexual and Reproductive Health Across the Lifecourse will be an invaluable text for undergraduate and graduate courses in a wide range of fields, including public health, global health, women\'s studies, sociology, anthropology, gender studies, and human rights.','global1.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-05-17 00:18:33','2020-05-17 00:25:50',NULL,NULL);
INSERT INTO `biblio` VALUES (876,32,'Health Care in Ghana','','','',283,'2009','36 pages','','','en',NULL,170,'','','ghana2.PNG.PNG',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-05-17 00:18:33','2020-05-17 00:27:46',NULL,NULL);
INSERT INTO `biblio` VALUES (877,32,'Performance improvement in hospitals and health systems : managing analytics and quality in healthcare','','','',214,'2018','','','','en',NULL,143,'','Contents Quality and quality management -- Strategy and performance management -- Performance management methods and tools -- Developing new quality teams -- Project management -- Process redesign -- Big data, predictive modeling, and collaboration -- Analytics in healthcare organizations -- Population health management -- Future of quality improvement.\r\n  Abstract \"Healthcare Organizations offer significant opportunities for change and improvement in their overall performance. Hospitals and clinics are generally large, complex, and inefficient, and need serious development in process workflow and management systems, which will ultimately lead to better patient and financial outcomes. The National Academy of Medicine has stated that hospital systems are broken, and that they must begin by \"...improving hospital efficiency and patient flow, and using operational management methods and information technologies.\" In fact, costs and quality are two of the important aspects of the \"triple aim\" in healthcare. One area that offers significant potential for improvement is through the application of performance improvement methods to patient and process flows. Performance improvement has a significant impact on a hospital\'s over financial and strategic performance. Performance improvement involves the deployment of quantitative and scientific methods to model and influence the functioning of organizations. Performance improvement professionals are tasked with managing a variety of activities, such as deploying new information technologies, serving as project managers for construction events, re-engineering departmental process workflow, eliminating bottlenecks, and improving the flow and movement of patients between resource-intensive clinical areas. All of these are high risk, and require use of advanced, sophisticated methods to improve efficiency and quality, while minimizing disruptions from change. This updated edition is a comprehensive and concise guide to performance improvement in healthcare. It describes the management engineering principles focused on designing optimal management and information systems and processes. Case studies and examples are integrated throughout all chapters.','perf5.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-05-17 00:18:33','2020-05-17 00:29:11',NULL,NULL);
INSERT INTO `biblio` VALUES (878,32,'Service Business Model Innovation in Healthcare and Hospital Management : Models, Strategies, Tools','','','',203,'2017','XIV, 296 pages 63 illustrations, 40 illustrations','','','en',NULL,146,'','Contents Chapter 1 Service Model Innovation in Hospitals -- Beyond Expert Organizations -- Chapter 2 Strategies with Service Business Model Innovation -- Chapter 3 The integrated-Physician-Model -- Business Model Innovation in Hospital Management -- Chapter 4 The Role of Digital Disruption in Healthcare Service Innovation -- Chapter 5 The opportunities offered by digitizing clinical pathways -- Chapter 6 A New Perspective of Product-Service Business Models for Customized Manufacturing in Healthcare -- Chapter 7 Patient Driven Service Delivery Models in Mental Health Care -- Chapter 8 Essential Characteristics of Service Business Model Innovation in Healthcare: A Case-Study Approach -- Chapter 9 Characteristics and Drivers of Service Business Model Innovation in Hospitals. A Case Study of Three Mexican Hospitals -- Chapter 10 Business Model Design and Entrepreneurial Risk Evaluation for Health Service Innovations -- Chapter 11 Guided Business Modeling and Analysis for Business Professionals -- Chapter 12 Modeling directly executable processes for healthcare professionals with XMDD -- Chapter 13 Lean Tools for Service Business Model Innovation in Healthcare -- Chapter 14 Continuous and Co-Creative Business Model Creation -- Chapter 15 E-Health & Co-Production: Critical Drivers for Chronic Diseases Management.\r\n  Abstract This book demonstrates how to successfully manage and lead healthcare institutions by employing the logic of business model innovation to gain competitive advantages. Since clerk-like routines in professional organizations tend to overlook patient and service-centered healthcare solutions, it challenges the view that competition and collaboration in the healthcare sector should not only incorporate single-end services, therapies or diagnosis related groups. Moreover, the authors focus on holistic business models, which place greater emphasis on customer needs and put customers and patients first. The holistic business models approach addresses topics such as business operations, competitiveness, strategic business objectives, opportunities and threats, critical success factors and key performance indicators. The contributions cover various aspects of service business innovation such as reconfiguring the hospital business model in healthcare delivery, essential characteristics of service business model innovation in healthcare, guided business modeling and analysis for business professionals, patient-driven service delivery models in healthcare, and continuous and co-creative business model creation. All of the contributions introduce business models and strategies, process innovations, and toolkits that can be applied at the managerial level, ensuring the book will be of interest to healthcare professionals, hospital managers and consultants, as well as scholars, whose focus is on improving value-generating and competitive business architectures in the healthcare sector.','service1.jpg.jpg',NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2020-05-17 00:18:33','2020-05-17 00:32:54',NULL,NULL);
INSERT INTO `biblio` VALUES (879,32,'Evidence-based Care for Normal Labour and Birth','','1ST EDITION','0-203-96171-4',94,'2007','','','RG651 wal','en',NULL,114,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2021-04-20 12:54:23','2021-04-20 12:59:26',NULL,NULL);
INSERT INTO `biblio` VALUES (880,1,'Testing Mike','','7th','9781139135009',131,'2017','xi, 497 pages','','K3316 .D89','en',NULL,7,'','Abstract\r\nIn Elements of Legislation, Neil Duxbury examines the history of English law through the lens of legal philosophy in an effort to draw out the differences between judge-made and enacted law and to explain what courts do with the laws that legislatures enact. He presents a series of rigorously researched and carefully rehearsed arguments concerning the law-making functions of legislatures and courts, the concepts of legislative supremacy and judicial review, the nature of legislative intent and the core principles of statutory interpretation.','element1.jpg.jpg',NULL,1,0,NULL,0,'',NULL,NULL,NULL,'2021-10-13 16:19:51','2022-02-17 07:49:09',NULL,NULL);
INSERT INTO `biblio` VALUES (881,1,'PRINCIPLES OF PUBLIC/COMMUNITY HEALTH NURSING','','VOL.2','9988125295',0,'2009','','','RT 98 off. C1','en',NULL,66,'','','cover_principles_of_public_community_health_nursing.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2021-10-15 11:15:13','2022-02-17 07:46:59',NULL,NULL);
INSERT INTO `biblio` VALUES (882,1,'COMMUNITY HEALTH NURSING(Principles and Practice)','','SECOND EDITION','9789374735152',140,'2015','','','RT 98 joe .c1','en',NULL,97,'','','cover_community_health_nursing_principles_and_practice_.jpg',NULL,0,1,NULL,0,'',NULL,NULL,NULL,'2021-10-15 12:04:48','2022-02-17 07:40:05',NULL,NULL);
INSERT INTO `biblio` VALUES (883,1,'PRINCIPLES AND PRACTICE OF COMMUNITY HEALTH NURSING','','','9789988128333',0,'2007','','','RT 98 asi c1','en',NULL,0,'','',NULL,NULL,0,0,NULL,0,'',NULL,NULL,NULL,'2021-10-15 13:00:34','2021-10-15 13:00:34',NULL,NULL);
/*!40000 ALTER TABLE `biblio` ENABLE KEYS */;
COMMIT;

-- Dumped table `biblio` with 848 row(s)
--

--
-- Table structure for table `biblio_attachment`
--

DROP TABLE IF EXISTS `biblio_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `biblio_attachment` (
  `biblio_id` int(11) NOT NULL,
  `file_id` int(11) NOT NULL,
  `placement` enum('link','popup','embed') COLLATE utf8_unicode_ci DEFAULT NULL,
  `access_type` enum('public','private') COLLATE utf8_unicode_ci NOT NULL,
  `access_limit` text COLLATE utf8_unicode_ci,
  KEY `biblio_id` (`biblio_id`),
  KEY `file_id` (`file_id`),
  KEY `biblio_id_2` (`biblio_id`,`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `biblio_attachment`
--

/*!40000 ALTER TABLE `biblio_attachment` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `biblio_attachment` VALUES (145,1,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (146,2,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (147,3,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (148,4,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (149,5,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (150,6,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (151,7,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (152,8,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (153,9,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (226,10,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (227,11,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (228,12,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (229,13,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (230,14,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (231,15,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (232,16,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (234,17,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (233,18,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (235,19,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (236,20,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (237,21,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (238,22,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (239,23,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (240,24,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (241,25,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (242,26,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (243,27,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (244,28,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (245,29,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (246,30,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (247,31,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (248,32,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (249,33,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (250,34,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (251,35,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (252,36,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (253,37,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (254,38,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (255,39,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (256,40,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (257,41,'embed','public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (258,42,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (259,43,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (260,44,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (261,45,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (262,46,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (263,47,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (264,48,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (265,49,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (266,50,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (267,51,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (268,52,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (269,53,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (270,54,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (271,55,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (272,56,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (273,57,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (274,58,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (275,59,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (276,60,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (277,61,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (278,62,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (279,63,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (280,64,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (281,65,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (282,66,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (283,67,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (284,68,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (285,69,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (286,70,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (287,71,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (288,72,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (289,73,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (290,74,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (291,75,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (292,76,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (293,77,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (294,78,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (295,79,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (296,80,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (297,81,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (298,82,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (299,83,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (300,84,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (301,85,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (302,86,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (303,87,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (304,88,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (305,89,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (306,90,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (307,91,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (308,92,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (309,93,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (310,94,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (311,95,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (312,96,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (313,97,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (314,98,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (315,99,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (316,100,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (317,101,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (318,102,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (319,103,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (319,104,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (320,105,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (321,106,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (322,107,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (322,108,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (322,109,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (323,0,NULL,'public','a:1:{i:0;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (323,114,NULL,'public','a:1:{i:0;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (323,116,NULL,'public','a:1:{i:0;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (323,117,NULL,'public','a:1:{i:0;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (323,118,NULL,'public','a:1:{i:0;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (337,119,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (337,120,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (337,122,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (337,123,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (337,124,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (337,125,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (337,126,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (338,127,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (338,128,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (338,129,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (338,130,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (339,131,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (339,132,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (339,133,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (339,134,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (339,135,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (340,136,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (340,137,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (341,138,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (341,139,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (341,140,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (341,141,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (341,142,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (341,143,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (341,144,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (341,145,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (342,146,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (342,147,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (342,148,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (343,155,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (342,150,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (342,151,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (342,152,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (343,154,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (342,153,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (343,156,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (343,157,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (343,158,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (344,159,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (344,160,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (344,161,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (345,162,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (345,163,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (345,164,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (345,165,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (345,166,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (346,167,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (346,168,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (346,169,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (347,170,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (347,171,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (347,172,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (348,173,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (348,174,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (348,175,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (348,176,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (349,177,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (349,178,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (349,179,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (350,180,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (350,181,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (350,182,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (351,183,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (351,184,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (351,185,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (352,186,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (352,187,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (352,188,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (353,189,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (353,190,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (353,191,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (437,192,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (438,193,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (439,194,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (440,195,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (441,196,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (442,197,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (443,198,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (445,199,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (446,200,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (447,201,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (448,202,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (449,203,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (449,204,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (449,205,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (450,206,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (451,207,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (452,208,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (453,209,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (453,210,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (454,211,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (455,212,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (456,213,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (457,214,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (458,215,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (459,216,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (459,217,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (459,218,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (459,219,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (460,220,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (461,221,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (462,222,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (463,223,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (464,224,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (465,225,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (466,226,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (467,227,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (468,228,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (469,229,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (470,230,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (471,231,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (472,232,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (473,233,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (474,234,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (474,235,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (479,236,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (475,237,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (479,240,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (479,241,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (476,242,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (477,243,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (480,244,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (481,245,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (482,246,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (483,247,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (484,248,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (485,249,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (486,250,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (487,251,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (487,252,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (488,253,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (489,254,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (490,255,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (499,256,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (500,257,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (500,258,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (500,259,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (500,260,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (501,261,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (501,263,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (501,264,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (501,265,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (501,266,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (503,275,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (504,276,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (506,277,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (507,278,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (508,279,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (510,281,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (511,282,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (512,283,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (513,284,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (513,285,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (513,286,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (513,287,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (513,288,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (513,289,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (515,290,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (516,291,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (517,292,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (518,293,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (519,294,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (520,295,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (520,296,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (521,297,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (522,298,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (522,299,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (522,300,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (522,301,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (522,302,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (522,303,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (522,304,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (522,305,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (523,306,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (524,307,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (525,308,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (525,309,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (525,310,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (526,311,NULL,'public','a:2:{i:0;s:1:\"2\";i:1;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (530,319,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (531,320,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (532,321,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (533,322,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (562,323,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (563,324,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (564,325,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (565,326,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (566,327,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (567,328,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (568,329,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (569,330,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (570,331,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (569,333,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (569,334,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (569,335,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (569,336,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (569,337,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (569,338,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (569,339,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (569,340,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (569,341,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (569,342,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (571,343,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (572,344,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (573,345,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (574,346,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (574,347,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (574,348,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (574,349,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (574,350,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (574,351,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (575,352,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (576,353,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (577,354,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (577,355,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (577,356,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (578,357,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (579,358,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (580,359,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (581,360,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (582,361,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (583,362,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (584,363,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (585,364,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (586,365,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (587,366,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (588,367,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (588,368,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (588,369,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (589,370,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (589,371,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (589,372,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (590,373,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (590,374,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (590,375,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (595,376,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (591,377,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (592,378,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (594,379,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (593,380,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (596,381,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (597,382,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (597,383,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (597,384,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (598,385,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (598,386,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (599,387,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (600,0,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (601,388,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (601,389,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (603,390,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (612,391,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (604,392,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (605,393,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (605,394,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (606,395,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (607,396,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (607,397,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (607,398,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (608,399,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (609,400,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (610,401,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (611,402,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (611,403,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (611,404,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (611,405,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (614,406,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (613,407,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (615,408,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (616,409,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (617,410,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (618,411,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (619,412,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (620,413,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (620,414,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (621,0,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (616,522,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (623,0,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (624,0,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (625,415,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (626,416,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (627,417,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (627,418,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (629,419,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (630,420,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (631,421,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (632,422,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (633,423,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (634,424,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (635,425,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (636,426,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (637,427,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (638,0,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (639,0,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (640,428,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (641,0,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (642,429,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (643,430,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (644,431,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (645,432,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (646,0,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (647,433,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (648,434,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (649,0,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (650,435,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (651,0,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (652,436,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (653,437,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (654,438,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (655,439,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (656,440,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (657,441,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (658,442,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (659,443,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (660,444,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (661,445,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (662,446,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (663,0,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (664,447,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (665,0,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (666,0,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (667,448,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (668,449,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (669,0,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (670,0,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (671,450,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (673,451,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (674,452,NULL,'public','a:4:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";}');
INSERT INTO `biblio_attachment` VALUES (676,453,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (638,454,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (638,455,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (638,456,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (639,457,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (639,458,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (639,459,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (639,461,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (641,462,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (641,463,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (641,464,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (641,465,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (646,466,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (646,467,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (646,468,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (649,469,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (649,470,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (651,471,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (651,472,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (651,473,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (665,474,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (665,475,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (665,476,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (665,477,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (670,478,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (670,479,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (670,480,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (670,481,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (669,482,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (669,483,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (669,484,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (669,485,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (669,486,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (669,487,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (593,488,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (593,489,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (593,490,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (593,491,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (593,492,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (593,493,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (593,494,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (593,495,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (593,496,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (593,497,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (593,498,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (593,499,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (604,500,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (604,501,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (604,502,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (604,503,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (604,504,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (604,505,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (604,506,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (604,507,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (604,508,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (623,510,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (623,511,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (623,512,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (623,513,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (623,514,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (623,515,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (623,516,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (623,517,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (623,518,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (623,519,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (623,520,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (621,521,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (616,523,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (616,524,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (616,525,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (616,526,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (616,527,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (616,528,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (616,529,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (616,530,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (616,531,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (616,532,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (616,533,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (616,534,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (616,535,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (616,536,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (616,537,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (775,547,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (765,543,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (766,544,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (638,0,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (666,0,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (776,576,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (777,577,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (777,578,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (777,579,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (778,581,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (778,582,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (779,583,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (779,584,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (779,585,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (780,586,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (780,587,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (780,588,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (780,589,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (780,590,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (781,591,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (781,592,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (781,593,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (782,594,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (782,595,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (782,596,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (783,597,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (784,598,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (785,599,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (786,600,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (787,601,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (787,602,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (787,603,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (788,604,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (788,605,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (788,606,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (788,607,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (789,608,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (790,609,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (791,610,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (792,611,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (793,612,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (794,613,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (794,614,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (794,615,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (794,616,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (794,617,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (794,618,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (794,619,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (794,620,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (794,621,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (794,622,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (794,623,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (794,624,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (794,625,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (794,626,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (794,627,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (795,628,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (796,629,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (796,630,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (796,631,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (797,632,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (798,633,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (799,634,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (800,635,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (801,636,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (802,637,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (802,638,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (803,639,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (804,640,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (805,641,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (805,642,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (806,643,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (807,644,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (808,645,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (809,646,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (810,647,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (811,648,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (811,649,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (811,650,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (811,651,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (812,653,NULL,'public',NULL);
INSERT INTO `biblio_attachment` VALUES (812,654,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (812,655,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (813,656,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (813,657,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (813,658,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (813,659,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (814,660,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (814,661,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (814,662,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (814,663,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (815,665,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (815,666,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (815,667,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (815,668,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (815,669,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (815,670,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (815,671,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (815,672,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (815,673,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (815,674,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (816,675,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (816,676,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (816,677,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (816,678,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (816,679,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (816,680,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (816,681,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (817,683,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (818,684,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (819,685,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (820,686,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (821,687,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (821,688,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (822,689,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (823,690,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (824,691,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (825,692,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (826,693,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (827,694,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (828,695,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (829,696,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (830,697,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (830,698,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (830,699,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (831,700,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (832,701,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (833,702,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (834,703,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (835,704,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (836,705,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (837,706,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (838,707,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (838,708,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (839,709,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (839,710,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (839,711,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (840,712,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (840,713,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (840,714,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (841,715,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (842,716,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (842,717,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (843,718,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (843,719,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (843,720,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (843,721,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (844,722,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (844,723,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (844,724,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (844,725,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (845,726,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (846,727,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (847,728,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (848,729,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (849,732,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (850,734,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (851,735,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (852,736,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (853,737,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (854,738,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (855,739,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (856,740,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (857,741,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (858,742,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (859,743,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (860,744,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (861,745,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (862,746,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (863,747,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (864,748,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (865,749,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (866,750,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (867,751,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (868,752,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (869,753,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (870,754,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (871,755,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (872,756,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (873,757,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (874,0,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (875,758,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (876,759,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (877,760,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
INSERT INTO `biblio_attachment` VALUES (878,761,NULL,'public','a:3:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";}');
/*!40000 ALTER TABLE `biblio_attachment` ENABLE KEYS */;
COMMIT;

-- Dumped table `biblio_attachment` with 709 row(s)
--

--
-- Table structure for table `biblio_author`
--

DROP TABLE IF EXISTS `biblio_author`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `biblio_author` (
  `biblio_id` int(11) NOT NULL DEFAULT '0',
  `author_id` int(11) NOT NULL DEFAULT '0',
  `level` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`biblio_id`,`author_id`),
  KEY `biblio_id` (`biblio_id`),
  KEY `author_id` (`author_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `biblio_author`
--

/*!40000 ALTER TABLE `biblio_author` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `biblio_author` VALUES (158,229,1);
INSERT INTO `biblio_author` VALUES (72,215,1);
INSERT INTO `biblio_author` VALUES (153,214,1);
INSERT INTO `biblio_author` VALUES (152,213,1);
INSERT INTO `biblio_author` VALUES (151,212,1);
INSERT INTO `biblio_author` VALUES (150,211,1);
INSERT INTO `biblio_author` VALUES (157,228,1);
INSERT INTO `biblio_author` VALUES (156,227,1);
INSERT INTO `biblio_author` VALUES (72,216,1);
INSERT INTO `biblio_author` VALUES (155,226,1);
INSERT INTO `biblio_author` VALUES (149,210,1);
INSERT INTO `biblio_author` VALUES (148,209,1);
INSERT INTO `biblio_author` VALUES (154,225,1);
INSERT INTO `biblio_author` VALUES (154,224,1);
INSERT INTO `biblio_author` VALUES (148,208,1);
INSERT INTO `biblio_author` VALUES (26,222,1);
INSERT INTO `biblio_author` VALUES (87,220,1);
INSERT INTO `biblio_author` VALUES (26,221,1);
INSERT INTO `biblio_author` VALUES (27,218,1);
INSERT INTO `biblio_author` VALUES (72,217,1);
INSERT INTO `biblio_author` VALUES (147,207,1);
INSERT INTO `biblio_author` VALUES (147,206,1);
INSERT INTO `biblio_author` VALUES (146,205,1);
INSERT INTO `biblio_author` VALUES (145,204,1);
INSERT INTO `biblio_author` VALUES (16,25,2);
INSERT INTO `biblio_author` VALUES (17,26,2);
INSERT INTO `biblio_author` VALUES (18,27,2);
INSERT INTO `biblio_author` VALUES (18,28,2);
INSERT INTO `biblio_author` VALUES (19,29,2);
INSERT INTO `biblio_author` VALUES (19,30,2);
INSERT INTO `biblio_author` VALUES (20,31,2);
INSERT INTO `biblio_author` VALUES (21,31,2);
INSERT INTO `biblio_author` VALUES (22,32,2);
INSERT INTO `biblio_author` VALUES (23,33,2);
INSERT INTO `biblio_author` VALUES (24,34,2);
INSERT INTO `biblio_author` VALUES (24,35,2);
INSERT INTO `biblio_author` VALUES (24,36,2);
INSERT INTO `biblio_author` VALUES (25,37,2);
INSERT INTO `biblio_author` VALUES (154,223,1);
INSERT INTO `biblio_author` VALUES (28,39,2);
INSERT INTO `biblio_author` VALUES (29,40,2);
INSERT INTO `biblio_author` VALUES (29,41,2);
INSERT INTO `biblio_author` VALUES (29,42,2);
INSERT INTO `biblio_author` VALUES (30,43,2);
INSERT INTO `biblio_author` VALUES (31,44,2);
INSERT INTO `biblio_author` VALUES (31,45,2);
INSERT INTO `biblio_author` VALUES (32,46,2);
INSERT INTO `biblio_author` VALUES (33,47,2);
INSERT INTO `biblio_author` VALUES (33,48,2);
INSERT INTO `biblio_author` VALUES (33,49,2);
INSERT INTO `biblio_author` VALUES (34,50,2);
INSERT INTO `biblio_author` VALUES (35,51,2);
INSERT INTO `biblio_author` VALUES (36,52,2);
INSERT INTO `biblio_author` VALUES (37,53,2);
INSERT INTO `biblio_author` VALUES (38,54,2);
INSERT INTO `biblio_author` VALUES (39,55,2);
INSERT INTO `biblio_author` VALUES (39,56,2);
INSERT INTO `biblio_author` VALUES (40,57,2);
INSERT INTO `biblio_author` VALUES (41,58,2);
INSERT INTO `biblio_author` VALUES (41,59,2);
INSERT INTO `biblio_author` VALUES (42,60,2);
INSERT INTO `biblio_author` VALUES (43,61,2);
INSERT INTO `biblio_author` VALUES (45,62,2);
INSERT INTO `biblio_author` VALUES (45,63,2);
INSERT INTO `biblio_author` VALUES (46,64,2);
INSERT INTO `biblio_author` VALUES (47,65,2);
INSERT INTO `biblio_author` VALUES (47,66,2);
INSERT INTO `biblio_author` VALUES (47,67,2);
INSERT INTO `biblio_author` VALUES (48,68,2);
INSERT INTO `biblio_author` VALUES (48,69,2);
INSERT INTO `biblio_author` VALUES (49,70,2);
INSERT INTO `biblio_author` VALUES (50,71,2);
INSERT INTO `biblio_author` VALUES (50,72,2);
INSERT INTO `biblio_author` VALUES (50,73,2);
INSERT INTO `biblio_author` VALUES (51,74,2);
INSERT INTO `biblio_author` VALUES (52,75,2);
INSERT INTO `biblio_author` VALUES (52,76,2);
INSERT INTO `biblio_author` VALUES (53,77,2);
INSERT INTO `biblio_author` VALUES (54,78,2);
INSERT INTO `biblio_author` VALUES (54,79,2);
INSERT INTO `biblio_author` VALUES (220,330,1);
INSERT INTO `biblio_author` VALUES (56,0,2);
INSERT INTO `biblio_author` VALUES (57,81,2);
INSERT INTO `biblio_author` VALUES (57,82,2);
INSERT INTO `biblio_author` VALUES (58,83,2);
INSERT INTO `biblio_author` VALUES (59,84,2);
INSERT INTO `biblio_author` VALUES (59,85,2);
INSERT INTO `biblio_author` VALUES (59,86,2);
INSERT INTO `biblio_author` VALUES (60,87,2);
INSERT INTO `biblio_author` VALUES (61,88,2);
INSERT INTO `biblio_author` VALUES (62,89,2);
INSERT INTO `biblio_author` VALUES (63,90,2);
INSERT INTO `biblio_author` VALUES (63,91,2);
INSERT INTO `biblio_author` VALUES (64,92,2);
INSERT INTO `biblio_author` VALUES (65,93,2);
INSERT INTO `biblio_author` VALUES (66,94,2);
INSERT INTO `biblio_author` VALUES (66,95,2);
INSERT INTO `biblio_author` VALUES (67,96,2);
INSERT INTO `biblio_author` VALUES (67,97,2);
INSERT INTO `biblio_author` VALUES (68,98,2);
INSERT INTO `biblio_author` VALUES (69,99,2);
INSERT INTO `biblio_author` VALUES (69,100,2);
INSERT INTO `biblio_author` VALUES (70,101,2);
INSERT INTO `biblio_author` VALUES (71,102,2);
INSERT INTO `biblio_author` VALUES (324,353,1);
INSERT INTO `biblio_author` VALUES (75,104,2);
INSERT INTO `biblio_author` VALUES (75,105,2);
INSERT INTO `biblio_author` VALUES (75,106,2);
INSERT INTO `biblio_author` VALUES (76,107,2);
INSERT INTO `biblio_author` VALUES (76,108,2);
INSERT INTO `biblio_author` VALUES (76,109,2);
INSERT INTO `biblio_author` VALUES (76,110,2);
INSERT INTO `biblio_author` VALUES (76,111,2);
INSERT INTO `biblio_author` VALUES (76,112,2);
INSERT INTO `biblio_author` VALUES (77,113,2);
INSERT INTO `biblio_author` VALUES (77,114,2);
INSERT INTO `biblio_author` VALUES (77,115,2);
INSERT INTO `biblio_author` VALUES (78,116,2);
INSERT INTO `biblio_author` VALUES (78,117,2);
INSERT INTO `biblio_author` VALUES (78,118,2);
INSERT INTO `biblio_author` VALUES (79,119,2);
INSERT INTO `biblio_author` VALUES (79,120,2);
INSERT INTO `biblio_author` VALUES (82,121,2);
INSERT INTO `biblio_author` VALUES (83,122,2);
INSERT INTO `biblio_author` VALUES (83,123,2);
INSERT INTO `biblio_author` VALUES (84,124,2);
INSERT INTO `biblio_author` VALUES (85,125,2);
INSERT INTO `biblio_author` VALUES (85,126,2);
INSERT INTO `biblio_author` VALUES (86,127,2);
INSERT INTO `biblio_author` VALUES (86,128,2);
INSERT INTO `biblio_author` VALUES (88,129,2);
INSERT INTO `biblio_author` VALUES (89,130,2);
INSERT INTO `biblio_author` VALUES (90,131,2);
INSERT INTO `biblio_author` VALUES (91,132,2);
INSERT INTO `biblio_author` VALUES (92,133,2);
INSERT INTO `biblio_author` VALUES (93,134,2);
INSERT INTO `biblio_author` VALUES (94,135,2);
INSERT INTO `biblio_author` VALUES (94,136,2);
INSERT INTO `biblio_author` VALUES (94,137,2);
INSERT INTO `biblio_author` VALUES (95,122,2);
INSERT INTO `biblio_author` VALUES (95,123,2);
INSERT INTO `biblio_author` VALUES (96,29,2);
INSERT INTO `biblio_author` VALUES (96,30,2);
INSERT INTO `biblio_author` VALUES (97,138,2);
INSERT INTO `biblio_author` VALUES (98,139,2);
INSERT INTO `biblio_author` VALUES (99,140,2);
INSERT INTO `biblio_author` VALUES (99,141,2);
INSERT INTO `biblio_author` VALUES (100,142,2);
INSERT INTO `biblio_author` VALUES (100,143,2);
INSERT INTO `biblio_author` VALUES (100,144,2);
INSERT INTO `biblio_author` VALUES (101,145,2);
INSERT INTO `biblio_author` VALUES (102,145,2);
INSERT INTO `biblio_author` VALUES (103,146,2);
INSERT INTO `biblio_author` VALUES (104,147,2);
INSERT INTO `biblio_author` VALUES (105,148,2);
INSERT INTO `biblio_author` VALUES (680,304,1);
INSERT INTO `biblio_author` VALUES (107,150,2);
INSERT INTO `biblio_author` VALUES (107,151,2);
INSERT INTO `biblio_author` VALUES (108,152,2);
INSERT INTO `biblio_author` VALUES (109,153,2);
INSERT INTO `biblio_author` VALUES (109,154,2);
INSERT INTO `biblio_author` VALUES (110,155,2);
INSERT INTO `biblio_author` VALUES (111,156,2);
INSERT INTO `biblio_author` VALUES (112,122,2);
INSERT INTO `biblio_author` VALUES (112,27,2);
INSERT INTO `biblio_author` VALUES (113,27,2);
INSERT INTO `biblio_author` VALUES (113,28,2);
INSERT INTO `biblio_author` VALUES (114,122,2);
INSERT INTO `biblio_author` VALUES (114,123,2);
INSERT INTO `biblio_author` VALUES (115,157,2);
INSERT INTO `biblio_author` VALUES (115,158,2);
INSERT INTO `biblio_author` VALUES (116,159,2);
INSERT INTO `biblio_author` VALUES (117,160,2);
INSERT INTO `biblio_author` VALUES (117,161,2);
INSERT INTO `biblio_author` VALUES (118,162,2);
INSERT INTO `biblio_author` VALUES (119,163,2);
INSERT INTO `biblio_author` VALUES (119,164,2);
INSERT INTO `biblio_author` VALUES (119,165,2);
INSERT INTO `biblio_author` VALUES (120,166,2);
INSERT INTO `biblio_author` VALUES (120,167,2);
INSERT INTO `biblio_author` VALUES (121,168,2);
INSERT INTO `biblio_author` VALUES (122,169,2);
INSERT INTO `biblio_author` VALUES (123,170,2);
INSERT INTO `biblio_author` VALUES (123,171,2);
INSERT INTO `biblio_author` VALUES (124,172,2);
INSERT INTO `biblio_author` VALUES (124,173,2);
INSERT INTO `biblio_author` VALUES (125,174,2);
INSERT INTO `biblio_author` VALUES (125,175,2);
INSERT INTO `biblio_author` VALUES (126,176,2);
INSERT INTO `biblio_author` VALUES (126,177,2);
INSERT INTO `biblio_author` VALUES (126,178,2);
INSERT INTO `biblio_author` VALUES (127,179,2);
INSERT INTO `biblio_author` VALUES (127,180,2);
INSERT INTO `biblio_author` VALUES (128,181,2);
INSERT INTO `biblio_author` VALUES (130,182,2);
INSERT INTO `biblio_author` VALUES (131,183,2);
INSERT INTO `biblio_author` VALUES (131,184,2);
INSERT INTO `biblio_author` VALUES (132,185,2);
INSERT INTO `biblio_author` VALUES (132,186,2);
INSERT INTO `biblio_author` VALUES (133,187,2);
INSERT INTO `biblio_author` VALUES (134,188,2);
INSERT INTO `biblio_author` VALUES (135,189,2);
INSERT INTO `biblio_author` VALUES (136,190,2);
INSERT INTO `biblio_author` VALUES (137,191,2);
INSERT INTO `biblio_author` VALUES (137,192,2);
INSERT INTO `biblio_author` VALUES (138,193,2);
INSERT INTO `biblio_author` VALUES (138,194,2);
INSERT INTO `biblio_author` VALUES (138,195,2);
INSERT INTO `biblio_author` VALUES (139,497,6);
INSERT INTO `biblio_author` VALUES (140,196,2);
INSERT INTO `biblio_author` VALUES (140,197,2);
INSERT INTO `biblio_author` VALUES (141,198,2);
INSERT INTO `biblio_author` VALUES (142,199,2);
INSERT INTO `biblio_author` VALUES (143,200,2);
INSERT INTO `biblio_author` VALUES (144,201,2);
INSERT INTO `biblio_author` VALUES (144,202,2);
INSERT INTO `biblio_author` VALUES (144,203,2);
INSERT INTO `biblio_author` VALUES (159,232,1);
INSERT INTO `biblio_author` VALUES (160,233,1);
INSERT INTO `biblio_author` VALUES (160,234,1);
INSERT INTO `biblio_author` VALUES (160,235,1);
INSERT INTO `biblio_author` VALUES (161,236,1);
INSERT INTO `biblio_author` VALUES (161,237,1);
INSERT INTO `biblio_author` VALUES (161,238,1);
INSERT INTO `biblio_author` VALUES (162,239,1);
INSERT INTO `biblio_author` VALUES (163,240,1);
INSERT INTO `biblio_author` VALUES (164,241,1);
INSERT INTO `biblio_author` VALUES (243,1152,1);
INSERT INTO `biblio_author` VALUES (166,242,1);
INSERT INTO `biblio_author` VALUES (167,243,1);
INSERT INTO `biblio_author` VALUES (168,244,1);
INSERT INTO `biblio_author` VALUES (169,245,1);
INSERT INTO `biblio_author` VALUES (170,246,1);
INSERT INTO `biblio_author` VALUES (171,247,1);
INSERT INTO `biblio_author` VALUES (172,248,1);
INSERT INTO `biblio_author` VALUES (172,249,1);
INSERT INTO `biblio_author` VALUES (172,250,1);
INSERT INTO `biblio_author` VALUES (173,252,1);
INSERT INTO `biblio_author` VALUES (174,254,1);
INSERT INTO `biblio_author` VALUES (174,255,1);
INSERT INTO `biblio_author` VALUES (174,256,1);
INSERT INTO `biblio_author` VALUES (175,257,1);
INSERT INTO `biblio_author` VALUES (175,258,1);
INSERT INTO `biblio_author` VALUES (175,259,1);
INSERT INTO `biblio_author` VALUES (176,260,1);
INSERT INTO `biblio_author` VALUES (176,261,1);
INSERT INTO `biblio_author` VALUES (177,262,1);
INSERT INTO `biblio_author` VALUES (177,263,1);
INSERT INTO `biblio_author` VALUES (178,264,1);
INSERT INTO `biblio_author` VALUES (179,265,1);
INSERT INTO `biblio_author` VALUES (179,266,1);
INSERT INTO `biblio_author` VALUES (180,267,1);
INSERT INTO `biblio_author` VALUES (180,268,1);
INSERT INTO `biblio_author` VALUES (181,269,1);
INSERT INTO `biblio_author` VALUES (182,270,1);
INSERT INTO `biblio_author` VALUES (182,271,1);
INSERT INTO `biblio_author` VALUES (183,272,1);
INSERT INTO `biblio_author` VALUES (184,273,1);
INSERT INTO `biblio_author` VALUES (184,274,1);
INSERT INTO `biblio_author` VALUES (185,275,1);
INSERT INTO `biblio_author` VALUES (186,70,1);
INSERT INTO `biblio_author` VALUES (187,70,1);
INSERT INTO `biblio_author` VALUES (188,276,1);
INSERT INTO `biblio_author` VALUES (189,278,1);
INSERT INTO `biblio_author` VALUES (190,115,1);
INSERT INTO `biblio_author` VALUES (190,279,1);
INSERT INTO `biblio_author` VALUES (191,280,1);
INSERT INTO `biblio_author` VALUES (191,281,1);
INSERT INTO `biblio_author` VALUES (191,282,1);
INSERT INTO `biblio_author` VALUES (192,98,1);
INSERT INTO `biblio_author` VALUES (193,283,1);
INSERT INTO `biblio_author` VALUES (193,284,1);
INSERT INTO `biblio_author` VALUES (194,285,1);
INSERT INTO `biblio_author` VALUES (194,286,1);
INSERT INTO `biblio_author` VALUES (195,287,1);
INSERT INTO `biblio_author` VALUES (195,288,1);
INSERT INTO `biblio_author` VALUES (196,289,1);
INSERT INTO `biblio_author` VALUES (196,290,1);
INSERT INTO `biblio_author` VALUES (197,291,1);
INSERT INTO `biblio_author` VALUES (197,292,1);
INSERT INTO `biblio_author` VALUES (198,293,1);
INSERT INTO `biblio_author` VALUES (198,294,1);
INSERT INTO `biblio_author` VALUES (199,295,1);
INSERT INTO `biblio_author` VALUES (199,296,1);
INSERT INTO `biblio_author` VALUES (200,297,1);
INSERT INTO `biblio_author` VALUES (201,298,1);
INSERT INTO `biblio_author` VALUES (201,299,1);
INSERT INTO `biblio_author` VALUES (201,300,1);
INSERT INTO `biblio_author` VALUES (202,301,1);
INSERT INTO `biblio_author` VALUES (203,302,1);
INSERT INTO `biblio_author` VALUES (204,303,1);
INSERT INTO `biblio_author` VALUES (205,306,1);
INSERT INTO `biblio_author` VALUES (205,307,1);
INSERT INTO `biblio_author` VALUES (205,308,1);
INSERT INTO `biblio_author` VALUES (206,309,1);
INSERT INTO `biblio_author` VALUES (206,310,1);
INSERT INTO `biblio_author` VALUES (206,311,1);
INSERT INTO `biblio_author` VALUES (207,312,1);
INSERT INTO `biblio_author` VALUES (208,313,1);
INSERT INTO `biblio_author` VALUES (208,314,1);
INSERT INTO `biblio_author` VALUES (208,315,1);
INSERT INTO `biblio_author` VALUES (209,316,1);
INSERT INTO `biblio_author` VALUES (210,317,1);
INSERT INTO `biblio_author` VALUES (211,318,1);
INSERT INTO `biblio_author` VALUES (211,319,1);
INSERT INTO `biblio_author` VALUES (211,320,1);
INSERT INTO `biblio_author` VALUES (212,321,1);
INSERT INTO `biblio_author` VALUES (212,322,1);
INSERT INTO `biblio_author` VALUES (213,318,1);
INSERT INTO `biblio_author` VALUES (213,319,1);
INSERT INTO `biblio_author` VALUES (214,324,1);
INSERT INTO `biblio_author` VALUES (214,325,1);
INSERT INTO `biblio_author` VALUES (215,318,1);
INSERT INTO `biblio_author` VALUES (215,319,1);
INSERT INTO `biblio_author` VALUES (216,325,1);
INSERT INTO `biblio_author` VALUES (216,324,1);
INSERT INTO `biblio_author` VALUES (216,323,1);
INSERT INTO `biblio_author` VALUES (217,325,1);
INSERT INTO `biblio_author` VALUES (217,324,1);
INSERT INTO `biblio_author` VALUES (217,326,1);
INSERT INTO `biblio_author` VALUES (218,327,1);
INSERT INTO `biblio_author` VALUES (218,328,1);
INSERT INTO `biblio_author` VALUES (219,329,1);
INSERT INTO `biblio_author` VALUES (221,331,1);
INSERT INTO `biblio_author` VALUES (222,332,1);
INSERT INTO `biblio_author` VALUES (223,333,1);
INSERT INTO `biblio_author` VALUES (224,334,1);
INSERT INTO `biblio_author` VALUES (224,335,1);
INSERT INTO `biblio_author` VALUES (225,336,1);
INSERT INTO `biblio_author` VALUES (226,337,1);
INSERT INTO `biblio_author` VALUES (226,338,1);
INSERT INTO `biblio_author` VALUES (227,339,1);
INSERT INTO `biblio_author` VALUES (227,340,1);
INSERT INTO `biblio_author` VALUES (228,341,1);
INSERT INTO `biblio_author` VALUES (228,342,1);
INSERT INTO `biblio_author` VALUES (229,343,1);
INSERT INTO `biblio_author` VALUES (230,344,1);
INSERT INTO `biblio_author` VALUES (230,345,1);
INSERT INTO `biblio_author` VALUES (230,346,1);
INSERT INTO `biblio_author` VALUES (231,616,3);
INSERT INTO `biblio_author` VALUES (231,1136,3);
INSERT INTO `biblio_author` VALUES (232,349,3);
INSERT INTO `biblio_author` VALUES (74,350,1);
INSERT INTO `biblio_author` VALUES (325,354,1);
INSERT INTO `biblio_author` VALUES (326,355,1);
INSERT INTO `biblio_author` VALUES (326,356,1);
INSERT INTO `biblio_author` VALUES (326,357,1);
INSERT INTO `biblio_author` VALUES (327,358,1);
INSERT INTO `biblio_author` VALUES (327,359,1);
INSERT INTO `biblio_author` VALUES (327,360,1);
INSERT INTO `biblio_author` VALUES (328,361,1);
INSERT INTO `biblio_author` VALUES (329,362,1);
INSERT INTO `biblio_author` VALUES (329,363,1);
INSERT INTO `biblio_author` VALUES (329,364,1);
INSERT INTO `biblio_author` VALUES (330,365,1);
INSERT INTO `biblio_author` VALUES (331,366,1);
INSERT INTO `biblio_author` VALUES (332,367,1);
INSERT INTO `biblio_author` VALUES (333,367,1);
INSERT INTO `biblio_author` VALUES (334,368,1);
INSERT INTO `biblio_author` VALUES (335,369,1);
INSERT INTO `biblio_author` VALUES (335,370,1);
INSERT INTO `biblio_author` VALUES (336,371,1);
INSERT INTO `biblio_author` VALUES (336,372,1);
INSERT INTO `biblio_author` VALUES (354,373,1);
INSERT INTO `biblio_author` VALUES (354,374,1);
INSERT INTO `biblio_author` VALUES (355,373,1);
INSERT INTO `biblio_author` VALUES (355,374,1);
INSERT INTO `biblio_author` VALUES (355,375,1);
INSERT INTO `biblio_author` VALUES (356,244,1);
INSERT INTO `biblio_author` VALUES (357,376,1);
INSERT INTO `biblio_author` VALUES (357,123,1);
INSERT INTO `biblio_author` VALUES (358,377,1);
INSERT INTO `biblio_author` VALUES (358,378,1);
INSERT INTO `biblio_author` VALUES (359,379,1);
INSERT INTO `biblio_author` VALUES (359,380,1);
INSERT INTO `biblio_author` VALUES (360,381,1);
INSERT INTO `biblio_author` VALUES (360,382,1);
INSERT INTO `biblio_author` VALUES (361,383,1);
INSERT INTO `biblio_author` VALUES (362,384,1);
INSERT INTO `biblio_author` VALUES (362,385,1);
INSERT INTO `biblio_author` VALUES (363,386,1);
INSERT INTO `biblio_author` VALUES (363,387,1);
INSERT INTO `biblio_author` VALUES (364,388,1);
INSERT INTO `biblio_author` VALUES (364,389,1);
INSERT INTO `biblio_author` VALUES (364,390,1);
INSERT INTO `biblio_author` VALUES (365,391,1);
INSERT INTO `biblio_author` VALUES (365,392,1);
INSERT INTO `biblio_author` VALUES (365,393,1);
INSERT INTO `biblio_author` VALUES (366,394,1);
INSERT INTO `biblio_author` VALUES (367,395,1);
INSERT INTO `biblio_author` VALUES (368,396,1);
INSERT INTO `biblio_author` VALUES (369,397,1);
INSERT INTO `biblio_author` VALUES (370,398,1);
INSERT INTO `biblio_author` VALUES (371,399,1);
INSERT INTO `biblio_author` VALUES (372,400,1);
INSERT INTO `biblio_author` VALUES (373,153,1);
INSERT INTO `biblio_author` VALUES (373,154,1);
INSERT INTO `biblio_author` VALUES (374,401,1);
INSERT INTO `biblio_author` VALUES (374,402,1);
INSERT INTO `biblio_author` VALUES (374,403,1);
INSERT INTO `biblio_author` VALUES (375,404,1);
INSERT INTO `biblio_author` VALUES (375,405,1);
INSERT INTO `biblio_author` VALUES (375,406,1);
INSERT INTO `biblio_author` VALUES (376,407,1);
INSERT INTO `biblio_author` VALUES (376,408,1);
INSERT INTO `biblio_author` VALUES (376,409,1);
INSERT INTO `biblio_author` VALUES (377,410,1);
INSERT INTO `biblio_author` VALUES (378,411,1);
INSERT INTO `biblio_author` VALUES (379,412,1);
INSERT INTO `biblio_author` VALUES (379,413,1);
INSERT INTO `biblio_author` VALUES (380,414,1);
INSERT INTO `biblio_author` VALUES (380,415,1);
INSERT INTO `biblio_author` VALUES (381,416,1);
INSERT INTO `biblio_author` VALUES (381,417,1);
INSERT INTO `biblio_author` VALUES (382,418,1);
INSERT INTO `biblio_author` VALUES (382,419,1);
INSERT INTO `biblio_author` VALUES (383,420,1);
INSERT INTO `biblio_author` VALUES (383,421,1);
INSERT INTO `biblio_author` VALUES (384,422,1);
INSERT INTO `biblio_author` VALUES (384,423,1);
INSERT INTO `biblio_author` VALUES (385,424,1);
INSERT INTO `biblio_author` VALUES (386,253,1);
INSERT INTO `biblio_author` VALUES (386,425,1);
INSERT INTO `biblio_author` VALUES (386,426,1);
INSERT INTO `biblio_author` VALUES (387,427,1);
INSERT INTO `biblio_author` VALUES (387,428,1);
INSERT INTO `biblio_author` VALUES (388,429,1);
INSERT INTO `biblio_author` VALUES (388,430,1);
INSERT INTO `biblio_author` VALUES (389,431,1);
INSERT INTO `biblio_author` VALUES (389,432,1);
INSERT INTO `biblio_author` VALUES (389,433,1);
INSERT INTO `biblio_author` VALUES (390,434,1);
INSERT INTO `biblio_author` VALUES (390,435,1);
INSERT INTO `biblio_author` VALUES (390,437,1);
INSERT INTO `biblio_author` VALUES (391,438,1);
INSERT INTO `biblio_author` VALUES (392,439,1);
INSERT INTO `biblio_author` VALUES (392,440,1);
INSERT INTO `biblio_author` VALUES (393,441,1);
INSERT INTO `biblio_author` VALUES (394,442,1);
INSERT INTO `biblio_author` VALUES (394,443,1);
INSERT INTO `biblio_author` VALUES (394,444,1);
INSERT INTO `biblio_author` VALUES (395,445,1);
INSERT INTO `biblio_author` VALUES (395,446,1);
INSERT INTO `biblio_author` VALUES (396,447,1);
INSERT INTO `biblio_author` VALUES (397,448,1);
INSERT INTO `biblio_author` VALUES (397,449,1);
INSERT INTO `biblio_author` VALUES (398,450,1);
INSERT INTO `biblio_author` VALUES (399,366,1);
INSERT INTO `biblio_author` VALUES (400,369,1);
INSERT INTO `biblio_author` VALUES (401,451,1);
INSERT INTO `biblio_author` VALUES (401,452,1);
INSERT INTO `biblio_author` VALUES (402,453,1);
INSERT INTO `biblio_author` VALUES (402,454,1);
INSERT INTO `biblio_author` VALUES (403,455,1);
INSERT INTO `biblio_author` VALUES (404,456,1);
INSERT INTO `biblio_author` VALUES (405,457,1);
INSERT INTO `biblio_author` VALUES (406,458,1);
INSERT INTO `biblio_author` VALUES (406,459,1);
INSERT INTO `biblio_author` VALUES (407,460,1);
INSERT INTO `biblio_author` VALUES (407,461,1);
INSERT INTO `biblio_author` VALUES (407,462,1);
INSERT INTO `biblio_author` VALUES (408,463,1);
INSERT INTO `biblio_author` VALUES (409,464,1);
INSERT INTO `biblio_author` VALUES (410,465,1);
INSERT INTO `biblio_author` VALUES (410,466,1);
INSERT INTO `biblio_author` VALUES (411,467,1);
INSERT INTO `biblio_author` VALUES (411,468,1);
INSERT INTO `biblio_author` VALUES (411,469,1);
INSERT INTO `biblio_author` VALUES (412,360,1);
INSERT INTO `biblio_author` VALUES (412,470,1);
INSERT INTO `biblio_author` VALUES (412,471,1);
INSERT INTO `biblio_author` VALUES (413,472,1);
INSERT INTO `biblio_author` VALUES (413,473,1);
INSERT INTO `biblio_author` VALUES (413,474,1);
INSERT INTO `biblio_author` VALUES (414,475,1);
INSERT INTO `biblio_author` VALUES (414,476,1);
INSERT INTO `biblio_author` VALUES (414,477,1);
INSERT INTO `biblio_author` VALUES (415,478,1);
INSERT INTO `biblio_author` VALUES (415,479,1);
INSERT INTO `biblio_author` VALUES (415,480,1);
INSERT INTO `biblio_author` VALUES (416,481,1);
INSERT INTO `biblio_author` VALUES (417,482,1);
INSERT INTO `biblio_author` VALUES (417,483,1);
INSERT INTO `biblio_author` VALUES (418,484,1);
INSERT INTO `biblio_author` VALUES (418,485,1);
INSERT INTO `biblio_author` VALUES (419,486,1);
INSERT INTO `biblio_author` VALUES (420,484,1);
INSERT INTO `biblio_author` VALUES (420,485,1);
INSERT INTO `biblio_author` VALUES (421,487,1);
INSERT INTO `biblio_author` VALUES (421,488,1);
INSERT INTO `biblio_author` VALUES (422,181,6);
INSERT INTO `biblio_author` VALUES (423,489,6);
INSERT INTO `biblio_author` VALUES (424,490,1);
INSERT INTO `biblio_author` VALUES (425,491,1);
INSERT INTO `biblio_author` VALUES (426,52,1);
INSERT INTO `biblio_author` VALUES (427,493,1);
INSERT INTO `biblio_author` VALUES (428,494,1);
INSERT INTO `biblio_author` VALUES (428,495,1);
INSERT INTO `biblio_author` VALUES (429,496,1);
INSERT INTO `biblio_author` VALUES (430,498,1);
INSERT INTO `biblio_author` VALUES (431,499,1);
INSERT INTO `biblio_author` VALUES (431,500,1);
INSERT INTO `biblio_author` VALUES (432,501,1);
INSERT INTO `biblio_author` VALUES (433,502,1);
INSERT INTO `biblio_author` VALUES (434,503,1);
INSERT INTO `biblio_author` VALUES (435,504,1);
INSERT INTO `biblio_author` VALUES (436,505,1);
INSERT INTO `biblio_author` VALUES (436,506,1);
INSERT INTO `biblio_author` VALUES (437,507,1);
INSERT INTO `biblio_author` VALUES (437,508,1);
INSERT INTO `biblio_author` VALUES (437,509,1);
INSERT INTO `biblio_author` VALUES (438,510,1);
INSERT INTO `biblio_author` VALUES (438,511,1);
INSERT INTO `biblio_author` VALUES (438,512,1);
INSERT INTO `biblio_author` VALUES (438,513,1);
INSERT INTO `biblio_author` VALUES (438,514,1);
INSERT INTO `biblio_author` VALUES (438,515,1);
INSERT INTO `biblio_author` VALUES (439,516,1);
INSERT INTO `biblio_author` VALUES (439,517,1);
INSERT INTO `biblio_author` VALUES (440,518,1);
INSERT INTO `biblio_author` VALUES (440,519,1);
INSERT INTO `biblio_author` VALUES (441,520,1);
INSERT INTO `biblio_author` VALUES (441,521,1);
INSERT INTO `biblio_author` VALUES (441,522,1);
INSERT INTO `biblio_author` VALUES (442,523,1);
INSERT INTO `biblio_author` VALUES (442,524,1);
INSERT INTO `biblio_author` VALUES (443,525,1);
INSERT INTO `biblio_author` VALUES (443,526,1);
INSERT INTO `biblio_author` VALUES (443,527,1);
INSERT INTO `biblio_author` VALUES (445,528,1);
INSERT INTO `biblio_author` VALUES (445,529,1);
INSERT INTO `biblio_author` VALUES (445,530,1);
INSERT INTO `biblio_author` VALUES (445,531,1);
INSERT INTO `biblio_author` VALUES (446,535,1);
INSERT INTO `biblio_author` VALUES (447,532,1);
INSERT INTO `biblio_author` VALUES (447,533,1);
INSERT INTO `biblio_author` VALUES (447,181,1);
INSERT INTO `biblio_author` VALUES (447,534,1);
INSERT INTO `biblio_author` VALUES (448,538,1);
INSERT INTO `biblio_author` VALUES (448,539,1);
INSERT INTO `biblio_author` VALUES (449,540,1);
INSERT INTO `biblio_author` VALUES (450,541,1);
INSERT INTO `biblio_author` VALUES (451,542,1);
INSERT INTO `biblio_author` VALUES (451,543,1);
INSERT INTO `biblio_author` VALUES (452,545,1);
INSERT INTO `biblio_author` VALUES (452,546,1);
INSERT INTO `biblio_author` VALUES (453,544,1);
INSERT INTO `biblio_author` VALUES (453,547,1);
INSERT INTO `biblio_author` VALUES (454,548,1);
INSERT INTO `biblio_author` VALUES (454,549,1);
INSERT INTO `biblio_author` VALUES (455,550,1);
INSERT INTO `biblio_author` VALUES (456,551,1);
INSERT INTO `biblio_author` VALUES (456,552,1);
INSERT INTO `biblio_author` VALUES (456,553,1);
INSERT INTO `biblio_author` VALUES (457,554,1);
INSERT INTO `biblio_author` VALUES (458,555,1);
INSERT INTO `biblio_author` VALUES (459,556,1);
INSERT INTO `biblio_author` VALUES (459,557,1);
INSERT INTO `biblio_author` VALUES (459,558,1);
INSERT INTO `biblio_author` VALUES (460,1145,1);
INSERT INTO `biblio_author` VALUES (460,218,1);
INSERT INTO `biblio_author` VALUES (461,560,1);
INSERT INTO `biblio_author` VALUES (466,550,1);
INSERT INTO `biblio_author` VALUES (467,562,3);
INSERT INTO `biblio_author` VALUES (467,1158,1);
INSERT INTO `biblio_author` VALUES (468,561,1);
INSERT INTO `biblio_author` VALUES (469,564,1);
INSERT INTO `biblio_author` VALUES (469,565,1);
INSERT INTO `biblio_author` VALUES (469,566,1);
INSERT INTO `biblio_author` VALUES (470,567,1);
INSERT INTO `biblio_author` VALUES (470,568,1);
INSERT INTO `biblio_author` VALUES (470,569,1);
INSERT INTO `biblio_author` VALUES (472,570,1);
INSERT INTO `biblio_author` VALUES (473,571,1);
INSERT INTO `biblio_author` VALUES (473,572,1);
INSERT INTO `biblio_author` VALUES (473,573,1);
INSERT INTO `biblio_author` VALUES (474,574,1);
INSERT INTO `biblio_author` VALUES (474,575,1);
INSERT INTO `biblio_author` VALUES (475,576,1);
INSERT INTO `biblio_author` VALUES (475,577,1);
INSERT INTO `biblio_author` VALUES (475,578,1);
INSERT INTO `biblio_author` VALUES (475,579,1);
INSERT INTO `biblio_author` VALUES (476,580,1);
INSERT INTO `biblio_author` VALUES (477,581,1);
INSERT INTO `biblio_author` VALUES (488,592,1);
INSERT INTO `biblio_author` VALUES (487,591,1);
INSERT INTO `biblio_author` VALUES (487,590,1);
INSERT INTO `biblio_author` VALUES (479,583,1);
INSERT INTO `biblio_author` VALUES (480,584,1);
INSERT INTO `biblio_author` VALUES (481,585,1);
INSERT INTO `biblio_author` VALUES (481,586,1);
INSERT INTO `biblio_author` VALUES (482,587,1);
INSERT INTO `biblio_author` VALUES (483,588,1);
INSERT INTO `biblio_author` VALUES (484,589,1);
INSERT INTO `biblio_author` VALUES (485,589,1);
INSERT INTO `biblio_author` VALUES (486,181,1);
INSERT INTO `biblio_author` VALUES (489,593,1);
INSERT INTO `biblio_author` VALUES (489,594,1);
INSERT INTO `biblio_author` VALUES (489,595,1);
INSERT INTO `biblio_author` VALUES (490,596,1);
INSERT INTO `biblio_author` VALUES (491,597,1);
INSERT INTO `biblio_author` VALUES (491,598,1);
INSERT INTO `biblio_author` VALUES (492,285,1);
INSERT INTO `biblio_author` VALUES (492,599,1);
INSERT INTO `biblio_author` VALUES (493,600,1);
INSERT INTO `biblio_author` VALUES (493,601,1);
INSERT INTO `biblio_author` VALUES (493,602,1);
INSERT INTO `biblio_author` VALUES (493,603,1);
INSERT INTO `biblio_author` VALUES (494,604,1);
INSERT INTO `biblio_author` VALUES (494,605,1);
INSERT INTO `biblio_author` VALUES (494,606,1);
INSERT INTO `biblio_author` VALUES (495,607,1);
INSERT INTO `biblio_author` VALUES (496,608,1);
INSERT INTO `biblio_author` VALUES (496,609,1);
INSERT INTO `biblio_author` VALUES (496,610,1);
INSERT INTO `biblio_author` VALUES (497,611,1);
INSERT INTO `biblio_author` VALUES (497,612,1);
INSERT INTO `biblio_author` VALUES (497,613,1);
INSERT INTO `biblio_author` VALUES (498,40,1);
INSERT INTO `biblio_author` VALUES (498,41,1);
INSERT INTO `biblio_author` VALUES (498,614,1);
INSERT INTO `biblio_author` VALUES (499,615,1);
INSERT INTO `biblio_author` VALUES (499,616,1);
INSERT INTO `biblio_author` VALUES (499,617,1);
INSERT INTO `biblio_author` VALUES (500,618,1);
INSERT INTO `biblio_author` VALUES (500,619,1);
INSERT INTO `biblio_author` VALUES (500,620,1);
INSERT INTO `biblio_author` VALUES (501,621,1);
INSERT INTO `biblio_author` VALUES (501,622,1);
INSERT INTO `biblio_author` VALUES (618,1095,1);
INSERT INTO `biblio_author` VALUES (620,1094,1);
INSERT INTO `biblio_author` VALUES (671,1091,1);
INSERT INTO `biblio_author` VALUES (503,218,1);
INSERT INTO `biblio_author` VALUES (503,1145,1);
INSERT INTO `biblio_author` VALUES (503,1146,1);
INSERT INTO `biblio_author` VALUES (504,629,1);
INSERT INTO `biblio_author` VALUES (504,630,1);
INSERT INTO `biblio_author` VALUES (534,692,1);
INSERT INTO `biblio_author` VALUES (535,245,1);
INSERT INTO `biblio_author` VALUES (506,588,1);
INSERT INTO `biblio_author` VALUES (507,632,1);
INSERT INTO `biblio_author` VALUES (508,633,1);
INSERT INTO `biblio_author` VALUES (508,634,1);
INSERT INTO `biblio_author` VALUES (278,1154,1);
INSERT INTO `biblio_author` VALUES (278,1153,1);
INSERT INTO `biblio_author` VALUES (273,1151,1);
INSERT INTO `biblio_author` VALUES (510,645,1);
INSERT INTO `biblio_author` VALUES (510,646,1);
INSERT INTO `biblio_author` VALUES (510,647,1);
INSERT INTO `biblio_author` VALUES (511,648,1);
INSERT INTO `biblio_author` VALUES (512,649,1);
INSERT INTO `biblio_author` VALUES (512,650,1);
INSERT INTO `biblio_author` VALUES (513,651,1);
INSERT INTO `biblio_author` VALUES (513,652,1);
INSERT INTO `biblio_author` VALUES (513,653,1);
INSERT INTO `biblio_author` VALUES (533,691,1);
INSERT INTO `biblio_author` VALUES (532,690,1);
INSERT INTO `biblio_author` VALUES (515,654,1);
INSERT INTO `biblio_author` VALUES (515,656,1);
INSERT INTO `biblio_author` VALUES (516,657,1);
INSERT INTO `biblio_author` VALUES (516,658,1);
INSERT INTO `biblio_author` VALUES (517,570,1);
INSERT INTO `biblio_author` VALUES (517,659,1);
INSERT INTO `biblio_author` VALUES (518,660,1);
INSERT INTO `biblio_author` VALUES (518,661,1);
INSERT INTO `biblio_author` VALUES (518,662,1);
INSERT INTO `biblio_author` VALUES (518,663,1);
INSERT INTO `biblio_author` VALUES (518,664,1);
INSERT INTO `biblio_author` VALUES (519,665,1);
INSERT INTO `biblio_author` VALUES (519,356,1);
INSERT INTO `biblio_author` VALUES (519,357,1);
INSERT INTO `biblio_author` VALUES (520,666,1);
INSERT INTO `biblio_author` VALUES (520,667,1);
INSERT INTO `biblio_author` VALUES (520,668,1);
INSERT INTO `biblio_author` VALUES (521,669,1);
INSERT INTO `biblio_author` VALUES (522,670,1);
INSERT INTO `biblio_author` VALUES (522,671,1);
INSERT INTO `biblio_author` VALUES (522,672,1);
INSERT INTO `biblio_author` VALUES (523,673,1);
INSERT INTO `biblio_author` VALUES (523,674,1);
INSERT INTO `biblio_author` VALUES (524,675,1);
INSERT INTO `biblio_author` VALUES (283,1156,1);
INSERT INTO `biblio_author` VALUES (525,677,1);
INSERT INTO `biblio_author` VALUES (525,678,1);
INSERT INTO `biblio_author` VALUES (526,679,1);
INSERT INTO `biblio_author` VALUES (609,1090,1);
INSERT INTO `biblio_author` VALUES (437,1088,1);
INSERT INTO `biblio_author` VALUES (609,1089,1);
INSERT INTO `biblio_author` VALUES (532,689,1);
INSERT INTO `biblio_author` VALUES (531,688,1);
INSERT INTO `biblio_author` VALUES (530,687,1);
INSERT INTO `biblio_author` VALUES (530,686,1);
INSERT INTO `biblio_author` VALUES (530,685,1);
INSERT INTO `biblio_author` VALUES (536,654,1);
INSERT INTO `biblio_author` VALUES (537,693,1);
INSERT INTO `biblio_author` VALUES (538,694,1);
INSERT INTO `biblio_author` VALUES (539,695,1);
INSERT INTO `biblio_author` VALUES (539,696,1);
INSERT INTO `biblio_author` VALUES (540,697,1);
INSERT INTO `biblio_author` VALUES (541,698,1);
INSERT INTO `biblio_author` VALUES (542,699,1);
INSERT INTO `biblio_author` VALUES (542,700,1);
INSERT INTO `biblio_author` VALUES (542,701,1);
INSERT INTO `biblio_author` VALUES (543,702,1);
INSERT INTO `biblio_author` VALUES (544,703,1);
INSERT INTO `biblio_author` VALUES (545,704,1);
INSERT INTO `biblio_author` VALUES (546,705,1);
INSERT INTO `biblio_author` VALUES (547,706,1);
INSERT INTO `biblio_author` VALUES (547,707,3);
INSERT INTO `biblio_author` VALUES (547,708,3);
INSERT INTO `biblio_author` VALUES (548,709,1);
INSERT INTO `biblio_author` VALUES (549,710,1);
INSERT INTO `biblio_author` VALUES (550,711,1);
INSERT INTO `biblio_author` VALUES (550,712,1);
INSERT INTO `biblio_author` VALUES (551,713,1);
INSERT INTO `biblio_author` VALUES (551,714,1);
INSERT INTO `biblio_author` VALUES (552,715,1);
INSERT INTO `biblio_author` VALUES (553,716,1);
INSERT INTO `biblio_author` VALUES (553,717,1);
INSERT INTO `biblio_author` VALUES (554,718,1);
INSERT INTO `biblio_author` VALUES (555,350,3);
INSERT INTO `biblio_author` VALUES (556,719,1);
INSERT INTO `biblio_author` VALUES (556,720,1);
INSERT INTO `biblio_author` VALUES (557,721,1);
INSERT INTO `biblio_author` VALUES (557,722,1);
INSERT INTO `biblio_author` VALUES (558,373,1);
INSERT INTO `biblio_author` VALUES (558,374,1);
INSERT INTO `biblio_author` VALUES (559,723,1);
INSERT INTO `biblio_author` VALUES (559,724,1);
INSERT INTO `biblio_author` VALUES (560,725,3);
INSERT INTO `biblio_author` VALUES (560,726,1);
INSERT INTO `biblio_author` VALUES (560,727,1);
INSERT INTO `biblio_author` VALUES (561,728,1);
INSERT INTO `biblio_author` VALUES (561,729,1);
INSERT INTO `biblio_author` VALUES (562,730,1);
INSERT INTO `biblio_author` VALUES (562,731,1);
INSERT INTO `biblio_author` VALUES (563,732,1);
INSERT INTO `biblio_author` VALUES (564,733,1);
INSERT INTO `biblio_author` VALUES (564,734,1);
INSERT INTO `biblio_author` VALUES (565,735,1);
INSERT INTO `biblio_author` VALUES (565,736,1);
INSERT INTO `biblio_author` VALUES (566,737,1);
INSERT INTO `biblio_author` VALUES (566,738,1);
INSERT INTO `biblio_author` VALUES (567,617,3);
INSERT INTO `biblio_author` VALUES (567,616,3);
INSERT INTO `biblio_author` VALUES (567,615,3);
INSERT INTO `biblio_author` VALUES (568,739,1);
INSERT INTO `biblio_author` VALUES (569,740,1);
INSERT INTO `biblio_author` VALUES (569,1104,1);
INSERT INTO `biblio_author` VALUES (570,742,1);
INSERT INTO `biblio_author` VALUES (571,743,1);
INSERT INTO `biblio_author` VALUES (571,744,1);
INSERT INTO `biblio_author` VALUES (571,745,1);
INSERT INTO `biblio_author` VALUES (572,747,1);
INSERT INTO `biblio_author` VALUES (573,616,3);
INSERT INTO `biblio_author` VALUES (573,1135,3);
INSERT INTO `biblio_author` VALUES (574,750,1);
INSERT INTO `biblio_author` VALUES (574,751,1);
INSERT INTO `biblio_author` VALUES (574,749,1);
INSERT INTO `biblio_author` VALUES (575,290,1);
INSERT INTO `biblio_author` VALUES (575,752,1);
INSERT INTO `biblio_author` VALUES (576,753,1);
INSERT INTO `biblio_author` VALUES (577,754,1);
INSERT INTO `biblio_author` VALUES (578,755,1);
INSERT INTO `biblio_author` VALUES (579,756,1);
INSERT INTO `biblio_author` VALUES (579,757,1);
INSERT INTO `biblio_author` VALUES (580,758,1);
INSERT INTO `biblio_author` VALUES (581,759,1);
INSERT INTO `biblio_author` VALUES (581,760,1);
INSERT INTO `biblio_author` VALUES (582,761,1);
INSERT INTO `biblio_author` VALUES (582,762,1);
INSERT INTO `biblio_author` VALUES (583,763,1);
INSERT INTO `biblio_author` VALUES (583,764,1);
INSERT INTO `biblio_author` VALUES (584,1132,3);
INSERT INTO `biblio_author` VALUES (584,1133,3);
INSERT INTO `biblio_author` VALUES (585,1134,1);
INSERT INTO `biblio_author` VALUES (586,767,1);
INSERT INTO `biblio_author` VALUES (587,768,1);
INSERT INTO `biblio_author` VALUES (587,769,1);
INSERT INTO `biblio_author` VALUES (588,770,1);
INSERT INTO `biblio_author` VALUES (589,771,1);
INSERT INTO `biblio_author` VALUES (589,772,1);
INSERT INTO `biblio_author` VALUES (590,773,1);
INSERT INTO `biblio_author` VALUES (591,774,1);
INSERT INTO `biblio_author` VALUES (592,1138,3);
INSERT INTO `biblio_author` VALUES (593,776,1);
INSERT INTO `biblio_author` VALUES (594,777,1);
INSERT INTO `biblio_author` VALUES (594,778,1);
INSERT INTO `biblio_author` VALUES (595,779,1);
INSERT INTO `biblio_author` VALUES (596,780,1);
INSERT INTO `biblio_author` VALUES (596,781,1);
INSERT INTO `biblio_author` VALUES (597,782,1);
INSERT INTO `biblio_author` VALUES (597,1126,1);
INSERT INTO `biblio_author` VALUES (598,784,1);
INSERT INTO `biblio_author` VALUES (598,785,1);
INSERT INTO `biblio_author` VALUES (599,1127,1);
INSERT INTO `biblio_author` VALUES (599,218,1);
INSERT INTO `biblio_author` VALUES (600,786,1);
INSERT INTO `biblio_author` VALUES (601,787,1);
INSERT INTO `biblio_author` VALUES (601,788,1);
INSERT INTO `biblio_author` VALUES (601,789,1);
INSERT INTO `biblio_author` VALUES (690,963,6);
INSERT INTO `biblio_author` VALUES (690,181,6);
INSERT INTO `biblio_author` VALUES (690,962,6);
INSERT INTO `biblio_author` VALUES (690,961,6);
INSERT INTO `biblio_author` VALUES (689,960,1);
INSERT INTO `biblio_author` VALUES (689,959,1);
INSERT INTO `biblio_author` VALUES (688,958,1);
INSERT INTO `biblio_author` VALUES (688,957,1);
INSERT INTO `biblio_author` VALUES (687,956,1);
INSERT INTO `biblio_author` VALUES (687,955,1);
INSERT INTO `biblio_author` VALUES (687,954,1);
INSERT INTO `biblio_author` VALUES (686,953,1);
INSERT INTO `biblio_author` VALUES (686,324,1);
INSERT INTO `biblio_author` VALUES (686,952,1);
INSERT INTO `biblio_author` VALUES (685,951,1);
INSERT INTO `biblio_author` VALUES (685,950,1);
INSERT INTO `biblio_author` VALUES (684,949,1);
INSERT INTO `biblio_author` VALUES (684,948,1);
INSERT INTO `biblio_author` VALUES (683,947,1);
INSERT INTO `biblio_author` VALUES (682,946,6);
INSERT INTO `biblio_author` VALUES (682,945,6);
INSERT INTO `biblio_author` VALUES (681,178,1);
INSERT INTO `biblio_author` VALUES (681,278,1);
INSERT INTO `biblio_author` VALUES (680,944,1);
INSERT INTO `biblio_author` VALUES (679,943,1);
INSERT INTO `biblio_author` VALUES (679,942,1);
INSERT INTO `biblio_author` VALUES (603,1157,1);
INSERT INTO `biblio_author` VALUES (286,873,3);
INSERT INTO `biblio_author` VALUES (604,818,1);
INSERT INTO `biblio_author` VALUES (604,819,1);
INSERT INTO `biblio_author` VALUES (605,820,1);
INSERT INTO `biblio_author` VALUES (605,821,1);
INSERT INTO `biblio_author` VALUES (606,642,1);
INSERT INTO `biblio_author` VALUES (606,643,1);
INSERT INTO `biblio_author` VALUES (606,644,1);
INSERT INTO `biblio_author` VALUES (607,822,1);
INSERT INTO `biblio_author` VALUES (607,823,1);
INSERT INTO `biblio_author` VALUES (607,824,1);
INSERT INTO `biblio_author` VALUES (609,825,1);
INSERT INTO `biblio_author` VALUES (609,826,1);
INSERT INTO `biblio_author` VALUES (610,827,1);
INSERT INTO `biblio_author` VALUES (337,1101,1);
INSERT INTO `biblio_author` VALUES (612,829,1);
INSERT INTO `biblio_author` VALUES (612,830,1);
INSERT INTO `biblio_author` VALUES (612,831,1);
INSERT INTO `biblio_author` VALUES (613,832,1);
INSERT INTO `biblio_author` VALUES (614,833,1);
INSERT INTO `biblio_author` VALUES (614,834,1);
INSERT INTO `biblio_author` VALUES (614,835,1);
INSERT INTO `biblio_author` VALUES (615,836,1);
INSERT INTO `biblio_author` VALUES (615,837,1);
INSERT INTO `biblio_author` VALUES (615,838,1);
INSERT INTO `biblio_author` VALUES (616,839,1);
INSERT INTO `biblio_author` VALUES (616,840,1);
INSERT INTO `biblio_author` VALUES (616,841,1);
INSERT INTO `biblio_author` VALUES (617,842,1);
INSERT INTO `biblio_author` VALUES (618,398,1);
INSERT INTO `biblio_author` VALUES (619,843,1);
INSERT INTO `biblio_author` VALUES (619,844,1);
INSERT INTO `biblio_author` VALUES (619,845,1);
INSERT INTO `biblio_author` VALUES (619,846,1);
INSERT INTO `biblio_author` VALUES (619,847,1);
INSERT INTO `biblio_author` VALUES (621,848,1);
INSERT INTO `biblio_author` VALUES (679,940,1);
INSERT INTO `biblio_author` VALUES (623,850,1);
INSERT INTO `biblio_author` VALUES (624,852,1);
INSERT INTO `biblio_author` VALUES (625,853,1);
INSERT INTO `biblio_author` VALUES (626,854,1);
INSERT INTO `biblio_author` VALUES (626,855,1);
INSERT INTO `biblio_author` VALUES (627,856,1);
INSERT INTO `biblio_author` VALUES (627,857,1);
INSERT INTO `biblio_author` VALUES (627,858,1);
INSERT INTO `biblio_author` VALUES (627,859,1);
INSERT INTO `biblio_author` VALUES (679,941,1);
INSERT INTO `biblio_author` VALUES (678,938,1);
INSERT INTO `biblio_author` VALUES (629,862,1);
INSERT INTO `biblio_author` VALUES (629,863,1);
INSERT INTO `biblio_author` VALUES (630,864,1);
INSERT INTO `biblio_author` VALUES (630,865,1);
INSERT INTO `biblio_author` VALUES (631,699,1);
INSERT INTO `biblio_author` VALUES (631,700,1);
INSERT INTO `biblio_author` VALUES (631,866,1);
INSERT INTO `biblio_author` VALUES (632,867,1);
INSERT INTO `biblio_author` VALUES (632,868,1);
INSERT INTO `biblio_author` VALUES (633,867,1);
INSERT INTO `biblio_author` VALUES (633,868,1);
INSERT INTO `biblio_author` VALUES (634,869,1);
INSERT INTO `biblio_author` VALUES (635,870,1);
INSERT INTO `biblio_author` VALUES (636,871,1);
INSERT INTO `biblio_author` VALUES (636,872,1);
INSERT INTO `biblio_author` VALUES (637,873,1);
INSERT INTO `biblio_author` VALUES (638,874,1);
INSERT INTO `biblio_author` VALUES (639,875,1);
INSERT INTO `biblio_author` VALUES (640,876,1);
INSERT INTO `biblio_author` VALUES (640,877,1);
INSERT INTO `biblio_author` VALUES (640,878,1);
INSERT INTO `biblio_author` VALUES (641,879,1);
INSERT INTO `biblio_author` VALUES (642,880,1);
INSERT INTO `biblio_author` VALUES (642,881,1);
INSERT INTO `biblio_author` VALUES (642,882,1);
INSERT INTO `biblio_author` VALUES (643,883,1);
INSERT INTO `biblio_author` VALUES (643,884,1);
INSERT INTO `biblio_author` VALUES (644,885,1);
INSERT INTO `biblio_author` VALUES (644,552,1);
INSERT INTO `biblio_author` VALUES (645,886,1);
INSERT INTO `biblio_author` VALUES (645,887,1);
INSERT INTO `biblio_author` VALUES (646,888,1);
INSERT INTO `biblio_author` VALUES (646,889,1);
INSERT INTO `biblio_author` VALUES (647,890,1);
INSERT INTO `biblio_author` VALUES (648,891,1);
INSERT INTO `biblio_author` VALUES (648,892,1);
INSERT INTO `biblio_author` VALUES (649,893,1);
INSERT INTO `biblio_author` VALUES (649,894,1);
INSERT INTO `biblio_author` VALUES (650,895,1);
INSERT INTO `biblio_author` VALUES (651,303,1);
INSERT INTO `biblio_author` VALUES (652,896,1);
INSERT INTO `biblio_author` VALUES (653,897,1);
INSERT INTO `biblio_author` VALUES (653,898,1);
INSERT INTO `biblio_author` VALUES (654,899,1);
INSERT INTO `biblio_author` VALUES (654,900,1);
INSERT INTO `biblio_author` VALUES (654,901,1);
INSERT INTO `biblio_author` VALUES (654,902,1);
INSERT INTO `biblio_author` VALUES (655,903,1);
INSERT INTO `biblio_author` VALUES (655,904,1);
INSERT INTO `biblio_author` VALUES (656,905,1);
INSERT INTO `biblio_author` VALUES (657,906,1);
INSERT INTO `biblio_author` VALUES (657,907,1);
INSERT INTO `biblio_author` VALUES (658,908,1);
INSERT INTO `biblio_author` VALUES (658,910,1);
INSERT INTO `biblio_author` VALUES (659,909,1);
INSERT INTO `biblio_author` VALUES (659,911,1);
INSERT INTO `biblio_author` VALUES (659,912,1);
INSERT INTO `biblio_author` VALUES (660,913,1);
INSERT INTO `biblio_author` VALUES (660,914,1);
INSERT INTO `biblio_author` VALUES (661,915,1);
INSERT INTO `biblio_author` VALUES (661,916,1);
INSERT INTO `biblio_author` VALUES (662,917,1);
INSERT INTO `biblio_author` VALUES (663,918,1);
INSERT INTO `biblio_author` VALUES (663,919,1);
INSERT INTO `biblio_author` VALUES (664,920,1);
INSERT INTO `biblio_author` VALUES (664,921,1);
INSERT INTO `biblio_author` VALUES (664,923,1);
INSERT INTO `biblio_author` VALUES (665,924,1);
INSERT INTO `biblio_author` VALUES (665,925,1);
INSERT INTO `biblio_author` VALUES (666,312,1);
INSERT INTO `biblio_author` VALUES (666,926,1);
INSERT INTO `biblio_author` VALUES (667,927,1);
INSERT INTO `biblio_author` VALUES (668,928,1);
INSERT INTO `biblio_author` VALUES (669,929,1);
INSERT INTO `biblio_author` VALUES (669,930,1);
INSERT INTO `biblio_author` VALUES (670,929,1);
INSERT INTO `biblio_author` VALUES (670,930,1);
INSERT INTO `biblio_author` VALUES (620,1093,1);
INSERT INTO `biblio_author` VALUES (671,1092,1);
INSERT INTO `biblio_author` VALUES (673,932,1);
INSERT INTO `biblio_author` VALUES (673,933,1);
INSERT INTO `biblio_author` VALUES (674,934,1);
INSERT INTO `biblio_author` VALUES (674,935,1);
INSERT INTO `biblio_author` VALUES (678,937,1);
INSERT INTO `biblio_author` VALUES (677,244,1);
INSERT INTO `biblio_author` VALUES (676,936,1);
INSERT INTO `biblio_author` VALUES (691,964,1);
INSERT INTO `biblio_author` VALUES (691,965,1);
INSERT INTO `biblio_author` VALUES (691,966,1);
INSERT INTO `biblio_author` VALUES (691,967,1);
INSERT INTO `biblio_author` VALUES (691,968,1);
INSERT INTO `biblio_author` VALUES (691,969,1);
INSERT INTO `biblio_author` VALUES (691,970,1);
INSERT INTO `biblio_author` VALUES (691,971,1);
INSERT INTO `biblio_author` VALUES (692,972,1);
INSERT INTO `biblio_author` VALUES (693,973,1);
INSERT INTO `biblio_author` VALUES (693,974,1);
INSERT INTO `biblio_author` VALUES (694,975,1);
INSERT INTO `biblio_author` VALUES (694,976,1);
INSERT INTO `biblio_author` VALUES (695,977,1);
INSERT INTO `biblio_author` VALUES (696,978,1);
INSERT INTO `biblio_author` VALUES (696,979,1);
INSERT INTO `biblio_author` VALUES (697,980,1);
INSERT INTO `biblio_author` VALUES (697,981,1);
INSERT INTO `biblio_author` VALUES (697,982,1);
INSERT INTO `biblio_author` VALUES (698,699,1);
INSERT INTO `biblio_author` VALUES (698,983,1);
INSERT INTO `biblio_author` VALUES (698,866,1);
INSERT INTO `biblio_author` VALUES (699,984,1);
INSERT INTO `biblio_author` VALUES (699,985,1);
INSERT INTO `biblio_author` VALUES (700,309,1);
INSERT INTO `biblio_author` VALUES (700,986,1);
INSERT INTO `biblio_author` VALUES (701,987,1);
INSERT INTO `biblio_author` VALUES (701,988,1);
INSERT INTO `biblio_author` VALUES (701,989,1);
INSERT INTO `biblio_author` VALUES (702,990,1);
INSERT INTO `biblio_author` VALUES (702,991,1);
INSERT INTO `biblio_author` VALUES (703,992,1);
INSERT INTO `biblio_author` VALUES (703,993,1);
INSERT INTO `biblio_author` VALUES (704,994,1);
INSERT INTO `biblio_author` VALUES (705,451,1);
INSERT INTO `biblio_author` VALUES (705,452,1);
INSERT INTO `biblio_author` VALUES (706,995,1);
INSERT INTO `biblio_author` VALUES (707,996,1);
INSERT INTO `biblio_author` VALUES (708,997,1);
INSERT INTO `biblio_author` VALUES (709,999,1);
INSERT INTO `biblio_author` VALUES (710,1000,1);
INSERT INTO `biblio_author` VALUES (710,1001,1);
INSERT INTO `biblio_author` VALUES (711,1002,1);
INSERT INTO `biblio_author` VALUES (711,1003,1);
INSERT INTO `biblio_author` VALUES (712,1004,1);
INSERT INTO `biblio_author` VALUES (713,1005,1);
INSERT INTO `biblio_author` VALUES (714,1006,1);
INSERT INTO `biblio_author` VALUES (715,999,1);
INSERT INTO `biblio_author` VALUES (716,1007,1);
INSERT INTO `biblio_author` VALUES (717,1008,1);
INSERT INTO `biblio_author` VALUES (718,1009,1);
INSERT INTO `biblio_author` VALUES (719,1010,1);
INSERT INTO `biblio_author` VALUES (720,999,1);
INSERT INTO `biblio_author` VALUES (721,1011,1);
INSERT INTO `biblio_author` VALUES (722,999,1);
INSERT INTO `biblio_author` VALUES (723,1007,1);
INSERT INTO `biblio_author` VALUES (724,1012,1);
INSERT INTO `biblio_author` VALUES (724,1013,1);
INSERT INTO `biblio_author` VALUES (724,1014,1);
INSERT INTO `biblio_author` VALUES (725,1015,1);
INSERT INTO `biblio_author` VALUES (726,1016,1);
INSERT INTO `biblio_author` VALUES (726,1017,1);
INSERT INTO `biblio_author` VALUES (727,130,1);
INSERT INTO `biblio_author` VALUES (728,1018,1);
INSERT INTO `biblio_author` VALUES (728,1019,1);
INSERT INTO `biblio_author` VALUES (728,1020,1);
INSERT INTO `biblio_author` VALUES (729,130,1);
INSERT INTO `biblio_author` VALUES (730,1021,1);
INSERT INTO `biblio_author` VALUES (730,1022,1);
INSERT INTO `biblio_author` VALUES (731,1024,2);
INSERT INTO `biblio_author` VALUES (732,1025,1);
INSERT INTO `biblio_author` VALUES (732,1026,1);
INSERT INTO `biblio_author` VALUES (733,1027,1);
INSERT INTO `biblio_author` VALUES (733,1028,1);
INSERT INTO `biblio_author` VALUES (734,654,1);
INSERT INTO `biblio_author` VALUES (735,1030,1);
INSERT INTO `biblio_author` VALUES (736,1031,1);
INSERT INTO `biblio_author` VALUES (736,1032,1);
INSERT INTO `biblio_author` VALUES (737,1033,1);
INSERT INTO `biblio_author` VALUES (738,1031,1);
INSERT INTO `biblio_author` VALUES (739,1034,1);
INSERT INTO `biblio_author` VALUES (739,1035,1);
INSERT INTO `biblio_author` VALUES (739,1036,1);
INSERT INTO `biblio_author` VALUES (740,996,1);
INSERT INTO `biblio_author` VALUES (741,181,9);
INSERT INTO `biblio_author` VALUES (742,1037,1);
INSERT INTO `biblio_author` VALUES (742,1038,1);
INSERT INTO `biblio_author` VALUES (742,1039,1);
INSERT INTO `biblio_author` VALUES (743,1040,1);
INSERT INTO `biblio_author` VALUES (743,1041,1);
INSERT INTO `biblio_author` VALUES (743,1042,1);
INSERT INTO `biblio_author` VALUES (744,1027,1);
INSERT INTO `biblio_author` VALUES (744,1028,1);
INSERT INTO `biblio_author` VALUES (745,1043,3);
INSERT INTO `biblio_author` VALUES (746,1044,1);
INSERT INTO `biblio_author` VALUES (747,654,1);
INSERT INTO `biblio_author` VALUES (748,1045,1);
INSERT INTO `biblio_author` VALUES (748,1046,1);
INSERT INTO `biblio_author` VALUES (748,1047,1);
INSERT INTO `biblio_author` VALUES (749,1048,1);
INSERT INTO `biblio_author` VALUES (749,1049,1);
INSERT INTO `biblio_author` VALUES (751,1053,1);
INSERT INTO `biblio_author` VALUES (752,1051,1);
INSERT INTO `biblio_author` VALUES (752,1052,1);
INSERT INTO `biblio_author` VALUES (753,181,1);
INSERT INTO `biblio_author` VALUES (754,1054,1);
INSERT INTO `biblio_author` VALUES (754,1055,1);
INSERT INTO `biblio_author` VALUES (755,1056,1);
INSERT INTO `biblio_author` VALUES (756,1057,1);
INSERT INTO `biblio_author` VALUES (756,1058,1);
INSERT INTO `biblio_author` VALUES (756,1059,1);
INSERT INTO `biblio_author` VALUES (757,1060,1);
INSERT INTO `biblio_author` VALUES (757,1061,1);
INSERT INTO `biblio_author` VALUES (757,1062,1);
INSERT INTO `biblio_author` VALUES (758,357,3);
INSERT INTO `biblio_author` VALUES (758,358,1);
INSERT INTO `biblio_author` VALUES (758,355,1);
INSERT INTO `biblio_author` VALUES (759,1063,6);
INSERT INTO `biblio_author` VALUES (760,327,1);
INSERT INTO `biblio_author` VALUES (760,1065,1);
INSERT INTO `biblio_author` VALUES (761,1066,1);
INSERT INTO `biblio_author` VALUES (761,1067,1);
INSERT INTO `biblio_author` VALUES (761,1068,1);
INSERT INTO `biblio_author` VALUES (761,1069,3);
INSERT INTO `biblio_author` VALUES (762,1070,1);
INSERT INTO `biblio_author` VALUES (775,1160,1);
INSERT INTO `biblio_author` VALUES (768,1074,1);
INSERT INTO `biblio_author` VALUES (765,1071,1);
INSERT INTO `biblio_author` VALUES (768,1075,1);
INSERT INTO `biblio_author` VALUES (769,1076,1);
INSERT INTO `biblio_author` VALUES (770,451,1);
INSERT INTO `biblio_author` VALUES (770,1077,1);
INSERT INTO `biblio_author` VALUES (771,1078,1);
INSERT INTO `biblio_author` VALUES (771,1079,1);
INSERT INTO `biblio_author` VALUES (772,1080,6);
INSERT INTO `biblio_author` VALUES (773,1081,1);
INSERT INTO `biblio_author` VALUES (773,1082,1);
INSERT INTO `biblio_author` VALUES (773,1083,1);
INSERT INTO `biblio_author` VALUES (774,1084,1);
INSERT INTO `biblio_author` VALUES (618,1096,1);
INSERT INTO `biblio_author` VALUES (611,1097,1);
INSERT INTO `biblio_author` VALUES (337,1099,1);
INSERT INTO `biblio_author` VALUES (337,1100,1);
INSERT INTO `biblio_author` VALUES (440,1102,1);
INSERT INTO `biblio_author` VALUES (569,1105,1);
INSERT INTO `biblio_author` VALUES (340,1106,1);
INSERT INTO `biblio_author` VALUES (340,1107,1);
INSERT INTO `biblio_author` VALUES (247,1108,1);
INSERT INTO `biblio_author` VALUES (248,1109,1);
INSERT INTO `biblio_author` VALUES (248,1110,1);
INSERT INTO `biblio_author` VALUES (342,1111,1);
INSERT INTO `biblio_author` VALUES (342,585,1);
INSERT INTO `biblio_author` VALUES (343,1112,1);
INSERT INTO `biblio_author` VALUES (343,1113,1);
INSERT INTO `biblio_author` VALUES (251,1114,1);
INSERT INTO `biblio_author` VALUES (317,1115,1);
INSERT INTO `biblio_author` VALUES (252,1116,1);
INSERT INTO `biblio_author` VALUES (252,1117,1);
INSERT INTO `biblio_author` VALUES (252,1118,1);
INSERT INTO `biblio_author` VALUES (253,1119,1);
INSERT INTO `biblio_author` VALUES (253,1120,1);
INSERT INTO `biblio_author` VALUES (253,1121,1);
INSERT INTO `biblio_author` VALUES (253,1122,3);
INSERT INTO `biblio_author` VALUES (344,1123,1);
INSERT INTO `biblio_author` VALUES (344,1124,1);
INSERT INTO `biblio_author` VALUES (254,1125,1);
INSERT INTO `biblio_author` VALUES (255,1128,1);
INSERT INTO `biblio_author` VALUES (258,1129,1);
INSERT INTO `biblio_author` VALUES (258,1130,1);
INSERT INTO `biblio_author` VALUES (573,1136,3);
INSERT INTO `biblio_author` VALUES (231,1135,3);
INSERT INTO `biblio_author` VALUES (346,1137,3);
INSERT INTO `biblio_author` VALUES (261,1139,1);
INSERT INTO `biblio_author` VALUES (261,1140,1);
INSERT INTO `biblio_author` VALUES (262,1139,1);
INSERT INTO `biblio_author` VALUES (262,1140,1);
INSERT INTO `biblio_author` VALUES (263,1139,1);
INSERT INTO `biblio_author` VALUES (263,1140,1);
INSERT INTO `biblio_author` VALUES (264,1141,1);
INSERT INTO `biblio_author` VALUES (264,1142,1);
INSERT INTO `biblio_author` VALUES (265,1144,1);
INSERT INTO `biblio_author` VALUES (268,1147,1);
INSERT INTO `biblio_author` VALUES (233,1148,1);
INSERT INTO `biblio_author` VALUES (271,1149,1);
INSERT INTO `biblio_author` VALUES (280,1155,1);
INSERT INTO `biblio_author` VALUES (287,860,1);
INSERT INTO `biblio_author` VALUES (287,1159,1);
INSERT INTO `biblio_author` VALUES (775,1161,1);
INSERT INTO `biblio_author` VALUES (775,1162,1);
INSERT INTO `biblio_author` VALUES (776,1164,2);
INSERT INTO `biblio_author` VALUES (776,1165,2);
INSERT INTO `biblio_author` VALUES (777,1166,2);
INSERT INTO `biblio_author` VALUES (778,27,2);
INSERT INTO `biblio_author` VALUES (778,28,2);
INSERT INTO `biblio_author` VALUES (778,1167,2);
INSERT INTO `biblio_author` VALUES (780,309,2);
INSERT INTO `biblio_author` VALUES (780,1168,2);
INSERT INTO `biblio_author` VALUES (781,333,2);
INSERT INTO `biblio_author` VALUES (782,411,2);
INSERT INTO `biblio_author` VALUES (783,1169,2);
INSERT INTO `biblio_author` VALUES (784,1170,2);
INSERT INTO `biblio_author` VALUES (784,1171,2);
INSERT INTO `biblio_author` VALUES (785,853,2);
INSERT INTO `biblio_author` VALUES (786,1172,2);
INSERT INTO `biblio_author` VALUES (787,82,2);
INSERT INTO `biblio_author` VALUES (788,321,2);
INSERT INTO `biblio_author` VALUES (788,1173,2);
INSERT INTO `biblio_author` VALUES (789,39,2);
INSERT INTO `biblio_author` VALUES (789,1174,2);
INSERT INTO `biblio_author` VALUES (790,1175,2);
INSERT INTO `biblio_author` VALUES (791,1176,2);
INSERT INTO `biblio_author` VALUES (792,1177,2);
INSERT INTO `biblio_author` VALUES (793,1178,2);
INSERT INTO `biblio_author` VALUES (793,1179,2);
INSERT INTO `biblio_author` VALUES (794,1016,2);
INSERT INTO `biblio_author` VALUES (795,1180,2);
INSERT INTO `biblio_author` VALUES (795,1181,2);
INSERT INTO `biblio_author` VALUES (795,1182,2);
INSERT INTO `biblio_author` VALUES (795,1183,2);
INSERT INTO `biblio_author` VALUES (796,1184,2);
INSERT INTO `biblio_author` VALUES (796,1185,2);
INSERT INTO `biblio_author` VALUES (796,1186,2);
INSERT INTO `biblio_author` VALUES (796,1187,2);
INSERT INTO `biblio_author` VALUES (797,1188,2);
INSERT INTO `biblio_author` VALUES (797,1189,2);
INSERT INTO `biblio_author` VALUES (798,1190,2);
INSERT INTO `biblio_author` VALUES (799,1191,2);
INSERT INTO `biblio_author` VALUES (799,1192,2);
INSERT INTO `biblio_author` VALUES (800,1193,2);
INSERT INTO `biblio_author` VALUES (800,1194,2);
INSERT INTO `biblio_author` VALUES (801,1195,2);
INSERT INTO `biblio_author` VALUES (801,1196,2);
INSERT INTO `biblio_author` VALUES (802,1197,2);
INSERT INTO `biblio_author` VALUES (802,1198,2);
INSERT INTO `biblio_author` VALUES (802,1199,2);
INSERT INTO `biblio_author` VALUES (803,1200,2);
INSERT INTO `biblio_author` VALUES (803,1201,2);
INSERT INTO `biblio_author` VALUES (804,93,2);
INSERT INTO `biblio_author` VALUES (804,1202,2);
INSERT INTO `biblio_author` VALUES (805,339,2);
INSERT INTO `biblio_author` VALUES (805,1203,2);
INSERT INTO `biblio_author` VALUES (806,54,2);
INSERT INTO `biblio_author` VALUES (806,1204,2);
INSERT INTO `biblio_author` VALUES (807,1205,2);
INSERT INTO `biblio_author` VALUES (807,1206,2);
INSERT INTO `biblio_author` VALUES (808,1207,2);
INSERT INTO `biblio_author` VALUES (808,1208,2);
INSERT INTO `biblio_author` VALUES (808,1209,2);
INSERT INTO `biblio_author` VALUES (809,1210,2);
INSERT INTO `biblio_author` VALUES (809,1211,2);
INSERT INTO `biblio_author` VALUES (810,1212,2);
INSERT INTO `biblio_author` VALUES (811,1213,2);
INSERT INTO `biblio_author` VALUES (812,1214,2);
INSERT INTO `biblio_author` VALUES (812,656,2);
INSERT INTO `biblio_author` VALUES (813,1215,2);
INSERT INTO `biblio_author` VALUES (813,1216,2);
INSERT INTO `biblio_author` VALUES (813,1217,2);
INSERT INTO `biblio_author` VALUES (813,1218,2);
INSERT INTO `biblio_author` VALUES (814,115,2);
INSERT INTO `biblio_author` VALUES (814,279,2);
INSERT INTO `biblio_author` VALUES (814,1219,2);
INSERT INTO `biblio_author` VALUES (815,1220,2);
INSERT INTO `biblio_author` VALUES (815,1221,2);
INSERT INTO `biblio_author` VALUES (815,1222,2);
INSERT INTO `biblio_author` VALUES (815,1223,2);
INSERT INTO `biblio_author` VALUES (815,1224,2);
INSERT INTO `biblio_author` VALUES (815,1225,2);
INSERT INTO `biblio_author` VALUES (815,1226,2);
INSERT INTO `biblio_author` VALUES (816,1227,2);
INSERT INTO `biblio_author` VALUES (816,1095,2);
INSERT INTO `biblio_author` VALUES (816,845,2);
INSERT INTO `biblio_author` VALUES (816,1228,2);
INSERT INTO `biblio_author` VALUES (816,1229,2);
INSERT INTO `biblio_author` VALUES (817,493,2);
INSERT INTO `biblio_author` VALUES (818,1230,2);
INSERT INTO `biblio_author` VALUES (819,309,2);
INSERT INTO `biblio_author` VALUES (819,310,2);
INSERT INTO `biblio_author` VALUES (819,311,2);
INSERT INTO `biblio_author` VALUES (820,295,2);
INSERT INTO `biblio_author` VALUES (820,296,2);
INSERT INTO `biblio_author` VALUES (821,29,2);
INSERT INTO `biblio_author` VALUES (821,30,2);
INSERT INTO `biblio_author` VALUES (821,323,2);
INSERT INTO `biblio_author` VALUES (822,39,2);
INSERT INTO `biblio_author` VALUES (823,1231,2);
INSERT INTO `biblio_author` VALUES (823,1232,2);
INSERT INTO `biblio_author` VALUES (823,1233,2);
INSERT INTO `biblio_author` VALUES (824,1234,2);
INSERT INTO `biblio_author` VALUES (824,385,2);
INSERT INTO `biblio_author` VALUES (825,1235,2);
INSERT INTO `biblio_author` VALUES (825,1236,2);
INSERT INTO `biblio_author` VALUES (825,1237,2);
INSERT INTO `biblio_author` VALUES (825,1238,2);
INSERT INTO `biblio_author` VALUES (826,699,2);
INSERT INTO `biblio_author` VALUES (826,700,2);
INSERT INTO `biblio_author` VALUES (826,866,2);
INSERT INTO `biblio_author` VALUES (827,1239,2);
INSERT INTO `biblio_author` VALUES (827,1240,2);
INSERT INTO `biblio_author` VALUES (828,906,2);
INSERT INTO `biblio_author` VALUES (829,1241,2);
INSERT INTO `biblio_author` VALUES (829,1242,2);
INSERT INTO `biblio_author` VALUES (830,82,2);
INSERT INTO `biblio_author` VALUES (831,1206,2);
INSERT INTO `biblio_author` VALUES (831,1243,2);
INSERT INTO `biblio_author` VALUES (832,496,2);
INSERT INTO `biblio_author` VALUES (833,1244,2);
INSERT INTO `biblio_author` VALUES (834,1245,2);
INSERT INTO `biblio_author` VALUES (835,1246,2);
INSERT INTO `biblio_author` VALUES (835,1247,2);
INSERT INTO `biblio_author` VALUES (835,1248,2);
INSERT INTO `biblio_author` VALUES (836,1249,2);
INSERT INTO `biblio_author` VALUES (837,1250,2);
INSERT INTO `biblio_author` VALUES (838,1251,2);
INSERT INTO `biblio_author` VALUES (838,1252,2);
INSERT INTO `biblio_author` VALUES (838,1253,2);
INSERT INTO `biblio_author` VALUES (838,1254,2);
INSERT INTO `biblio_author` VALUES (838,1255,2);
INSERT INTO `biblio_author` VALUES (838,1256,2);
INSERT INTO `biblio_author` VALUES (839,27,2);
INSERT INTO `biblio_author` VALUES (839,1257,2);
INSERT INTO `biblio_author` VALUES (840,27,2);
INSERT INTO `biblio_author` VALUES (840,1257,2);
INSERT INTO `biblio_author` VALUES (840,123,2);
INSERT INTO `biblio_author` VALUES (842,1258,2);
INSERT INTO `biblio_author` VALUES (842,1259,2);
INSERT INTO `biblio_author` VALUES (842,1260,2);
INSERT INTO `biblio_author` VALUES (842,1261,2);
INSERT INTO `biblio_author` VALUES (842,1262,2);
INSERT INTO `biblio_author` VALUES (843,130,2);
INSERT INTO `biblio_author` VALUES (843,1263,2);
INSERT INTO `biblio_author` VALUES (844,1031,2);
INSERT INTO `biblio_author` VALUES (844,1264,2);
INSERT INTO `biblio_author` VALUES (845,1265,2);
INSERT INTO `biblio_author` VALUES (845,1266,2);
INSERT INTO `biblio_author` VALUES (847,1267,1);
INSERT INTO `biblio_author` VALUES (848,1268,1);
INSERT INTO `biblio_author` VALUES (849,1268,1);
INSERT INTO `biblio_author` VALUES (850,1269,2);
INSERT INTO `biblio_author` VALUES (850,1270,2);
INSERT INTO `biblio_author` VALUES (850,1271,2);
INSERT INTO `biblio_author` VALUES (851,743,2);
INSERT INTO `biblio_author` VALUES (851,744,2);
INSERT INTO `biblio_author` VALUES (851,745,2);
INSERT INTO `biblio_author` VALUES (851,39,2);
INSERT INTO `biblio_author` VALUES (852,1272,2);
INSERT INTO `biblio_author` VALUES (852,1273,2);
INSERT INTO `biblio_author` VALUES (853,1274,2);
INSERT INTO `biblio_author` VALUES (853,1275,2);
INSERT INTO `biblio_author` VALUES (853,1276,2);
INSERT INTO `biblio_author` VALUES (853,1277,2);
INSERT INTO `biblio_author` VALUES (854,1278,2);
INSERT INTO `biblio_author` VALUES (855,1279,2);
INSERT INTO `biblio_author` VALUES (856,1280,2);
INSERT INTO `biblio_author` VALUES (856,1281,2);
INSERT INTO `biblio_author` VALUES (856,1282,2);
INSERT INTO `biblio_author` VALUES (856,1283,2);
INSERT INTO `biblio_author` VALUES (857,385,2);
INSERT INTO `biblio_author` VALUES (858,1246,2);
INSERT INTO `biblio_author` VALUES (858,1247,2);
INSERT INTO `biblio_author` VALUES (858,1248,2);
INSERT INTO `biblio_author` VALUES (859,1284,2);
INSERT INTO `biblio_author` VALUES (859,1285,2);
INSERT INTO `biblio_author` VALUES (860,1286,2);
INSERT INTO `biblio_author` VALUES (860,1287,2);
INSERT INTO `biblio_author` VALUES (861,1288,2);
INSERT INTO `biblio_author` VALUES (861,1289,2);
INSERT INTO `biblio_author` VALUES (862,1290,2);
INSERT INTO `biblio_author` VALUES (862,1291,2);
INSERT INTO `biblio_author` VALUES (863,836,2);
INSERT INTO `biblio_author` VALUES (863,1292,2);
INSERT INTO `biblio_author` VALUES (863,1293,2);
INSERT INTO `biblio_author` VALUES (864,1294,2);
INSERT INTO `biblio_author` VALUES (865,1295,2);
INSERT INTO `biblio_author` VALUES (866,1296,2);
INSERT INTO `biblio_author` VALUES (866,1297,2);
INSERT INTO `biblio_author` VALUES (866,1298,2);
INSERT INTO `biblio_author` VALUES (866,1299,2);
INSERT INTO `biblio_author` VALUES (867,1300,2);
INSERT INTO `biblio_author` VALUES (867,1301,2);
INSERT INTO `biblio_author` VALUES (867,1302,2);
INSERT INTO `biblio_author` VALUES (868,1303,2);
INSERT INTO `biblio_author` VALUES (868,1304,2);
INSERT INTO `biblio_author` VALUES (868,1305,2);
INSERT INTO `biblio_author` VALUES (869,245,2);
INSERT INTO `biblio_author` VALUES (870,1306,2);
INSERT INTO `biblio_author` VALUES (870,1307,2);
INSERT INTO `biblio_author` VALUES (871,976,2);
INSERT INTO `biblio_author` VALUES (871,1308,2);
INSERT INTO `biblio_author` VALUES (872,1309,2);
INSERT INTO `biblio_author` VALUES (873,1310,2);
INSERT INTO `biblio_author` VALUES (873,1311,2);
INSERT INTO `biblio_author` VALUES (874,1312,2);
INSERT INTO `biblio_author` VALUES (875,1313,2);
INSERT INTO `biblio_author` VALUES (875,1314,2);
INSERT INTO `biblio_author` VALUES (875,1315,2);
INSERT INTO `biblio_author` VALUES (876,1316,2);
INSERT INTO `biblio_author` VALUES (876,1317,2);
INSERT INTO `biblio_author` VALUES (876,1318,2);
INSERT INTO `biblio_author` VALUES (877,1319,2);
INSERT INTO `biblio_author` VALUES (878,1320,2);
INSERT INTO `biblio_author` VALUES (878,1321,2);
INSERT INTO `biblio_author` VALUES (878,1322,2);
INSERT INTO `biblio_author` VALUES (879,1324,1);
INSERT INTO `biblio_author` VALUES (880,1325,1);
INSERT INTO `biblio_author` VALUES (880,1326,1);
INSERT INTO `biblio_author` VALUES (881,1327,1);
INSERT INTO `biblio_author` VALUES (881,1328,2);
INSERT INTO `biblio_author` VALUES (882,1329,1);
INSERT INTO `biblio_author` VALUES (883,1330,1);
INSERT INTO `biblio_author` VALUES (883,1331,2);
/*!40000 ALTER TABLE `biblio_author` ENABLE KEYS */;
COMMIT;

-- Dumped table `biblio_author` with 1372 row(s)
--

--
-- Table structure for table `biblio_custom`
--

DROP TABLE IF EXISTS `biblio_custom`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `biblio_custom` (
  `biblio_id` int(11) NOT NULL,
  PRIMARY KEY (`biblio_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='one to one relation with real biblio table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `biblio_custom`
--

/*!40000 ALTER TABLE `biblio_custom` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `biblio_custom` ENABLE KEYS */;
COMMIT;

-- Dumped table `biblio_custom` with 0 row(s)
--

--
-- Table structure for table `biblio_log`
--

DROP TABLE IF EXISTS `biblio_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `biblio_log` (
  `biblio_log_id` int(11) NOT NULL AUTO_INCREMENT,
  `biblio_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `realname` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `action` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `affectedrow` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rawdata` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `additional_information` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`biblio_log_id`),
  KEY `realname` (`realname`),
  KEY `biblio_id` (`biblio_id`),
  KEY `user_id` (`user_id`),
  KEY `ip` (`ip`),
  KEY `action` (`action`),
  KEY `affectedrow` (`affectedrow`),
  KEY `date` (`date`),
  FULLTEXT KEY `title` (`title`),
  FULLTEXT KEY `rawdata` (`rawdata`),
  FULLTEXT KEY `additional_information` (`additional_information`)
) ENGINE=MyISAM AUTO_INCREMENT=2134 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `biblio_log`
--

/*!40000 ALTER TABLE `biblio_log` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `biblio_log` VALUES (1,6,1,'Admin','PostgreSQL : a comprehensive guide to building, programming, and administering PostgreSQL databases','102.176.89.6','update','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A1%3A%226%22%3Bs%3A3%3A%22_id%22%3Bs%3A1%3A%226%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A1%3A%226%22%3Bs%3A5%3A%22title%22%3Bs%3A99%3A%22PostgreSQL+%3A+a+comprehensive+guide+to+building%2C+programming%2C+and+administering+PostgreSQL+databases%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A4%3A%22Text%22%3Bs%3A3%3A%22sor%22%3Bs%3A0%3A%22%22%3Bs%3A7%3A%22edition%22%3Bs%3A7%3A%221st+ed.%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A10%3A%220735712573%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A4%3A%22Sams%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A4%3A%222003%22%3Bs%3A9%3A%22collation%22%3Bs%3A27%3A%22xvii%2C+790+p.+%3A+ill.+%3B+23cm.%22%3Bs%3A12%3A%22series_title%22%3Bs%3A99%3A%22PostgreSQL+%3A+a+comprehensive+guide+to+building%2C+programming%2C+and+administering+PostgreSQL+databases%22%3Bs%3A11%3A%22call_number%22%3Bs%3A18%3A%22005.75%2F85-22+Kor+p%22%3Bs%3A13%3A%22language_name%22%3Bs%3A7%3A%22English%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A12%3A%22Indianapolis%22%3Bs%3A14%3A%22classification%22%3Bs%3A12%3A%22005.75%2F85+22%22%3Bs%3A5%3A%22notes%22%3Bs%3A309%3A%22PostgreSQL+is+the+world%27s+most+advanced+open-source+database.+PostgreSQL+is+the+most+comprehensive%2C+in-depth%2C+and+easy-to-read+guide+to+this+award-winning+database.+This+book+starts+with+a+thorough+overview+of+SQL%2C+a+description+of+all+PostgreSQL+data+types%2C+and+a+complete+explanation+of+PostgreSQL+commands.%22%3Bs%3A5%3A%22image%22%3Bs%3A14%3A%22postgresql.jpg%22%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%221%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3Ba%3A2%3A%7Bi%3A0%3Ba%3A3%3A%7Bs%3A11%3A%22author_name%22%3Bs%3A14%3A%22Douglas%2C+Korry%22%3Bs%3A14%3A%22authority_type%22%3Bs%3A13%3A%22Personal+Name%22%3Bs%3A15%3A%22authority_level%22%3Bs%3A14%3A%22Primary+Author%22%3B%7Di%3A1%3Ba%3A3%3A%7Bs%3A11%3A%22author_name%22%3Bs%3A14%3A%22Douglas%2C+Susan%22%3Bs%3A14%3A%22authority_type%22%3Bs%3A13%3A%22Personal+Name%22%3Bs%3A15%3A%22authority_level%22%3Bs%3A17%3A%22Additional+Author%22%3B%7D%7Ds%3A8%3A%22subjects%22%3Ba%3A2%3A%7Bi%3A0%3Ba%3A3%3A%7Bs%3A5%3A%22topic%22%3Bs%3A11%3A%22Programming%22%3Bs%3A10%3A%22topic_type%22%3Bs%3A5%3A%22Topic%22%3Bs%3A11%3A%22topic_level%22%3Bs%3A7%3A%22Primary%22%3B%7Di%3A1%3Ba%3A3%3A%7Bs%3A5%3A%22topic%22%3Bs%3A5%3A%22RDBMS%22%3Bs%3A10%3A%22topic_type%22%3Bs%3A5%3A%22Topic%22%3Bs%3A11%3A%22topic_level%22%3Bs%3A10%3A%22Additional%22%3B%7D%7Ds%3A5%3A%22items%22%3Ba%3A1%3A%7Bi%3A0%3Ba%3A20%3A%7Bs%3A7%3A%22item_id%22%3Bs%3A1%3A%222%22%3Bs%3A9%3A%22item_code%22%3Bs%3A6%3A%22B00002%22%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A14%3A%22coll_type_name%22%3Bs%3A9%3A%22Reference%22%3Bs%3A14%3A%22shelf_location%22%3Bs%3A0%3A%22%22%3Bs%3A13%3A%22location_name%22%3Bs%3A10%3A%22My+Library%22%3Bs%3A14%3A%22inventory_code%22%3Bs%3A10%3A%22INV%2FB00002%22%3Bs%3A11%3A%22item_status%22%3Bs%3A9%3A%22Available%22%3Bs%3A8%3A%22order_no%22%3Bs%3A0%3A%22%22%3Bs%3A10%3A%22order_date%22%3Bs%3A10%3A%222007-11-29%22%3Bs%3A13%3A%22received_date%22%3Bs%3A10%3A%222007-11-29%22%3Bs%3A13%3A%22supplier_name%22%3BN%3Bs%3A6%3A%22source%22%3Bs%3A3%3A%22Buy%22%3Bs%3A7%3A%22invoice%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22invoice_date%22%3Bs%3A10%3A%222007-11-29%22%3Bs%3A5%3A%22price%22%3Bs%3A6%3A%22700000%22%3Bs%3A14%3A%22price_currency%22%3Bs%3A6%3A%22Rupiah%22%3Bs%3A10%3A%22input_date%22%3BN%3Bs%3A11%3A%22last_update%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3B%7D%7Ds%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22c739c38ad111dc309ebccf915edd20a257545a7d%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22563ecd3169619ca48558f42ce90ee17fd71584c2%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%220bb053c271c116ffae238ad9b2b2a8fab5179bc2%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ed3ecd5d1a1262460ef8340ae9b5b6a1bf515a58%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22f23419a21e9f33280a31f8d28b2a5245346a89ca%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222007-11-29+16%3A29%3A33%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-05+07%3A07%3A44%22%3B%7D','Updated data. Bibliography.','2022-02-05 07:07:44');
INSERT INTO `biblio_log` VALUES (2,950,1,'Admin','Fundamentals of anatomy and physiology for nursing and healthcare students;\"Ebook\";\"2nd\";\"\";\"Wiley Blackwell\";\"2016\";\"(xl','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22950%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22950%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22950%22%3Bs%3A5%3A%22title%22%3Bs%3A121%3A%22Fundamentals+of+anatomy+and+physiology+for+nursing+and+healthcare+students%3B%22Ebook%22%3B%222nd%22%3B%22%22%3B%22Wiley+Blackwell%22%3B%222016%22%3B%22%28xl%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22614+pages%29+%3A+color+illustratio%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22MA%22%3B%22%22%3B%22Contents+Basic+scientific+principles+of+ph%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A21%3A%22cellular+compartments%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A17%3A%22transport+systems%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22fluid+movement+betwe%22%3Bs%3A9%3A%22collation%22%3Bs%3A9%3A%22Ian%3E%3CNair%22%3Bs%3A12%3A%22series_title%22%3Bs%3A54%3A%22Muralitharan%3E%22%3B%22%3CHuman+anatomy%3E%3CEbook%3E%3CPhysiology%3E%22%3B%22%22%22%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%225212075f55b4b508d34c4a402f55af5d9e964017%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (3,951,1,'Admin','Foundations of nursing research;\"Ebook\";\"7th\";\"\";\"Pearson\";\"2018\";\"xxiv','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22951%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22951%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22951%22%3Bs%3A5%3A%22title%22%3Bs%3A71%3A%22Foundations+of+nursing+research%3B%22Ebook%22%3B%227th%22%3B%22%22%3B%22Pearson%22%3B%222018%22%3B%22xxiv%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22403+pages%5C%22%3B%5C%22%5C%22%3B%5C%22%5C%22%3B%5C%22Englis%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22helping+students+understand+the+importance+of+rese%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A30%3A%22evaluate+and+critique+research%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22and+determine+whether+study+findings+are+ready+to+apply+in+practice.+Its+conversational+tone+explain%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A18%3A%22Rose+Marie%3E%3CBailey%22%3Bs%3A9%3A%22collation%22%3Bs%3A100%3A%22Catherine%3E%22%3B%22%3CNursing+--+Research+--+Methodology%3E%3CEbook%3E%3CNursing+Research+--+methods%3E%3CResearch+Desig%22%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%222afa0f388d7fc1687ee9fc03281180eb668d1d0b%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (4,953,1,'Admin','First aid manual : the authorised manual of St John Ambulance, St Andrews First Aid and the British Red Cross;\"Ebook\";\"Revised 10th\";\"\";\"Dorling Kindersley\";\"2016\";\"288 pages : illustrations (colour)\";\"\";\"\";\"English\";\"London\";\"\";\"Abstract \'First Aid Manual\' covers all aspects of first aid','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22953%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22953%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22953%22%3Bs%3A5%3A%22title%22%3Bs%3A289%3A%22First+aid+manual+%3A+the+authorised+manual+of+St+John+Ambulance%2C+St+Andrews+First+Aid+and+the+British+Red+Cross%3B%22Ebook%22%3B%22Revised+10th%22%3B%22%22%3B%22Dorling+Kindersley%22%3B%222016%22%3B%22288+pages+%3A+illustrations+%28colour%29%22%3B%22%22%3B%22%22%3B%22English%22%3B%22London%22%3B%22%22%3B%22Abstract+%27First+Aid+Manual%27+covers+all+aspects+of+first+aid%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22from+emergency+first+aid+and+f%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22to+resuscitation.+Find+out+how+to+treat+over+100+d%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22from+splinters+and+sprained+ankl%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22to+strokes+and+unconsciousness+and+how+to+use+essential+equipment.%5C%22%3B%5C%22%5C%22%3B%5C%22%5C%22%3B%5C%22%3CSt.+John+Ambulance%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%221374fcfbb95148bae6a169dc5d67b8aca1e4a692%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (5,954,1,'Admin','Family planning : a global handbook for providers;\"Ebook\";\"\";\"\";\"World Health Organization','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22954%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22954%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22954%22%3Bs%3A5%3A%22title%22%3Bs%3A90%3A%22Family+planning+%3A+a+global+handbook+for+providers%3B%22Ebook%22%3B%22%22%3B%22%22%3B%22World+Health+Organization%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22Department+of+Reproductive+Hea%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A25%3A%22372+pages+%3A+illustrations%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22photographs%22%3B%22%22%3B%22%22%3B%22English%22%3B%22Ba%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A36%3A%22manuals%3E%3CContraceptives+--+Handbooks%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22manuals%3E%3CContracepti%22%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22ed2ea87d6530620f6b42e17ae6b24743c2672115%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (6,955,1,'Admin','Essentials of nursing informatics;\"Ebook\";\"6th\";\"\";\"McGraw-Hill Education\";\"2015\";\"xxiii','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22955%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22955%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22955%22%3Bs%3A5%3A%22title%22%3Bs%3A88%3A%22Essentials+of+nursing+informatics%3B%22Ebook%22%3B%226th%22%3B%22%22%3B%22McGraw-Hill+Education%22%3B%222015%22%3B%22xxiii%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22886+pages+%3A+illustrations%5C%22%3B%5C%22%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22this+comprehensive+up-to-date+text+helps+you+under%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A12%3A%22technologies%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A8%3A%22policies%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22and+required+skills.%22%3Bs%3A9%3A%22collation%22%3Bs%3A22%3A%22Virginia+K.%3E%3CMcCormick%22%3Bs%3A12%3A%22series_title%22%3Bs%3A87%3A%22Kathleen+Ann%3E%22%3B%22%3CEbook%3E%3CNursing+informatics%3E%3CNursing+--+Data+processing%3E%3CComputers%3E%22%3B%22%22%22%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22a02a01ab7886d6e5ebc569a36af01a14f51b46c9%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (7,956,1,'Admin','Digital health entrepreneurship;\"Ebook\";\"1st\";\"\";\"Springer\";\"2019\";\"VIII','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22956%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22956%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22956%22%3Bs%3A5%3A%22title%22%3Bs%3A72%3A%22Digital+health+entrepreneurship%3B%22Ebook%22%3B%221st%22%3B%22%22%3B%22Springer%22%3B%222019%22%3B%22VIII%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A26%3A%22226+pages+19+illustrations%22%3Bs%3A3%3A%22sor%22%3Bs%3A72%3A%22Arlen%3E%22%3B%22%3CEbook%3E%3CMedical+informatics%3E%3CTelecommunication+in+medicine%3E%22%3B%22%22%22%3Bs%3A7%3A%22edition%22%3Bs%3A39%3A%2215+illustrations%22%3B%22%22%3B%22%22%3B%22English%22%3B%22Cham%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22Switzerland%22%3B%22%22%3B%22Contents+Introd%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A59%3A%22protecting+digital+health+intellectual+property+in+software%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22hardware+and+busines%22%3Bs%3A9%3A%22collation%22%3Bs%3A35%3A%22financing+a+digital+health+start+up%22%3Bs%3A12%3A%22series_title%22%3Bs%3A27%3A%22cybersecurity+best+practice%22%3Bs%3A11%3A%22call_number%22%3Bs%3A50%3A%22and+digital+health+business+model+testing+for+desi%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A30%3A%22and+viability.+Digital+Health+%22%3Bs%3A14%3A%22classification%22%3Bs%3A10%3A%22deployment%22%3Bs%3A5%3A%22notes%22%3Bs%3A237%3A%22dissemination+and+implementation.+It+therefore+provides+an+ideal+resource+for+medical+professionals+across+a+broad+range+of+disciplines+seeking+a+greater+understanding+of+digital+health+innovation+and+entrepreneurship.%22%3B%22%22%3B%22%22%3B%22%3CWulfovich%22%3Bs%3A5%3A%22image%22%3Bs%3A14%3A%22Sharon%3E%3CMeyers%22%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%2272ce587316d7fe99082f7cddb1e9a14c2702d79b%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22c23ac87d5ad227c17f84568ccc6eb8ca3a083231%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22c90b0ee7d433e4dd36099764541c15ea1de0225a%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (8,957,1,'Admin','Daily readings from Love your life : devotions for living happy, healthy, and whole;\"Ebook\";\"1st\";\"\";\"Free Press\";\"2011\";\"289 pages\";\"\";\"\";\"English\";\"New York\";\"\";\"Contents Understanding your influence -- Living with confidence -- Embracing what\'s important -- Keeping the right perspective -- Making the most of what you have -- Recovering lost opportunities -- Overcoming offenses -- Enjoying rich relationships -- Discovering what others need -- Being a people builder -- Receiving love.rn  Abstract A guide to help you transform your life and love it more. Each reading offers insight','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22957%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22957%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22957%22%3Bs%3A5%3A%22title%22%3Bs%3A588%3A%22Daily+readings+from+Love+your+life+%3A+devotions+for+living+happy%2C+healthy%2C+and+whole%3B%22Ebook%22%3B%221st%22%3B%22%22%3B%22Free+Press%22%3B%222011%22%3B%22289+pages%22%3B%22%22%3B%22%22%3B%22English%22%3B%22New+York%22%3B%22%22%3B%22Contents+Understanding+your+influence+--+Living+with+confidence+--+Embracing+what%27s+important+--+Keeping+the+right+perspective+--+Making+the+most+of+what+you+have+--+Recovering+lost+opportunities+--+Overcoming+offenses+--+Enjoying+rich+relationships+--+Discovering+what+others+need+--+Being+a+people+builder+--+Receiving+love.rn++Abstract+A+guide+to+help+you+transform+your+life+and+love+it+more.+Each+reading+offers+insight%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A10%3A%22scriptures%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A7%3A%22stories%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22and+uplifting+messages+focusing+%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22Victoria%3E%5C%22%3B%5C%22%3CEbook%3E%3CChristian+women+--+Prayers+and+devotions%3E%3CSelf-realization+--+Religious+aspect%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22a03555c3dc1bda16d6cd41e65988d2686ce30a71%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (9,959,1,'Admin','Comprehensive gynecology;\"Ebook\";\"7th\";\"\";\"Elsevier\";\"2016\";\"xii','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22959%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22959%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22959%22%3Bs%3A5%3A%22title%22%3Bs%3A64%3A%22Comprehensive+gynecology%3B%22Ebook%22%3B%227th%22%3B%22%22%3B%22Elsevier%22%3B%222016%22%3B%22xii%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22956+pages+%3A+illustrations+%28chi%22%3Bs%3A3%3A%22sor%22%3Bs%3A44%3A%22Female%3E%3CEbook%3E%3CGynecology%3E%3CGenerative+organs%22%3Bs%3A7%3A%22edition%22%3Bs%3A20%3A%22Physical+Examination%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22and+Preventive+Health+Care+8.+In%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A6%3A%22Vagina%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22Vulva%29+29.+Malignant%22%3Bs%3A9%3A%22collation%22%3Bs%3A21%3A%22Premenstrual+Syndrome%22%3Bs%3A12%3A%22series_title%22%3Bs%3A118%3A%22and+Premenstrual+Dysphoric+Disorder+38.+Primary+and+Secondary+Amenorrhea+and+Precocious+Puberty+39.+Hyperprolactinemia%22%3Bs%3A11%3A%22call_number%22%3Bs%3A12%3A%22Galactorrhea%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A28%3A%22David+M.+%28David+Marc%29%3E%3CLentz%22%3Bs%3A14%3A%22classification%22%3Bs%3A17%3A%22Gretchen+M.%3E%3CLobo%22%3Bs%3A5%3A%22notes%22%3Bs%3A17%3A%22Rogerio+A.%3E%3CValea%22%3Bs%3A5%3A%22image%22%3Bs%3A29%3A%22Fidel+A.%3E%22%3B%22%3CGenital+Diseases%22%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3Ba%3A2%3A%7Bi%3A0%3Ba%3A3%3A%7Bs%3A11%3A%22author_name%22%3Bs%3A18%3A%22Female+--+Diseases%22%3Bs%3A14%3A%22authority_type%22%3Bs%3A13%3A%22Personal+Name%22%3Bs%3A15%3A%22authority_level%22%3Bs%3A17%3A%22Additional+Author%22%3B%7Di%3A1%3Ba%3A3%3A%7Bs%3A11%3A%22author_name%22%3Bs%3A17%3A%22Genital+Neoplasms%22%3Bs%3A14%3A%22authority_type%22%3Bs%3A13%3A%22Personal+Name%22%3Bs%3A15%3A%22authority_level%22%3Bs%3A17%3A%22Additional+Author%22%3B%7D%7Ds%3A8%3A%22subjects%22%3Ba%3A1%3A%7Bi%3A0%3Ba%3A3%3A%7Bs%3A5%3A%22topic%22%3Bs%3A13%3A%22Female%5C%22%3B%5C%22%5C%22%22%3Bs%3A10%3A%22topic_type%22%3Bs%3A5%3A%22Topic%22%3Bs%3A11%3A%22topic_level%22%3Bs%3A10%3A%22Additional%22%3B%7D%7Ds%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22a760023cad08ff8605ec9a0e1a9a73fb08f64eae%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22db18211bee9db0c669ff82e67a42a236195c04b9%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22626913defa6c3b253d02711e5a7087a7dd7a58a0%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%228abc5237bc8083595d6b17b9ca16f56b0147c474%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ece9eae2e3ad5de90f62003eb13284fbddb0f6a4%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (10,961,1,'Admin','Chapman\'s orthopaedic surgery;\"Ebook\";\"3rd\";\"\";\"Lippincott Williams & Wilkins\";\"2001\";\"4 volumes (xxxi','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22961%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22961%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22961%22%3Bs%3A5%3A%22title%22%3Bs%3A102%3A%22Chapman%27s+orthopaedic+surgery%3B%22Ebook%22%3B%223rd%22%3B%22%22%3B%22Lippincott+Williams+%26+Wilkins%22%3B%222001%22%3B%224+volumes+%28xxxi%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A4%3A%224601%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%2297+pages%29+%3A+illustrations%22%3B%22%22%3B%22%22%3B%22English%22%3B%22Philad%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A12%3A%22dislocations%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A9%3A%22nonunions%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22and+malunions+--+The%22%3Bs%3A9%3A%22collation%22%3Bs%3A9%3A%22arthritis%22%3Bs%3A12%3A%22series_title%22%3Bs%3A43%3A%22and+arthrosplasty+--+The+foot+--+Neoplastic%22%3Bs%3A11%3A%22call_number%22%3Bs%3A10%3A%22infections%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A30%3A%22Michael+W.%3E%5C%22%3B%5C%22%3CEbook%3E%3COrthop%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%225c5c9026a0de7dea431bdad17636a6d95868553a%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (11,962,1,'Admin','Basic science in obstetrics and gynaecology : a textbook for MRCOG Part I;\"Ebook\";\"4th\";\"\";\"Churchill Livingstone\";\"2010\";\"viii','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22962%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22962%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22962%22%3Bs%3A5%3A%22title%22%3Bs%3A127%3A%22Basic+science+in+obstetrics+and+gynaecology+%3A+a+textbook+for+MRCOG+Part+I%3B%22Ebook%22%3B%224th%22%3B%22%22%3B%22Churchill+Livingstone%22%3B%222010%22%3B%22viii%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22386+pages+%3A+illustrations%5C%22%3B%5C%22%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22Anna+Kenyon+%26+Dawn+Adamson+--+Endocrinology+%2F+Mark%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A19%3A%22Phillip%3E%3CWilliamson%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A71%3A%22Catherine%3E%5C%22%3B%5C%22%3CEbook%3E%3CObstetrics%3E%3CMedical+Sciences%3E%3CGynecology%3E%5C%22%3B%5C%22%5C%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%229043e4d2bb310c37222980ca54d8d085cb13b5d4%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (12,964,1,'Admin','Basic & clinical pharmacology;\"Ebook\";\"14th\";\"\";\"McGraw-Hill\";\"2018\";\"xi','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22964%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22964%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22964%22%3Bs%3A5%3A%22title%22%3Bs%3A72%3A%22Basic+%26+clinical+pharmacology%3B%22Ebook%22%3B%2214th%22%3B%22%22%3B%22McGraw-Hill%22%3B%222018%22%3B%22xi%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%221250+pages+%3A+illustrations+%28ch%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A12%3A%22inflammation%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22%26+gout+--+Sect.+VII%3A+Endocrine+d%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A16%3A%22pharmacogenomics%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22and+new+drugs+of+all%22%3Bs%3A9%3A%22collation%22%3Bs%3A75%3A%22it+reflects+the+major+expansion+of+large-molecule+drugs+in+the+pharmacopeia%22%3Bs%3A12%3A%22series_title%22%3Bs%3A103%3A%22with+numerous+new+monoclonal+antibodies+and+other+biologic+agents.+Case+studies+accompany+most+chapters%22%3Bs%3A11%3A%22call_number%22%3Bs%3A50%3A%22and+answers+to+questions+posed+in+the+case+studies%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A30%3A%22and+readable+pharmacology+text%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22and+the+availability+of+an+online+versio%22%3Bs%3A5%3A%22notes%22%3Bs%3A92%3A%22Bertram+G.%3E%22%3B%22%3CPharmacology%3E%3CClinical+pharmacology%3E%3CEbook%3E%3CPharmacology+--+Case+studies%3E%22%3B%22%22%22%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%226a04caab7fd55b6e6e71d45efbf527c5db81257d%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22d68e5a63cd47b53d205cbf02b06bbb0a9bb836f5%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (13,965,1,'Admin','Atlas of Ophthalmology;\"Ebook\";\"\";\"\";\"Springer Netherlands\";\"1982\";\"128 pages\";\"\";\"\";\"English\";\"Dordrecht\";\"\";\"Contents 1 Anatomy and Physiology -- 2 Examination of the Eye -- 3 Errors of Refraction and their Correction -- 4 The External Eye Part I -- 5 The External Eye Part II -- 6 The Internal Eye -- 7 The Fundus Part I -- 8 The Fundus Part II -- 9 Trauma to the Eye Part I -- 10 Trauma to the Eye Part II -- 11 Cataract -- 12 Glaucoma -- 13 Squint -- 14 Congenital Deformities -- 15 The Eye in Systemic Disease -- 16 Neuro-ophthalmology -- 17 Ocular Pharmacology.rn  Abstract This book is designed to be a pictorial guide to ophthalmology and not a comprehensive textbook. It includes chapters on anatomy','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22965%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22965%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22965%22%3Bs%3A5%3A%22title%22%3Bs%3A709%3A%22Atlas+of+Ophthalmology%3B%22Ebook%22%3B%22%22%3B%22%22%3B%22Springer+Netherlands%22%3B%221982%22%3B%22128+pages%22%3B%22%22%3B%22%22%3B%22English%22%3B%22Dordrecht%22%3B%22%22%3B%22Contents+1+Anatomy+and+Physiology+--+2+Examination+of+the+Eye+--+3+Errors+of+Refraction+and+their+Correction+--+4+The+External+Eye+Part+I+--+5+The+External+Eye+Part+II+--+6+The+Internal+Eye+--+7+The+Fundus+Part+I+--+8+The+Fundus+Part+II+--+9+Trauma+to+the+Eye+Part+I+--+10+Trauma+to+the+Eye+Part+II+--+11+Cataract+--+12+Glaucoma+--+13+Squint+--+14+Congenital+Deformities+--+15+The+Eye+in+Systemic+Disease+--+16+Neuro-ophthalmology+--+17+Ocular+Pharmacology.rn++Abstract+This+book+is+designed+to+be+a+pictorial+guide+to+ophthalmology+and+not+a+comprehensive+textbook.+It+includes+chapters+on+anatomy%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22physiology+and+optics+to+expla%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22but+includes+those+common+problems+that+can+worry+%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22but+also+the+hard+pressed+medica%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22a+study+of+which+The+eye+consists+of+three+concentric+layers.+The+outer+will+simplify+the+understand%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22which+tract+is+made+%22%3Bs%3A9%3A%22collation%22%3Bs%3A100%3A%22ciliary+body+and+iris.+is+approximately+pyramidal+in+shape.+The+bony+orbital+The+innermost+layer+is+%22%3Bs%3A12%3A%22series_title%22%3Bs%3A38%3A%22which+outlines+the+base+of+the+pyramid%22%3Bs%3A11%3A%22call_number%22%3Bs%3A50%3A%22affords+embryologically+from+the+forebrain+vesicle%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%222505aa93abc94c4b5276abd45aa9013feef3b507%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (14,966,1,'Admin','Diet, nutrition and the prevention of chronic diseases;\"Ebook\";\"\";\"\";\"World Health Organization\";\"2003\";\"x','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22966%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22966%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22966%22%3Bs%3A5%3A%22title%22%3Bs%3A106%3A%22Diet%2C+nutrition+and+the+prevention+of+chronic+diseases%3B%22Ebook%22%3B%22%22%3B%22%22%3B%22World+Health+Organization%22%3B%222003%22%3B%22x%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22149+p.+%3A+ill.%5C%22%3B%5C%22%5C%22%3B%5C%22%5C%22%3B%5C%22En%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22nutrition+and+physical+activity+on+chronic+disease%22%3Bs%3A9%3A%22isbn_issn%22%3BN%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%223ac708152e35867ecb99b79f7a305d6858705526%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (15,967,1,'Admin','Brunner & Suddarth\'s textbook of medical-surgical nursing;\"Ebook\";\"12th\";\"\";\"Wolters Kluwer Health/Lippincott Williams & Wilkins\";\"2010\";\"xxvii','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22967%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22967%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22967%22%3Bs%3A5%3A%22title%22%3Bs%3A143%3A%22Brunner+%26+Suddarth%27s+textbook+of+medical-surgical+nursing%3B%22Ebook%22%3B%2212th%22%3B%22%22%3B%22Wolters+Kluwer+Health%2FLippincott+Williams+%26+Wilkins%22%3B%222010%22%3B%22xxvii%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A10%3A%222240+pages%22%3Bs%3A3%3A%22sor%22%3Bs%3A71%3A%22Suzanne+C.%3E%22%3B%22%3CNursing%3E%3CEbook%3E%3CNursing+Care%3E%3CPerioperative+Nursing%3E%22%3B%22%22%22%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%2296+pages+%3A+illustrations+%28some%22%3B%22%22%3B%22%22%3B%22English%22%3B%22%22%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A23%3A%22ethical+decision+making%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22and+the+nursing+process+--+Health+education+and+health+promotion+--+Adult+health+and+nutritional+ass%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A6%3A%22stress%22%3Bs%3A9%3A%22collation%22%3Bs%3A100%3A%22and+adaptation+--+Individual+and+family+considerations+related+to+illness+--+Perspectives+in+transcu%22%3Bs%3A12%3A%22series_title%22%3Bs%3A10%3A%22infectious%22%3Bs%3A11%3A%22call_number%22%3Bs%3A50%3A%22and+inflammatory+cardiac+disorders+--+Management+o%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A30%3A%22and+neuropathies+--+Management%22%3Bs%3A14%3A%22classification%22%3Bs%3A13%3A%22mass+casualty%22%3Bs%3A5%3A%22notes%22%3Bs%3A38%3A%22and+disaster+nursing.%22%3B%22%22%3B%22%22%3B%22%3CBrunner%22%3Bs%3A5%3A%22image%22%3Bs%3A25%3A%22Lillian+Sholtis%3E%3CSmeltzer%22%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22f32de2233b4db910a4b1dd5ca753f07b4b4a0ccc%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%2232fb5607d5d1caca37690d1a86c87dc22ec97daf%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22aa1013b7c58bf81053b14a7054d719ce41ebc720%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (16,968,1,'Admin','Obstetrics by ten teachers;\"Ebook\";\"16th\";\"\";\"Little','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22968%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22968%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22968%22%3Bs%3A5%3A%22title%22%3Bs%3A52%3A%22Obstetrics+by+ten+teachers%3B%22Ebook%22%3B%2216th%22%3B%22%22%3B%22Little%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A22%3A%22Brown%5C%22%3B%5C%221995%5C%22%3B%5C%22xvi%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22368+pages+%3A+illustrations%22%3B%22%22%3B%22%22%3B%22English%22%3B%22London%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22Geoffrey%3E%22%3B%22%3CPregnancy+Complicat%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%229c4bf29efd74f6959e4a377a7b937282f56bfa73%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (17,969,1,'Admin','Public health nutrition in developing countries;\"Ebook\";\"\";\"\";\"Woodhead Publishing India\";\"2011\";\"xxxvi','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22969%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22969%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22969%22%3Bs%3A5%3A%22title%22%3Bs%3A103%3A%22Public+health+nutrition+in+developing+countries%3B%22Ebook%22%3B%22%22%3B%22%22%3B%22Woodhead+Publishing+India%22%3B%222011%22%3B%22xxxvi%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A9%3A%222+volumes%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%221244+pages+%3A+illustrations%22%3B%22%22%3B%22%22%3B%22English%22%3B%22New+D%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22India%22%3B%22%22%3B%22Contents+29.+Vitamin+%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22food+and+nutrition+security+--+32.+Food+and+nutrition+situation+in+India+--+33.+Food+and+nutrition+i%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A12%3A%22consequences%22%3Bs%3A9%3A%22collation%22%3Bs%3A100%3A%22and+control+measures+--+5.+Measuring+undernutrition+and+overnutrition+in+children+--+6.+Essential+ne%22%3Bs%3A12%3A%22series_title%22%3Bs%3A200%3A%22current+status+and+future+directions+--+8.+Complementary+feeding+of+infants+and+young+children+--+9.+Options+and+strategies+to+reach+under-two+children+through+complementary+feeding+with+ARF+in+the+So%22%3Bs%3A11%3A%22call_number%22%3Bs%3A50%3A%22folic+acid+and+vitamin+B12+--+24.+Iron+deficiency+%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A30%3A%22Sheila+Chander%3E%5C%22%3B%5C%22%3CEbook%3E%3CPu%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22c5976cb9dcbfbf90e0697469d35fbe6d463f7bc4%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (18,970,1,'Admin','Medical-surgical nursing certification examination : review;\"Ebook\";\"\";\"\";\"McGraw-Hill Medical\";\"2007\";\"x','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22970%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22970%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22970%22%3Bs%3A5%3A%22title%22%3Bs%3A105%3A%22Medical-surgical+nursing+certification+examination+%3A+review%3B%22Ebook%22%3B%22%22%3B%22%22%3B%22McGraw-Hill+Medical%22%3B%222007%22%3B%22x%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22158+pages%5C%22%3B%5C%22%5C%22%3B%5C%22%5C%22%3B%5C%22Englis%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A36%3A%22trauma+and+orthopedic+pearls+--+Eyes%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A4%3A%22ears%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A4%3A%22nose%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22and+throat+%28EENT%29+pe%22%3Bs%3A9%3A%22collation%22%3Bs%3A100%3A%22metabolic+and+endocrine+pearls+--+Neurology+pearls+--+Infectious+disease%2Frheumatology%2Fimmunology+pea%22%3Bs%3A12%3A%22series_title%22%3Bs%3A43%3A%22Scott+H.%3E%22%3B%22%3CEbook%3E%3CNursing+--+Examinations%22%3Bs%3A11%3A%22call_number%22%3Bs%3A49%3A%22questions%3E%3COperating+room+nursing+--+Examinations%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22231ff243a3469f8473f8e84d3acd359ddefc6760%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (19,971,1,'Admin','Nutrition and health in Developing countries;\"Ebook\";\"\";\"\";\"Humana Press\";\"2001\";\"xvii','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22971%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22971%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22971%22%3Bs%3A5%3A%22title%22%3Bs%3A86%3A%22Nutrition+and+health+in+Developing+countries%3B%22Ebook%22%3B%22%22%3B%22%22%3B%22Humana+Press%22%3B%222001%22%3B%22xvii%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22569+pages+%3A+illustrations%5C%22%3B%5C%22%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22NJ%22%3B%22%22%3B%22Contents+1.+Nutrition+and+Development%3A+A+H%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22Jr.+and+Ian+Darnton-Hill.%22%3B%22%22%3B%22%22%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A17%3A%22Richard+D.%3E%3CBloem%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22Martin+W.%3E%22%3B%22%3CEbook%3E%22%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%228c616abba35d7e8b485f2c3687a41dd31a62111b%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (20,972,1,'Admin','Psychiatric and Mental Health Nursing : the craft of caring;\"Ebook\";\"2nd\";\"\";\"CRC Press\";\"2012\";\"1 online resource (780 pages)\";\"\";\"\";\"English\";\"\";\"\";\"Contents Cover; Book title; Contents; List of contributors; Poem: The Cleansing has Begun; The Space I\'m in; Poem: Half dead; Preface to the second edition; Acknowledgements; Section 1 THE NEED FOR NURSING; Preface to Section 1; 1 The nature of nursing; 2 Getting personal: being human in mental health care; 3 The care and confinement of the mentally ill; 4 Evidence-based practice in mental health; 5 The craft of psychiatric-mental health nursing practice; 6 Leading developments in the craft of caring; 7 Recovery: a personal perspective.rn8 Recovery and reclamation: a pilgrimage in understanding who and what we areSection 2 ASSESSMENT IN PRACTICE; Preface to Section 2; 9 Assessment: the foundation of practice; 10 Assessment methods; 11 The craft of interviewing; 12 Developing collaborative assessment; 13 The context of family assessment; 14 The assessment of feelings','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22972%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22972%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22972%22%3Bs%3A5%3A%22title%22%3Bs%3A1029%3A%22Psychiatric+and+Mental+Health+Nursing+%3A+the+craft+of+caring%3B%22Ebook%22%3B%222nd%22%3B%22%22%3B%22CRC+Press%22%3B%222012%22%3B%221+online+resource+%28780+pages%29%22%3B%22%22%3B%22%22%3B%22English%22%3B%22%22%3B%22%22%3B%22Contents+Cover%3B+Book+title%3B+Contents%3B+List+of+contributors%3B+Poem%3A+The+Cleansing+has+Begun%3B+The+Space+I%27m+in%3B+Poem%3A+Half+dead%3B+Preface+to+the+second+edition%3B+Acknowledgements%3B+Section+1+THE+NEED+FOR+NURSING%3B+Preface+to+Section+1%3B+1+The+nature+of+nursing%3B+2+Getting+personal%3A+being+human+in+mental+health+care%3B+3+The+care+and+confinement+of+the+mentally+ill%3B+4+Evidence-based+practice+in+mental+health%3B+5+The+craft+of+psychiatric-mental+health+nursing+practice%3B+6+Leading+developments+in+the+craft+of+caring%3B+7+Recovery%3A+a+personal+perspective.rn8+Recovery+and+reclamation%3A+a+pilgrimage+in+understanding+who+and+what+we+areSection+2+ASSESSMENT+IN+PRACTICE%3B+Preface+to+Section+2%3B+9+Assessment%3A+the+foundation+of+practice%3B+10+Assessment+methods%3B+11+The+craft+of+interviewing%3B+12+Developing+collaborative+assessment%3B+13+The+context+of+family+assessment%3B+14+The+assessment+of+feelings%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22thoughts+and+beliefs%3B+Section+%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22control+or+care%3B+49+Mental+health+nursing+in+commu%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22thoughts+and+beliefs+The+Structu%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22control+or+care+Mental+health+nursing+in+community+care+Crisis+assessment+and+resolution+Assertive+o%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22Ethical+and+Moral+Is%22%3Bs%3A9%3A%22collation%22%3Bs%3A100%3A%22the+law+and+human+rights+Ethics+and+nursing+Sexuality+and+gender+Freedom+and+consent+Providing+cultu%22%3Bs%3A12%3A%22series_title%22%3Bs%3A200%3A%22nursing+and+mental+health+The+Development+of+Mental+Health+Nursing+Clinical+supervision+The+possibility+of+genuine+mental+health+nursing+Building+practice+from+research+Reclamation%3A+beyond+recovery+Th%22%3Bs%3A11%3A%22call_number%22%3Bs%3A40%3A%22Phil%3E%22%3B%22%3CPsychiatric+nursing%3E%3CEbook%3E%22%3B%22%22%22%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22d6a7854d3e9203138cef4aa86ff66d2a4185fe74%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (21,973,1,'Admin','Imaging of the Newborn, Infant, and Young Child;\"Ebook\";\"5th\";\"\";\"Wolters Kluwer Health\";\"2015\";\"1 online resource (1225 pages)\";\"\";\"\";\"English\";\"\";\"\";\"Contents IMAGING OF THE NEWBORN','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22973%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22973%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22973%22%3Bs%3A5%3A%22title%22%3Bs%3A183%3A%22Imaging+of+the+Newborn%2C+Infant%2C+and+Young+Child%3B%22Ebook%22%3B%225th%22%3B%22%22%3B%22Wolters+Kluwer+Health%22%3B%222015%22%3B%221+online+resource+%281225+pages%29%22%3B%22%22%3B%22%22%3B%22English%22%3B%22%22%3B%22%22%3B%22Contents+IMAGING+OF+THE+NEWBORN%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A6%3A%22INFANT%22%3Bs%3A3%3A%22sor%22%3Bs%3A164%3A%22Leonard+E.%3E%22%3B%22%3CEbook%3E%3CNewborn+infants+--+Diseases+--+Diagnosis%3E%3CPediatric+diagnostic+imaging%3E%3CPediatric+radiography%3E%3CPremature+infants+--+Diseases+--+Diagnosis%3E%22%3B%22%22%22%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22AND+YOUNG+CHILD%3B+CONTENTS%3B+PREFACE%3B+RESPIRATORY+SY%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A8%3A%22MANDIBLE%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22AND+UPPER+AIRWAY%3B+ABNORMALITIES+OF+THE+NASAL+PASSAGES%3B+ABNORMALITIES+OF+THE+TONGUE%3B+ABNORMALITIES+OF%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A7%3A%22ASCITES%22%3Bs%3A9%3A%22collation%22%3Bs%3A100%3A%22AND+HEMOPERITONEUM%3B+THE+APPENDIX%3B+OTHER+MISCELLANEOUS+ABDOMINAL+AND+GASTROINTESTINAL+ABNORMALITIES%3B+%22%3Bs%3A12%3A%22series_title%22%3Bs%3A6%3A%22infant%22%3Bs%3A11%3A%22call_number%22%3Bs%3A42%3A%22and+young+child.+Organized+by+organ+system%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A20%3A%22congenital+anomalies%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22and+common+disease+processes.+Many+norma%22%3Bs%3A5%3A%22notes%22%3Bs%3A41%3A%22expanded+chapters+on+the+abdomen+and+head%22%3Bs%3A5%3A%22image%22%3Bs%3A31%3A%22and+material.%22%3B%22%22%3B%22%22%3B%22%3CSwischuk%22%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22e03fc7d7ae83555a049bd7e7c7574d61c5d4418e%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%224cebf1f4d047f5332237fe9b30ce3664e5fb1ca4%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22267afc4db534161950a12b81415ecd02e925052e%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (22,974,1,'Admin','Life-span development;\"Ebook\";\"13th\";\"\";\"McGraw-Hill\";\"2011\";\"xliv','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22974%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22974%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22974%22%3Bs%3A5%3A%22title%22%3Bs%3A66%3A%22Life-span+development%3B%22Ebook%22%3B%2213th%22%3B%22%22%3B%22McGraw-Hill%22%3B%222011%22%3B%22xliv%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A3%3A%22643%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22%5B112%5D+pages+%3A+illustrations+%28chiefly+co%22%3B%22%22%3B%22%22%3B%22En%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A5%3A%22dying%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22and+grieving.rn++Abstract+Helps+students+complete+and+understand+the+assigned+material+in+a+number+o%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22pointing+out+the+cor%22%3Bs%3A9%3A%22collation%22%3Bs%3A92%3A%22John+W.%3E%22%3B%22%3CPsychology%3E%3CEbook%3E%3CDevelopmental+psychology+--+Textbooks%3E%3CHuman+Development%3E%22%3B%22%22%22%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%229c2b3f4e828fdb5223a8692c33cae1463847ac6a%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (23,975,1,'Admin','Principles of anatomy & physiology;\"Ebook\";\"13th\";\"\";\"Wiley\";\"2012\";\"1 volume (various pagings) : illustrations (chiefl\";\"\";\"\";\"English\";\"\";\"\";\"Contents V. 1. Organization','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22975%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22975%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22975%22%3Bs%3A5%3A%22title%22%3Bs%3A171%3A%22Principles+of+anatomy+%26+physiology%3B%22Ebook%22%3B%2213th%22%3B%22%22%3B%22Wiley%22%3B%222012%22%3B%221+volume+%28various+pagings%29+%3A+illustrations+%28chiefl%22%3B%22%22%3B%22%22%3B%22English%22%3B%22%22%3B%22%22%3B%22Contents+V.+1.+Organization%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22support+and+movement+and+contr%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A28%3A%22normal+anatomy+and+pathology%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22and+homeostasis+and+homeostatic+%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22including+WileyPlus+5.0.+No+other+text+and+package+offers+a+teaching+and+learning+environment+as+ric%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22Gerard+J.%3E%3CDerrickso%22%3Bs%3A9%3A%22collation%22%3Bs%3A97%3A%22Bryan%3E%22%3B%22%3CAnatomy%3E%3CEbook%3E%3CPhysiology%3E%3CHuman+physiology+--+Textbooks%3E%3CPhysiological+Phenomena%3E%22%3B%22%22%22%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22e6185c2b80b30f5d72f785f60fecadb3e156520d%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (24,976,1,'Admin','Introduction to psychology : gateways to mind and behavior;\"Ebook\";\"12th\";\"\";\"Cengage Learning\";\"2010\";\"xxx','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22976%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22976%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22976%22%3Bs%3A5%3A%22title%22%3Bs%3A107%3A%22Introduction+to+psychology+%3A+gateways+to+mind+and+behavior%3B%22Ebook%22%3B%2212th%22%3B%22%22%3B%22Cengage+Learning%22%3B%222010%22%3B%22xxx%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A3%3A%22622%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22%5B79%5D+pages+%3A+illustrations+%28chiefly+colo%22%3B%22%22%3B%22%22%3B%22E%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22CA%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%3CPsychology%3E%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%228151eb761dbfb651ee0e41b4dd87d2ac98d45878%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (25,977,1,'Admin','Ross and Wilson anatomy and physiology in health and illness;\"Ebook\";\"\";\"\";\"Churchill Livingstone\";\"2001\";\"\";\"\";\"\";\"English\";\"\";\"\";\"\";\"\";\"\";\"<Waugh','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22977%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22977%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22977%22%3Bs%3A5%3A%22title%22%3Bs%3A147%3A%22Ross+and+Wilson+anatomy+and+physiology+in+health+and+illness%3B%22Ebook%22%3B%22%22%3B%22%22%3B%22Churchill+Livingstone%22%3B%222001%22%3B%22%22%3B%22%22%3B%22%22%3B%22English%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%3CWaugh%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A11%3A%22Anne%3E%3CGrant%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A13%3A%22Allison%3E%3CRoss%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22Janet+S%3E%22%3B%22%3CNursing%3E%3CAnatomy%3E%3CHu%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%220d8785e7d7cb9fbf2f7801861a571a1ce90029bb%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (26,978,1,'Admin','Abnormal psychology;\"Ebook\";\"11th\";\"9780470380086\";\"J. Wiley\";\"2010\";\"1 volume (various pagings) : illustrations (chiefl\";\"\";\"\";\"English\";\"Hoboken','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22978%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22978%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22978%22%3Bs%3A5%3A%22title%22%3Bs%3A146%3A%22Abnormal+psychology%3B%22Ebook%22%3B%2211th%22%3B%229780470380086%22%3B%22J.+Wiley%22%3B%222010%22%3B%221+volume+%28various+pagings%29+%3A+illustrations+%28chiefl%22%3B%22%22%3B%22%22%3B%22English%22%3B%22Hoboken%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22NJ%5C%22%3B%5C%22%5C%22%3B%5C%22Contents+Introduct%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A21%3A%22cutting-edge+coverage%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A21%3A%22authoritative+content%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22and+clinical+emphasis.+It+helps+them+fully+integrate+the+details+of+all+the+disorders+and+distinguis%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22psychologists+will+f%22%3Bs%3A9%3A%22collation%22%3Bs%3A8%3A%22engaging%22%3Bs%3A12%3A%22series_title%22%3Bs%3A32%3A%22and+informative.%22%22%3B%22%22%3B%22%22%3B%22%3CKring%22%3Bs%3A11%3A%22call_number%22%3Bs%3A46%3A%22Ann+M.%3E%22%3B%22%3CEbook%3E%3CMental+Disorders%3E%3CPsychology%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%2240114b42987b8cc62aa04ec07bc97303dc5e3056%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (27,979,1,'Admin','Research for nurses : methods and interpretation;\"Ebook\";\"\";\"9.78E+12\";\"F.A. Davis Co.\";\"2002\";\"xiii','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22979%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22979%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22979%22%3Bs%3A5%3A%22title%22%3Bs%3A100%3A%22Research+for+nurses+%3A+methods+and+interpretation%3B%22Ebook%22%3B%22%22%3B%229.78E%2B12%22%3B%22F.A.+Davis+Co.%22%3B%222002%22%3B%22xiii%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22752+pages+%3A+illustrations%5C%22%3B%5C%22%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22PA%22%3B%22%22%3B%22Introduction+to+Nursing+Research+--+Resear%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A15%3A%22Angela%3E%3CJackson%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22Winston%3E%5C%22%3B%5C%22%3CNursing+--+Research+--+Methodology%3E%3CEbook%3E%3CNursing+--+Research%3E%3CNursing+Research+--+me%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A16%3A%22Statistical%3E%22%3B%22%22%22%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22851c1b8b81bf19b53ea8b040957b59353b0eebdc%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:00');
INSERT INTO `biblio_log` VALUES (28,980,1,'Admin','Managing incomplete abortion;\"Ebook\";\"\";\"\";\"\";\"\";\"\";\"\";\"\";\"English\";\"\";\"\";\"\";\"\";\"\";\"\";\"<Ebook>\";\"\"','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22980%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22980%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22980%22%3Bs%3A5%3A%22title%22%3Bs%3A98%3A%22Managing+incomplete+abortion%3B%22Ebook%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22English%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%3CEbook%3E%22%3B%22%22%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A0%3A%22%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3BN%3Bs%3A9%3A%22isbn_issn%22%3BN%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22817a603166db0b4bc0e284c1474c51954f437208%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (29,981,1,'Admin','Provider and pharmacy directory;\"Ebook\";\"\";\"\";\"\";\"2015\";\"444 pages : illustrations\";\"\";\"ebook\";\"English\";\"Cigna Pub.\";\"\";\"\";\"\";\"\";\"<Maricopa','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22981%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22981%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22981%22%3Bs%3A5%3A%22title%22%3Bs%3A140%3A%22Provider+and+pharmacy+directory%3B%22Ebook%22%3B%22%22%3B%22%22%3B%22%22%3B%222015%22%3B%22444+pages+%3A+illustrations%22%3B%22%22%3B%22ebook%22%3B%22English%22%3B%22Cigna+Pub.%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%3CMaricopa%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22County%3E%3CApache+Junction%3E%3CQueen%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A24%3A%22Creek%3E%22%3B%22%22%3B%22%3Chmo+ebook%3E%22%22%3Bs%3A9%3A%22isbn_issn%22%3BN%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%220bc9ee18c0e661f0efae4df9b5b5b6c017bf89c1%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (30,982,1,'Admin','Enabling learning in nursing and midwifery practice : a guide for mentors;\"Ebook\";\"\";\"\";\"John Wiley & Sons\";\"2007\";\"xv','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22982%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22982%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22982%22%3Bs%3A5%3A%22title%22%3Bs%3A118%3A%22Enabling+learning+in+nursing+and+midwifery+practice+%3A+a+guide+for+mentors%3B%22Ebook%22%3B%22%22%3B%22%22%3B%22John+Wiley+%26+Sons%22%3B%222007%22%3B%22xv%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22251+pages%5C%22%3B%5C%22%5C%22%3B%5C%22%5C%22%3B%5C%22Englis%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22England%22%3B%22%22%3B%22Abstract%09rn%22This+text+addresses+the+i%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22examines+the+nature+of+effective%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22virtual+learning+and+other+core+resources+to+enhance+and+support+learning+in+practice+and+examines+a%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22making+correct+judge%22%3Bs%3A9%3A%22collation%22%3Bs%3A100%3A%22Andrew+Southgate+--+The+development+of+competence+in+newly+qualified+practitioners+%2F+Tim+Clark+--+As%22%3Bs%3A12%3A%22series_title%22%3Bs%3A112%3A%22process+and+responsibilities+%2F+Sue+West+--+Use+of+the+Internet+to+support+learning+in+practice+%2F+Susan+Westerman%22%3Bs%3A11%3A%22call_number%22%3Bs%3A50%3A%22Emily+Hurt+--+Challenges+in+the+interprofessional+%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A11%3A%22Tim%3E%3CJasper%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22Melanie%3E%22%3B%22%3CNursing%3E%3CEducation%3E%3CMentorin%22%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%2284ffdc79df592cd0e93aa53674dca9938c327f11%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22b75cd63d563d9eaa3fb84c0db78c780770a133e7%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (31,983,1,'Admin','Practical handbook of microbiology / edited by Emanuel Goldman, Lorrence H. Green.;\"Ebook\";\"2nd ed.\";\"978-0-8493-9365-5\";\"CRC Press\";\"2009\";\"1 online resource (xx','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22983%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22983%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22983%22%3Bs%3A5%3A%22title%22%3Bs%3A162%3A%22Practical+handbook+of+microbiology+%2F+edited+by+Emanuel+Goldman%2C+Lorrence+H.+Green.%3B%22Ebook%22%3B%222nd+ed.%22%3B%22978-0-8493-9365-5%22%3B%22CRC+Press%22%3B%222009%22%3B%221+online+resource+%28xx%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22853+pages%29+%3A+illustrations%5C%22%3B%5C%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A15%3A%22Emanuel.%3E%3CGreen%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22Lorrence+H.%3E%22%3B%22%3CMicrobiology.%3E%3CM%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A7%3A%22manuals%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A18%3A%22etc.%3E%22%3B%22%3CGol+C.1%3E%22%22%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%222af109baa9772d6cdd3926029df76ace57670a47%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (32,984,1,'Admin','Initial management of acute medical patients : a guide for nurses and healthcare practitioners / edited by Ian Wood, Michelle Garner.;\"Ebook\";\"2nd ed.\";\"978-1-4443-3716-7\";\"Wiley-Blackwell\";\"2012\";\"1 online resource (x','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22984%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22984%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22984%22%3Bs%3A5%3A%22title%22%3Bs%3A218%3A%22Initial+management+of+acute+medical+patients+%3A+a+guide+for+nurses+and+healthcare+practitioners+%2F+edited+by+Ian+Wood%2C+Michelle+Garner.%3B%22Ebook%22%3B%222nd+ed.%22%3B%22978-1-4443-3716-7%22%3B%22Wiley-Blackwell%22%3B%222012%22%3B%221+online+resource+%28x%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22310+pages%29+%3A+illustrations%5C%22%3B%5C%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22Iowa%22%3B%22%22%3B%22Revised+edition+of%3A+Medical+assessment+u%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%222003.rnIncludes+bibliographical+%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A3%3A%22Ian%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A13%3A%221962-%3E%3CGarner%22%3Bs%3A9%3A%22collation%22%3Bs%3A100%3A%22Michelle.%3E%22%3B%22%3CNursing+Assessment.%3E%3CEbook%3E%3CEmergency+nursing.%3E%3CCritical+Care+--+methods.%3E%3CEmergency+N%22%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%221c586419bbf5f7d67c586d114509cc8450e40617%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (33,985,1,'Admin','International handbook of psychiatry : a concise guide for medical students, residents, and medical practitioners / editors, Laura Weiss Roberts, Joseph B. Layde, Richard Balon ; [in-house editor, Veronica Low].;\"Ebook\";\"\";\"978-9814405607\";\"World Scientific\";\"2013\";\"1 online resource (xxxii','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22985%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22985%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22985%22%3Bs%3A5%3A%22title%22%3Bs%3A291%3A%22International+handbook+of+psychiatry+%3A+a+concise+guide+for+medical+students%2C+residents%2C+and+medical+practitioners+%2F+editors%2C+Laura+Weiss+Roberts%2C+Joseph+B.+Layde%2C+Richard+Balon+%3B+%5Bin-house+editor%2C+Veronica+Low%5D.%3B%22Ebook%22%3B%22%22%3B%22978-9814405607%22%3B%22World+Scientific%22%3B%222013%22%3B%221+online+resource+%28xxxii%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22924+pages%29%5C%22%3B%5C%22%5C%22%3B%5C%22RC454+.In8%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22What+Not+to+Do+%2F+Mara+Pheister+--+ch.+6+Psychologi%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A11%3A%22Laura+Weiss%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A7%3A%22%3E%3CLayde%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A16%3A%22Joseph+B.%3E%3CBalon%22%3Bs%3A9%3A%22collation%22%3Bs%3A32%3A%22Richard.%3E%22%3B%22%3CEbook%3E%22%3B%22%3CInt+C.1%3E%22%22%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%223f984f40a4176d5638c4549e5791fa1a80332912%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (34,986,1,'Admin','Microbiology Demystified, A self-Teaching Guide;\"Ebook\";\"\";\"1280244933\";\"McGraw-Hill Publishing\";\"2005\";\"1 online resource (309 pages)\";\"\";\"QR41.2 B46\";\"English\";\"New York [u.a.]\";\"\";\"The Microbial World 2. Observing Microorganisms Through a Microscope 3. Functional Anatomy of Prokaryotic and Eukaryotic Cells 4. Microbial Metabolism 5. Microbial Growth and Controlling Microbial Growth 6. Microbial Genetics 7. Biotechnology and Recombinant DNA 8. Classification of Microorganisms 9.\";\"Microbiology_Demystified','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22986%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22986%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22986%22%3Bs%3A5%3A%22title%22%3Bs%3A512%3A%22Microbiology+Demystified%2C+A+self-Teaching+Guide%3B%22Ebook%22%3B%22%22%3B%221280244933%22%3B%22McGraw-Hill+Publishing%22%3B%222005%22%3B%221+online+resource+%28309+pages%29%22%3B%22%22%3B%22QR41.2+B46%22%3B%22English%22%3B%22New+York+%5Bu.a.%5D%22%3B%22%22%3B%22The+Microbial+World+2.+Observing+Microorganisms+Through+a+Microscope+3.+Functional+Anatomy+of+Prokaryotic+and+Eukaryotic+Cells+4.+Microbial+Metabolism+5.+Microbial+Growth+and+Controlling+Microbial+Growth+6.+Microbial+Genetics+7.+Biotechnology+and+Recombinant+DNA+8.+Classification+of+Microorganisms+9.%22%3B%22Microbiology_Demystified%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22_A_self-Teaching_Guide.jpg.jpg%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A11%3A%22Tom.%3E%3CKeogh%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22James.%3E%22%3B%22%3CEbook%3E%3CMicrobiology%3E%3C%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%2271044396d2a3d1297439e0b3b6ce97586a6543ed%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (35,987,1,'Admin','Microbiology and immunology;\"Ebook\";\"\";\"0385-56001348-0421\";\"Center for Academic Publications\";\"1977-\";\"1 online resource: volumes : illustrations\";\"\";\"QR1 .J25\";\"English\";\"Tokyo\";\"\";\"\";\"\";\"\";\"<Nihon Saikin Gakkai.><Nihon Uirusu Gakkai.><Nihon Men\'eki Gakkai.><Nihon Seitai Bōgyo Gakkai.>\";\"<Ebook><Microbiology.><Allergy and Immunology.><Microbiology -- Periodicals.><Immunology -- Periodicals.>\";\"<Jan C.1>\"','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22987%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22987%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22987%22%3Bs%3A5%3A%22title%22%3Bs%3A411%3A%22Microbiology+and+immunology%3B%22Ebook%22%3B%22%22%3B%220385-56001348-0421%22%3B%22Center+for+Academic+Publications%22%3B%221977-%22%3B%221+online+resource%3A+volumes+%3A+illustrations%22%3B%22%22%3B%22QR1+.J25%22%3B%22English%22%3B%22Tokyo%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%3CNihon+Saikin+Gakkai.%3E%3CNihon+Uirusu+Gakkai.%3E%3CNihon+Men%27eki+Gakkai.%3E%3CNihon+Seitai+Bo%CC%84gyo+Gakkai.%3E%22%3B%22%3CEbook%3E%3CMicrobiology.%3E%3CAllergy+and+Immunology.%3E%3CMicrobiology+--+Periodicals.%3E%3CImmunology+--+Periodicals.%3E%22%3B%22%3CJan+C.1%3E%22%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A0%3A%22%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3BN%3Bs%3A9%3A%22isbn_issn%22%3BN%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%225ad63727534cef3e32f0d9ba4e19fc1d659d3dee%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (36,988,1,'Admin','Microbiology : PreTest self-assessment and review / [edited by] Richard C. Tilton.;\"Ebook\";\"10th ed.\";\"0-07-138970-9\";\"McGraw Hill\";\"2002\";\"1 online resource (vii','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22988%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22988%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22988%22%3Bs%3A5%3A%22title%22%3Bs%3A162%3A%22Microbiology+%3A+PreTest+self-assessment+and+review+%2F+%5Bedited+by%5D+Richard+C.+Tilton.%3B%22Ebook%22%3B%2210th+ed.%22%3B%220-07-138970-9%22%3B%22McGraw+Hill%22%3B%222002%22%3B%221+online+resource+%28vii%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22264+pages%29+%3A+illustrations%5C%22%3B%5C%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22Richard+C.%3E%22%3B%22%3CMedical+microbiology.%3E%3CMedical+micr%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A9%3A%22questions%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A18%3A%22e%3E%5C%22%3B%5C%22%3CTil+C.1%3E%5C%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%226b8d71db52526e0b260f6f3285a5edb339af6d16%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (37,989,1,'Admin','Metabolic Syndrome and Complications of Pregnancy : The Potential Preventive Role of Nutrition;\"Ebook\";\"\";\"9783319168531\";\"Springer International Publishing : Imprint : Springer\";\"2015\";\"1 online resource (x','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22989%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22989%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22989%22%3Bs%3A5%3A%22title%22%3Bs%3A207%3A%22Metabolic+Syndrome+and+Complications+of+Pregnancy+%3A+The+Potential+Preventive+Role+of+Nutrition%3B%22Ebook%22%3B%22%22%3B%229783319168531%22%3B%22Springer+International+Publishing+%3A+Imprint+%3A+Springer%22%3B%222015%22%3B%221+online+resource+%28x%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A23%3A%22238+p.+46+illustrations%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%2236%22%3B%22%22%3B%22RG499.2+M55%22%3B%22English%22%3B%22Cham%22%3B%22%22%3B%22This+boo%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22during+which+key+risk+factors+ca%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A82%3A%22including+the+nature+of+the+placenta+as+a+proinflammatory+tissue.+In+the+main+body%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22it+points+to+new+pos%22%3Bs%3A9%3A%22collation%22%3Bs%3A12%3A%22inflammation%22%3Bs%3A12%3A%22series_title%22%3Bs%3A18%3A%22metabolic+syndrome%22%3Bs%3A11%3A%22call_number%22%3Bs%3A31%3A%22and+major+obstetrical+syndromes%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A30%3A%22gestational+diabetes+and+pre-t%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22the+remainder+of+the+book+focuses+on+a+v%22%3Bs%3A5%3A%22notes%22%3Bs%3A14%3A%22Enrico.%3E%3CSears%22%3Bs%3A5%3A%22image%22%3Bs%3A100%3A%22Barry.%3E%22%3B%22%3CObstetrics.%3E%3CEbook%3E%3CNutrition.%3E%3CMedicine.%3E%3CCardiology.%3E%3CMedicine+%26+Public+Health.%3E%3CEndocr%22%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22779779a601bef8b4a0d0229ce1c5e5c24cb34ec3%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22519dd884c6b8131376d8bd57fd1e36807d4352e4%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%221544070c101f12c5c7ab1c33272d8bb91a17b7bf%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (38,990,1,'Admin','Melloni\'s pocket illustrated medical dictionary;\"Ebook\";\"\";\"\";\"\";\"\";\"\";\"\";\"\";\"English\";\"\";\"\";\"\"This new pocket dictionary is an abbreviated version of an award-winning and highly acclaimed dictionary. It is a convenient','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22990%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22990%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22990%22%3Bs%3A5%3A%22title%22%3Bs%3A219%3A%22Melloni%27s+pocket+illustrated+medical+dictionary%3B%22Ebook%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22English%22%3B%22%22%3B%22%22%3B%22%22This+new+pocket+dictionary+is+an+abbreviated+version+of+an+award-winning+and+highly+acclaimed+dictionary.+It+is+a+convenient%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A15%3A%22highly+portable%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22rapid+reference+and+yet+it+still+features+a+surpri%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A11%3A%22but+concise%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A45%3A%22medical+definitions.%5C%22%5C%22%3B%5C%22%5C%22%3B%5C%22%5C%22%3B%5C%22%3CMelloni%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22June+L.%3E%22%3B%22%3CEbook%3E%22%3B%22%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22ba020ac9a573956756214a81a59b695603b68a80%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (39,992,1,'Admin','Medical-surgical nursing certification examination : review / Scott H. Plantz [and others].;\"Ebook\";\"\";\"0-07-151117-2\";\"McGraw-Hill Medical\";\"2007\";\"1 online resource (ix','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22992%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22992%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22992%22%3Bs%3A5%3A%22title%22%3Bs%3A170%3A%22Medical-surgical+nursing+certification+examination+%3A+review+%2F+Scott+H.+Plantz+%5Band+others%5D.%3B%22Ebook%22%3B%22%22%3B%220-07-151117-2%22%3B%22McGraw-Hill+Medical%22%3B%222007%22%3B%221+online+resource+%28ix%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22170+pages%29.%5C%22%3B%5C%22%5C%22%3B%5C%22RT55+.M46%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22Scott+H.%3E%22%3B%22%3CNursing.%3E%3CNursing+Care.%3E%3CPerioperativ%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A9%3A%22questions%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A21%3A%22etc.%3E%5C%22%3B%5C%22%3CMed+c.3%3E%5C%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%228b34b621fbb7c9812f28145d0c7932914b6fab15%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (40,993,1,'Admin','Maternal care : a learning programme for professionals;\"Ebook\";\"\";\"\";\"\";\"\";\"\";\"\";\"\";\"English\";\"\";\"\";\"\"This book addresses all the common and important problems that occur during pregnancy','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22993%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22993%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22993%22%3Bs%3A5%3A%22title%22%3Bs%3A187%3A%22Maternal+care+%3A+a+learning+programme+for+professionals%3B%22Ebook%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22English%22%3B%22%22%3B%22%22%3B%22%22This+book+addresses+all+the+common+and+important+problems+that+occur+during+pregnancy%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A6%3A%22labour%22%3Bs%3A3%3A%22sor%22%3Bs%3A200%3A%22and+performing+and+repairing+an+episiotomy.+Maternal+care+is+aimed+at+professional+healthcare+workers+in+level+1+hospitals+or+clinics.%22--Page+10.%22%3B%22%22%3B%22%22%3B%22%3CPerinatal+Education+Programme.%3E%22%3B%22%3CEbook%3E%22%3B%22%22%22%3Bs%3A7%3A%22edition%22%3Bs%3A8%3A%22delivery%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22and+the+puerperium.+It+includes+%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A36%3A%22problems+during+the+antenatal+period%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22monitoring+and+manag%22%3Bs%3A9%3A%22collation%22%3Bs%3A32%3A%22fetus+and+progress+during+labour%22%3Bs%3A12%3A%22series_title%22%3Bs%3A33%3A%22medical+problems+during+pregnancy%22%3Bs%3A11%3A%22call_number%22%3Bs%3A50%3A%22problems+during+the+three+stages+of+labourand+the+%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A30%3A%22and+regionalised+perinatal+car%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22abdominal+and+vaginal+examination+in+pre%22%3Bs%3A5%3A%22notes%22%3Bs%3A30%3A%22screening+for+syphilis+and+HIV%22%3Bs%3A5%3A%22image%22%3Bs%3A38%3A%22use+of+an+antenatal+card+and+partogram%22%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%223f828f0da1f36f09a1f5cb5ac1fb5f43710fe630%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%2206e08ba8c5e4c3e0268b76c3bcbc3a6f03d59bb8%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22b388b3bba91fbee5b723f8bf23c3601a1e042ba3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (41,994,1,'Admin','Managing postpartum haemorrhage;\"Ebook\";\"\";\"\";\"\";\"\";\"\";\"\";\"\";\"English\";\"\";\"\";\"\";\"\";\"\";\"\";\"<Ebook>\";\"\"','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22994%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22994%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22994%22%3Bs%3A5%3A%22title%22%3Bs%3A101%3A%22Managing+postpartum+haemorrhage%3B%22Ebook%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22English%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%3CEbook%3E%22%3B%22%22%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A0%3A%22%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3BN%3Bs%3A9%3A%22isbn_issn%22%3BN%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%222d028e145eb875eae6242b8d261e12a2be20ea59%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (42,995,1,'Admin','Managing newborn problems : a guide for doctors, nurses, and midwives.;\"Ebook\";\"\";\"9241546220\";\"Dept. of Reproductive Health and Research','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22995%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22995%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22995%22%3Bs%3A5%3A%22title%22%3Bs%3A137%3A%22Managing+newborn+problems+%3A+a+guide+for+doctors%2C+nurses%2C+and+midwives.%3B%22Ebook%22%3B%22%22%3B%229241546220%22%3B%22Dept.+of+Reproductive+Health+and+Research%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22World+Health+Organization%5C%22%3B%5C%22%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22World+Health.%3E%22%3B%22%3CNewborn+infants+--+Care.%3E%3CNewbor%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22Newborn.%3E%3CEbook%3E%3CNewborn+infants%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%225016620a7a71e28d671e95a291e547d7be2648b9%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (43,996,1,'Admin','Managing complications in pregnancy and childbirth : a guide for midwives and doctors;\"Ebook\";\"\";\"92 4 154587 9\";\"WHO\";\"2003\";\"1 v (various pagings) : ill.\";\"\";\"RG551 .M31\";\"English\";\"Geneva\";\"\";\"\";\"Managing_Complications_in.jpg.jpg\";\"\";\"<World Health Organization.><Reproductive Health and Research.>\";\"<Ebook><Pregnancy -- Complications.><Labor (Obstrtrics) -- Complications><Delivery','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22996%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22996%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22996%22%3Bs%3A5%3A%22title%22%3Bs%3A386%3A%22Managing+complications+in+pregnancy+and+childbirth+%3A+a+guide+for+midwives+and+doctors%3B%22Ebook%22%3B%22%22%3B%2292+4+154587+9%22%3B%22WHO%22%3B%222003%22%3B%221+v+%28various+pagings%29+%3A+ill.%22%3B%22%22%3B%22RG551+.M31%22%3B%22English%22%3B%22Geneva%22%3B%22%22%3B%22%22%3B%22Managing_Complications_in.jpg.jpg%22%3B%22%22%3B%22%3CWorld+Health+Organization.%3E%3CReproductive+Health+and+Research.%3E%22%3B%22%3CEbook%3E%3CPregnancy+--+Complications.%3E%3CLabor+%28Obstrtrics%29+--+Complications%3E%3CDelivery%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22Obstetric+%5BMESH%5D%3E%3CManual%3E%5C%22%3B%5C%22%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3BN%3Bs%3A9%3A%22isbn_issn%22%3BN%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%220f6cace7a76f2270210eaca08b214ff57bfb29d1%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (44,997,1,'Admin','Management and Therapy of Early Pregnancy Complications : First and Second Trimesters / edited by Antonio Malvasi, Andrea Tinelli, Gian Carlo Di Renzo;\"Ebook\";\"\";\"978-3-319-31377-1\";\"Cham Springer International Publishing\";\"2016\";\"1 online resource (79 pages)\";\"\";\"RG499.2 M31\";\"English\";\"Switzerland\";\"\";\"\"This richly illustrated book draws on recently acquired knowledge to provide the reader with comprehensive','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22997%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22997%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22997%22%3Bs%3A5%3A%22title%22%3Bs%3A413%3A%22Management+and+Therapy+of+Early+Pregnancy+Complications+%3A+First+and+Second+Trimesters+%2F+edited+by+Antonio+Malvasi%2C+Andrea+Tinelli%2C+Gian+Carlo+Di+Renzo%3B%22Ebook%22%3B%22%22%3B%22978-3-319-31377-1%22%3B%22Cham+Springer+International+Publishing%22%3B%222016%22%3B%221+online+resource+%2879+pages%29%22%3B%22%22%3B%22RG499.2+M31%22%3B%22English%22%3B%22Switzerland%22%3B%22%22%3B%22%22This+richly+illustrated+book+draws+on+recently+acquired+knowledge+to+provide+the+reader+with+comprehensive%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22up-to-date+information+on+the+%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22including+those+potentially+involved+in+malpractic%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22risk+factors+and+clinical+presen%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A8%3A%22diagrams%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A11%3A%22flow+charts%22%3Bs%3A9%3A%22collation%22%3Bs%3A95%3A%22and+drawings.+The+volume+has+been+compiled+in+collaboration+with+a+large+group+of+gynecologists%22%3Bs%3A12%3A%22series_title%22%3Bs%3A96%3A%22obstetricians+and+internationally+renowned+scientists+to+provide+an+essential+guide.+Accordingly%22%3Bs%3A11%3A%22call_number%22%3Bs%3A50%3A%22this+book+will+be+a+valuable+tool+for+every+obstet%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A9%3A%22%3E%3CTinelli%22%3Bs%3A14%3A%22classification%22%3Bs%3A13%3A%22Andrea%3E%3CRenzo%22%3Bs%3A5%3A%22notes%22%3Bs%3A38%3A%22Gian+Carlo+Di%3E%22%3B%22%3CEbook%3E%22%3B%22%3CMan++C.1%3E%22%22%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22e09930c1a329560395d37641d70f5a60f80fa667%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22d55fc817740ebcfbae93ce69e208393f965389f2%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (45,998,1,'Admin','Man up! : a practical guide for men in nursing / [edited by] Christopher Lance Coleman.;\"Ebook\";\"\";\"9781937554873\";\"Sigma Theta Tau International\";\"2013\";\"1 online resource (xxiii','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22998%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22998%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22998%22%3Bs%3A5%3A%22title%22%3Bs%3A179%3A%22Man+up%21+%3A+a+practical+guide+for+men+in+nursing+%2F+%5Bedited+by%5D+Christopher+Lance+Coleman.%3B%22Ebook%22%3B%22%22%3B%229781937554873%22%3B%22Sigma+Theta+Tau+International%22%3B%222013%22%3B%221+online+resource+%28xxiii%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22234+pages%29+%3A+illustratio%5C%22%3B%5C%22%5C%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22Ind.%22%3B%22%22%3B%22Includes+bibliographical+references+and+%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22Christopher+Lance.%3E%22%3B%22%3CMEDICAL+-%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%223637f9f43f395cb49269a1e4ab2303cc842dd818%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (46,999,1,'Admin','Legal aspects of midwifery;\"Ebook\";\"3rd\";\"0  7506  8817  3\";\"Books for Midwives\";\"2006\";\"xxix','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A3%3A%22999%22%3Bs%3A3%3A%22_id%22%3Bs%3A3%3A%22999%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A3%3A%22999%22%3Bs%3A5%3A%22title%22%3Bs%3A93%3A%22Legal+aspects+of+midwifery%3B%22Ebook%22%3B%223rd%22%3B%220++7506++8817++3%22%3B%22Books+for+Midwives%22%3B%222006%22%3B%22xxix%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22702p.%5C%22%3B%5C%22%5C%22%3B%5C%22KD2968.M5+D56%5C%22%22%3Bs%3A3%3A%22sor%22%3Bs%3A53%3A%22laws%3E%3CObstetrics+--+Law+and+legislation%3E%22%3B%22%3CDim+C.1%3E%22%22%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22the+code+of+professional+conduct+and+the+scope+of+%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22statements+and+report+writing+--%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22community+and+primary+care+services+--+22.+Employment+law+--+23.+The+independent+midwife+and+private%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22embryology+and+genet%22%3Bs%3A9%3A%22collation%22%3Bs%3A20%3A%22clinical+instructors%22%3Bs%3A12%3A%22series_title%22%3Bs%3A200%3A%22preceptors+and+mentors+--+31.+Midwifery+research+--+32.+Child+protection+--+33.+Mental+disorder+and+mental+incapacity+--+34.+Complementary+therapies+--+App.+1.+Human+Rights+Act+1998+%3A+schedule+1+%3A+the%22%3Bs%3A11%3A%22call_number%22%3Bs%3A19%3A%22accessible+language%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A30%3A%22the+third+edition+of+this+text%22%3Bs%3A14%3A%22classification%22%3Bs%3A38%3A%22B.%3E%22%3B%22%3CEbook%3E%3CMidwives+--+Legal+status%22%3Bs%3A5%3A%22notes%22%3Bs%3A4%3A%22laws%22%3Bs%3A5%3A%22image%22%3Bs%3A100%3A%22--+Great+Britain%3E%3CObstetrics+--+Law+and+legislation+--+Great+Britain%3E%3CMidwifery+--+legislation+%26+jur%22%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%222b7aa490d1265512e55b371a700453e3eaa1b2c0%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22062ec5514b735874d59033105b1db52ba9b7850b%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22deafcc8b9b85c2f0e4787af04028d3a56fc9767d%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (47,1000,1,'Admin','Introduction to the Anatomy and Physiology of Children : a Guide for Students of Nursing, Child Care and Health;\"Ebook\";\"2nd\";\"0-203-92931-4\";\"Taylor & Francis Inc.\";\"2008\";\"1 online resource (270 pages)\";\"\";\"RJ125 .M13\";\"English\";\"Hoboken\";\"\";\"Thoroughly updated throughout','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221000%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221000%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221000%22%3Bs%3A5%3A%22title%22%3Bs%3A274%3A%22Introduction+to+the+Anatomy+and+Physiology+of+Children+%3A+a+Guide+for+Students+of+Nursing%2C+Child+Care+and+Health%3B%22Ebook%22%3B%222nd%22%3B%220-203-92931-4%22%3B%22Taylor+%26+Francis+Inc.%22%3B%222008%22%3B%221+online+resource+%28270+pages%29%22%3B%22%22%3B%22RJ125+.M13%22%3B%22English%22%3B%22Hoboken%22%3B%22%22%3B%22Thoroughly+updated+throughout%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22this+new+edition+provides+an+i%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22healthy+physical+development+for+all+professionals%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A28%3A%22an+experienced+nurse+teacher%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22guides+the+reader+through+the+key+changes+in+body+systems+and+functions+from+embryo+to+birth+through%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22Janet.%3E%22%3B%22%3CEbook%3E%3CCh%22%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22c7edbbb839dd266801cbb7a698dd02107d809045%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (48,1001,1,'Admin','Introduction to nursing research : developing research awareness / by Andree le May and Susan Holmes.;\"Ebook\";\"\";\"978-1-4441-6491-6\";\"Routledge','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221001%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221001%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221001%22%3Bs%3A5%3A%22title%22%3Bs%3A143%3A%22Introduction+to+nursing+research+%3A+developing+research+awareness+%2F+by+Andree+le+May+and+Susan+Holmes.%3B%22Ebook%22%3B%22%22%3B%22978-1-4441-6491-6%22%3B%22Routledge%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22an+imprint+of+Taylor+and+Franc%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22FL%22%3B%22%22%3B%22In+an+engaging+and+accessible+introduction%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22Introduction+to+Nursing+Research%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22stressing+its+influence+on+policy+and+improving+patient+care.+The+book+delivers+a+comprehensive+guid%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A6%3A%22nurses%22%3Bs%3A9%3A%22collation%22%3Bs%3A8%3A%22patients%22%3Bs%3A12%3A%22series_title%22%3Bs%3A118%3A%22and+policy+makers%3F+Why+is+it+such+an+exciting+discipline%3FrnIncludes+bibliographical+references+and+index.%22%3B%22%22%3B%22%22%3B%22%3CMay%22%3Bs%3A11%3A%22call_number%22%3Bs%3A18%3A%22Andree+Le.%3E%3CHolmes%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%2281dfa6cdab57c9cc90eb751745b70d1ea867b9ed%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (49,1002,1,'Admin','Introduction to community-based nursing / Roberta Hunt.;\"Ebook\";\"4th\";\"978-0-7817-7247-1\";\"Wolters Kluwer Health/Lippincott Williams & Wilkins\";\"2009\";\"1 online resource (xvii','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221002%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221002%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221002%22%3Bs%3A5%3A%22title%22%3Bs%3A175%3A%22Introduction+to+community-based+nursing+%2F+Roberta+Hunt.%3B%22Ebook%22%3B%224th%22%3B%22978-0-7817-7247-1%22%3B%22Wolters+Kluwer+Health%2FLippincott+Williams+%26+Wilkins%22%3B%222009%22%3B%221+online+resource+%28xvii%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22524+pages%29++%3A+illustratio%5C%22%3B%5C%22%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22with+specific+attention+to+the+NLN+competencies+fo%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22Roberta.%3E%22%3B%22%3CEbook%3E%22%3B%22%3CHun+C.1%3E%22%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%228d0ca2a9ed28a4619cfde899b7c75ddc627cb34f%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (50,1003,1,'Admin','Intravenous therapy / Teresa M.D. Finlay.;\"Ebook\";\"\";\"0-632-06451-X\";\"Blackwell Science\";\"2004\";\"1 online resource (xii','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221003%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221003%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221003%22%3Bs%3A5%3A%22title%22%3Bs%3A119%3A%22Intravenous+therapy+%2F+Teresa+M.D.+Finlay.%3B%22Ebook%22%3B%22%22%3B%220-632-06451-X%22%3B%22Blackwell+Science%22%3B%222004%22%3B%221+online+resource+%28xii%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22228+pages%29+%3A+illustrations%5C%22%3B%5C%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22MA%22%3B%22%22%3B%22Includes+bibliographical+references+and+in%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22Teresa+%28Teresa+M.+D.%29%3E%22%3B%22%3CNursin%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A55%3A%22Intravenous.%3E%3CMEDICAL+--+Pharmacology.%3E%5C%22%3B%5C%22%3CFin+C.1%3E%5C%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%225f7bdc87075c0000bcea718f60c7f9654b451850%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (51,1004,1,'Admin','Intrapartum care : a learning programme for professionals;\"Ebook\";\"\";\"\";\"\";\"\";\"\";\"\";\"\";\"English\";\"\";\"\";\"Monitoring the condition of the mother during the first stage of labour -- Monitoring the condition of the fetus during the first stage of labour -- Monitoring and management of the first stage of labour -- Skills workshop: examination of the abdomen in labour -- Skills workshop: vaginal examination in labour -- Skills workshop: recording observations on the partogram -- The second stage of labour -- Skills workshop: performing and repairing an episiotomy -- The third stage of labour -- Managing pain during labour -- The puerperium -- Family planning after pregnancy -- Tests. rnrnBased on the highly successful Perinatal Education Programme','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221004%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221004%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221004%22%3Bs%3A5%3A%22title%22%3Bs%3A751%3A%22Intrapartum+care+%3A+a+learning+programme+for+professionals%3B%22Ebook%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22English%22%3B%22%22%3B%22%22%3B%22Monitoring+the+condition+of+the+mother+during+the+first+stage+of+labour+--+Monitoring+the+condition+of+the+fetus+during+the+first+stage+of+labour+--+Monitoring+and+management+of+the+first+stage+of+labour+--+Skills+workshop%3A+examination+of+the+abdomen+in+labour+--+Skills+workshop%3A+vaginal+examination+in+labour+--+Skills+workshop%3A+recording+observations+on+the+partogram+--+The+second+stage+of+labour+--+Skills+workshop%3A+performing+and+repairing+an+episiotomy+--+The+third+stage+of+labour+--+Managing+pain+during+labour+--+The+puerperium+--+Family+planning+after+pregnancy+--+Tests.+rnrnBased+on+the+highly+successful+Perinatal+Education+Programme%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22which+has+brought+continuing+t%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22neonatal+nurses+and+doctors.%22%3B%22%22%3B%22%22%3B%22%3CPerinatal+Ed%22%3Bs%3A9%3A%22isbn_issn%22%3BN%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22b7a8d634fbd854dbb6b1af40a7ab243560f674b2%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (52,1005,1,'Admin','Intrapartum care : care of healthy women and their babies during childbirth;\"Ebook\";\"\";\"\";\"\";\"\";\"\";\"\";\"\";\"English\";\"\";\"\";\"Indhold: Introduction ; Summary of recommendations and care pathway ; Planning place of birth ; Care throughout labour ; Coping with pain in labour: non-epidural ; Pain relief in labour: regional analgesia ; Normal labour: first stage ; Normal labour: second stage ; Normal labour: thrid stage ; Normal labour: care of the baby and woman immediately after birth ; Prelabour rupture of membranes at term ; Meconium-stained liquor ; Complicated labour: monitoring babies in labour ; Complicated labour: first stage ; Complicated labour: second stage ; Complicated labour: immediate care of newborn ; Complicated labour: third stagernAppendix: Declarations of interest ; Clinical questions ; Selection criteria and validity scores for included and excluded studies for the systematic review comparing planned home birth and planned hospital birth and the systematic review comparing planned standalone midwife-led unit and obstetric unit birth ; NCC-WCH analysis to obtain the best estimate of intrapartum-related perinatal mortality in England and Wales ; Decision tree modelling framework to assess cost-effectiveness for place of birth ; Economic evaluation for ST analysis\";\"\";\"\";\"<National Collaborating Centre for Women\'s and Children\'s Health>\";\"<Ebook>\";\"\"','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221005%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221005%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221005%22%3Bs%3A5%3A%22title%22%3Bs%3A1383%3A%22Intrapartum+care+%3A+care+of+healthy+women+and+their+babies+during+childbirth%3B%22Ebook%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22English%22%3B%22%22%3B%22%22%3B%22Indhold%3A+Introduction+%3B+Summary+of+recommendations+and+care+pathway+%3B+Planning+place+of+birth+%3B+Care+throughout+labour+%3B+Coping+with+pain+in+labour%3A+non-epidural+%3B+Pain+relief+in+labour%3A+regional+analgesia+%3B+Normal+labour%3A+first+stage+%3B+Normal+labour%3A+second+stage+%3B+Normal+labour%3A+thrid+stage+%3B+Normal+labour%3A+care+of+the+baby+and+woman+immediately+after+birth+%3B+Prelabour+rupture+of+membranes+at+term+%3B+Meconium-stained+liquor+%3B+Complicated+labour%3A+monitoring+babies+in+labour+%3B+Complicated+labour%3A+first+stage+%3B+Complicated+labour%3A+second+stage+%3B+Complicated+labour%3A+immediate+care+of+newborn+%3B+Complicated+labour%3A+third+stagernAppendix%3A+Declarations+of+interest+%3B+Clinical+questions+%3B+Selection+criteria+and+validity+scores+for+included+and+excluded+studies+for+the+systematic+review+comparing+planned+home+birth+and+planned+hospital+birth+and+the+systematic+review+comparing+planned+standalone+midwife-led+unit+and+obstetric+unit+birth+%3B+NCC-WCH+analysis+to+obtain+the+best+estimate+of+intrapartum-related+perinatal+mortality+in+England+and+Wales+%3B+Decision+tree+modelling+framework+to+assess+cost-effectiveness+for+place+of+birth+%3B+Economic+evaluation+for+ST+analysis%22%3B%22%22%3B%22%22%3B%22%3CNational+Collaborating+Centre+for+Women%27s+and+Children%27s+Health%3E%22%3B%22%3CEbook%3E%22%3B%22%22%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A0%3A%22%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3BN%3Bs%3A9%3A%22isbn_issn%22%3BN%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22830bc3bb195fda946a0e01f76331378b04117109%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:36:17');
INSERT INTO `biblio_log` VALUES (53,1024,1,'Admin','Becoming a midwife in the 21st century;\"Ebook\";\"\";\"0470985828\";\"John Wiley & Sons\";\"2008\";\"xiii','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221024%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221024%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221024%22%3Bs%3A5%3A%22title%22%3Bs%3A95%3A%22Becoming+a+midwife+in+the+21st+century%3B%22Ebook%22%3B%22%22%3B%220470985828%22%3B%22John+Wiley+%26+Sons%22%3B%222008%22%3B%22xiii%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22458+pages+%3A+illustrations%5C%22%3B%5C%22%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22England%22%3B%22%22%3B%22Contents%09Effective+communication+%2F+Ta%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22Meryl+Dimmock+%26+Sarah+Green+--+I%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22Celia+Wildeman+%26+Chandra+Mehta+--+Regulating+the+midwifery+profession%3A+protecting+women+or+the+profe%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22safety+and+environme%22%3Bs%3A9%3A%22collation%22%3Bs%3A89%3A%22Sally+Luck+%26+Nada+Schiavone.%22%3B%22Becoming_a_Midwife_in_the_21st_Century.jpg.jpg%22%3B%22%22%3B%22%3CPeate%22%3Bs%3A12%3A%22series_title%22%3Bs%3A13%3A%22Ian%3E%3CHamilton%22%3Bs%3A11%3A%22call_number%22%3Bs%3A50%3A%22Cathy%3E%22%3B%22%3CEbook%3E%3CQuality+Assurance%3E%3CHealth+Care%3E%3CM%22%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%223287529e981c89de69c55cad1dd0d500d552ff74%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:55');
INSERT INTO `biblio_log` VALUES (54,1025,1,'Admin','Ask a midwife;\"Ebook\";\"1st American ed.\";\"978-0-7566-3687-6\";\"DK Pub\";\"2008\";\"1 online resource (324 pages) : color illustration\";\"\";\"RG525 .P22\";\"English\";\"New York\";\"\";\"This book has your pregnancy and birth questions answered by experienced midwives. It covers what you need to know from conception to the first weeks of life with a new baby.\";\"Ask_a_midwife.jpg.jpg\";\"\";\"<Parker-Littler','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221025%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221025%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221025%22%3Bs%3A5%3A%22title%22%3Bs%3A390%3A%22Ask+a+midwife%3B%22Ebook%22%3B%221st+American+ed.%22%3B%22978-0-7566-3687-6%22%3B%22DK+Pub%22%3B%222008%22%3B%221+online+resource+%28324+pages%29+%3A+color+illustration%22%3B%22%22%3B%22RG525+.P22%22%3B%22English%22%3B%22New+York%22%3B%22%22%3B%22This+book+has+your+pregnancy+and+birth+questions+answered+by+experienced+midwives.+It+covers+what+you+need+to+know+from+conception+to+the+first+weeks+of+life+with+a+new+baby.%22%3B%22Ask_a_midwife.jpg.jpg%22%3B%22%22%3B%22%3CParker-Littler%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22Catherine%3E%3Cwww.midwivesonline.%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3BN%3Bs%3A9%3A%22isbn_issn%22%3BN%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22c20d966918f2e0238711b212f2932b10cf243a06%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:55');
INSERT INTO `biblio_log` VALUES (55,1026,1,'Admin','Abnormal Psychology By Kring,Johnson,Davison and Neale;\"Ebook\";\"\";\"\";\"J. Wiley\";\"2010\";\"1 electronic document (1 volume (various pagings :\";\"\";\"RC454 .Ab2\";\"English\";\"Hoboken','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221026%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221026%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221026%22%3Bs%3A5%3A%22title%22%3Bs%3A174%3A%22Abnormal+Psychology+By+Kring%2CJohnson%2CDavison+and+Neale%3B%22Ebook%22%3B%22%22%3B%22%22%3B%22J.+Wiley%22%3B%222010%22%3B%221+electronic+document+%281+volume+%28various+pagings+%3A%22%3B%22%22%3B%22RC454+.Ab2%22%3B%22English%22%3B%22Hoboken%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22NJ%5C%22%3B%5C%22%5C%22%3B%5C%22Includes+bibliogra%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A7%3A%22Johnson%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22Davison_and_Neale.jpg.jpg%22%3B%22%22%3B%22%3C%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A31%3A%22Johnson%3E%5C%22%3B%5C%22%3CEbook%3E%3CPsychology%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22Pathological.%3E%22%3B%22%3CAb%22%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%221798438d63457882504c86f0a045ce0dc5ab3509%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:55');
INSERT INTO `biblio_log` VALUES (56,1027,1,'Admin','Anatomy at a glance;\"Ebook\";\"\";\"0-632-05934-6\";\"Blackwell Pub. Ltd.\";\"2002\";\"1 online resource (177 pages)\";\"At a glance series\";\"QM31 .F17\";\"English\";\"Oxford\";\"\";\"\";\"Anatomy_at_glance.png.png\";\"\";\"<Faiz','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221027%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221027%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221027%22%3Bs%3A5%3A%22title%22%3Bs%3A203%3A%22Anatomy+at+a+glance%3B%22Ebook%22%3B%22%22%3B%220-632-05934-6%22%3B%22Blackwell+Pub.+Ltd.%22%3B%222002%22%3B%221+online+resource+%28177+pages%29%22%3B%22At+a+glance+series%22%3B%22QM31+.F17%22%3B%22English%22%3B%22Oxford%22%3B%22%22%3B%22%22%3B%22Anatomy_at_glance.png.png%22%3B%22%22%3B%22%3CFaiz%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A12%3A%22Omar%3E%3CMoffat%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A5%3A%22David%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22MD%3E%22%3B%22%3CHuman+anatomy.%3E%3CEbook%3E%3CAn%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%221cb51b231a2e5a198121f2aaebaa68e094c086be%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:55');
INSERT INTO `biblio_log` VALUES (57,1028,1,'Admin','Statistics Demystified, A self Teaching guide;\"Ebook\";\"\";\"\";\"\";\"\";\"\";\"\";\"\";\"English\";\"\";\"\";\"\";\"Statistics_Demystified','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221028%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221028%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221028%22%3Bs%3A5%3A%22title%22%3Bs%3A117%3A%22Statistics+Demystified%2C+A+self+Teaching+guide%3B%22Ebook%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22English%22%3B%22%22%3B%22%22%3B%22%22%3B%22Statistics_Demystified%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22_A_self_Teaching_guide.jpg.jpg%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3BN%3Bs%3A9%3A%22isbn_issn%22%3BN%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22b37f1e54429e2ad74f61ce756bee0c95ca620ef9%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:55');
INSERT INTO `biblio_log` VALUES (58,1029,1,'Admin','Nursing diagnoses in psychiatric nursing : care plans and psychotropic medications;\"Text\";\"6th\";\"9780803611665\";\"F.A. Davis Co.\";\"2004\";\"xxix','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221029%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221029%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221029%22%3Bs%3A5%3A%22title%22%3Bs%3A141%3A%22Nursing+diagnoses+in+psychiatric+nursing+%3A+care+plans+and+psychotropic+medications%3B%22Text%22%3B%226th%22%3B%229780803611665%22%3B%22F.A.+Davis+Co.%22%3B%222004%22%3B%22xxix%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22577p.+%3B+19+cm%5C%22%3B%5C%22%5C%22%3B%5C%22RC440+.%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A9%3A%22Childhood%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A26%3A%22or+Adolescence+--+Delirium%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A8%3A%22Dementia%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22and+Amnestic+Disorde%22%3Bs%3A9%3A%22collation%22%3Bs%3A65%3A%22M.C.%3E%22%3B%22%3CPsychiatric+nursing%3E%3CMental+illness%3E%22%3B%22%3CRC440+.T66+C.1%3E%22%22%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22bad0779191848b5abc9765ea83a2c9ab69d9c70e%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:55');
INSERT INTO `biblio_log` VALUES (59,1030,1,'Admin','Evidence-based advance directives : a guide for nurses / Dinah Brothers.;\"Ebook\";\"\";\"1-57839-685-9\";\"\";\"2005\";\"1 online resource (x','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221030%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221030%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221030%22%3Bs%3A5%3A%22title%22%3Bs%3A131%3A%22Evidence-based+advance+directives+%3A+a+guide+for+nurses+%2F+Dinah+Brothers.%3B%22Ebook%22%3B%22%22%3B%221-57839-685-9%22%3B%22%22%3B%222005%22%3B%221+online+resource+%28x%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%2293+pages%29%5C%22%3B%5C%22%5C%22%3B%5C%22RT42.B79%5C%22%3B%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22Mass%22%3B%22%22%3B%22Includes+bibliographical+references.%22%3B%22E%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22_A_study_guide_for_Nurses.jpg.jp%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22Dinah.%3E%5C%22%3B%5C%22%3CNursing+--+Study+and+teaching.%3E%3CNursing.%3E%3CEbook%3E%3CEvidence-based+nursing.%3E%3CEvidence-base%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%2262abe130e65e04e2131604b3b3b204b0fd865880%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:55');
INSERT INTO `biblio_log` VALUES (60,1031,1,'Admin','Examination of the newborn : a practical guide / Helen Baston and Heather Durward.;\"Ebook\";\"\";\"0-203-97716-5\";\"Routledge\";\"2001\";\"1 online resource (xiv','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221031%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221031%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221031%22%3Bs%3A5%3A%22title%22%3Bs%3A152%3A%22Examination+of+the+newborn+%3A+a+practical+guide+%2F+Helen+Baston+and+Heather+Durward.%3B%22Ebook%22%3B%22%22%3B%220-203-97716-5%22%3B%22Routledge%22%3B%222001%22%3B%221+online+resource+%28xiv%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22207+pages%29+%3A+illustrations%5C%22%3B%5C%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A14%3A%22Helen%3E%3CDurward%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A7%3A%22Heather%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A13%3A%22%3E%5C%22%3B%5C%22%3CInfant%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22Newborn.%3E%3CEbook%3E%3CPhy%22%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%228fd76b8b2202a8a5baa056b9d069503a1d1b15a5%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:56');
INSERT INTO `biblio_log` VALUES (61,1032,1,'Admin','Everyday English for international nurses : a guide to working in the UK / Joy Parkinson, Chris Brooker.;\"Ebook\";\"\";\"1417593431\";\"Churchill Livingstone\";\"2004\";\"1 online resource (xi','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221032%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221032%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221032%22%3Bs%3A5%3A%22title%22%3Bs%3A182%3A%22Everyday+English+for+international+nurses+%3A+a+guide+to+working+in+the+UK+%2F+Joy+Parkinson%2C+Chris+Brooker.%3B%22Ebook%22%3B%22%22%3B%221417593431%22%3B%22Churchill+Livingstone%22%3B%222004%22%3B%221+online+resource+%28xi%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22237+pages%29+%3A+illustrations%5C%22%3B%5C%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A13%3A%22Joy.%3E%3CBrooker%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22Christine.%3E%22%3B%22%3CNursing.%3E%3CEbook%3E%3C%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%225ca94695a6e0f91270c86dc882023244ba3a4b2c%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:56');
INSERT INTO `biblio_log` VALUES (62,1033,1,'Admin','Evaluation and testing in nursing education / Marilyn H. Oermann, PhD, RN, ANEF, FAAN, Kathleen B. Gaberson, PhD, RN, CNOR, CNE, ANEF;\"Ebook\";\"4th ed.\";\"978-0-8261-9556-2\";\"Springer Publishing Company\";\"2014\";\"1 online resource (xv','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221033%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221033%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221033%22%3Bs%3A5%3A%22title%22%3Bs%3A231%3A%22Evaluation+and+testing+in+nursing+education+%2F+Marilyn+H.+Oermann%2C+PhD%2C+RN%2C+ANEF%2C+FAAN%2C+Kathleen+B.+Gaberson%2C+PhD%2C+RN%2C+CNOR%2C+CNE%2C+ANEF%3B%22Ebook%22%3B%224th+ed.%22%3B%22978-0-8261-9556-2%22%3B%22Springer+Publishing+Company%22%3B%222014%22%3B%221+online+resource+%28xv%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22434+p.%29%5C%22%3B%5C%22%5C%22%3B%5C%22RT73.7+.Oe7%5C%22%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A20%3A%22Marilyn+H.%3E%3CGaberson%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22Kathleen+B.%3E%22%3B%22%3CNursing%3E%3CEbook%3E%3C%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22c220b989fe3facecd256df61464a21f5b76bb543%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:56');
INSERT INTO `biblio_log` VALUES (63,1034,1,'Admin','Evaluation and testing in nursing education Marilyn H. Oermann, Kathleen B. Gaberson;\"Ebook\";\"3rd\";\"978-0-8261-1062-6\";\"Springer Publishing Company\";\"2009\";\"1 online resource (xv','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221034%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221034%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221034%22%3Bs%3A5%3A%22title%22%3Bs%3A178%3A%22Evaluation+and+testing+in+nursing+education+Marilyn+H.+Oermann%2C+Kathleen+B.+Gaberson%3B%22Ebook%22%3B%223rd%22%3B%22978-0-8261-1062-6%22%3B%22Springer+Publishing+Company%22%3B%222009%22%3B%221+online+resource+%28xv%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22446+p.%29++%3A+illustrations.%5C%22%3B%5C%22%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A11%3A%22measurement%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22and+testing+in+nursing+education%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A20%3A%22Marilyn+H.%3E%3CGaberson%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22Kathleen+B.%3E%22%3B%22%3CEboo%22%3Bs%3A9%3A%22collation%22%3Bs%3A100%3A%22Nursing+--+standards.%3E%3CEducational+Measurement+--+methods.%3E%3CEvaluation+Studies+as+Topic.%3E%22%3B%22%3COer+C.2%22%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%221eeb91f0d6a38fef91bb3f8c0afc4355d8363708%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:56');
INSERT INTO `biblio_log` VALUES (64,1035,1,'Admin','Evaluation and testing in nursing education / Marilyn H. Oermann, Kathleen B. Gaberson.;\"Ebook\";\"2nd\";\"0-8261-9951-8\";\"Springer Pub. Co.\";\"2006\";\"1 online resource (xiv','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221035%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221035%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221035%22%3Bs%3A5%3A%22title%22%3Bs%3A168%3A%22Evaluation+and+testing+in+nursing+education+%2F+Marilyn+H.+Oermann%2C+Kathleen+B.+Gaberson.%3B%22Ebook%22%3B%222nd%22%3B%220-8261-9951-8%22%3B%22Springer+Pub.+Co.%22%3B%222006%22%3B%221+online+resource+%28xiv%22%3Bs%3A8%3A%22gmd_name%22%3BN%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A10%3A%22administer%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A17%3A%22and+analyze+tests%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A20%3A%22measurement+concepts%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A7%3A%22grading%22%3Bs%3A9%3A%22collation%22%3Bs%3A93%3A%22and+clinical+evaluation.+Educators+will+learn+the+basics+of+how+to+plan+for+classroom+testing%22%3Bs%3A12%3A%22series_title%22%3Bs%3A78%3A%22analyze+test.rnIncludes+bibliographical+references+and+index.%22%3B%22%22%3B%22%22%3B%22%3COermann%22%3Bs%3A11%3A%22call_number%22%3Bs%3A20%3A%22Marilyn+H.%3E%3CGaberson%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A30%3A%22Nursing+--+standards.%3E%3CEducati%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%2205e2d69331e060fe5e1b32affb4550dfcddcf74a%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:56');
INSERT INTO `biblio_log` VALUES (65,1036,1,'Admin','Ethics in paediatric nursing / edited by Gosia M. Brykczyńska.;\"Ebook\";\"\";\"978-1-4899-3268-6\";\"Chapman and Hall\";\"1989\";\"1 online resource (xiv','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221036%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221036%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221036%22%3Bs%3A5%3A%22title%22%3Bs%3A145%3A%22Ethics+in+paediatric+nursing+%2F+edited+by+Gosia+M.+Brykczyn%CC%81ska.%3B%22Ebook%22%3B%22%22%3B%22978-1-4899-3268-6%22%3B%22Chapman+and+Hall%22%3B%221989%22%3B%221+online+resource+%28xiv%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22157+pages%29%5C%22%3B%5C%22%5C%22%3B%5C%22RJ245+.E3%5C%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22Gosia+M.%3E%22%3B%22%3CPediatrics.%3E%3CPediatric+nursing.%3E%3CEboo%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22Nursing.%3E%3CMedical+ethics.%3E%22%3B%22%3CBr%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22399b8232c990b630d60296d5223518086df8043e%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:56');
INSERT INTO `biblio_log` VALUES (66,1037,1,'Admin','Ethical issues in nursing and midwifery practice : perspectives from Europe / edited by Win Tadd.;\"Ebook\";\"\";\"978-0-333-71005-0\";\"Macmillan Education Ltd\";\"1998\";\"1 online resource (xvi','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221037%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221037%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221037%22%3Bs%3A5%3A%22title%22%3Bs%3A185%3A%22Ethical+issues+in+nursing+and+midwifery+practice+%3A+perspectives+from+Europe+%2F+edited+by+Win+Tadd.%3B%22Ebook%22%3B%22%22%3B%22978-0-333-71005-0%22%3B%22Macmillan+Education+Ltd%22%3B%221998%22%3B%221+online+resource+%28xvi%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22263+pages%29.%5C%22%3B%5C%22%5C%22%3B%5C%22RT85+.Et3%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22this+book+discusses+the+key+ethical+issues+faced+b%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22Win.%3E%22%3B%22%3CMidwifery.%3E%3CEbook%3E%3CMidw%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A16%3A%22Nursing.%3E%3CEthics%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22Professional.%3E%22%3B%22%3CEt%22%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22661bfe75a8f28ca631ec432fb582e40241de70f5%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:56');
INSERT INTO `biblio_log` VALUES (67,1038,1,'Admin','Essentials of nursing leadership & management / Patricia Kelly;\"Ebook\";\"2nd ed.\";\"978-14354-53562\";\"Delmar Cengage Learning\";\"2010\";\"1 online resource (xxx','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221038%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221038%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221038%22%3Bs%3A5%3A%22title%22%3Bs%3A155%3A%22Essentials+of+nursing+leadership+%26+management+%2F+Patricia+Kelly%3B%22Ebook%22%3B%222nd+ed.%22%3B%22978-14354-53562%22%3B%22Delmar+Cengage+Learning%22%3B%222010%22%3B%221+online+resource+%28xxx%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22457+pages%29+%3A+illustrations%5C%22%3B%5C%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A26%3A%22NY%22%3B%22%22%3B%22Nursing+leadership%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A10%3A%22management%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A77%3A%22and+motivation+--+Health+care+environment+--+Nursing+today+--+Decision+making%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A17%3A%22critical+thinking%22%3Bs%3A9%3A%22collation%22%3Bs%3A100%3A%22and+technology+--+Leadership+and+management+of+the+interdisciplinary+team+--+Health+care+communicati%22%3Bs%3A12%3A%22series_title%22%3Bs%3A10%3A%22innovation%22%3Bs%3A11%3A%22call_number%22%3Bs%3A50%3A%22and+conflict+--+Power+and+politics+--+Leadership+a%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A30%3A%22and+spirituality+--+Leadership%22%3Bs%3A14%3A%22classification%22%3Bs%3A8%3A%22Patricia%22%3Bs%3A5%3A%22notes%22%3Bs%3A97%3A%22%3E%22%3B%22%3CEbook%3E%3CNursing+services+--+Administration.%3E%3CLeadership.%3E%3CPersonnel+Management.%3E%22%3B%22%3CKel+C.1%3E%22%22%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%226a2f892d86bc287dc5d8bb6ac5dbebc48f25486e%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22a4da2caf488b1795335cf9123faba195cc4d2f68%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:56');
INSERT INTO `biblio_log` VALUES (68,1039,1,'Admin','Essential midwifery practice. Leadership, expertise and collaborative working / edited by Soo Downe, Sheena Byrom, and Louise Simpson.;\"Ebook\";\"\";\"978-1-4051-8431-1\";\"Wiley-Blackwell\";\"2011\";\"1 online resource (xiv','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221039%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221039%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221039%22%3Bs%3A5%3A%22title%22%3Bs%3A214%3A%22Essential+midwifery+practice.+Leadership%2C+expertise+and+collaborative+working+%2F+edited+by+Soo+Downe%2C+Sheena+Byrom%2C+and+Louise+Simpson.%3B%22Ebook%22%3B%22%22%3B%22978-1-4051-8431-1%22%3B%22Wiley-Blackwell%22%3B%222011%22%3B%221+online+resource+%28xiv%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22233+pages%29%5C%22%3B%5C%22Essential+midwi%22%3Bs%3A3%3A%22sor%22%3Bs%3A145%3A%22RM.%3E%22%3B%22%3CMidwifery.%3E%3CEbook%3E%3CLeadership.%3E%3CHEALTH+%26+FITNESS+--+Pregnancy+%26+Childbirth.%3E%3CCooperative+Behavior.%3E%3CProfessional+Competence%3E%22%3B%22%3CDow+C.1%3E%22%22%3Bs%3A7%3A%22edition%22%3Bs%3A11%3A%22West+Sussex%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22U.K%22%3B%22%22%3B%22Midwifery+leadership+%3A+%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22practice+and+potential+%2F+Sheena+Byrom+and+Lesley+Kay+--+Transformational+leadership+and+midwifery+%3A+%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A10%3A%22Anna+Byrom%22%3Bs%3A9%3A%22collation%22%3Bs%3A100%3A%22and+Soo+Downe+--+What+do+leaders+do+to+influence+maternity+services%3F+%3A+midwifery+leadership+as+appli%22%3Bs%3A12%3A%22series_title%22%3Bs%3A6%3A%22models%22%3Bs%3A11%3A%22call_number%22%3Bs%3A50%3A%22and+maternity+care+%2F+Soo+Downe+and+Kenny+Finlayson%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A30%3A%22Sheena+Byrom.rnIncludes+biblio%22%3Bs%3A14%3A%22classification%22%3Bs%3A11%3A%22Soo.%3E%3CByrom%22%3Bs%3A5%3A%22notes%22%3Bs%3A16%3A%22Sheena.%3E%3CSimpson%22%3Bs%3A5%3A%22image%22%3Bs%3A6%3A%22Louise%22%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22390f36ff2104e6ac78f9892341c2e13dd6d6954b%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22b0fef0198c3590f66709d9b09e8cc7b9557d5861%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22f8fb6f03d9f085004979d60934fc769a0ebe2790%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:56');
INSERT INTO `biblio_log` VALUES (69,1040,1,'Admin','Essential midwifery practice : postnatal care / edited by Sheena Byrom, Grace Edwards, Debra Bick.;\"Ebook\";\"\";\"978-1-4051-7091-8\";\"Wiley-Blackwell\";\"2010\";\"1 online resource','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221040%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221040%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221040%22%3Bs%3A5%3A%22title%22%3Bs%3A173%3A%22Essential+midwifery+practice+%3A+postnatal+care+%2F+edited+by+Sheena+Byrom%2C+Grace+Edwards%2C+Debra+Bick.%3B%22Ebook%22%3B%22%22%3B%22978-1-4051-7091-8%22%3B%22Wiley-Blackwell%22%3B%222010%22%3B%221+online+resource%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A6%3A%22%28+%28xix%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22260+p.%29%29+%3A+illustration%22%3B%22%22%3B%22RG801+.Es7%22%3B%22English%22%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22Iowa%22%3B%22%22%3B%22The+history+of+postnat%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22national+and+international+perspectives+--+Contemporary+postnatal+care+in+the+21st+century+--+Women%5C%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A14%3A%22postnatal+care%22%3Bs%3A9%3A%22collation%22%3Bs%3A30%3A%22and+parenthood.%22%3B%22%22%3B%22%22%3B%22%3CByrom%22%3Bs%3A12%3A%22series_title%22%3Bs%3A16%3A%22Sheena.%3E%3CEdwards%22%3Bs%3A11%3A%22call_number%22%3Bs%3A5%3A%22Grace%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A30%3A%22Debra.%3E%5C%22%3B%5C%22%3CMidwifery.%3E%3CEbook%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22ee6b6f8da9031b6eaf13da90d49566e10859a2b5%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:56');
INSERT INTO `biblio_log` VALUES (70,1041,1,'Admin','Essential epidemiology : an introduction for students and health professionals;\"Ebook\";\"2nd ed.\";\"978-0-521-17731-3\";\"Cambridge University Press\";\"2011\";\"1 online resource (XIV','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221041%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221041%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221041%22%3Bs%3A5%3A%22title%22%3Bs%3A176%3A%22Essential+epidemiology+%3A+an+introduction+for+students+and+health+professionals%3B%22Ebook%22%3B%222nd+ed.%22%3B%22978-0-521-17731-3%22%3B%22Cambridge+University+Press%22%3B%222011%22%3B%221+online+resource+%28XIV%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22445+p.%29%5C%22%3B%5C%22%5C%22%3B%5C%22RA651+.W38%5C%22%3B%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22it+gives+students+an+understanding+of+the+fundamen%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22it+steps+through+the+methods+and%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22while+maintaining+a+balance+of+rigour+and+clarity.+The+nuts-and-bolts+of+epidemiology+are+embedded+i%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22and+end-of-chapter+q%22%3Bs%3A9%3A%22collation%22%3Bs%3A100%3A%22slides+for+teaching+and+useful+weblinks%22--Provided+by+publisher.rnrn%091.+Epidemiology+is+...+--+2.+Ho%22%3Bs%3A12%3A%22series_title%22%3Bs%3A4%3A%22what%22%3Bs%3A11%3A%22call_number%22%3Bs%3A50%3A%22where+and+when%3F+Descriptive+epidemiology+--+4.+Hea%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A11%3A%22Penny%3E%3CBain%22%3Bs%3A14%3A%22classification%22%3Bs%3A5%3A%22Chris%22%3Bs%3A5%3A%22notes%22%3Bs%3A25%3A%22%3E%22%3B%22%3CEbook%3E%22%3B%22%3CWeb++C.1%3E%22%22%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22015278c04fe242ecd800178866ea0bf0f730c5d1%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%227c1cc09503a11232ea9bdc9da052e133ae419436%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:56');
INSERT INTO `biblio_log` VALUES (71,1042,1,'Admin','Essential communication skills for nursing and midwifery / Philippa Sully, Joan Dallas.;\"Ebook\";\"2nd ed.\";\"978 0 7234 3527 3\";\"\";\"2010\";\"1 online resource (ix','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221042%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221042%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221042%22%3Bs%3A5%3A%22title%22%3Bs%3A158%3A%22Essential+communication+skills+for+nursing+and+midwifery+%2F+Philippa+Sully%2C+Joan+Dallas.%3B%22Ebook%22%3B%222nd+ed.%22%3B%22978+0+7234+3527+3%22%3B%22%22%3B%222010%22%3B%221+online+resource+%28ix%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22239+pages%29+%3A+illustrations%5C%22%3B%5C%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A8%3A%22advocacy%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22and+negotiation+skills+--+Commun%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A16%3A%22Philippa%3E%3CDallas%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22Joan.%3E%22%3B%22%3CEbook%3E%3CCom%22%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22ee6e7caa5af9ba43e02df43e1a476987b775f823%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:56');
INSERT INTO `biblio_log` VALUES (72,1043,1,'Admin','Essential psychology for nurses and other health professionals / Graham Russell;\"Ebook\";\"\";\"0-203-02744-2\";\"Routledge\";\"1999\";\"1 online resource (xiv','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221043%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221043%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221043%22%3Bs%3A5%3A%22title%22%3Bs%3A149%3A%22Essential+psychology+for+nurses+and+other+health+professionals+%2F+Graham+Russell%3B%22Ebook%22%3B%22%22%3B%220-203-02744-2%22%3B%22Routledge%22%3B%221999%22%3B%221+online+resource+%28xiv%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22230+p.%29+illustrations%5C%22%3B%5C%22%5C%22%3B%5C%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A38%3A%22Challenging+Events+and+Loss.+5.+Stress%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22appraisal+and+coping.+6.+Anxiety%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22bereavement+and+loss+--+pt.+3.+Promoting+and+Maintaining+Health.+10.+Health+protective+behaviour+--+%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22Graham%3E%22%3B%22%3CEbook%3E%3CPs%22%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%229acb0bea2f907f44db270cb582f104ac32c766a2%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:56');
INSERT INTO `biblio_log` VALUES (73,1044,1,'Admin','Essential midwifery practice : public health / edited by Grace Edwards, Sheena Byrom;\"Ebook\";\"\";\"978-1-4051-4441-4\";\"Blackwell Pub. Ltd.\";\"2007\";\"1 online resource (xx','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221044%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221044%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221044%22%3Bs%3A5%3A%22title%22%3Bs%3A167%3A%22Essential+midwifery+practice+%3A+public+health+%2F+edited+by+Grace+Edwards%2C+Sheena+Byrom%3B%22Ebook%22%3B%22%22%3B%22978-1-4051-4441-4%22%3B%22Blackwell+Pub.+Ltd.%22%3B%222007%22%3B%221+online+resource+%28xx%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22233+p.%29+illustrations%5C%22%3B%5C%22%5C%22%3B%5C%22%3Bs%3A3%3A%22sor%22%3Bs%3A77%3A%22Denis+Walsh.rnIncludes+bibliographical+references+and+index.%22%3B%22%22%3B%22%22%3B%22%3CEdwards%22%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22MA%22%3B%22%22%3B%22The+midwifery+public+health+agenda+%3A+setti%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22Sheena+Byrom+--+Health+and+inequ%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A73%3A%22David+King+--+Teenage+pregnancy+%3A+everyone%5C%27s+business+%2F+Vanessa+Hollings%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A14%3A%22Claire+Jackson%22%3Bs%3A9%3A%22collation%22%3Bs%3A67%3A%22Clare+McCann+--+Sexual+health+%3A+a+potential+time+bomb+%2F+Julie+Kelly%22%3Bs%3A12%3A%22series_title%22%3Bs%3A200%3A%22Grace+Edwards+--+Substance+abuse+%3A+what+is+the+problem%3F+%2F+Lyn+McIver+--+Domestic+abuse+in+pregnancy+%3A+a+public+health+issue+%2F+Sally+Price+--+Maternal+mental+health+%3A+working+in+partnership+%2F+Samuel+De%22%3Bs%3A11%3A%22call_number%22%3Bs%3A18%3A%22Kathryn+Gutteridge%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A11%3A%22Fiona+Dykes%22%3Bs%3A14%3A%22classification%22%3Bs%3A12%3A%22Sheena+Byrom%22%3Bs%3A5%3A%22notes%22%3Bs%3A14%3A%22Michelle+Atkin%22%3Bs%3A5%3A%22image%22%3Bs%3A100%3A%22Elaine+Jackson+--+Normal+birth+and+birth+centre+care+%3A+a+public+health+catalyst+for+maternal+and+soc%22%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3Ba%3A1%3A%7Bi%3A0%3Ba%3A3%3A%7Bs%3A11%3A%22author_name%22%3Bs%3A5%3A%22Grace%22%3Bs%3A14%3A%22authority_type%22%3Bs%3A13%3A%22Personal+Name%22%3Bs%3A15%3A%22authority_level%22%3Bs%3A17%3A%22Additional+Author%22%3B%7D%7Ds%3A8%3A%22subjects%22%3Ba%3A2%3A%7Bi%3A0%3Ba%3A3%3A%7Bs%3A5%3A%22topic%22%3Bs%3A2%3A%22RN%22%3Bs%3A10%3A%22topic_type%22%3Bs%3A5%3A%22Topic%22%3Bs%3A11%3A%22topic_level%22%3Bs%3A10%3A%22Additional%22%3B%7Di%3A1%3Ba%3A3%3A%7Bs%3A5%3A%22topic%22%3Bs%3A5%3A%22Byrom%22%3Bs%3A10%3A%22topic_type%22%3Bs%3A5%3A%22Topic%22%3Bs%3A11%3A%22topic_level%22%3Bs%3A10%3A%22Additional%22%3B%7D%7Ds%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22f69dbe9ac03aaab5843fe521d6fc48bcc5252b00%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%220182b6fd29c7752a6844e66d0d82c36a1df82cfa%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%220840de84c126ede1d229c7f0c92aa1a4c9ab497b%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22bf04fbfd651eb46ee0e73ff0ba8781ede36ade50%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22e5305f3a20fa83286a477d8a08273334bdacf9a3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:56');
INSERT INTO `biblio_log` VALUES (74,1045,1,'Admin','Drugs and pregnancy : a handbook / Bertis B. Little.;\"Ebook\";\"\";\"9780340809174\";\"Distributed in the U.S.A. by Oxford University Press\";\"2006\";\"1 online resource','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221045%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221045%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221045%22%3Bs%3A5%3A%22title%22%3Bs%3A160%3A%22Drugs+and+pregnancy+%3A+a+handbook+%2F+Bertis+B.+Little.%3B%22Ebook%22%3B%22%22%3B%229780340809174%22%3B%22Distributed+in+the+U.S.A.+by+Oxford+University+Press%22%3B%222006%22%3B%221+online+resource%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22372+pages+%3A+illustrations.%5C%22%3B%5C%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A11%3A%22but+concise%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22this+practical+handbook+will+ass%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22Bertis+Britt.%3E%5C%22%3B%5C%22%3CEbook%3E%3CPregnancy.%3E%3CObstetrical+pharmacology.%3E%3CFetus+--+Effect+of+drugs+on.%3E%3CDrug%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%225ba89a76684960adcef344dc7cc835eca2d8175c%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:57');
INSERT INTO `biblio_log` VALUES (75,1046,1,'Admin','Diabetology of pregnancy / volume editors, J. Djelmis, G. Desoye, M. Ivanisevi;\"Ebook\";\"\";\"3–8055–7925–X\";\"Karger\";\"2005\";\"1 online resource (x','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221046%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221046%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221046%22%3Bs%3A5%3A%22title%22%3Bs%3A149%3A%22Diabetology+of+pregnancy+%2F+volume+editors%2C+J.+Djelmis%2C+G.+Desoye%2C+M.+Ivanisevi%3B%22Ebook%22%3B%22%22%3B%223%E2%80%938055%E2%80%937925%E2%80%93X%22%3B%22Karger%22%3B%222005%22%3B%221+online+resource+%28x%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22327+s.%29+illustrations+%28some%5C%22%3B%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A10%3A%22physiology%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A30%3A%22molecular+biology+and+genetics%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A10%3A%22immunology%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A12%3A%22pathogenesis%22%3Bs%3A9%3A%22collation%22%3Bs%3A9%3A%22diagnosis%22%3Bs%3A12%3A%22series_title%22%3Bs%3A24%3A%22treatment+and+management%22%3Bs%3A11%3A%22call_number%22%3Bs%3A50%3A%22pathology+and+evidence-based+medicine.+The+role+of%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A21%3A%22Gernot.%3E%3CIvanisevic%CC%81%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22M.+%28Marina%29%3E%22%3B%22%3CEbook%3E%3CPregnancy+--+Comp%22%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%2209a31e5cb6d15ca2cf6b96bec4e73a06945304ba%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22fcde54dcd88c4afe31cd40346220d42a7886600f%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:57');
INSERT INTO `biblio_log` VALUES (76,1047,1,'Admin','Core Anatomy - Illustrated.;\"Ebook\";\"\";\"9781444113723\";\"CRC Press\";\"2007\";\"1 online resource (109 pages)\";\"\";\"QM23.2.P23\";\"English\";\"London\";\"\";\"\"The authors are to be congratulated on covering such a wide range of essential material in a concise manner while still providing an engaging and readable text.\" Clive Lee','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221047%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221047%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221047%22%3Bs%3A5%3A%22title%22%3Bs%3A317%3A%22Core+Anatomy+-+Illustrated.%3B%22Ebook%22%3B%22%22%3B%229781444113723%22%3B%22CRC+Press%22%3B%222007%22%3B%221+online+resource+%28109+pages%29%22%3B%22%22%3B%22QM23.2.P23%22%3B%22English%22%3B%22London%22%3B%22%22%3B%22%22The+authors+are+to+be+congratulated+on+covering+such+a+wide+range+of+essential+material+in+a+concise+manner+while+still+providing+an+engaging+and+readable+text.%22+Clive+Lee%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22Royal+College+of+Surgeons+in+I%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A11%3A%22Ian.%3E%3CLogan%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22Bari.%3E%22%3B%22%3CHuman+anatomy.%3E%3CEbook%3E%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%2278014a7f813d231f165f1f2f595b7c596bebee29%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:57');
INSERT INTO `biblio_log` VALUES (77,1048,1,'Admin','Delmar\'s practice questions for NCLEX-PN / Judith C. Miller, Janet Tompkins McMahon.;\"Ebook\";\"2nd ed.\";\"978-1-428-31219-7\";\"Delmar/Cengage Learning\";\"2011\";\"1 online resource (ix','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221048%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221048%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221048%22%3Bs%3A5%3A%22title%22%3Bs%3A178%3A%22Delmar%27s+practice+questions+for+NCLEX-PN+%2F+Judith+C.+Miller%2C+Janet+Tompkins+McMahon.%3B%22Ebook%22%3B%222nd+ed.%22%3B%22978-1-428-31219-7%22%3B%22Delmar%2FCengage+Learning%22%3B%222011%22%3B%221+online+resource+%28ix%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22390+pages%29.%5C%22%3B%5C%22Practice+quest%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22N.Y%22%3B%22%22%3B%22Unit+1+Overview+of+practical%2Fvocational+n%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A9%3A%22maternity%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22and+newborns+--+Pediatrics.rnUnit+IV+Special+populations+--+The+Older+adult+client+--+The+Mental+hea%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A18%3A%22Judith+C.%3E%3CMcMahon%22%3Bs%3A9%3A%22collation%22%3Bs%3A100%3A%22Janet+Tompkins.%3E%22%3B%22%3CEbook%3E%3CStudy+guides.%3E%3CNational+Council+Licensure+Examination+for+Practic%3E%3CPracti%22%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%2291257243d2c9c9c7641344ee44bbcbce69feb5ae%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:57');
INSERT INTO `biblio_log` VALUES (78,1049,1,'Admin','Davis\'s basic math review for nurses : with step-by-step solutions / Vicki Raines.;\"Ebook\";\"\";\"978-0-8036-2056-8\";\"F.A. Davis Co.\";\"2010\";\"1 online resource (xix','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221049%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221049%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221049%22%3Bs%3A5%3A%22title%22%3Bs%3A161%3A%22Davis%27s+basic+math+review+for+nurses+%3A+with+step-by-step+solutions+%2F+Vicki+Raines.%3B%22Ebook%22%3B%22%22%3B%22978-0-8036-2056-8%22%3B%22F.A.+Davis+Co.%22%3B%222010%22%3B%221+online+resource+%28xix%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22340+pages%29+%3A+illustrations%5C%22%3B%5C%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22Vicki.%3E%22%3B%22%3CEbook%3E%3CNursing+--+Mathematics.%3E%3CMathema%22%3Bs%3A9%3A%22isbn_issn%22%3BN%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%2242569c741d2d1e2079b123d92b2ee8946f28623b%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:57');
INSERT INTO `biblio_log` VALUES (79,1050,1,'Admin','Counselling for maternal and newborn health care : a handbook for building skills.;\"Ebook\";\"\";\"9789240684874\";\"World Health Organization\";\"2009\";\"1 online resource (232 pages)\";\"\";\"RG940 .C83\";\"English\";\"Geneva\";\"\";\"\";\"\";\"\";\"<World Health Organization.><Department of Making Pregnancy Safer.>\";\"<Ebook><Maternal health services.><HEALTH & FITNESS -- Pregnancy & Childbirth.><Pregnancy -- Complications -- Prevention.><Maternal and infant welfare.>\";\"<Cou C.1>\"','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221050%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221050%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221050%22%3Bs%3A5%3A%22title%22%3Bs%3A460%3A%22Counselling+for+maternal+and+newborn+health+care+%3A+a+handbook+for+building+skills.%3B%22Ebook%22%3B%22%22%3B%229789240684874%22%3B%22World+Health+Organization%22%3B%222009%22%3B%221+online+resource+%28232+pages%29%22%3B%22%22%3B%22RG940+.C83%22%3B%22English%22%3B%22Geneva%22%3B%22%22%3B%22%22%3B%22%22%3B%22%22%3B%22%3CWorld+Health+Organization.%3E%3CDepartment+of+Making+Pregnancy+Safer.%3E%22%3B%22%3CEbook%3E%3CMaternal+health+services.%3E%3CHEALTH+%26+FITNESS+--+Pregnancy+%26+Childbirth.%3E%3CPregnancy+--+Complications+--+Prevention.%3E%3CMaternal+and+infant+welfare.%3E%22%3B%22%3CCou+C.1%3E%22%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A0%3A%22%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3BN%3Bs%3A9%3A%22isbn_issn%22%3BN%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%228fb92640efca18a42d0d3b4d634757d3e87fd8c4%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:57');
INSERT INTO `biblio_log` VALUES (80,1051,1,'Admin','Contemporary psychiatric-mental health nursing / Carol Ren Kneisl, Eileen Trigoboff.;\"Ebook\";\"3rd ed.\";\"978-0-13-255777-1\";\"Prentice Hall\";\"2013\";\"1 online resource xxxiii','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221051%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221051%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221051%22%3Bs%3A5%3A%22title%22%3Bs%3A171%3A%22Contemporary+psychiatric-mental+health+nursing+%2F+Carol+Ren+Kneisl%2C+Eileen+Trigoboff.%3B%22Ebook%22%3B%223rd+ed.%22%3B%22978-0-13-255777-1%22%3B%22Prentice+Hall%22%3B%222013%22%3B%221+online+resource+xxxiii%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22806+pages+%3A+illustration%5C%22%3B%5C%22%5C%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A21%3A%22Carol+Ren.%3E%3CTrigoboff%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22Eileen.%3E%22%3B%22%3CEbook%3E%3CPsychiatric+N%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22dcb792e648d9cf07cbeb568d1ec44b5ab84c4064%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:57');
INSERT INTO `biblio_log` VALUES (81,1052,1,'Admin','Contemporary medical surgical nursing / Rick Daniels, Leslie H. Nicoll.;\"Ebook\";\"2nd ed.\";\"978-1-439-05860-2\";\"Delmar','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221052%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221052%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221052%22%3Bs%3A5%3A%22title%22%3Bs%3A117%3A%22Contemporary+medical+surgical+nursing+%2F+Rick+Daniels%2C+Leslie+H.+Nicoll.%3B%22Ebook%22%3B%222nd+ed.%22%3B%22978-1-439-05860-2%22%3B%22Delmar%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22Cengage+Learning%5C%22%3B%5C%222012%5C%22%3B%5C%22%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22NY%22%3B%22%22%3B%22Includes+bibliographical+references+and+in%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22Rick+%28Associate+professor%29%3E%22%3B%22%3CN%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%225c27fdb71d91e5e99e476080311a8413d1e545ad%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:57');
INSERT INTO `biblio_log` VALUES (82,1053,1,'Admin','Congenital and perinatal infections : a concise guide to diagnosis / edited by Cecelia Hutto.;\"Ebook\";\"\";\"1-58829-297-5\";\"Humana Press\";\"2006\";\"1 online resource (xiv','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221053%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221053%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221053%22%3Bs%3A5%3A%22title%22%3Bs%3A166%3A%22Congenital+and+perinatal+infections+%3A+a+concise+guide+to+diagnosis+%2F+edited+by+Cecelia+Hutto.%3B%22Ebook%22%3B%22%22%3B%221-58829-297-5%22%3B%22Humana+Press%22%3B%222006%22%3B%221+online+resource+%28xiv%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22314+pages%29+%3A+illustrations%5C%22%3B%5C%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A23%3A%22N.J.%22%3B%22%22%3B%22In+this+title%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22a+distinguished+panel+of+pediatr%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22the+book+provides+pertinent+information+about+the+epidemiology+of+each+infection+in+the+pregnant+wom%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22as+well+as+the+risk+%22%3Bs%3A9%3A%22collation%22%3Bs%3A32%3A%22the+spectrum+of+clinical+disease%22%3Bs%3A12%3A%22series_title%22%3Bs%3A155%3A%22and+a+recommended+approach+to+the+diagnosis+of+the+infection+in+both+the+mother+and+neonate.rnIncludes+bibliographical+references+and+index.%22%3B%22%22%3B%22%22%3B%22%3CHutto%22%3Bs%3A11%3A%22call_number%22%3Bs%3A50%3A%22Cecelia.%3E%22%3B%22%3CEbook%3E%3CCommunicable+diseases+in+the+f%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A24%3A%22newborn%3E%5C%22%3B%5C%22%3CInf+C.1%3E%5C%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%2297f936b8735d8abc870af372944d4f20f77174e6%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:37:57');
INSERT INTO `biblio_log` VALUES (83,1054,1,'Admin','Compact clinical guide to infant and children\'s pain management : an evidence-based approach / Linda L. Oakes.;\"Ebook\";\"\";\"978-0-8261-0618-6\";\"Springer Publishing Company\";\"2011\";\"1 online resource (ix','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221054%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221054%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221054%22%3Bs%3A5%3A%22title%22%3Bs%3A201%3A%22Compact+clinical+guide+to+infant+and+children%27s+pain+management+%3A+an+evidence-based+approach+%2F+Linda+L.+Oakes.%3B%22Ebook%22%3B%22%22%3B%22978-0-8261-0618-6%22%3B%22Springer+Publishing+Company%22%3B%222011%22%3B%221+online+resource+%28ix%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22399+p.%29%5C%22%3B%5C%22Compact+clinical+g%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22Linda+L.%3E%22%3B%22%3CEbook%3E%3CPain+in+children+--+Treatment.%22%3Bs%3A9%3A%22isbn_issn%22%3BN%3Bs%3A14%3A%22publisher_name%22%3Bs%3A0%3A%22%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%22c3ab4a8475a09007dc45a3395283885a40adfa2e%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:38:07');
INSERT INTO `biblio_log` VALUES (84,1055,1,'Admin','Communication and interpersonal skills for nurses / Shirley Bach and Alec Grant.;\"Ebook\";\"\";\"184445438X\";\"Learning Matters\";\"2009\";\"1 online resource (192 pages).\";\"Communication & interpersonal skills for nurses\";\"RT23 .B13\";\"English\";\"London\";\"\";\"An essential resource for nursing students on communication and interpersonal skills','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221055%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221055%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221055%22%3Bs%3A5%3A%22title%22%3Bs%3A333%3A%22Communication+and+interpersonal+skills+for+nurses+%2F+Shirley+Bach+and+Alec+Grant.%3B%22Ebook%22%3B%22%22%3B%22184445438X%22%3B%22Learning+Matters%22%3B%222009%22%3B%221+online+resource+%28192+pages%29.%22%3B%22Communication+%26+interpersonal+skills+for+nurses%22%3B%22RT23+.B13%22%3B%22English%22%3B%22London%22%3B%22%22%3B%22An+essential+resource+for+nursing+students+on+communication+and+interpersonal+skills%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22reflecting+the+NMC+Proficienci%22%3Bs%3A3%3A%22sor%22%3BN%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22NOS+and+Skills+for+Health+Competencies+and+QAA+des%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A15%3A%22Shirley.%3E%3CGrant%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22Alec.%3E%5C%22%3B%5C%22%3CEbook%3E%3CNurse+and+patient.%3E%3CCommunication+in+nursing.%3E%3CInterpersonal+relations.%3E%5C%22%3B%5C%22%3CBac%22%3Bs%3A12%3A%22publish_year%22%3BN%3Bs%3A9%3A%22collation%22%3BN%3Bs%3A12%3A%22series_title%22%3BN%3Bs%3A11%3A%22call_number%22%3BN%3Bs%3A13%3A%22language_name%22%3Bs%3A0%3A%22%22%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A0%3A%22%22%3Bs%3A14%3A%22classification%22%3BN%3Bs%3A5%3A%22notes%22%3BN%3Bs%3A5%3A%22image%22%3BN%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3BN%3Bs%3A8%3A%22subjects%22%3BN%3Bs%3A5%3A%22items%22%3BN%3Bs%3A4%3A%22hash%22%3Ba%3A5%3A%7Bs%3A6%3A%22biblio%22%3Bs%3A40%3A%2224cffd5c6e023b2d218c595dcbb5c854cf788c65%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A7%3A%22authors%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A8%3A%22subjects%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3Bs%3A5%3A%22image%22%3Bs%3A40%3A%22ec0a0fa7e8b0092ad8f0bf8c93ff597b874fabe3%22%3B%7Ds%3A10%3A%22input_date%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3Bs%3A11%3A%22last_update%22%3Bs%3A19%3A%222022-02-17+03%3A33%3A56%22%3B%7D','Data bibliografi dihapus.','2022-02-17 03:38:07');
INSERT INTO `biblio_log` VALUES (85,1056,1,'Admin','Color atlas of biochemistry  / Jan Koolman, Klaus-Heinrich Roehm.;\"Ebook\";\"2nd ed.\";\"3-13-100372-3\";\"Georg Thieme Verlag\";\"2005\";\"1 online resource (1 texte électronique (x','172.26.1.123','delete','description','a%3A34%3A%7Bs%3A2%3A%22id%22%3Bs%3A4%3A%221056%22%3Bs%3A3%3A%22_id%22%3Bs%3A4%3A%221056%22%3Bs%3A9%3A%22biblio_id%22%3Bs%3A4%3A%221056%22%3Bs%3A5%3A%22title%22%3Bs%3A174%3A%22Color+atlas+of+biochemistry++%2F+Jan+Koolman%2C+Klaus-Heinrich+Roehm.%3B%22Ebook%22%3B%222nd+ed.%22%3B%223-13-100372-3%22%3B%22Georg+Thieme+Verlag%22%3B%222005%22%3B%221+online+resource+%281+texte+e%CC%81lectronique+%28x%22%3Bs%3A8%3A%22gmd_name%22%3Bs%3A30%3A%22467+p%5C%22%3B%5C%22%5C%22%3B%5C%22QP514.2+.K83%5C%22%3B%22%3Bs%3A3%3A%22sor%22%3Bs%3A7%3A%22manuals%22%3Bs%3A7%3A%22edition%22%3Bs%3A50%3A%22the+Color+Atlas+of+Biochemistry+presents+the+funda%22%3Bs%3A9%3A%22isbn_issn%22%3Bs%3A32%3A%22the+2nd+edition+covers+new+appro%22%3Bs%3A14%3A%22publisher_name%22%3Bs%3A100%3A%22such+as+links+between+chemical+structure+and+biological+function+or+pathways+for+information+transfe%22%3Bs%3A12%3A%22publish_year%22%3Bs%3A20%3A%22as+well+as+recent+de%22%3Bs%3A9%3A%22collation%22%3Bs%3A100%3A%22such+as+the+structures+of+many+new+important+molecules.+Key+features+of+this+title+include%3A+The+uniq%22%3Bs%3A12%3A%22series_title%22%3Bs%3A29%3A%22Unified+color-coding+of+atoms%22%3Bs%3A11%3A%22call_number%22%3Bs%3A9%3A%22coenzymes%22%3Bs%3A13%3A%22language_name%22%3BN%3Bs%3A6%3A%22source%22%3BN%3Bs%3A5%3A%22place%22%3Bs%3A30%3A%22and+cell+organelles+that+allow%22%3Bs%3A14%3A%22classification%22%3Bs%3A40%3A%22Computer+graphics+provide+simulated+3D+r%22%3Bs%3A5%3A%22notes%22%3Bs%3A11%3A%22Jan.%3E%3CRoehm%22%3Bs%3A5%3A%22image%22%3Bs%3A68%3A%22Klaus-Heinrich+.%3E%22%3B%22%3CEbook%3E%3CBiochemistry.%3E%3CBiochemistry+--+Handbooks%22%3Bs%3A9%3A%22opac_hide%22%3Bs%3A1%3A%220%22%3Bs%3A8%3A%22promoted%22%3Bs%3A1%3A%220%22%3Bs%3A6%3A%22labels%22%3BN%3Bs%3A9%3A%22frequency%22%3BN%3Bs%3A16%3A%22spec_detail_info%22%3BN%3Bs%3A12%3A%22content_type%22%3BN%3Bs%3A10%3A%22media_type%22%3BN%3Bs%3A12%3A%22carrier_type%22%3BN%3Bs%3A3%3A%22uid%22%3BN%3Bs%3A7%3A%22authors%22%3Ba%3A3%3A%7Bi%3A0%3Ba%3A3%3A%7Bs%3A11%3A%22author_name%22%3Bs%3A4%3A%22